/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameInfo;
import cds.aladin.Glu;
import cds.aladin.MetaDataTree;
import cds.aladin.MyInputStream;
import cds.aladin.MyListener;
import cds.aladin.PlanImage;
import cds.aladin.Server;
import cds.aladin.TreeView;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public final class ServerAladin
extends Server
implements Runnable,
MyListener {
    Thread thread;
    JCheckBox byTree;
    ButtonGroup format;
    JRadioButton jpgCb;
    JRadioButton fitsCb;
    JLabel step1;
    JLabel step2;
    String STEP1;
    String STEP2;
    String BYTREE;
    String DEFFMT;
    String SERVERR;
    String GLUDEFQUAL = "DefQual";
    String GLUIMAGE = "Image";
    String GLUQUALIFIER = "Aladin.qualifierServer";
    static String[] ACOLOR = new String[]{"J", "F", "E", "EJ", "V", "O", "R", "I", "S", "SR", "ER", "U", "B", "N"};
    static String[] COLOR = new String[]{"Blue", "Red", "Red", "Equ. blue", "Visible", "Blue", "Red", "InfraRed", "Short red", "Short red", "Equ. red", "UV", "Blue", "Red/IR"};
    static String lastQual = "";
    static boolean flagContWhichQual = false;
    private String _target;
    private String _criteria;
    private String _label;
    private String _origin;
    private String _serverTaskId;
    private boolean flagIDHASIAcall = false;
    private boolean flagCreatPlane = false;
    private boolean launchLock = false;
    private boolean olistView = true;
    static String otarget = null;
    boolean flagClear = true;

    private String getTagGlu(String string) {
        return string;
    }

    protected ServerAladin(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.type = 1;
        this.aladinLogo = "AladinLogo.gif";
        this.DISCOVERY = true;
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 2;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Aladin.BLUE);
        Dimension dimension = this.makeTitle(jPanel, this.title);
        jPanel.setBounds(235 - dimension.width / 2, n, dimension.width, dimension.height);
        this.add(jPanel);
        this.step1 = new JLabel(this.STEP1);
        this.step1.setForeground(Color.blue);
        this.step1.setBounds(80, n += dimension.height + 10, 400, 19);
        n += 20;
        this.add(this.step1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Aladin.BLUE);
        int n2 = this.makeTargetPanel(jPanel2, Aladin.OUTREACH ? 2 : 16);
        jPanel2.setBounds(0, n, XWIDTH, n2);
        n += n2;
        this.add(jPanel2);
        this.modeCoo = 5;
        this.modeRad = 0;
        if (this.radius != null) {
            this.radius.setText("0 arcmin");
        }
        this.step2 = new JLabel(this.STEP2);
        this.step2.setBounds(15, n, 310, 19);
        this.add(this.step2);
        this.byTree = new JCheckBox(this.BYTREE, false);
        this.byTree.setActionCommand(this.BYTREE);
        this.byTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerAladin.this.changeViewMode();
            }
        });
        int n3 = 150;
        int n4 = XWIDTH - 10 - n3;
        this.byTree.setBounds(n4, n + 2, n3, 18);
        n += 22;
        this.byTree.setBackground(Aladin.BLUE);
        this.add(this.byTree);
        this.tree = new MetaDataTree(aladin, null);
        this.tree.setAllowSortByFields(false);
        this.tree.setFlat(true);
        this.tree.setSortable(true);
        this.tree.setStateChangedListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.tree.setScroll(jScrollPane);
        jScrollPane.setBackground(this.tree.bkgColor);
        jScrollPane.setBounds(10, n, XWIDTH - 20, 217);
        this.add(jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Aladin.BLUE);
        jPanel3.setBounds(110, n += 215, XWIDTH, 30);
        n += 35;
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.setFont(Aladin.PLAIN);
        this.format = new ButtonGroup();
        jPanel3.add(new JLabel(this.DEFFMT));
        this.jpgCb = new JRadioButton("JPEG", true);
        jPanel3.add(this.jpgCb);
        this.jpgCb.setActionCommand("JPEG");
        this.jpgCb.setBackground(Aladin.BLUE);
        this.format.add(this.jpgCb);
        this.fitsCb = new JRadioButton("FITS", false);
        jPanel3.add(this.fitsCb);
        this.fitsCb.setActionCommand("FITS");
        this.fitsCb.setBackground(Aladin.BLUE);
        this.format.add(this.fitsCb);
        if (!Aladin.OUTREACH) {
            this.add(jPanel3);
        }
        this.setStepColor(this.step1, this.step2);
        this.setMaxComp(jScrollPane);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.title = Aladin.chaine.getString("ALADINTITLE");
        this.BYTREE = Aladin.chaine.getString("ALADINBYTREE");
        this.DEFFMT = Aladin.chaine.getString("ALADINDEFFMT");
        this.aladinLabel = Aladin.chaine.getString("ALADINNAME");
        this.description = Aladin.chaine.getString("ALADININFO");
        this.verboseDescr = Aladin.chaine.getString("ALADINDESC");
        this.STEP1 = Aladin.chaine.getString("ALADINSTEP1");
        this.STEP2 = Aladin.chaine.getString("ALADINSTEP2");
        this.SERVERR = Aladin.chaine.getString("ALADINSERVERR");
    }

    @Override
    protected boolean is(String string) {
        return string.equalsIgnoreCase("Aladin");
    }

    protected static String fixChar(String string, int n) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = i < cArray.length ? cArray[i] : 32;
        }
        return new String(cArray2);
    }

    static String change2FITS(String string) {
        int n = string.indexOf("JPEG");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + "FITS" + string.substring(n + 4, string.length());
    }

    static String whichQualifier(String string) {
        flagContWhichQual = false;
        return ServerAladin.whichQual(string);
    }

    static String whichQual(String string) {
        boolean bl = flagContWhichQual && string.equals(lastQual);
        flagContWhichQual = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 3) {
            return string;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        stringBuffer.append(ServerAladin.fixChar(bl ? "   \"" : string2, 6));
        stringBuffer.append(ServerAladin.fixChar(bl ? "    \"   \"" : "  " + (string4.equals("MAMA") ? "MAMA/CAI" : (string4.equalsIgnoreCase("STSCI") ? "DSS1/STScI" : (string4.equalsIgnoreCase("DSS2") ? "DSS2/STScI" : (string2.equalsIgnoreCase("2MASS") ? "UMass/IRSA" : string4)))), 12));
        if (string2.equalsIgnoreCase("2MASS") || string2.equalsIgnoreCase("EROSI")) {
            stringBuffer.append(ServerAladin.fixChar("  " + string3, 12));
        } else {
            int n;
            for (n = 0; n < ACOLOR.length && !ACOLOR[n].equals(string3); ++n) {
            }
            if (n < ACOLOR.length) {
                stringBuffer.append(ServerAladin.fixChar(bl ? "  \"  \"" : "  " + string3 + " (" + COLOR[n] + ")", 12));
            } else {
                stringBuffer.append(ServerAladin.fixChar(bl ? "  \"" : "  " + string3, 12));
            }
        }
        lastQual = string;
        return stringBuffer.toString();
    }

    private void freeLaunchLock() {
        this.launchLock = false;
    }

    private synchronized boolean getLaunchLock() {
        if (this.launchLock) {
            return false;
        }
        this.launchLock = true;
        return true;
    }

    @Override
    protected synchronized int createPlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if ((string3 = ServerAladin.specialUnQuoteCriteria(string3)) != null && !this.isAllSky(string3)) {
            int n = string3.indexOf(47);
            int n2 = string3.indexOf(47, n + 1);
            if (n > 0 && n2 > n) {
                string8 = string3.replace('/', ' ');
                string7 = "FULL";
                string6 = "JPEG";
                string3 = null;
            }
        }
        if (string3 != null) {
            while (!this.getLaunchLock()) {
                Util.pause(500);
            }
            this._target = string;
            this._criteria = string3;
            this._origin = string5;
            this._label = string4;
            this._serverTaskId = this.aladin.synchroServer.start("ServerAladin.createPlane/" + string);
            this.thread = new Thread((Runnable)this, "AladinCreatePlane");
            this.flagCreatPlane = true;
            this.thread.start();
            return 0;
        }
        return this.creatAladinPlane(string, string6, string7, string8, string4, string5);
    }

    @Override
    public void run() {
        if (this.flagIDHASIAcall) {
            this.flagIDHASIAcall = false;
            this.submitThread();
        } else if (this.flagCreatPlane) {
            this.flagCreatPlane = false;
            this.creatPlaneThread();
        }
        this.setStepColor(this.step1, this.step2);
    }

    protected boolean isAllSky(String string) {
        return string.equalsIgnoreCase("allsky");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatPlaneThread() {
        block8: {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = this._target;
            String string5 = this._criteria;
            String string6 = this._origin;
            String string7 = this._label;
            String string8 = this._serverTaskId;
            try {
                this.freeLaunchLock();
                if (this.isAllSky(string5)) {
                    this.aladin.calque.newPlan("http://aladin.u-strasbg.fr/java/AllSky.fits", "AllSky", "Aladin image server");
                    break block8;
                }
                try {
                    URL uRL = this.aladin.glu.getURL(this.getTagGlu(this.GLUDEFQUAL), Glu.quote(string4) + " " + Glu.quote(string5));
                    DataInputStream dataInputStream = new DataInputStream(Util.openStream(uRL));
                    string = dataInputStream.readLine();
                    string2 = dataInputStream.readLine();
                    string3 = dataInputStream.readLine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string == null || string.length() == 0) {
                    Aladin.warning(this, Aladin.chaine.getString("NOSUCHIMG") + " [" + string5 + "] [" + string4 + "]", 1);
                } else {
                    this.creatAladinPlane(string4, string3, string2, string, string7, string6);
                }
            }
            finally {
                this.aladin.synchroServer.stop(string8);
            }
        }
    }

    protected int creatAladinPlane(String string, String string2, String string3, String string4, String string5, String string6) {
        URL uRL;
        if (string2 == null) {
            string2 = "JPEG";
        }
        if (string3 == null) {
            string3 = "FULL";
        }
        String string7 = Glu.quote(string) + " " + Glu.quote(string2) + " " + Glu.quote(string3);
        if (string4 != null && string4.length() > 0) {
            string7 = string7 + " " + Glu.quote(string4);
        }
        if ((uRL = this.aladin.glu.getURL(this.getTagGlu(this.GLUIMAGE), string7)) == null) {
            Aladin.warning(this, this.WERROR, 1);
            return -1;
        }
        if (!this.verif(1, string, string4, PlanImage.getFmt(string2) + "/" + PlanImage.getRes(string3))) {
            return -1;
        }
        if (string5 == null) {
            string5 = ServerAladin.getPlanLabel(string3, string4);
        }
        if (string6 == null) {
            string6 = string4.indexOf("MAMA") >= 0 ? "CAI/Paris - provided by CDS image server" : (string4.indexOf("DSS2") >= 0 ? "STScI -  provided by CDS image server" : (string4.indexOf("2MASS") >= 0 ? "UMass/IRSA - provided by CDS image server" : "STScI - provided by CDS"));
        }
        return this.aladin.calque.newPlanImage(uRL, 0, string5, string, string4, string6, PlanImage.getFmt(string2), PlanImage.getRes(string3), null);
    }

    private void submitThread() {
        this.waitCursor();
        URL uRL = null;
        try {
            String string;
            String string2 = null;
            String string3 = null;
            try {
                string3 = this.getTarget();
                string = this.getRadius(false);
                string = string == null ? "0" : "" + ServerAladin.getRM(string) / 60.0;
                string2 = this.sesameIfRequired(string3, ":");
                if (string2 == null) {
                    throw new Exception(this.UNKNOWNOBJ + " [" + string3 + "]");
                }
            }
            catch (Exception exception) {
                Aladin.warning(this, exception.getMessage(), 1);
                this.defaultCursor();
                this.ball.setMode(3);
                return;
            }
            uRL = this.aladin.glu.getURL(this.getTagGlu(this.GLUQUALIFIER), Glu.quote(TreeView.getDeciCoord(string2)) + Glu.quote(string));
            MyInputStream myInputStream = Util.openStream(uRL);
            if ((myInputStream.getType() & 0x1800L) == 0L) {
                String string4 = myInputStream.readLine().trim();
                Aladin.warning(this, this.SERVERR + "\n\"" + string4 + "\"");
                this.defaultCursor();
                this.ball.setMode(2);
                return;
            }
            this.updateMetaData(myInputStream, this, string3, null);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning(this, this.SERVERR, 1);
        }
        this.defaultCursor();
        if (this.tree.isEmpty()) {
            this.ball.setMode(3);
        }
    }

    @Override
    protected MyInputStream getMetaData(String string, String string2, StringBuffer stringBuffer) throws Exception {
        String string3;
        if (string2 != "") {
            string2 = ServerAladin.getRM(string2) / 60.0 + "";
        }
        if ((string3 = this.sesameIfRequired(string, ":")) == null) {
            throw new Exception();
        }
        URL uRL = this.aladin.glu.getURL("Aladin.qualifierServer", Glu.quote(TreeView.getDeciCoord(string3)) + Glu.quote(string2));
        stringBuffer.append(uRL + "");
        return Util.openStream(uRL);
    }

    private void changeViewMode() {
        boolean bl;
        boolean bl2 = bl = !this.byTree.isSelected();
        if (this.olistView != bl) {
            this.tree.setFlat(bl);
            this.olistView = bl;
        }
    }

    protected String getDefaultFormat() {
        return this.format.getSelection().getActionCommand();
    }

    @Override
    public void submit() {
        this.waitCursor();
        String string = this.target.getText().trim();
        if (string != null && this.isAllSky(string)) {
            while (!this.getLaunchLock()) {
                Util.pause(500);
            }
            this._criteria = string;
            this.creatPlaneThread();
            return;
        }
        String string2 = this.getTarget();
        if (string2 == null) {
            this.defaultCursor();
            return;
        }
        this.memoTarget(string2);
        if (this.tree != null && !this.tree.isEmpty()) {
            if (this.tree.nbSelected() > 0) {
                if (!this.tooManyChecked()) {
                    String string3 = this.getDefaultFormat();
                    this.tree.loadSelected(string3);
                    this.tree.resetCb();
                }
            } else {
                FrameInfo frameInfo = this.aladin.getFrameInfo();
                if (frameInfo.isVisible()) {
                    frameInfo.load();
                } else {
                    Aladin.warning(this, this.WNEEDCHECK);
                }
            }
            this.defaultCursor();
            return;
        }
        FrameInfo frameInfo = this.aladin.getFrameInfo();
        if (frameInfo.isVisible()) {
            frameInfo.hide();
        }
        this.thread = new Thread((Runnable)this, "AladinServerMetaData");
        this.flagIDHASIAcall = true;
        Util.decreasePriority(Thread.currentThread(), this.thread);
        this.thread.start();
    }

    protected static String getPlanLabel(String string, String string2) {
        return ServerAladin.getPlanLabel(PlanImage.getRes(string), string2);
    }

    protected static String getPlanLabel(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < 3; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        if (stringArray[0].indexOf("2MASS") >= 0) {
            stringArray[2] = stringArray[0];
            stringArray[0] = null;
        }
        if (n == 3) {
            stringBuffer.append("Pl-");
        } else if (n == 2) {
            stringBuffer.append("Lw-");
        }
        if (stringArray[2].equals("STScI") || stringArray[2].equals("STSCI")) {
            stringBuffer.append("DSS1.");
        } else if (!stringArray[2].startsWith("___")) {
            stringBuffer.append(stringArray[2] + ".");
        }
        stringBuffer.append(stringArray[1]);
        if (stringArray[0] != null) {
            stringBuffer.append("." + stringArray[0]);
        }
        return stringBuffer.toString();
    }

    protected void memoTarget(String string) {
        otarget = string;
    }

    @Override
    protected void setTarget(String string) {
        if (this.flagClear && otarget != null && !otarget.equals(string)) {
            this.clear();
        }
        this.flagClear = true;
        super.setTarget(string);
    }

    protected static String blankToUnderline(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != ' ') continue;
            cArray[i] = 95;
        }
        return new String(cArray);
    }

    @Override
    protected void reset() {
        this.tree.resetCb();
        this.flagClear = false;
        super.reset();
        this.setStepColor(this.step1, this.step2);
    }

    @Override
    protected void clear() {
        this.tree.clear();
        super.clear();
        if (this.radius != null) {
            this.radius.setText("0 arcmin");
        }
        this.setStepColor(this.step1, this.step2);
    }

    @Override
    public void fireStateChange(String string) {
        if (string.equals("Flat view")) {
            this.byTree.setSelected(false);
            this.changeViewMode();
        } else if (string.equals("Hierarchical view")) {
            this.byTree.setSelected(true);
            this.changeViewMode();
        }
    }

    @Override
    public void fireStateChange(int n) {
    }
}

