/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.FootprintBean;
import cds.aladin.PlanField;
import cds.aladin.Server;
import cds.aladin.SubFootprintBean;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerAlmaFootprint
extends Server {
    private List<ALMASetup> setups = new ArrayList<ALMASetup>();
    private JComboBox setupList;
    private JTextField widthField;
    private JTextField heightField;

    protected ServerAlmaFootprint(Aladin aladin) {
        this.aladin = aladin;
        this.init();
        this.createChaine();
        this.buildGUI();
    }

    protected void init() {
        this.type = 8;
        this.aladinMenu = "FoV...";
        this.aladinLabel = "ALMA footprint";
        this.aladinLogo = "ALMALogo.gif";
        this.grab = null;
        this.setups.add(new ALMASetup(3, 44.7f, new float[]{2.6f, 3.6f}, new float[]{84.0f, 116.0f}));
        this.setups.add(new ALMASetup(4, 30.9f, new float[]{1.8f, 2.4f}, new float[]{125.0f, 169.0f}));
        this.setups.add(new ALMASetup(5, 24.1f, new float[]{1.4f, 1.8f}, new float[]{163.0f, 211.0f}));
        this.setups.add(new ALMASetup(6, 18.9f, new float[]{1.1f, 1.4f}, new float[]{211.0f, 275.0f}));
        this.setups.add(new ALMASetup(7, 13.8f, new float[]{0.8f, 1.1f}, new float[]{275.0f, 373.0f}));
        this.setups.add(new ALMASetup(8, 10.3f, new float[]{0.6f, 0.8f}, new float[]{385.0f, 500.0f}));
        this.setups.add(new ALMASetup(9, 6.9f, new float[]{0.4f, 0.5f}, new float[]{602.0f, 720.0f}));
    }

    @Override
    protected void createChaine() {
        this.title = Aladin.chaine.getString("ALTITLE");
        this.description = Aladin.chaine.getString("ALINFO");
        super.createChaine();
    }

    private void buildGUI() {
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 50;
        int n2 = 150;
        JPanel jPanel = new JPanel();
        Dimension dimension = this.makeTitle(jPanel, this.title);
        jPanel.setBackground(Aladin.BLUE);
        jPanel.setBounds(235 - dimension.width / 2, n, dimension.width, dimension.height);
        this.add(jPanel);
        JLabel jLabel = new JLabel(this.description);
        jLabel.setBounds(90, n += dimension.height + 10, 400, 20);
        n += 20;
        this.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Aladin.BLUE);
        int n3 = this.makeTargetPanel(jPanel2, 2);
        jPanel2.setBounds(0, n, XWIDTH, n3);
        this.add(jPanel2);
        this.modeCoo = 5;
        JLabel jLabel2 = new JLabel("Receiver band");
        jLabel2.setBounds(10, n += n3, 150, HAUT);
        this.add(jLabel2);
        this.setupList = new JComboBox();
        for (ALMASetup object2 : this.setups) {
            this.setupList.addItem(object2);
        }
        this.add(this.setupList);
        this.setupList.setBounds(160, n, XWIDTH - 160, HAUT);
        JLabel jLabel3 = new JLabel("Width (arcmin)");
        jLabel3.setBounds(10, n += HAUT + MARGE, 150, HAUT);
        this.add(jLabel3);
        this.widthField = new JTextField("5");
        this.add(this.widthField);
        this.widthField.setBounds(160, n, XWIDTH - 160, HAUT);
        JLabel jLabel4 = new JLabel("Height (arcmin)");
        jLabel4.setBounds(10, n += HAUT + MARGE, 150, HAUT);
        this.add(jLabel4);
        this.heightField = new JTextField("2");
        this.add(this.heightField);
        this.heightField.setBounds(160, n, XWIDTH - 160, HAUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit() {
        double d;
        double d2;
        String string = this.getTarget();
        ALMASetup aLMASetup = (ALMASetup)this.setupList.getItemAt(this.setupList.getSelectedIndex());
        try {
            d2 = Double.parseDouble(this.widthField.getText()) / 60.0;
            d = Double.parseDouble(this.heightField.getText()) / 60.0;
        }
        catch (NumberFormatException numberFormatException) {
            Aladin.warning("Incorrect value for width/height !");
            return;
        }
        FootprintBean footprintBean = new FootprintBean();
        float f = aLMASetup.primaryBeam / 3600.0f;
        TreeSet<Point2D> treeSet = new TreeSet<Point2D>();
        double d3 = 0.0;
        int n = 0;
        while (true) {
            double d4;
            double d5 = (double)((float)n * f) * 0.5 * 0.5;
            if (!(d4 <= d2 / 2.0)) break;
            int n2 = 0;
            while (true) {
                double d6;
                double d7 = (double)((float)n2 * f) * Math.sqrt(3.0) * 0.5;
                if (!(d6 <= d / 2.0 + (double)(f / 2.0f))) break;
                if (n % 2 == 1) {
                    d7 += Math.sqrt(3.0) / 4.0 * (double)f;
                }
                for (int i = 0; i < 4; ++i) {
                    int n3 = i % 2 == 0 ? 1 : -1;
                    int n4 = i < 2 ? 1 : -1;
                    treeSet.add(new Point2D((double)n3 * d5, (double)n4 * d7));
                    if (!(d3 < d7)) continue;
                    d3 = d7;
                }
                ++n2;
            }
            ++n;
        }
        footprintBean.addSubFootprintBean(new SubFootprintBean(new double[]{0.0, 0.0}, new double[]{0.0, d3 *= 1.3}, "handle"));
        footprintBean.addSubFootprintBean(new SubFootprintBean(0.0, d3, 270.0, 180.0, 0.0, 0.001, "handle"));
        for (Point2D point2D : treeSet) {
            footprintBean.addSubFootprintBean(new SubFootprintBean(point2D.x, point2D.y, (double)f / 2.0, null));
        }
        Calque calque = this.aladin.calque;
        synchronized (calque) {
            int n5 = this.aladin.calque.newPlanField(footprintBean, string, "ALMA", 0.0);
            ((PlanField)this.aladin.calque.plan[n5]).setIsAlmaFP(true);
            ((PlanField)this.aladin.calque.plan[n5]).setOpacityLevel(0.05f);
        }
    }

    public static class ALMASetup {
        int bandId;
        float primaryBeam;
        float[] wavelengthRange;
        float[] frequencyRange;

        public ALMASetup(int n, float f, float[] fArray, float[] fArray2) {
            this.bandId = n;
            this.primaryBeam = f;
            this.wavelengthRange = fArray;
            this.frequencyRange = fArray2;
        }

        public String toString() {
            return "Band " + this.bandId + " | " + this.wavelengthRange[0] + "-" + this.wavelengthRange[1] + " mm | " + this.frequencyRange[0] + "-" + this.frequencyRange[1] + " GHz";
        }
    }

    public static class Point2D
    implements Comparable<Point2D> {
        private double x;
        private double y;

        public Point2D(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Point2D)) {
                return false;
            }
            Point2D point2D = (Point2D)object;
            return point2D.x == this.x && point2D.y == this.y;
        }

        @Override
        public int compareTo(Point2D point2D) {
            double d = 1.0E-5;
            if (Math.abs(point2D.x - this.x) < d && Math.abs(point2D.y - this.y) < d) {
                return 0;
            }
            return 1;
        }
    }
}

