/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Calque;
import cds.aladin.ComponentLocator;
import cds.aladin.Coord;
import cds.aladin.FrameInfo;
import cds.aladin.Glu;
import cds.aladin.MyButton;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.SelectDialog;
import cds.aladin.Server;
import cds.aladin.ServerAladin;
import cds.aladin.ServerAllVO;
import cds.aladin.ServerAlmaFootprint;
import cds.aladin.ServerFile;
import cds.aladin.ServerFoV;
import cds.aladin.ServerFolder;
import cds.aladin.ServerGlu;
import cds.aladin.ServerHips;
import cds.aladin.ServerMocQuery;
import cds.aladin.ServerNED;
import cds.aladin.ServerSWarp;
import cds.aladin.ServerSimbad;
import cds.aladin.ServerVizieR;
import cds.aladin.ServerVizieRMission;
import cds.aladin.ServerVizieRSurvey;
import cds.aladin.ServerWatch;
import cds.aladin.SwingWidgetFinder;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public final class ServerDialog
extends JFrame
implements SwingWidgetFinder,
Runnable,
ActionListener,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    static final int MAXSERVER = 10;
    static int ALADIN = 0;
    static int SIMBAD = 0;
    static int NED = 0;
    static int VIZIER = 0;
    static int FIELD = 0;
    static int LOCAL = 0;
    static final String VO_RESOURCES_BY_PLASTIC = "VO res.";
    static final String DEFAULTTAILLE = "14";
    protected String defaultTarget = "";
    protected String defaultTaille = "14";
    protected String defaultDate;
    String TITLE;
    String SUBMIT;
    String RESET;
    String CLEAR;
    String HELP;
    String CLOSE;
    String IMG;
    String CAT;
    String OTHER;
    String MESSAGE;
    String TIPRESET;
    String TIPCLEAR;
    String TIPSUBMIT;
    String TIPCLOSE;
    Server[] server;
    JPanel mp;
    CardLayout card;
    SelectDialog selectDialog;
    Label status;
    MyButton[] buttons;
    ServerFolder voResPopup;
    int current = 0;
    int bcurrent = 0;
    protected boolean flagSetPos = false;
    Server curServer;
    Server localServer;
    Server vizierServer;
    Server vizierArchives;
    Server vizierSurveys;
    Server vizierBestof;
    Server discoveryServer;
    Server aladinServer;
    Server fovServer;
    Server almaFovServer;
    Server vizierSED;
    Server hipsServer;
    JButton submit;
    Aladin aladin;
    Calque calque;
    private final JPanel buttonImg;
    long t1;
    long t;
    private boolean lock;
    protected boolean ivoaServersLoaded = false;
    private Thread threadUpdater = null;
    private boolean encore = true;

    protected String getDefaultTargetJ2000() {
        return this.defaultTarget.trim();
    }

    protected String getDefaultTarget() {
        return this.aladin.localisation.getFrameCoord(this.defaultTarget.trim());
    }

    protected String getDefaultTaille() {
        return this.defaultTaille.trim();
    }

    protected String getDefaultDate() {
        return this.defaultDate;
    }

    protected void setDefaultDate(String string) {
        this.defaultDate = string;
    }

    protected void setDefaultTarget(String string) {
        if (string.equals(" --   --")) {
            return;
        }
        this.defaultTarget = this.aladin.localisation.getICRSCoord(string);
    }

    protected void setDefaultTaille(Plan plan) {
        if (!Projection.isOk(plan.projd)) {
            return;
        }
        double d = Math.max(plan.projd.rm, plan.projd.rm1);
        this.defaultTaille = d > 0.0 ? 1.4142 * (d / 2.0) + "" : DEFAULTTAILLE;
    }

    protected void setDefaultTaille(String string) {
        if (string == null) {
            string = DEFAULTTAILLE;
        }
        this.defaultTaille = string;
    }

    private void addGluServer(Vector<Server> vector, int n) {
        for (int i = Glu.vGluServer.size() - 1; i >= 0; --i) {
            int n2;
            Server server = (Server)Glu.vGluServer.elementAt(i);
            if ((server.type & n) == 0) continue;
            vector.addElement(server);
            if (server.aladinMenu == null || server.isHidden()) continue;
            for (n2 = vector.size() - 1; n2 >= 0; --n2) {
                Server server2 = vector.elementAt(n2);
                if (server2.aladinLabel.equals(server.aladinMenu) && server2 instanceof ServerFolder) break;
            }
            if (n2 < 0) {
                n2 = vector.size();
                vector.addElement(new ServerFolder(this.aladin, server.aladinMenu, n2, n == 1 ? 0 : (n == 2 ? 1 : 2)));
            }
            ((ServerFolder)vector.elementAt(n2)).addItem(server.aladinLabel);
        }
    }

    protected int getLastGluServerIndice() {
        return this.findIndiceServer(this.aladin.glu.lastGluServer);
    }

    private Vector triServer(Vector vector) {
        Vector<Server> vector2 = new Vector<Server>(vector.size());
        Vector<Server> vector3 = new Vector<Server>(10);
        Vector<Server> vector4 = new Vector<Server>(10);
        Vector<Server> vector5 = new Vector<Server>(10);
        Vector<Server> vector6 = new Vector<Server>(10);
        Vector<Server> vector7 = new Vector<Server>(10);
        Vector<Server> vector8 = new Vector<Server>(10);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Server server = (Server)enumeration.nextElement();
            if (server instanceof ServerFolder) {
                if (server.aladinLabel.startsWith("Other")) {
                    vector5.addElement(server);
                    continue;
                }
                if (server.aladinLabel.startsWith("Optical") || server.aladinLabel.startsWith("DSS")) {
                    vector3.addElement(server);
                    continue;
                }
                vector4.addElement(server);
                continue;
            }
            if (server.aladinMenu != null) {
                if (server.aladinMenu.startsWith("Other")) {
                    vector7.addElement(server);
                    continue;
                }
                if (server.aladinMenu.startsWith("Optical")) {
                    vector8.addElement(server);
                    continue;
                }
                vector6.addElement(server);
                continue;
            }
            vector2.addElement(server);
        }
        int n = vector2.size();
        for (int i = 0; i < 6; ++i) {
            Enumeration enumeration2 = i == 0 ? vector3.elements() : (i == 1 ? vector4.elements() : (i == 2 ? vector5.elements() : (i == 4 ? vector6.elements() : (enumeration = i == 5 ? vector7.elements() : vector8.elements()))));
            while (enumeration.hasMoreElements()) {
                Server server = (Server)enumeration.nextElement();
                if (server instanceof ServerFolder) {
                    ((ServerFolder)server).numButton = n++;
                }
                vector2.addElement(server);
            }
        }
        return vector2;
    }

    protected int getMargeGauche() {
        return this.buttonImg.size().width;
    }

    protected void createChaine() {
        this.TITLE = Aladin.chaine.getString("SERVERTITLE");
        this.SUBMIT = Aladin.chaine.getString("SUBMIT");
        this.RESET = Aladin.chaine.getString("RESET");
        this.CLEAR = Aladin.chaine.getString("CLEAR");
        this.CLOSE = Aladin.chaine.getString("CLOSE");
        this.IMG = Aladin.chaine.getString("IMG");
        this.CAT = Aladin.chaine.getString("CAT");
        this.OTHER = Aladin.chaine.getString("OTHER");
        this.MESSAGE = Aladin.chaine.getString("SSHELP");
        this.TIPRESET = Aladin.chaine.getString("TIPRESET");
        this.TIPCLEAR = Aladin.chaine.getString("TIPCLEAR");
        this.TIPSUBMIT = Aladin.chaine.getString("TIPSUBMIT");
        this.TIPCLOSE = Aladin.chaine.getString("TIPCLOSE");
    }

    protected ServerDialog(Aladin aladin) {
        int n;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.aladin = aladin;
        Aladin.setIcon(this);
        Vector vector = new Vector(100);
        JPanel jPanel3 = new JPanel();
        this.createChaine();
        this.setTitle(this.TITLE);
        this.calque = aladin.calque;
        this.setFont(Aladin.BOLD);
        this.enableEvents(64L);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.trapESC();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerDialog.this.trapESC();
            }
        }, KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setFont(Aladin.LITALIC);
        jLabel2.setForeground(Color.blue);
        if (!Aladin.OUTREACH && Aladin.NETWORK) {
            this.aladinServer = new ServerAladin(aladin);
            vector.addElement((Server)this.aladinServer);
        }
        if (Aladin.NETWORK) {
            this.addGluServer(vector, 1);
        }
        if (Aladin.OUTREACH && Aladin.NETWORK) {
            this.aladinServer = new ServerAladin(aladin);
            vector.addElement(this.aladinServer);
        }
        if (Aladin.NETWORK) {
            jPanel2 = new ServerVizieR(aladin, this, jPanel3);
            this.vizierServer = jPanel2;
            if (!Aladin.OUTREACH) {
                vector.addElement(jPanel2);
                this.vizierSurveys = new ServerVizieRSurvey(aladin, ((ServerVizieR)jPanel2).vSurveys);
                vector.addElement(this.vizierSurveys);
                this.vizierArchives = new ServerVizieRMission(aladin, ((ServerVizieR)jPanel2).vArchives);
                vector.addElement(this.vizierArchives);
                vector.addElement(new ServerSimbad(aladin));
                vector.addElement(new ServerNED(aladin));
                if (Aladin.PROTO) {
                    vector.addElement(new ServerSWarp(aladin));
                }
                if (Aladin.BETA) {
                    vector.addElement(new ServerMocQuery(aladin));
                }
            } else {
                vector.addElement(new ServerSimbad(aladin));
                this.vizierSurveys = new ServerVizieRSurvey(aladin, ((ServerVizieR)jPanel2).vSurveys);
                vector.addElement(this.vizierSurveys);
                this.vizierArchives = new ServerVizieRMission(aladin, ((ServerVizieR)jPanel2).vArchives);
                vector.addElement(this.vizierArchives);
                vector.addElement(jPanel2);
            }
        }
        if (Aladin.NETWORK) {
            this.addGluServer(vector, 2);
        }
        if (!Aladin.OUTREACH) {
            vector = this.triServer(vector);
        }
        this.hipsServer = new ServerHips(aladin);
        vector.addElement(this.hipsServer);
        this.localServer = new ServerFile(aladin);
        vector.addElement(this.localServer);
        this.discoveryServer = null;
        if (!Aladin.OUTREACH && Aladin.NETWORK) {
            this.discoveryServer = new ServerAllVO(aladin);
            vector.addElement(this.discoveryServer);
        }
        vector.addElement(new ServerWatch(aladin));
        if (!Aladin.OUTREACH && Aladin.NETWORK) {
            this.addGluServer(vector, 4);
        }
        if (!Aladin.OUTREACH) {
            this.fovServer = new ServerFoV(aladin);
            vector.addElement(this.fovServer);
            int n2 = vector.size();
            jPanel = new ServerFolder(aladin, this.fovServer.aladinMenu, n2, 2);
            vector.addElement(jPanel);
            ((ServerFolder)jPanel).addItem(this.fovServer.aladinLabel);
            this.almaFovServer = new ServerAlmaFootprint(aladin);
            vector.addElement(this.almaFovServer);
            ((ServerFolder)jPanel).addItem(this.almaFovServer.aladinLabel);
        }
        if (!Aladin.OUTREACH && Aladin.NETWORK) {
            this.addGluServer(vector, 24);
        }
        jPanel2 = new JPanel();
        this.buttonImg = new JPanel();
        jPanel = new JPanel();
        jPanel2.setOpaque(false);
        this.buttonImg.setOpaque(false);
        jPanel.setOpaque(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weighty = 0.0;
        this.buttonImg.setLayout(gridBagLayout2);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        jPanel.setLayout(gridBagLayout3);
        gridBagConstraints2.insets.bottom = 6;
        gridBagConstraints2.insets.top = 12;
        JLabel jLabel3 = jLabel = new JLabel(Util.fold("<center><i>" + this.IMG + "</i></center>", 80, true));
        jLabel.setFont(Aladin.BOLD);
        jLabel.setForeground(Aladin.DARKBLUE);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        this.buttonImg.add(jLabel);
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints3.insets.bottom = 6;
        gridBagConstraints3.insets.top = 12;
        JLabel jLabel4 = jLabel = new JLabel(Util.fold("<center><i>" + this.CAT + "</i></center>", 80, true));
        jLabel.setFont(Aladin.BOLD);
        jLabel.setForeground(Aladin.DARKBLUE);
        gridBagLayout3.setConstraints(jLabel, gridBagConstraints3);
        jPanel.add(jLabel);
        gridBagConstraints3.insets.bottom = 0;
        gridBagConstraints3.insets.top = 0;
        gridBagConstraints.insets.right = 12;
        jLabel = new JLabel(Util.fold("<center><i>" + this.OTHER + "</i></center>", 80, true));
        jLabel.setFont(Aladin.BOLD);
        jLabel.setForeground(Aladin.DARKBLUE);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.insets.right = 0;
        this.server = new Server[vector.size()];
        this.buttons = new MyButton[vector.size()];
        MyButton myButton = null;
        MyButton myButton2 = null;
        MyButton myButton3 = null;
        for (n = 0; n < this.server.length; ++n) {
            gridBagConstraints2.insets.top = 0;
            this.server[n] = (Server)vector.elementAt(n);
            if (this.server[n].isHidden()) continue;
            if (this.server[n] instanceof ServerFile) {
                LOCAL = n;
            } else if (this.server[n] instanceof ServerFoV) {
                FIELD = n;
            } else if (this.server[n] instanceof ServerVizieR) {
                VIZIER = n;
                if (Aladin.OUTREACH) {
                    gridBagConstraints3.insets.top = 45;
                    myButton3.setLastInColumn();
                }
            } else if (this.server[n] instanceof ServerAladin) {
                ALADIN = n;
                if (Aladin.OUTREACH && myButton2 != null) {
                    myButton2.setLastInColumn();
                }
            } else if (this.server[n] instanceof ServerNED) {
                NED = n;
            } else if (this.server[n] instanceof ServerSimbad) {
                SIMBAD = n;
            } else if (Aladin.OUTREACH && this.server[n].aladinLabel.startsWith("Hubble")) {
                gridBagConstraints2.insets.top = 45;
            }
            if (this.server[n].aladinMenu != null) continue;
            if (this.server[n].type == 1) {
                myButton2 = this.buttons[n] = new MyButton(aladin, jLabel2, 2, this.server[n].aladinLabel, this.server[n].description);
                gridBagLayout2.setConstraints(this.buttons[n], gridBagConstraints2);
                this.buttonImg.add(this.buttons[n]);
            } else if (this.server[n].type == 2) {
                myButton3 = this.buttons[n] = new MyButton(aladin, jLabel2, 3, this.server[n].aladinLabel, this.server[n].description);
                gridBagLayout3.setConstraints(this.buttons[n], gridBagConstraints3);
                jPanel.add(this.buttons[n]);
            } else {
                myButton = this.buttons[n] = new MyButton(aladin, jLabel2, 4, this.server[n].aladinLabel, this.server[n].description);
                gridBagLayout.setConstraints(this.buttons[n], gridBagConstraints);
                jPanel2.add(this.buttons[n]);
            }
            this.buttons[n].setAlwaysUp(false);
            this.buttons[n].setModeMenu(true);
            if (this.server[n].aladinLogo == null) continue;
            try {
                this.buttons[n].setBackGroundLogo(aladin.getImagette(this.server[n].aladinLogo), this.server[n] instanceof ServerFolder ? 1 : 0);
                continue;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        jLabel = new JLabel();
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        this.buttonImg.add(jLabel);
        jLabel = new JLabel();
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.fill = 1;
        gridBagLayout3.setConstraints(jLabel, gridBagConstraints3);
        jPanel.add(jLabel);
        jLabel = new JLabel();
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        if (myButton2 == null) {
            jLabel3.setText(Util.fold("<center><i>No image\nservers\nfound !</i></center>", 80, true));
        }
        if (myButton3 == null) {
            jLabel4.setText(Util.fold("<center><i>No catalog\nservers\nfound !</i></center>", 80, true));
        }
        if (myButton != null) {
            myButton.setLastInColumn();
        }
        if (myButton3 != null) {
            myButton3.setLastInColumn();
        }
        if (myButton2 != null) {
            myButton2.setLastInColumn();
        }
        vector = null;
        this.buttons[this.bcurrent].push();
        this.setFont(Aladin.PLAIN);
        this.mp = new JPanel();
        this.mp.setOpaque(true);
        this.card = new CardLayout();
        this.mp.setLayout(this.card);
        for (n = 0; n < this.server.length; ++n) {
            if (this.server[n] == null || this.server[n].isHidden()) continue;
            this.server[n].setOpaque(true);
            this.mp.add(this.server[n].aladinLabel, this.server[n]);
        }
        this.selectDialog = new SelectDialog(this, this.mp);
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new BorderLayout());
        Aladin.makeAdd(jPanel4, this.buttonImg, "West");
        Aladin.makeAdd(jPanel4, this.selectDialog, "Center");
        Aladin.makeAdd(jPanel4, jPanel, "East");
        JButton jButton = new JButton(this.RESET);
        jPanel3.add(jButton);
        jButton.addActionListener(this);
        jButton.setOpaque(false);
        jButton.setToolTipText(this.TIPRESET);
        jButton = new JButton(this.CLEAR);
        jPanel3.add(jButton);
        jButton.addActionListener(this);
        jButton.setOpaque(false);
        jButton.setToolTipText(this.TIPCLEAR);
        jPanel3.add(new JLabel("           "));
        jButton = this.submit = new JButton(this.SUBMIT);
        jButton.addActionListener(this);
        jButton.setOpaque(false);
        jButton.setToolTipText(this.TIPSUBMIT);
        jButton.setForeground(Aladin.GREEN);
        jButton.setFont(jButton.getFont().deriveFont(1));
        jPanel3.add(this.submit);
        jButton = new JButton(this.CLOSE);
        jPanel3.add(jButton);
        jButton.addActionListener(this);
        jButton.setOpaque(false);
        jButton.setToolTipText(this.TIPCLOSE);
        jButton.setForeground(Color.red);
        jButton.setFont(jButton.getFont().deriveFont(1));
        jButton = Util.getHelpButton(this, this.MESSAGE);
        jPanel3.add(jButton);
        jPanel3.setFont(Aladin.BOLD);
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        jPanel5.setLayout(new BorderLayout(0, 0));
        Aladin.makeAdd(jPanel5, jLabel2, "Center");
        Aladin.makeAdd(jPanel5, jPanel3, "South");
        jPanel3.setOpaque(false);
        JPanel jPanel6 = (JPanel)this.getContentPane();
        jPanel6.setOpaque(true);
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        Aladin.makeAdd(jPanel6, jPanel2, "North");
        Aladin.makeAdd(jPanel6, jPanel4, "Center");
        Aladin.makeAdd(jPanel6, jPanel5, "South");
        aladin.manageDrop();
        this.setCurrent("hips");
        this.run();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.aladin.drop(dropTargetDropEvent);
    }

    @Override
    public void run() {
        this.pack();
        try {
            this.aladin.addServerMenu(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setLock(true);
    }

    private synchronized void setLock(boolean bl) {
        this.lock = bl;
    }

    private synchronized boolean packed() {
        return this.lock;
    }

    protected synchronized boolean appendIVOAServer() {
        if (this.ivoaServersLoaded) {
            return true;
        }
        URL uRL = null;
        try {
            uRL = this.aladin.glu.getURL("IVOAdic");
            Aladin.trace(1, "Loading the remote IVOA glu dictionary");
            Aladin.trace(3, "  => " + uRL);
            DataInputStream dataInputStream = new DataInputStream(Aladin.cache.getWithBackup(uRL.toString()));
            Glu cfr_ignored_0 = this.aladin.glu;
            Glu.vGluServer = new Vector(50);
            this.aladin.glu.loadGluDic(dataInputStream, true, false);
            Glu cfr_ignored_1 = this.aladin.glu;
            int n = Glu.vGluServer.size();
            if (n == 0) {
                this.ivoaServersLoaded = false;
                return false;
            }
            Server[] serverArray = new Server[this.server.length + n];
            System.arraycopy(this.server, 0, serverArray, 0, this.server.length);
            for (int i = 0; i < n; ++i) {
                Glu cfr_ignored_2 = this.aladin.glu;
                serverArray[this.server.length + i] = (Server)Glu.vGluServer.elementAt(i);
            }
            this.server = serverArray;
            serverArray = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Remote IVOA Glu dictionary not reached");
            this.ivoaServersLoaded = false;
            return false;
        }
        this.ivoaServersLoaded = true;
        return true;
    }

    protected synchronized void appendServersFromStream(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            Glu cfr_ignored_0 = this.aladin.glu;
            Glu.vGluServer = new Vector(50);
            this.aladin.glu.loadGluDic(dataInputStream, true, false);
            Glu cfr_ignored_1 = this.aladin.glu;
            int n = Glu.vGluServer.size();
            if (n == 0) {
                return;
            }
            Server[] serverArray = new Server[this.server.length + n];
            System.arraycopy(this.server, 0, serverArray, 0, this.server.length);
            for (int i = 0; i < n; ++i) {
                Glu cfr_ignored_2 = this.aladin.glu;
                serverArray[this.server.length + i] = (Server)Glu.vGluServer.elementAt(i);
            }
            this.server = serverArray;
            serverArray = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Problem while adding servers");
        }
    }

    protected int getServer(String string) {
        for (int i = 0; i < this.server.length; ++i) {
            if (!this.server[i].is(string)) continue;
            return i;
        }
        return -1;
    }

    private void trapESC() {
        if (this.aladin.command.robotMode) {
            this.aladin.stopRobot(this);
        } else {
            this.cache();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.cache();
        }
        super.processWindowEvent(windowEvent);
    }

    protected void cache() {
        try {
            FrameInfo frameInfo;
            if (Aladin.NETWORK) {
                ((ServerVizieR)this.server[VIZIER]).hideSFrame();
            }
            if ((frameInfo = this.aladin.getFrameInfo()) != null) {
                frameInfo.setVisible(false);
            }
            if (this.discoveryServer != null && ((ServerAllVO)this.discoveryServer).frameServer != null) {
                ((ServerAllVO)this.discoveryServer).frameServer.setVisible(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
    }

    void popOtherButton() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (i == this.bcurrent || this.buttons[i] == null) continue;
            this.buttons[i].pop();
        }
    }

    protected void setGrabItCoord(double d, double d2) {
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        Plan plan = viewSimple.pref;
        if (plan == null) {
            return;
        }
        Projection projection = plan.projd;
        if (projection == null) {
            return;
        }
        PointD pointD = viewSimple.getPosition(d, d2);
        Coord coord = new Coord();
        coord.x = pointD.x;
        coord.y = pointD.y;
        projection.getCoord(coord);
        if (Double.isNaN(coord.al)) {
            return;
        }
        this.server[this.current].setTarget(this.aladin.localisation.getFrameCoord(coord.getSexa()));
    }

    protected void stopGrabIt() {
        JToggleButton jToggleButton = this.server[this.current].grab;
        if (jToggleButton != null) {
            Plan plan = this.aladin.calque.getPlanRef();
            jToggleButton.getModel().setSelected(false);
            jToggleButton.setEnabled(plan != null && Projection.isOk(plan.projd));
            Server server = this.server[this.current];
            if (server.tree != null && !server.tree.isEmpty()) {
                server.tree.clear();
            }
        }
        this.toFront();
    }

    protected void startGrabIt() {
        if (this.server[this.current].grab == null || !this.server[this.current].grab.getModel().isSelected()) {
            return;
        }
        this.aladin.f.toFront();
    }

    protected boolean isGrabIt() {
        return this.server[this.current].modeCoo != 0 && this.server[this.current].grab != null && this.server[this.current].grab.getModel().isSelected();
    }

    protected void setGrabItRadius(double d, double d2, double d3, double d4) {
        if (this.server[this.current].modeRad == 0) {
            return;
        }
        if (Math.abs(d - d3) < 3.0 && Math.abs(d2 - d4) < 3.0) {
            return;
        }
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        Plan plan = viewSimple.pref;
        if (plan == null) {
            return;
        }
        Projection projection = plan.projd;
        if (projection == null) {
            return;
        }
        PointD pointD = viewSimple.getPosition(d, d2);
        PointD pointD2 = viewSimple.getPosition(d3, d4);
        Coord coord = new Coord();
        coord.x = pointD.x;
        coord.y = pointD.y;
        projection.getCoord(coord);
        if (Double.isNaN(coord.al)) {
            return;
        }
        Coord coord2 = new Coord();
        coord2.x = pointD2.x;
        coord2.y = pointD2.y;
        projection.getCoord(coord2);
        if (Double.isNaN(coord2.al)) {
            return;
        }
        this.server[this.current].resolveRadius(Coord.getUnit(Coord.getDist(coord, coord2)), true);
    }

    protected void adjustParameters() {
        this.setDefaultParameters(this.current, 3);
    }

    protected synchronized void setDefaultParameters(int n, int n2) {
        block20: {
            Object object;
            Projection projection;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (n2 == 1 || n2 == 2 || n2 == 5) {
                string = this.getDefaultTarget();
                if (string.length() == 0) {
                    string = null;
                }
                if ((string2 = this.getDefaultTaille()).length() == 0) {
                    string2 = null;
                }
            }
            boolean bl = false;
            ViewSimple viewSimple = this.aladin.view.getCurrentView();
            if (viewSimple != null && !viewSimple.isFree() && viewSimple.pref != null && (projection = viewSimple.getProj()) != null) {
                if (n2 == 1 || n2 == 2 || n2 == 4 || n2 == 5) {
                    string6 = viewSimple.pref.objet;
                }
                if (n2 != 2 && n2 != 3 && Projection.isOk(projection)) {
                    boolean bl2 = bl = projection.rm > 10800.0;
                    if (viewSimple.pref.isImage()) {
                        object = projection.c;
                        string4 = Coord.getUnit(((Calib)object).getImgWidth()) + " x " + Coord.getUnit(((Calib)object).getImgHeight());
                    } else {
                        string4 = Coord.getUnit(projection.rm / 120.0);
                    }
                }
                if (n2 == 3) {
                    string4 = viewSimple.getTaille(2);
                }
                string3 = n2 == 2 || n2 == 3 || n2 == 5 || viewSimple.pref instanceof PlanBG ? Coord.getSexa(this.aladin.view.repere.raj, this.aladin.view.repere.dej, ":") : viewSimple.getCentre();
                if (bl) {
                    string3 = null;
                    string4 = null;
                }
            } else {
                string = this.getDefaultTarget();
                string2 = this.getDefaultTaille();
            }
            Object object2 = string != null ? string : (string6 != null ? this.aladin.localisation.getFrameCoord(string6) : (object = string3 != null ? this.aladin.localisation.getFrameCoord(string3) : ""));
            String string7 = n2 == 5 ? (string2 != null ? string2 : string4) : (string4 != null ? string4 : string2);
            this.setDefaultTarget((String)object);
            if (this.server[n].modeRad != 0) {
                this.setDefaultTaille(string4);
            }
            if (viewSimple != null) {
                string5 = viewSimple.getEpoch();
                if (string5 != null) {
                    this.server[n].setDate(string5);
                } else if (viewSimple.pref instanceof PlanImage && (string5 = ((PlanImage)viewSimple.pref).getDateObs()) != null) {
                    this.server[n].setDate(string5);
                }
                this.setDefaultDate(string5);
            }
            if (!(this.server[n].tree == null || this.server[n].tree.isEmpty() || this.server[n].target != null && this.server[n].target.getText().trim().length() == 0)) {
                return;
            }
            this.server[n].setTarget((String)object);
            try {
                if (string7 != null && string7.trim().length() != 0 && this.server[n].modeRad != 0) {
                    this.server[n].resolveRadius(string7, true);
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block20;
                exception.printStackTrace();
            }
        }
    }

    protected void setGrab() {
        Plan plan = this.aladin.calque.getPlanRef();
        boolean bl = plan != null && plan.projd != null;
        for (int i = 0; i < this.server.length; ++i) {
            if (this.server[i] == null || this.server[i].grab == null) continue;
            this.server[i].grab.setEnabled(bl);
        }
    }

    void showNow() {
        while (!this.packed()) {
            Util.pause(100);
        }
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            super.setVisible(false);
            return;
        }
        if (!this.packed()) {
            return;
        }
        if (this.current >= 0) {
            this.server[this.current].resumeTargetLabel();
        }
        if (!this.flagSetPos) {
            this.setLocation(Aladin.computeLocation(this));
            if (this.current >= 0) {
                this.server[this.current].setInitialFocus();
                this.server[this.current].initServer();
            }
            this.flagSetPos = true;
        }
        this.setDefaultParameters(this.current, 2);
        try {
            super.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void resume() {
        this.setGrab();
        this.server[this.current].resumeTargetLabel();
        this.server[this.current].resumeInputChoice();
    }

    protected boolean submitServer(String string) {
        int n = this.findIndiceServer(string);
        if (n < 0 && this.vizierSurveys.setParam(string)) {
            n = this.findIndiceServer(this.vizierSurveys);
        }
        if (n < 0 && this.vizierArchives.setParam(string)) {
            n = this.findIndiceServer(this.vizierArchives);
        }
        if (n < 0) {
            return false;
        }
        this.setCurrent(n);
        if (!Aladin.OUTREACH || this.getDefaultTarget().length() == 0) {
            this.toFront();
        } else {
            this.server[n].submit();
        }
        return true;
    }

    public boolean show(String string) {
        int n = this.findIndiceServer(string);
        if (n < 0) {
            return false;
        }
        this.setCurrent(n);
        this.toFront();
        return true;
    }

    protected void show(Server server) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.setCurrent(this.findIndiceServer(server));
        this.toFront();
    }

    protected boolean show(Server server, String string) {
        if (server == null || !server.setParam(string)) {
            return false;
        }
        this.setCurrent(this.findIndiceServer(server));
        this.toFront();
        return true;
    }

    @Override
    public void toFront() {
        this.setExtendedState(0);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        super.toFront();
    }

    private int findIndiceServer(Server server) {
        for (int i = 0; i < this.server.length; ++i) {
            if (this.server[i] != server) continue;
            return i;
        }
        return -1;
    }

    protected int findIndiceServer(String string) {
        for (int i = 0; i < this.server.length; ++i) {
            if (!this.server[i].sameNom(string)) continue;
            return i;
        }
        return -1;
    }

    protected int getCurrent() {
        return this.current;
    }

    protected String[] getServerNames(int n, boolean bl) {
        int n2 = 0;
        String[] stringArray = null;
        for (int i = 0; i < 2; ++i) {
            if (i == 1) {
                stringArray = new String[n2];
            }
            n2 = 0;
            for (int j = 0; j < this.server.length; ++j) {
                if (this.server[j] == null || this.server[j].isHidden() || this.server[j] instanceof ServerFolder || (this.server[j].type & n) == 0 || !bl && !(this.server[j] instanceof ServerGlu)) continue;
                String[] stringArray2 = this.server[j].getNomPaths();
                if (i == 1) {
                    for (int k = 0; k < stringArray2.length; ++k) {
                        stringArray[n2 + k] = stringArray2[k];
                    }
                }
                n2 += stringArray2.length;
            }
        }
        return stringArray;
    }

    protected String[] getServerLogos(int n) {
        int n2 = 0;
        String[] stringArray = null;
        for (int i = 0; i < 2; ++i) {
            if (i == 1) {
                stringArray = new String[n2];
            }
            n2 = 0;
            for (int j = 0; j < this.server.length; ++j) {
                if (this.server[j] == null || this.server[j].isHidden() || this.server[j] instanceof ServerFolder || this.server[j].type != n) continue;
                String[] stringArray2 = new String[]{this.server[j].aladinLogo};
                if (i == 1) {
                    for (int k = 0; k < stringArray2.length; ++k) {
                        stringArray[n2 + k] = stringArray2[k];
                    }
                }
                n2 += stringArray2.length;
            }
        }
        return stringArray;
    }

    protected void setCurrent(String string) {
        this.setCurrent(this.findIndiceServer(string));
    }

    protected void setCurrent(int n) {
        if (n < 0 || n >= this.server.length) {
            return;
        }
        if (this.buttons[n] != null) {
            this.buttons[n].push();
        }
        this.setDefaultParameters(n, 2);
        this.current = n;
        this.curServer = this.server[this.current];
        this.bcurrent = this.server[n].aladinMenu != null ? this.findIndiceServer(this.server[n].aladinMenu) : n;
        this.selectDialog.invalidate();
        this.selectDialog.repaint();
        this.popOtherButton();
        if (this.server[n] instanceof ServerGlu) {
            ((ServerGlu)this.server[n]).majChoiceSize();
        }
        this.card.show(this.mp, this.server[n].aladinLabel);
        if (this.server[n] instanceof ServerVizieR) {
            ((ServerVizieR)this.server[VIZIER]).hideSFrame();
        }
        this.server[n].setInitialFocus();
        this.server[n].initServer();
        this.invalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!(actionEvent.getSource() instanceof JButton)) {
            return;
        }
        String string = ((JButton)actionEvent.getSource()).getActionCommand();
        if (this.CLOSE.equals(string)) {
            this.server[this.current].memTarget();
            this.cache();
            return;
        }
        if (this.CLEAR.equals(string)) {
            this.server[this.current].clear();
            return;
        }
        if (this.SUBMIT.equals(string)) {
            if ((actionEvent.getModifiers() & 1) != 0) {
                this.server[this.current].flagVerif = false;
            }
            this.server[this.current].submit();
            return;
        }
        if (this.RESET.equals(string)) {
            this.server[this.current].reset();
            return;
        }
    }

    @Override
    public boolean action(Event event, Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        this.server[this.current].memTarget();
        this.setCurrent((String)object);
        return false;
    }

    @Override
    public boolean findWidget(String string) {
        return string.equalsIgnoreCase("local") || string.equalsIgnoreCase("simbad") || string.equalsIgnoreCase("ned") || string.equals("vizier") || string.equals("aladin");
    }

    @Override
    public Point getWidgetLocation(String string) {
        ComponentLocator componentLocator = new ComponentLocator();
        if (string.equalsIgnoreCase("local") || string.equalsIgnoreCase("mydata")) {
            return componentLocator.getLocation(this.buttons[LOCAL], this);
        }
        if (string.equalsIgnoreCase("simbad")) {
            return componentLocator.getLocation(this.buttons[SIMBAD], this);
        }
        if (string.equalsIgnoreCase("ned")) {
            return componentLocator.getLocation(this.buttons[NED], this);
        }
        if (string.equalsIgnoreCase("vizier")) {
            return componentLocator.getLocation(this.buttons[VIZIER], this);
        }
        if (string.equalsIgnoreCase("aladin")) {
            return componentLocator.getLocation(this.buttons[ALADIN], this);
        }
        return null;
    }

    @Override
    public void show() {
        super.show();
        this.startHipsUpdater();
    }

    @Override
    public void hide() {
        this.stopHipsUpdater();
        super.hide();
    }

    private void startHipsUpdater() {
        if (this.threadUpdater == null) {
            this.threadUpdater = new Updater("HipsUpdater");
            this.threadUpdater.start();
        } else {
            this.encore = true;
        }
    }

    private void stopHipsUpdater() {
        this.encore = false;
    }

    private boolean isOpened() {
        return this.isVisible();
    }

    class Updater
    extends Thread {
        public Updater(String string) {
            super(string);
        }

        @Override
        public void run() {
            ServerDialog.this.encore = true;
            while (ServerDialog.this.encore) {
                try {
                    if (ServerDialog.this.isOpened()) {
                        ((ServerHips)ServerDialog.this.aladin.dialog.hipsServer).hipsUpdate();
                    }
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            ServerDialog.this.threadUpdater = null;
        }
    }
}

