/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.Cercle;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.FrameHeaderFits;
import cds.aladin.IDHAGenerator;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.MetaDataTree;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFolder;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageAlgo;
import cds.aladin.PlanImageMosaic;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanImageResamp;
import cds.aladin.PlanTool;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.ResourceNode;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.ServerFoV;
import cds.aladin.Source;
import cds.aladin.SourceStat;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewMemoItem;
import cds.tools.Util;
import cds.xml.Field;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.ColorModel;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ServerFile
extends Server
implements XMLConsumer {
    String BROWSE;
    JTextField file;
    static String loadError;
    String titre;
    String info1;
    String info2;
    String info3;
    private Coord circleCenter;
    String of = "";
    private static final String DEFAULT_FILENAME = "-";
    private boolean inValue;
    private boolean inFilterScript;
    private boolean inFitsHeader;
    private boolean inFilter;
    private int nFilter = 0;
    private Vector vField;
    private Legende leg = null;
    private Plan plan = null;
    private ViewMemoItem vmi;
    private int firstView;
    private double ra = 0.0;
    private double de = 0.0;
    private double rm = 0.0;
    private int proj = 0;
    private int typePlan = -1;
    private boolean flagCatalogSource = false;
    private String rec;
    private Obj prevO = null;
    private boolean prevFlagSuite = false;
    private Vector pdf = null;
    byte[] rgb = null;
    int pOffset = 0;
    Hashtable pFilter;
    static final int CATALOGTOOL = 1000;
    static final int AJTOOL = 1001;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("FILEINFO");
        this.titre = Aladin.chaine.getString("FILETITLE");
        this.verboseDescr = Aladin.chaine.getString("FILEDESC");
        this.info1 = Aladin.chaine.getString("FILEINFO1");
        this.info2 = Aladin.chaine.getString("FILEINFO2");
        this.info3 = Aladin.chaine.getString("FILEINFO3");
        this.BROWSE = Aladin.chaine.getString("FILEBROWSE");
    }

    protected void init() {
        this.type = 8;
        this.aladinLogo = "MyDataLogo.gif";
    }

    protected ServerFile(Aladin aladin) {
        JComponent jComponent;
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 45;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Aladin.BLUE);
        Dimension dimension = this.makeTitle(jPanel, this.titre);
        jPanel.setBounds(235 - dimension.width / 2, n, dimension.width, dimension.height);
        this.add(jPanel);
        JLabel jLabel = new JLabel(this.info1 + " " + (Aladin.STANDALONE ? this.info2 + " " : "") + this.info3);
        jLabel.setBounds(20, n += dimension.height + 10, 400, 20);
        n += 20;
        this.add(jLabel);
        this.file = new JTextField(50);
        this.file.addKeyListener(this);
        int n2 = 60;
        int n3 = XWIDTH - 10 - n2;
        this.file.setBounds(10, n, n3 - 15, HAUT);
        this.add(this.file);
        if (Aladin.STANDALONE) {
            jComponent = new JButton(this.BROWSE);
            ((AbstractButton)jComponent).setMargin(new Insets(0, 0, 0, 0));
            ((AbstractButton)jComponent).addActionListener(this);
            jComponent.setBounds(n3, n + 1, n2, 24);
            n += 40;
            this.add(jComponent);
        } else {
            n += 40;
        }
        this.tree = new MetaDataTree(aladin, null);
        jComponent = new JScrollPane(this.tree);
        this.tree.setScroll((JScrollPane)jComponent);
        jComponent.setBackground(this.tree.bkgColor);
        jComponent.setBounds(10, n, XWIDTH - 20, 230);
        n += 230;
        this.add(jComponent);
        this.setMaxComp(jComponent);
    }

    @Override
    protected boolean is(String string) {
        if (string.equalsIgnoreCase("Local") || string.equalsIgnoreCase("MyData") || string.equalsIgnoreCase("File")) {
            return true;
        }
        return super.is(string);
    }

    @Override
    protected int createPlane(String string, String string2, String string3, String string4, String string5) {
        String string6;
        int n;
        String string7 = string3;
        Tok tok = new Tok(string3, " ,");
        string7 = tok.nextToken();
        if (tok.hasMoreTokens()) {
            string4 = tok.nextToken();
        }
        if (tok.hasMoreTokens()) {
            string5 = tok.nextToken();
        }
        if ((n = string7.lastIndexOf(32)) > 0 && ((string6 = string7.substring(n + 1).toLowerCase()).startsWith("image/") || string6.startsWith("text/"))) {
            string7 = string7.substring(0, n);
        }
        return this.creatLocalPlane(string7, string4, string5, null, null, null, this, string, string2);
    }

    private String getNameWithoutBrackets(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n < 4 || string.charAt(n - 1) != ']') {
            return string;
        }
        int n2 = string.lastIndexOf(91);
        if (n2 < 0) {
            return string;
        }
        try {
            n = Integer.parseInt(string.substring(n2 + 1, n - 1));
            return string.substring(0, n2);
        }
        catch (Exception exception) {
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int creatLocalPlane(String string, String string2, String string3, Obj obj, ResourceNode resourceNode, InputStream inputStream, Server server, String string4, String string5) {
        String string6 = this.aladin.synchroServer.start("ServerFile.creatLocalPlane/" + string2);
        try {
            long l;
            boolean bl;
            URL uRL;
            MyInputStream myInputStream;
            int n;
            block77: {
                n = 0;
                myInputStream = null;
                uRL = null;
                bl = false;
                if (string != null) {
                    string = this.aladin.getFullFileName(string);
                }
                this.waitCursor();
                try {
                    if (string2 == null) {
                        int n2 = string.lastIndexOf(string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:") ? "/" : Util.FS);
                        string2 = n2 >= 0 ? string.substring(n2 + 1) : string;
                        if ((n2 = string2.lastIndexOf(46)) > 0 && string2.length() - n2 <= 5) {
                            string2 = string2.substring(0, n2);
                        }
                    }
                    if (inputStream != null || string.startsWith("http:") || string.startsWith("https:")) break block77;
                    try {
                        final File file = new File(string);
                        if (!file.isDirectory()) break block77;
                        Aladin.trace(4, "ServerFile.creatLocalPlane(" + string + "...) => detect: DIR");
                        if (PlanBG.isPlanBG(string)) {
                            void var18_26;
                            void var18_23;
                            Object var18_21 = null;
                            try {
                                TreeNodeAllsky treeNodeAllsky = new TreeNodeAllsky(this.aladin, string);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (var18_23 == null) {
                                if (PlanBG.isPlanHpxFinder(string)) {
                                    TreeNodeAllsky treeNodeAllsky = new TreeNodeAllsky(this.aladin, null, null, null, null, null, null, null, null, null, null, null, string, "15 progen", null);
                                } else if (new File(string + "/" + "metadata.xml").exists() || new File(string + "/Norder3/Allsky.xml").exists()) {
                                    TreeNodeAllsky treeNodeAllsky = new TreeNodeAllsky(this.aladin, null, null, null, null, null, null, null, null, null, null, null, string, "15 cat", null);
                                }
                            }
                            n = var18_26 != null ? this.aladin.calque.newPlanBG((TreeNodeAllsky)var18_26, string2, string4, string5) : this.aladin.calque.newPlanBG(string, string2, string4, string5);
                        } else {
                            final ServerFile serverFile = this;
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        ServerFile.this.aladin.log("load", "dir");
                                        MyInputStream myInputStream = new MyInputStream(new IDHAGenerator().getStream(file, serverFile));
                                        ServerFile.this.updateMetaData(myInputStream, serverFile, "", null);
                                        myInputStream.close();
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                    ServerFile.this.defaultCursor();
                                }
                            }.start();
                        }
                        int n3 = n;
                        return n3;
                    }
                    catch (Exception exception) {
                        this.defaultCursor();
                        exception.printStackTrace();
                        int n4 = n;
                        return n4;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Aladin.warning(this, "" + exception, 1);
                    this.defaultCursor();
                    this.ball.setMode(3);
                    int n5 = -1;
                    return n5;
                }
            }
            if (string3 == null) {
                string3 = string;
            }
            String string7 = inputStream == null ? "file" : "stream";
            this.flagVerif = false;
            this.verif(0, null, null, null);
            if (string != null && string.startsWith("file:")) {
                string = string.replaceAll("\\\\", "/");
            }
            if (inputStream == null && (string.startsWith("http:") || string.startsWith("https:"))) {
                uRL = this.aladin.glu.getURL("Http", this.getNameWithoutBrackets(string), true, true);
                try {
                    myInputStream = Util.openStream(uRL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string7 = "http";
            } else if (inputStream == null && string.indexOf("ftp://") >= 0) {
                uRL = new URL(this.getNameWithoutBrackets(string));
                myInputStream = Util.openStream(uRL);
                string7 = "ftp";
            } else if (inputStream == null && string.startsWith("file:/")) {
                bl = true;
                uRL = new URL(this.getNameWithoutBrackets(string));
                myInputStream = Util.openStream(uRL);
                string7 = "file";
            } else if (inputStream == null) {
                bl = true;
                Aladin.trace(3, "Opening " + this.getNameWithoutBrackets(string));
                myInputStream = new MyInputStream(new FileInputStream(this.getNameWithoutBrackets(string)));
            } else {
                myInputStream = inputStream instanceof MyInputStream ? (MyInputStream)inputStream : new MyInputStream(inputStream);
            }
            if (myInputStream != null) {
                myInputStream = myInputStream.startRead();
                l = myInputStream.getType();
            } else {
                l = 0L;
            }
            if (string != null && string.endsWith(".ajs")) {
                l |= 0x400L;
            }
            if (string != null && string.endsWith(".reg")) {
                l |= 0x400L;
            }
            String string8 = MyInputStream.decodeType(l);
            Aladin.trace(3, (string == null ? "stream" : string) + " => detect: " + string8);
            this.aladin.log("load", string7 + string8);
            if ((l & 0x2000000000L) != 0L) {
                this.aladin.calque.newPlanTool(null);
            }
            if ((l & 0x8400L) != 0L) {
                this.aladin.command.readFromStream(myInputStream);
            } else if ((l & 0x200L) != 0L) {
                n = this.loadAJ(myInputStream) ? 1 : 0;
            } else if ((l & 0x10000000000L) != 0L) {
                n = this.loadTool(myInputStream, string2) ? 1 : 0;
            } else if ((l & 0x800L) != 0L) {
                n = this.updateMetaData(myInputStream, server, "", null) ? 1 : 0;
            } else if ((l & 0x1000000000L) != 0L) {
                n = this.aladin.calque.newPlanMOC(myInputStream, string2);
            } else if ((l & 1L) != 0L && (l & 0x200000L) != 0L) {
                n = uRL != null ? this.aladin.calque.newPlanImageRGB(uRL, myInputStream, 2, string2, null, string, string3, 0, 0, null, resourceNode) : this.aladin.calque.newPlanImageRGB(string, null, myInputStream, resourceNode);
            } else if ((l & 0x100000000L) != 0L) {
                n = this.aladin.calque.newPlanHealpix(string, myInputStream, string2, 0, 0, false, string4, string5);
            } else if ((l & 0x20000L) != 0L) {
                this.aladin.calque.newFitsExt(string, myInputStream, string2, obj, string4, string5);
                n = 1;
            } else if ((l & 0x800000001L) != 0L) {
                n = uRL != null ? this.aladin.calque.newPlanImage(uRL, myInputStream, 2, string2, null, string, string3, 0, 0, obj, resourceNode) : this.aladin.calque.newPlanImage(string, myInputStream, string2, string3, obj, resourceNode);
            } else if ((l & 0x80000L) != 0L) {
                boolean bl2;
                n = this.aladin.processFovVOTable(myInputStream, null, true);
                boolean bl3 = bl2 = n >= 0;
                if (!bl2) {
                    n = -2;
                    this.aladin.dialog.setCurrent(ServerDialog.FIELD);
                    ((ServerFoV)this.aladin.dialog.server[ServerDialog.FIELD]).selectFOV(ServerFoV.idLastRegistered);
                }
            } else if ((l & 0x20402180L) != 0L) {
                n = uRL != null ? this.aladin.calque.newPlanCatalog(uRL, myInputStream, string2, "", string, null, server) : (string != null ? this.aladin.calque.newPlanCatalog(string, myInputStream) : this.aladin.calque.newPlanCatalog(myInputStream, string2, string3));
            } else if ((l & MyInputStream.NativeImage()) != 0L) {
                n = uRL != null ? this.aladin.calque.newPlanImageColor(uRL, myInputStream, 2, string2, null, string, string3, 0, 0, obj, resourceNode) : this.aladin.calque.newPlanImageColor(string, null, myInputStream, resourceNode);
            } else if ((l & 0x200000000L) != 0L) {
                if (this.aladin.glu.loadGluDic(new DataInputStream(myInputStream), false, bl)) {
                    this.aladin.glu.reload(false, true);
                    n = 1;
                }
            } else {
                if (!string7.equals("http") || string == null || string.indexOf(63) >= 0) throw new Exception("Data format not recognized");
                TreeNodeAllsky treeNodeAllsky = null;
                try {
                    treeNodeAllsky = new TreeNodeAllsky(this.aladin, string);
                }
                catch (Exception exception) {
                    Aladin.trace(4, "ServerFile.creatLocalPlane(...) HiPS properties file not found => autodiscovery");
                }
                if (treeNodeAllsky != null) {
                    n = this.aladin.calque.newPlanBG(treeNodeAllsky, string2, null, null);
                } else if (Util.isUrlResponding(new URL(string + "/Norder3/Allsky.jpg")) || Util.isUrlResponding(new URL(string + "/Norder3/Allsky.fits")) || Util.isUrlResponding(new URL(string + "/Norder3/Allsky.png"))) {
                    n = this.aladin.calque.newPlanBG(new URL(string), string2, null, null);
                } else if (string.endsWith("HpxFinder") || string.endsWith("HpxFinder/")) {
                    treeNodeAllsky = new TreeNodeAllsky(this.aladin, null, null, null, string, null, null, null, null, null, null, null, null, "15 progen", null);
                    n = this.aladin.calque.newPlanBG(treeNodeAllsky, string2, null, null);
                } else {
                    if (!Util.isUrlResponding(new URL(string + "/metadata.xml")) && !Util.isUrlResponding(new URL(string + "/Norder3/Allsky.xml"))) throw new Exception("Data format not recognized");
                    treeNodeAllsky = new TreeNodeAllsky(this.aladin, null, null, null, string, null, null, null, null, null, null, null, null, "15 cat", null);
                    n = this.aladin.calque.newPlanBG(treeNodeAllsky, string2, null, null);
                }
            }
            this.aladin.endMsg();
            if ((l & 0x800L) != 0L) {
                this.aladin.dialog.show();
                this.aladin.dialog.setCurrent(this.aladinLabel);
            }
            this.defaultCursor();
            if (n > 0 && (string != null || uRL != null)) {
                this.aladin.memoLastFile(string != null ? string : uRL.toString());
            }
            int n6 = n;
            return n6;
        }
        finally {
            this.aladin.synchroServer.stop(string6);
        }
    }

    @Override
    protected void setInitialFocus() {
        this.file.requestFocus();
        this.file.setCaretPosition(this.file.getText().length());
    }

    @Override
    public void submit() {
        this.waitCursor();
        String string = this.file.getText().trim();
        if (!string.startsWith("\"")) {
            string = Tok.quote(string, true);
        }
        Tok tok = new Tok(string, " ");
        while (tok.hasMoreTokens()) {
            string = tok.nextToken();
            if (!(string = this.aladin.getFullFileName(string)).equals(this.of)) {
                this.tree.clear();
            }
            this.of = string;
            if (this.tree != null && !this.tree.isEmpty()) {
                if (this.tree.nbSelected() > 0) {
                    if (!this.tooManyChecked()) {
                        this.tree.loadSelected();
                        this.tree.resetCb();
                    }
                } else {
                    Aladin.warning(this, this.WNEEDCHECK);
                }
                this.defaultCursor();
                continue;
            }
            String string2 = "load " + string;
            this.aladin.console.printCommand(string2);
            int n = this.creatLocalPlane(string, null, null, null, null, null, this, null, null);
            if (n == -1) continue;
            this.aladin.calque.getPlan(n).setBookmarkCode(string2);
        }
    }

    @Override
    protected void clear() {
        this.file.setText("");
        this.tree.clear();
        super.clear();
    }

    @Override
    protected void reset() {
        if (this.tree != null) {
            this.tree.resetCb();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton && ((JButton)object).getActionCommand().equals(this.BROWSE)) {
            this.browseFile();
            return;
        }
        super.actionPerformed(actionEvent);
    }

    protected void browseFile() {
        Object object;
        String string = Util.dirBrowser(this.description, this.aladin.getDefaultDirectory(), this.file, 2);
        if (string == null) {
            return;
        }
        String string2 = string;
        int n = string.indexOf(" ");
        if (n > 0) {
            object = new Tok(string, " ");
            string2 = ((Tok)object).nextToken();
        }
        if (!((File)(object = new File(string2))).isDirectory()) {
            string2 = ((File)object).getParent();
        }
        this.aladin.memoDefaultDirectory(string2);
        this.submit();
    }

    protected boolean loadAJ(MyInputStream myInputStream) {
        boolean bl;
        XMLParser xMLParser = new XMLParser(this);
        loadError = null;
        try {
            bl = xMLParser.parse(myInputStream);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            loadError = "" + exception;
            return false;
        }
        if (!bl) {
            loadError = xMLParser.getError();
        }
        this.aladin.view.findBestDefault();
        this.aladin.view.setDefaultRepere();
        this.aladin.calque.repaintAll();
        return bl && loadError == null;
    }

    protected boolean loadTool(MyInputStream myInputStream, String string) {
        this.plan = new PlanTool(this.aladin);
        this.inValue = true;
        this.typePlan = 1001;
        boolean bl = this.loadAJ(myInputStream);
        if (bl) {
            this.plan.setLabel(string);
            this.endElement("PLANE");
        }
        return bl;
    }

    private ViewMemoItem creatViewMemoItemByAJ(Hashtable hashtable) {
        ViewMemoItem viewMemoItem = new ViewMemoItem();
        String string = (String)hashtable.get("zoom");
        if (string != null) {
            viewMemoItem.zoom = Double.valueOf(string);
        }
        if ((string = (String)hashtable.get("xzoomView")) != null) {
            viewMemoItem.xzoomView = Double.valueOf(string);
        }
        if ((string = (String)hashtable.get("yzoomView")) != null) {
            viewMemoItem.yzoomView = Double.valueOf(string);
        }
        if ((string = (String)hashtable.get("rzoomWidth")) != null) {
            viewMemoItem.rzoomWidth = Double.valueOf(string);
        }
        if ((string = (String)hashtable.get("rzoomHeight")) != null) {
            viewMemoItem.rzoomHeight = Double.valueOf(string);
        }
        if ((string = (String)hashtable.get("rvWidth")) != null) {
            viewMemoItem.rvWidth = Integer.parseInt(string);
        }
        if ((string = (String)hashtable.get("rvHeight")) != null) {
            viewMemoItem.rvHeight = Integer.parseInt(string);
        }
        if ((string = (String)hashtable.get("pref")) != null) {
            viewMemoItem.pref = this.aladin.calque.getPlan(string, 1);
        }
        if ((string = (String)hashtable.get("roi")) != null || (string = (String)hashtable.get("locked")) != null) {
            viewMemoItem.locked = new Boolean(string);
        }
        if ((string = (String)hashtable.get("northUp")) != null) {
            viewMemoItem.northUp = new Boolean(string);
        }
        return viewMemoItem;
    }

    private Plan creatPlaneByAJ(Hashtable hashtable) {
        String string;
        Object object;
        String string2 = (String)hashtable.get("type");
        this.typePlan = Util.indexInArrayOf(string2, Plan.Tp);
        this.inFilterScript = false;
        this.inFitsHeader = false;
        this.inFilter = false;
        switch (this.typePlan) {
            case 12: {
                object = null;
                string = (String)hashtable.get("dedicatedto");
                if (string != null) {
                    object = (PlanCatalog)this.aladin.calque.getPlan(string, 1);
                }
                this.plan = new PlanFilter(this.aladin, "", null, (Plan)object);
                break;
            }
            case 11: {
                this.plan = new PlanFolder(this.aladin);
                string = (String)hashtable.get("localscope");
                if (string == null) break;
                ((PlanFolder)this.plan).localScope = new Boolean(string);
                break;
            }
            case 8: {
                this.plan = new PlanCatalog(this.aladin);
                string = (String)hashtable.get("object");
                if (string != null) {
                    this.plan.objet = string;
                }
                if ((string = (String)hashtable.get("param")) != null) {
                    this.plan.param = string + ".";
                }
                if ((string = (String)hashtable.get("from")) != null) {
                    this.plan.copyright = string;
                }
                if ((string = (String)hashtable.get("RA")) != null) {
                    this.ra = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("DE")) != null) {
                    this.de = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("radius")) != null) {
                    this.rm = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("color")) == null) break;
                this.plan.c = Action.getColor(string);
                break;
            }
            case 9: 
            case 10: {
                this.plan = new PlanTool(this.aladin);
                string = (String)hashtable.get("color");
                if (string != null) {
                    this.plan.c = Action.getColor(string);
                }
                if ((string = (String)hashtable.get("withsource")) != null) {
                    this.flagCatalogSource = true;
                }
                if ((string = (String)hashtable.get("xylock")) == null) break;
                ((PlanTool)this.plan).hasXYorig = new Boolean(string);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                boolean bl;
                boolean bl2 = bl = hashtable.get("cacheID") != null;
                if (this.typePlan == 1) {
                    this.plan = new PlanImage(this.aladin);
                } else if (this.typePlan == 6) {
                    this.plan = new PlanImageMosaic(this.aladin);
                } else if (this.typePlan == 5) {
                    this.plan = new PlanImageResamp(this.aladin);
                } else if (this.typePlan == 7) {
                    this.plan = new PlanImageAlgo(this.aladin);
                } else if (this.typePlan == 2) {
                    this.plan = new PlanImageRGB(this.aladin);
                    ((PlanImageRGB)this.plan).RGBControl = new int[9];
                }
                string = (String)hashtable.get("object");
                if (string != null) {
                    this.plan.objet = string;
                }
                PlanImage planImage = (PlanImage)this.plan;
                string = (String)hashtable.get("param");
                if (string != null) {
                    this.plan.param = string + ".";
                }
                if ((string = (String)hashtable.get("fmt")) != null) {
                    planImage.fmt = PlanImage.getFmt(string);
                }
                if ((string = (String)hashtable.get("resolution")) != null) {
                    planImage.res = PlanImage.getRes(string);
                }
                if ((string = (String)hashtable.get("from")) != null) {
                    this.plan.copyright = string;
                }
                if ((string = (String)hashtable.get("cacheID")) != null) {
                    planImage.cacheID = string;
                }
                if ((string = (String)hashtable.get("cacheOffset")) != null) {
                    planImage.cacheOffset = Long.parseLong(string);
                }
                if ((string = (String)hashtable.get("url")) != null) {
                    try {
                        this.plan.u = new URL(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = (String)hashtable.get("RA")) != null) {
                    this.ra = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("DE")) != null) {
                    this.de = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("radius")) != null) {
                    this.rm = Double.valueOf(string);
                }
                planImage.transfertFct = 3;
                planImage.bScale = 1.0;
                planImage.bitpix = 8;
                planImage.npix = 1;
                planImage.typeCM = 0;
                string = (String)hashtable.get("width");
                if (string != null) {
                    planImage.naxis1 = planImage.width = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("height")) != null) {
                    planImage.naxis2 = planImage.height = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("video")) != null) {
                    planImage.video = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("transfertFct")) != null) {
                    planImage.transfertFct = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("minPix")) != null) {
                    planImage.dataMin = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("maxPix")) != null) {
                    planImage.dataMax = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("minPixCut")) != null) {
                    planImage.pixelMin = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("maxPixCut")) != null) {
                    planImage.pixelMax = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("bZero")) != null) {
                    planImage.bZero = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("bScale")) != null) {
                    planImage.bScale = Double.valueOf(string);
                }
                if ((string = (String)hashtable.get("cm")) != null) {
                    planImage.typeCM = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("colormap1")) != null) {
                    planImage.cmControl[0] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("colormap2")) != null) {
                    planImage.cmControl[1] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("colormap3")) != null) {
                    planImage.cmControl[2] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl1")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[0] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl2")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[1] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl3")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[2] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl4")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[3] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl5")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[4] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl6")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[5] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl7")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[6] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl8")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[7] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBControl9")) != null) {
                    ((PlanImageRGB)planImage).RGBControl[8] = Integer.parseInt(string);
                }
                if ((string = (String)hashtable.get("RGBRed")) != null) {
                    ((PlanImageRGB)planImage).labelRed = string;
                }
                if ((string = (String)hashtable.get("RGBGreen")) != null) {
                    ((PlanImageRGB)planImage).labelGreen = string;
                }
                if ((string = (String)hashtable.get("RGBBlue")) != null) {
                    ((PlanImageRGB)planImage).labelBlue = string;
                }
                if ((string = (String)hashtable.get("opacity")) != null) {
                    planImage.setOpacityLevel(Float.valueOf(string).floatValue());
                }
                if (!bl || (string = (String)hashtable.get("bitpix")) == null) break;
                planImage.bitpix = Integer.parseInt(string);
                planImage.npix = Math.abs(planImage.bitpix) / 8;
                break;
            }
            default: {
                this.plan = null;
            }
        }
        if (this.plan != null) {
            string = (String)hashtable.get("label");
            if (string != null) {
                this.plan.label = string;
            }
            if ((string = (String)hashtable.get("depth")) != null) {
                this.plan.folder = Integer.parseInt(string);
            }
            if ((string = (String)hashtable.get("activated")) != null) {
                this.plan.active = this.plan.askActive = new Boolean(string).booleanValue();
            }
            if ((string = (String)hashtable.get("selectable")) != null) {
                this.plan.setSelectable(new Boolean(string));
            }
            if (this.plan instanceof PlanImage) {
                ((PlanImage)this.plan).orig = 1;
            }
            if ((string = (String)hashtable.get("proj")) != null) {
                this.proj = Integer.parseInt(string);
            }
            if ((string = (String)hashtable.get("calib")) != null) {
                object = new Calib();
                this.parseCalib((Calib)object, string);
                ((Calib)object).adxpoly = this.parsePoly((String)hashtable.get("adxpoly"));
                ((Calib)object).adypoly = this.parsePoly((String)hashtable.get("adypoly"));
                ((Calib)object).xyapoly = this.parsePoly((String)hashtable.get("xyapoly"));
                ((Calib)object).xydpoly = this.parsePoly((String)hashtable.get("xydpoly"));
                ((Calib)object).CD = this.parseMat((String)hashtable.get("CD"));
                ((Calib)object).ID = this.parseMat((String)hashtable.get("ID"));
                this.plan.setNewProjD(new Projection(this.proj, (Calib)object));
                if (this.plan instanceof PlanImage) {
                    ((PlanImage)this.plan).setHasSpecificCalib();
                }
            }
            if ((string = (String)hashtable.get("flagepoch")) != null && this.plan.projd != null && this.plan.projd.c != null) {
                this.plan.projd.c.flagepoc = Integer.parseInt(string);
            }
            if ((string = (String)hashtable.get("system")) != null && this.plan.projd != null && this.plan.projd.c != null) {
                this.plan.projd.c.system = Integer.parseInt(string);
            }
            if ((string = (String)hashtable.get("projection")) != null && this.plan.projd != null && this.plan.projd.c != null) {
                this.plan.projd.c.proj = Calib.getProjType(string);
            }
            this.plan.flagOk = true;
        }
        return this.plan;
    }

    private void parseCalib(Calib calib, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        calib.aladin = Integer.parseInt(stringTokenizer.nextToken());
        calib.epoch = Double.valueOf(stringTokenizer.nextToken());
        calib.alpha = Double.valueOf(stringTokenizer.nextToken());
        calib.delta = Double.valueOf(stringTokenizer.nextToken());
        calib.yz = Double.valueOf(stringTokenizer.nextToken());
        calib.xz = Double.valueOf(stringTokenizer.nextToken());
        calib.focale = Double.valueOf(stringTokenizer.nextToken());
        calib.Xorg = Double.valueOf(stringTokenizer.nextToken());
        calib.Yorg = Double.valueOf(stringTokenizer.nextToken());
        calib.incX = Double.valueOf(stringTokenizer.nextToken());
        calib.incY = Double.valueOf(stringTokenizer.nextToken());
        calib.alphai = Double.valueOf(stringTokenizer.nextToken());
        calib.deltai = Double.valueOf(stringTokenizer.nextToken());
        calib.incA = Double.valueOf(stringTokenizer.nextToken());
        calib.incD = Double.valueOf(stringTokenizer.nextToken());
        calib.Xcen = Double.valueOf(stringTokenizer.nextToken());
        calib.Ycen = Double.valueOf(stringTokenizer.nextToken());
        calib.widtha = Double.valueOf(stringTokenizer.nextToken());
        calib.widthd = Double.valueOf(stringTokenizer.nextToken());
        calib.xnpix = Integer.parseInt(stringTokenizer.nextToken());
        calib.ynpix = Integer.parseInt(stringTokenizer.nextToken());
        calib.rota = Double.valueOf(stringTokenizer.nextToken());
        calib.cdelz = Double.valueOf(stringTokenizer.nextToken());
        calib.sdelz = Double.valueOf(stringTokenizer.nextToken());
        calib.type1 = stringTokenizer.nextToken();
        calib.type2 = stringTokenizer.nextToken();
        try {
            calib.equinox = Double.valueOf(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            calib.equinox = 2000.0;
        }
        try {
            calib.proj = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            calib.proj = 1;
        }
    }

    private double[] parsePoly(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        double[] dArray = new double[stringTokenizer.countTokens()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.valueOf(stringTokenizer.nextToken());
        }
        return dArray;
    }

    private double[][] parseMat(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        double[][] dArray = new double[2][2];
        dArray[0][0] = Double.valueOf(stringTokenizer.nextToken());
        dArray[0][1] = Double.valueOf(stringTokenizer.nextToken());
        dArray[1][0] = Double.valueOf(stringTokenizer.nextToken());
        dArray[1][1] = Double.valueOf(stringTokenizer.nextToken());
        return dArray;
    }

    @Override
    public void startElement(String string, Hashtable hashtable) {
        block36: {
            if (string.equals("ALADINJAVA")) {
                this.aladin.calque.FreeAll();
            } else if (string.equals("PLANE")) {
                this.plan = this.creatPlaneByAJ(hashtable);
            } else if (string.equals("TABLE")) {
                this.vField = new Vector(10);
            } else if (string.equals("SCRIPT")) {
                this.inFilterScript = true;
            } else if (string.equals("ORIRIGINALHEADERFITS")) {
                this.inFitsHeader = true;
            } else if (string.equals("FILTER")) {
                this.inFilter = true;
            } else {
                if (string.equals("FILTERS")) {
                    try {
                        this.nFilter = 0;
                        this.plan.filters = new String[Integer.parseInt((String)hashtable.get("nFilter"))];
                        this.plan.filterIndex = Integer.parseInt((String)hashtable.get("filterIndex"));
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace >= 3) {
                            exception.printStackTrace();
                        }
                        break block36;
                    }
                }
                if (string.equals("MODEVIEW")) {
                    this.firstView = 0;
                    try {
                        String string2 = (String)hashtable.get("mode");
                        if (string2 != null) {
                            this.aladin.view.setModeView(Integer.parseInt(string2));
                        }
                        if ((string2 = (String)hashtable.get("position")) != null) {
                            this.firstView = Integer.parseInt(string2);
                        }
                        if ((string2 = (String)hashtable.get("grid")) != null) {
                            this.aladin.calque.setOverlayFlag("grid", new Boolean(string2));
                        }
                        if ((string2 = (String)hashtable.get("target")) != null) {
                            this.aladin.calque.setOverlayFlag("target", new Boolean(string2));
                        }
                        if ((string2 = (String)hashtable.get("overlay")) != null) {
                            this.aladin.calque.flagOverlay = new Boolean(string2);
                        }
                        if ((string2 = (String)hashtable.get("overlays")) != null) {
                            this.aladin.calque.setOverlayList(string2);
                        }
                        break block36;
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace >= 3) {
                            exception.printStackTrace();
                        }
                        break block36;
                    }
                }
                if (string.equals("VIEW")) {
                    this.vmi = this.creatViewMemoItemByAJ(hashtable);
                    String string3 = (String)hashtable.get("n");
                    try {
                        this.aladin.view.viewMemo.set(Integer.parseInt(string3), this.vmi);
                    }
                    catch (Exception exception) {
                        if (Aladin.levelTrace >= 3) {
                            exception.printStackTrace();
                        }
                    }
                } else if (string.equals("VALUE")) {
                    this.inValue = true;
                    if (this.vField != null && this.vField.size() > 0) {
                        this.leg = new Legende(this.vField);
                    }
                } else if (string.equals("COLUMN")) {
                    Field field = new Field(hashtable);
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        field.addInfo(string4, (String)hashtable.get(string4));
                    }
                    this.vField.addElement(field);
                }
            }
        }
    }

    @Override
    public void endElement(String string) {
        if (string.equals("PLANE")) {
            if (this.plan != null) {
                if (this.plan.filters != null && this.plan.filterIndex >= 0) {
                    if (this.pdf == null) {
                        this.pdf = new Vector();
                    }
                    this.pdf.addElement(this.plan);
                }
                if (this.typePlan == 1 || this.typePlan == 6 || this.typePlan == 5 || this.typePlan == 7) {
                    PlanImage planImage = (PlanImage)this.plan;
                    planImage.cm = CanvasColorMap.getCM(planImage.cmControl[0], planImage.cmControl[1], planImage.cmControl[2], planImage.video == 1, planImage.typeCM, planImage.transfertFct);
                    planImage.calculPixelsZoom();
                    planImage.changeImgID();
                }
                this.plan.flagOk = true;
                this.aladin.calque.addOnStack(this.plan);
                this.plan = null;
                this.inFitsHeader = false;
                this.flagCatalogSource = false;
            }
        } else if (string.equals("MODEVIEW")) {
            this.aladin.view.scrollOn(this.firstView, 0, 1);
        } else if (string.equals("SCRIPT")) {
            this.inFilterScript = false;
        } else if (string.equals("TABLE")) {
            this.leg = null;
            this.vField = null;
            if (this.flagCatalogSource) {
                this.typePlan = 1000;
            }
        } else if (string.equals("VALUE")) {
            this.inValue = false;
        } else if (string.equals("ALADINJAVA")) {
            if (this.pFilter != null) {
                Enumeration enumeration = this.pFilter.keys();
                while (enumeration.hasMoreElements()) {
                    PlanFilter planFilter = (PlanFilter)enumeration.nextElement();
                    planFilter.updateDefinition((String)this.pFilter.get(planFilter), planFilter.label, null);
                    planFilter.updateState();
                }
                new Thread("AladinFilterUpdate"){

                    @Override
                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        PlanFilter.updateAllFilters(ServerFile.this.aladin);
                        Enumeration enumeration = ServerFile.this.pFilter.keys();
                        while (enumeration.hasMoreElements()) {
                            PlanFilter planFilter = (PlanFilter)enumeration.nextElement();
                            planFilter.setMustUpdate();
                            planFilter.doApplyFilter();
                        }
                        ServerFile.this.aladin.calque.select.repaint();
                        ServerFile.this.pFilter.clear();
                    }
                }.start();
            }
            if (this.pdf != null) {
                new Thread("AladinFilterUpdate2"){

                    @Override
                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1200L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        Enumeration enumeration = ServerFile.this.pdf.elements();
                        while (enumeration.hasMoreElements()) {
                            Plan plan = (Plan)enumeration.nextElement();
                            plan.setFilter(plan.filterIndex);
                        }
                        ServerFile.this.aladin.calque.select.repaint();
                        ServerFile.this.pdf = null;
                    }
                }.start();
            }
        }
    }

    private int getSourceField(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n < n2 && cArray[n] != '\t' && cArray[n] != '\n') {
            ++n;
        }
        this.rec = new String(cArray, n3, n - n3).trim();
        return cArray[n] == '\t' ? n + 1 : n;
    }

    private int getSource(char[] cArray, int n, int n2) {
        while (n < n2 && (cArray[n] == '\r' || cArray[n] == '\n')) {
            ++n;
        }
        n = this.getSourceField(cArray, n, n2);
        double d = Double.valueOf(this.rec);
        n = this.getSourceField(cArray, n, n2);
        double d2 = Double.valueOf(this.rec);
        String string = this.rec;
        int n3 = n;
        for (n = this.getSourceField(cArray, n, n2); n < n2 && cArray[n] != '\n'; ++n) {
        }
        this.rec = new String(cArray, n3, n - n3);
        Source source = this.leg != null ? new Source(this.plan, d, d2, string, this.rec, this.leg) : new Source(this.plan, d, d2, string, this.rec);
        this.plan.pcat.setObjetFast(source);
        return n;
    }

    private int getTool(char[] cArray, int n, int n2) {
        return this.getTool1(cArray, n, n2, false);
    }

    private int getToolAjtool(char[] cArray, int n, int n2) {
        return this.getTool1(cArray, n, n2, true);
    }

    private int getTool1(char[] cArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        double d;
        double d2;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        while (n < n2 && (cArray[n] == '\r' || cArray[n] == '\n')) {
            ++n;
        }
        n = this.getSourceField(cArray, n, n2);
        string = this.rec;
        n = this.getSourceField(cArray, n, n2);
        bl2 = this.rec.equals("+");
        bl3 = this.rec.equals("*");
        n = this.getSourceField(cArray, n, n2);
        try {
            d2 = Double.valueOf(this.rec);
        }
        catch (Exception exception) {
            d2 = 0.0;
        }
        n = this.getSourceField(cArray, n, n2);
        try {
            d = Double.valueOf(this.rec);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        n = this.getSourceField(cArray, n, n2);
        try {
            n4 = Integer.parseInt(this.rec);
        }
        catch (Exception exception) {
            n4 = 0;
        }
        n = this.getSourceField(cArray, n, n2);
        try {
            n3 = Integer.parseInt(this.rec);
        }
        catch (Exception exception) {
            n3 = 0;
        }
        n = this.getSourceField(cArray, n, n2);
        bl4 = new Boolean(this.rec);
        n = this.getSourceField(cArray, n, n2);
        String string2 = this.rec;
        Position position = null;
        if (string.equals("tag")) {
            position = new Repere(this.plan);
        } else if (string.equals("text")) {
            position = new Tag(this.plan);
        } else if (string.equals("phot")) {
            position = new SourceStat(this.plan);
        } else if (string.equals("source")) {
            position = new Repere(this.plan);
        } else if (string.equals("taglabel")) {
            position = new Tag(this.plan);
        } else if (string.equals("line")) {
            position = new Ligne(this.plan);
        } else if (string.equals("arrow")) {
            position = new Cote(this.plan);
        } else if (string.equals("circle")) {
            if (this.circleCenter != null) {
                double d3 = d - this.circleCenter.del;
                position = new Cercle(this.plan, this.circleCenter, d3);
                this.circleCenter = null;
            } else {
                this.circleCenter = new Coord(d2, d);
            }
        }
        if (position != null) {
            position.raj = d2;
            position.dej = d;
            position.x = n4;
            position.y = n3;
            position.setWithLabel(bl4);
            position.setSpecificAJInfo(string2);
            try {
                if (this.prevFlagSuite) {
                    ((Ligne)this.prevO).finligne = (Ligne)position;
                    ((Ligne)position).debligne = (Ligne)this.prevO;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bl3) {
                    ((Ligne)position).bout = (byte)3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.plan.pcat.setObjetFast(position);
            this.prevO = position;
            this.prevFlagSuite = bl2;
        }
        return n;
    }

    private void getImageRGB(char[] cArray, int n, int n2) {
        PlanImageRGB planImageRGB = (PlanImageRGB)this.plan;
        if (this.rgb == null) {
            this.rgb = new byte[planImageRGB.width * planImageRGB.height * 3];
            this.pOffset = 0;
        }
        this.pOffset = Save.get64(this.rgb, this.pOffset, cArray, n, n2);
        if (this.pOffset == planImageRGB.width * planImageRGB.height * 3) {
            planImageRGB.setByteRGB(this.rgb);
            planImageRGB.cm = ColorModel.getRGBdefault();
            for (int i = 0; i < 3; ++i) {
                planImageRGB.filterRGB(planImageRGB.cmControl, i);
            }
            planImageRGB.flagBlue = true;
            planImageRGB.flagGreen = true;
            planImageRGB.flagRed = true;
            this.rgb = null;
            this.pOffset = 0;
        }
    }

    private void getImage(char[] cArray, int n, int n2) {
        PlanImage planImage = (PlanImage)this.plan;
        if (planImage.getBufPixels8() == null) {
            planImage.setBufPixels8(new byte[planImage.width * planImage.height]);
            this.pOffset = 0;
        }
        this.pOffset = Save.get64(planImage.getBufPixels8(), this.pOffset, cArray, n, n2);
    }

    private void setScript(String string) {
        if (this.pFilter == null) {
            this.pFilter = new Hashtable();
        }
        this.plan.setActivated();
        this.pFilter.put(this.plan, string);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        if (this.inValue) {
            switch (this.typePlan) {
                case 8: 
                case 1000: {
                    int n4;
                    for (n4 = n; n4 < n3; ++n4) {
                        n4 = this.getSource(cArray, n4, n3);
                    }
                    break;
                }
                case 9: {
                    int n4;
                    while (n4 < n3) {
                        n4 = this.getTool(cArray, n4, n3);
                        ++n4;
                    }
                    this.prevFlagSuite = false;
                    break;
                }
                case 1001: {
                    int n4;
                    while (n4 < n3) {
                        n4 = this.getToolAjtool(cArray, n4, n3);
                        ++n4;
                    }
                    this.prevFlagSuite = false;
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 15: {
                    this.getImage(cArray, n, n2);
                    break;
                }
                case 2: {
                    this.getImageRGB(cArray, n, n2);
                }
            }
        } else if (this.inFilterScript) {
            this.setScript(new String(cArray, n, n2).replaceAll("\\\\n", "\n"));
        } else if (this.inFitsHeader) {
            if (((PlanImage)this.plan).headerFits == null) {
                ((PlanImage)this.plan).headerFits = new FrameHeaderFits(this.plan, new String(cArray, n, n2));
            } else {
                ((PlanImage)this.plan).headerFits.setOriginalHeaderFits(new String(cArray, n, n2));
            }
        } else if (this.inFilter) {
            if (this.plan.filters == null) {
                return;
            }
            this.plan.filters[this.nFilter++] = new String(cArray, n, n2);
        }
    }
}

