/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FootprintBean;
import cds.aladin.FootprintParser;
import cds.aladin.MyInputStream;
import cds.aladin.PlanField;
import cds.aladin.Server;
import cds.aladin.ServerFile;
import cds.aladin.Tok;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public final class ServerFoV
extends Server
implements TableModel {
    static final int MAXLINE = 7;
    String LOAD;
    Vector<FoVItem> fovList;
    JTable table;
    TableModelListener tableListener;
    JTextField roll;
    String info1;
    String info2;
    String angle;
    String angle1;
    String edit;
    String fovedit;
    int idxSortedCol = 1;
    boolean ascSort;
    protected static String idLastRegistered;
    static final String[][] FOV;
    private boolean dynFoV = false;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("FOVINFO");
        this.info1 = Aladin.chaine.getString("FOVINFO1");
        this.info2 = Aladin.chaine.getString("FOVINFO2");
        this.angle = Aladin.chaine.getString("FOVANGLE");
        this.angle1 = Aladin.chaine.getString("FOVANGLE1");
        this.angle = this.angle + " (" + this.angle1 + ")";
        this.edit = Aladin.chaine.getString("FOVEDIT");
        this.LOAD = Aladin.chaine.getString("FOVLOAD");
        this.fovedit = "FovEditor";
    }

    protected ServerFoV(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.aladinLabel = "Instrument Field of Views (FoV)";
        this.aladinMenu = "FoV...";
        this.type = 8;
        this.aladinLogo = "FoVLogo.gif";
        this.grab = null;
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        this.setBounds(0, 0, WIDTH, HEIGHT);
        int n = 20;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Aladin.BLUE);
        Dimension dimension = this.makeTitle(jPanel, this.description);
        jPanel.setBounds(XWIDTH / 2 - dimension.width / 2, n, dimension.width, dimension.height);
        this.add(jPanel);
        JLabel jLabel = new JLabel(this.info1);
        jLabel.setBounds(182, n += dimension.height + 10, 400, 20);
        this.add(jLabel);
        jLabel = new JLabel(this.info2);
        jLabel.setBounds(92, n += 15, 300, 20);
        n += 20;
        this.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Aladin.BLUE);
        int n2 = this.makeTargetPanel(jPanel2, 2);
        jPanel2.setBounds(0, n, XWIDTH, n2);
        n += n2;
        this.add(jPanel2);
        this.modeCoo = 5;
        this.modeRad = 0;
        JLabel jLabel2 = new JLabel(this.addDot(this.angle));
        jLabel2.setFont(Aladin.BOLD);
        jLabel2.setBounds(10, n, 150, HAUT);
        this.add(jLabel2);
        this.roll = new JTextField("0.0");
        this.roll.setBounds(160, n, XWIDTH - 160, HAUT);
        n += HAUT + MARGE + 10;
        this.add(this.roll);
        this.table = new TwoColorJTable(this);
        this.table.setGridColor(Color.lightGray);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setDefaultRenderer(new TableHeaderRenderer(this.table.getTableHeader().getDefaultRenderer()));
        this.table.getTableHeader().addMouseListener(new TableHeaderListener());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(110);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(80);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBounds(10, n, XWIDTH, 150);
        n += 150;
        this.add(jScrollPane);
        JButton jButton = new JButton(this.edit);
        jButton.setOpaque(false);
        jButton.addActionListener(this);
        jButton.setBounds(190, n += 10, 150, HAUT);
        this.add(jButton);
        jButton = new JButton(this.LOAD);
        jButton.setOpaque(false);
        jButton.addActionListener(this);
        jButton.setBounds(350, n, 100, HAUT);
        this.add(jButton);
        this.setMaxComp(jScrollPane);
        this.initStaticFoV();
    }

    @Override
    protected int createPlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        double d = 0.0;
        Tok tok = new Tok(string3, " ,");
        string6 = tok.nextToken();
        if (string6 != null) {
            string6 = string6.toUpperCase();
        }
        if (tok.hasMoreTokens()) {
            try {
                d = Double.valueOf(tok.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initDynamicFoV();
        return this.creatFieldPlane(string, d, string6, string4);
    }

    protected int creatFieldPlane(String string, double d, String string2, String string3) {
        if (string2 == null || string2.equals("")) {
            Aladin.warning(this.WNEEDCHECK, 1);
            return -1;
        }
        this.loadRemoteFoV();
        FootprintBean footprintBean = this.getFovBeanByID(string2);
        if (string3 == null) {
            string3 = string2;
        }
        if (footprintBean != null) {
            return this.aladin.calque.newPlanField(footprintBean, string, string3, d);
        }
        return this.aladin.calque.newPlanField(string, d, string2, string3);
    }

    @Override
    public void submit() {
        Object object;
        String string = this.getTarget();
        String string2 = this.roll.getText().trim();
        double d = string2.length() == 0 ? 0.0 : Double.valueOf(string2);
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            object = this.fovList.elementAt(n);
            string2 = ((FoVItem)object).id;
        } else {
            string2 = null;
        }
        object = "get FoV(" + Tok.quote(string2) + ")";
        this.aladin.console.printCommand((String)object + " " + string);
        int n2 = this.creatFieldPlane(string, d, string2, null);
        if (n2 != -1) {
            this.ball.setMode(1);
            this.aladin.calque.getPlan(n2).setBookmarkCode((String)object + " $TARGET");
        } else {
            this.ball.setMode(3);
        }
    }

    public boolean registerNewFovTemplate(String string, PlanField planField) {
        if (this.findFoVIndex(string) >= 0) {
            Aladin.trace(3, "PlanField " + string + " is already registered !! Existing definition will be erased");
        } else {
            this.addFoV(string, planField);
        }
        idLastRegistered = string;
        return true;
    }

    public FootprintBean getFovBeanByID(String string) {
        return FootprintParser.getBeanFromID(string);
    }

    public void selectFOV(String string) {
        int n = this.findFoVIndex(string);
        this.table.getSelectionModel().setSelectionInterval(n, n);
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Instrument";
            }
            case 1: {
                return "Telescope";
            }
            case 2: {
                return "Description";
            }
            case 3: {
                return "Author";
            }
        }
        return "";
    }

    int findFoVIndex(String string) {
        for (int i = 0; i < this.fovList.size(); ++i) {
            FoVItem foVItem = this.fovList.elementAt(i);
            if (!foVItem.id.equals(string)) continue;
            return i;
        }
        return -1;
    }

    boolean addFoV(String string, PlanField planField) {
        if (this.findFoVIndex(string) != -1) {
            return false;
        }
        FoVItem foVItem = new FoVItem(string, planField);
        this.fovList.addElement(foVItem);
        this.idxSortedCol = 1;
        this.ascSort = true;
        this.fireTable();
        return true;
    }

    boolean addFoV(String string, String string2, String string3, String string4) {
        String string5 = ServerFoV.makeID(string, string2);
        if (this.findFoVIndex(string5) != -1) {
            return false;
        }
        FoVItem foVItem = new FoVItem(string, string2, string3, string4);
        this.fovList.addElement(foVItem);
        this.idxSortedCol = 1;
        this.ascSort = true;
        this.fireTable();
        return true;
    }

    private void notifyTableChanged() {
        int n = this.fovList.size();
        this.tableListener.tableChanged(new TableModelEvent(this, n, n, -1, 1));
    }

    private void fireTable() {
        this.defaultSortFoV();
        this.notifyTableChanged();
    }

    private void defaultSortFoV() {
        Collections.sort(this.fovList, new Comparator<FoVItem>(){

            @Override
            public int compare(FoVItem foVItem, FoVItem foVItem2) {
                int n = foVItem.telescope.compareTo(foVItem2.telescope);
                if (n != 0) {
                    return n;
                }
                return foVItem.instrument.compareTo(foVItem2.instrument);
            }
        });
        if (!this.ascSort) {
            Collections.reverse(this.fovList);
        }
        this.ascSort = !this.ascSort;
    }

    @Override
    public int getRowCount() {
        return this.fovList == null ? -1 : this.fovList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        FoVItem foVItem = this.fovList.elementAt(n);
        switch (n2) {
            case 0: {
                return foVItem.instrument;
            }
            case 1: {
                return foVItem.telescope;
            }
            case 2: {
                return foVItem.description;
            }
            case 3: {
                return foVItem.origine == null ? "?" : foVItem.origine;
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableListener = tableModelListener;
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
    }

    private void initStaticFoV() {
        this.fovList = new Vector();
        for (int i = 0; i < FOV.length; ++i) {
            FoVItem foVItem = new FoVItem(FOV[i][0], FOV[i][1], FOV[i][2], FOV[i][3]);
            this.fovList.add(foVItem);
        }
    }

    @Override
    public void show() {
        this.initDynamicFoV();
        super.show();
    }

    private void initDynamicFoV() {
        if (this.dynFoV) {
            return;
        }
        new Thread("initFov"){

            @Override
            public void run() {
                ServerFoV.this.loadRemoteFoV();
            }
        }.start();
    }

    protected void loadRemoteFoV() {
        block3: {
            if (this.dynFoV) {
                return;
            }
            try {
                this.dynFoV = true;
                Aladin.trace(3, "Loading FoV definitions...");
                MyInputStream myInputStream = new MyInputStream(Aladin.cache.get("http://aladin.u-strasbg.fr/java/FOVs.xml"));
                this.aladin.processFovVOTable(myInputStream, null, false);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
    }

    static String makeID(String string, String string2) {
        return string + "." + string2;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = ((JButton)object).getActionCommand();
            if (string.equals(this.edit)) {
                this.aladin.buildFoV();
            } else if (string.equals(this.LOAD)) {
                ((ServerFile)this.aladin.dialog.localServer).browseFile();
            }
        }
        super.actionPerformed(actionEvent);
    }

    static {
        FOV = new String[][]{{"MEGACAM", "CFHT", "Wide field imaging camera", "CFH"}, {"MEGAPRIME", "CFHT", "Wide field imaging camera + guiders", "CFH"}, {"CFH12K", "CFHT", "Large field camera", "CFH"}, {"WIRCAM", "CFHT", "Wide field IR camera", "CFH"}, {"ESPADONS", "CFHT", "Echelle Spectropolarimetric device", "CFH"}, {"EPICMOS", "XMM", "Sensitive imaging (0.1 to 15 keV)", "CDS"}, {"EPICpn", "XMM", "High resolution (<0.03ms)", "CDS"}};
    }

    class TableHeaderListener
    extends MouseAdapter {
        TableHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            TableColumnModel tableColumnModel = ServerFoV.this.table.getColumnModel();
            int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            ServerFoV.this.idxSortedCol = n = ServerFoV.this.table.convertColumnIndexToModel(n2);
            if (mouseEvent.getClickCount() == 1 && n != -1) {
                if (n == 1) {
                    int n3 = ServerFoV.this.table.getSelectedRow();
                    FoVItem foVItem = n3 >= 0 ? ServerFoV.this.fovList.get(n3) : null;
                    ServerFoV.this.defaultSortFoV();
                    ServerFoV.this.notifyTableChanged();
                    this.selectItem(foVItem);
                    return;
                }
                Comparator comparator = new Comparator(){

                    public final int compare(Object object, Object object2) {
                        String string = null;
                        String string2 = null;
                        switch (n) {
                            case 0: {
                                string2 = ((FoVItem)object).instrument;
                                string = ((FoVItem)object2).instrument;
                                break;
                            }
                            case 2: {
                                string2 = ((FoVItem)object).description;
                                string = ((FoVItem)object2).description;
                                break;
                            }
                            case 3: {
                                string2 = ((FoVItem)object).origine;
                                string = ((FoVItem)object2).origine;
                            }
                        }
                        return ((Comparable)((Object)string2)).compareTo(string);
                    }
                };
                int n4 = ServerFoV.this.table.getSelectedRow();
                FoVItem foVItem = n4 >= 0 ? ServerFoV.this.fovList.get(n4) : null;
                Collections.sort(ServerFoV.this.fovList, comparator);
                if (!ServerFoV.this.ascSort) {
                    Collections.reverse(ServerFoV.this.fovList);
                }
                ServerFoV.this.ascSort = !ServerFoV.this.ascSort;
                ServerFoV.this.notifyTableChanged();
                this.selectItem(foVItem);
            }
        }

        private void selectItem(final Object object) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerFoV.this.table.clearSelection();
                    if (object == null) {
                        return;
                    }
                    int n = ServerFoV.this.fovList.indexOf(object);
                    if (n >= 0) {
                        ServerFoV.this.table.addRowSelectionInterval(n, n);
                    }
                }
            });
        }
    }

    class TableHeaderRenderer
    extends DefaultTableCellRenderer {
        TableCellRenderer renderer;

        public TableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.renderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToView(ServerFoV.this.idxSortedCol);
            if (component instanceof JLabel) {
                if (n2 == n3) {
                    ImageIcon imageIcon = ServerFoV.this.ascSort ? Util.getAscSortIcon() : Util.getDescSortIcon();
                    ((JLabel)component).setIcon(imageIcon);
                    ((JLabel)component).setHorizontalTextPosition(10);
                } else {
                    ((JLabel)component).setIcon(null);
                }
            }
            return component;
        }
    }

    class FoVItem {
        String instrument;
        String telescope;
        String description;
        String origine;
        String id;
        PlanField pf;

        FoVItem(String string, String string2, String string3, String string4) {
            this.instrument = string;
            this.telescope = string2;
            this.description = string3;
            this.origine = string4 == null ? "" : string4;
            this.id = this.instrument;
            this.pf = null;
        }

        FoVItem(String string, PlanField planField) {
            this.id = string;
            this.pf = planField;
            this.instrument = planField.getInstrumentName();
            this.telescope = planField.getTelescopeName();
            this.description = planField.getInstrumentDesc();
            this.origine = planField.getOrigine();
            if (this.instrument == null || this.instrument.length() == 0) {
                this.instrument = string;
            }
        }
    }
}

