/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MyTree;
import cds.aladin.Projection;
import cds.aladin.ServerTree;
import cds.aladin.Tok;
import cds.aladin.TreeNode;
import cds.aladin.TreeNodeAllsky;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

public class ServerHips
extends ServerTree {
    private boolean populated = false;
    private JRadioButton fitsRadio;
    private Coord oc = null;
    private double osize = -1.0;
    private boolean dynTree = false;

    @Override
    protected void init() {
        this.type = 8;
        this.aladinLabel = "hips";
        this.aladinLogo = "Hips.png";
    }

    @Override
    protected int addTailPanel(int n) {
        int n2 = 25;
        if (Aladin.OUTREACH) {
            return n;
        }
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        JLabel jLabel = new JLabel(Aladin.chaine.getString("ALADINDEFFMT"));
        jPanel.add(jLabel);
        JRadioButton jRadioButton = new JRadioButton(Aladin.chaine.getString("ALLSKYJPEG"));
        jRadioButton.setBackground(Aladin.BLUE);
        jRadioButton.setSelected(true);
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        this.fitsRadio = jRadioButton = new JRadioButton(Aladin.chaine.getString("ALLSKYFITS"));
        jRadioButton.setBackground(Aladin.BLUE);
        buttonGroup.add(jRadioButton);
        jPanel.add(jRadioButton);
        jPanel.setBackground(Aladin.BLUE);
        jPanel.setBounds(0, n, XWIDTH, n2);
        this.add(jPanel);
        return n += n2;
    }

    @Override
    protected int makeTarget(int n) {
        JPanel jPanel = new JPanel();
        int n2 = this.makeTargetPanel(jPanel, 0);
        jPanel.setBackground(Aladin.BLUE);
        jPanel.setBounds(0, n, XWIDTH, n2);
        this.add(jPanel);
        return n += n2;
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.title = Aladin.chaine.getString("ALLSKYTITLE");
        this.info = null;
        this.info1 = null;
        this.description = Aladin.chaine.getString("ALLSKYDESC");
    }

    protected ServerHips(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected int createPlane(String string, String string2, String string3, String string4, String string5) {
        Object object;
        String string6;
        int n = 0;
        if (string3 == null || string3.trim().length() == 0) {
            string6 = "DSS colored";
        } else {
            Tok tok = new Tok(string3, ", ");
            string6 = tok.nextToken();
            while (tok.hasMoreTokens()) {
                object = tok.nextToken();
                if (((String)object).equalsIgnoreCase("Fits")) {
                    n = 2;
                    continue;
                }
                if (!((String)object).equalsIgnoreCase("Jpeg") && !((String)object).equalsIgnoreCase("jpg") && !((String)object).equalsIgnoreCase("png")) continue;
                n = 1;
            }
        }
        int n2 = this.aladin.glu.findGluSky(string6, 2);
        if (n2 < 0) {
            Aladin.warning(this, "Progressive survey (HiPS) unknown [" + string6 + "]", 1);
            return -1;
        }
        object = this.aladin.glu.getGluSky(n2);
        try {
            if (n != 0) {
                ((TreeNodeAllsky)object).setDefaultMode(n);
            }
        }
        catch (Exception exception) {
            this.aladin.command.printConsole("!!! " + exception.getMessage());
        }
        return this.aladin.hips((TreeNodeAllsky)object, string4, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void hipsUpdate() {
        block23: {
            try {
                BufferedReader bufferedReader = null;
                try {
                    Object object;
                    block22: {
                        ViewSimple viewSimple = this.aladin.view.getCurrentView();
                        if (viewSimple.isFree() || viewSimple.isAllSky() || !Projection.isOk(viewSimple.getProj())) {
                            Glu cfr_ignored_0 = this.aladin.glu;
                            for (TreeNodeAllsky object22 : Glu.vGluSky) {
                                object22.ok = true;
                            }
                        } else {
                            Object object2;
                            Serializable serializable;
                            Coord coord = viewSimple.getCooCentre();
                            double d = viewSimple.getTaille();
                            if (coord.equals(this.oc) && d == this.osize) {
                                return;
                            }
                            this.oc = coord;
                            this.osize = d;
                            if (viewSimple.getTaille() > 45.0) {
                                object = "client_application=AladinDesktop" + (Aladin.BETA ? "*" : "") + "&hips_service_url=*&RA=" + coord.al + "&DEC=" + coord.del + "&SR=" + d * Math.sqrt(2.0);
                            } else {
                                serializable = new StringBuilder("Polygon");
                                object2 = viewSimple.getCooCorners();
                                int n = ((Coord[])object2).length;
                                for (int i = 0; i < n; ++i) {
                                    Coord coord2 = object2[i];
                                    serializable.append(" " + coord2.al + " " + coord2.del);
                                }
                                object = "client_application=AladinDesktop" + (Aladin.BETA ? "*" : "") + "&hips_service_url=*&stc=" + URLEncoder.encode(serializable.toString());
                            }
                            serializable = this.aladin.glu.getURL("MocServer", (String)object, true);
                            Aladin.trace(4, "ServerHips.hipsUpdate: Contacting MocServer : " + serializable);
                            bufferedReader = new BufferedReader(new InputStreamReader(Util.openStream((URL)serializable)));
                            HashSet<String> hashSet = new HashSet<String>();
                            while ((object2 = bufferedReader.readLine()) != null) {
                                hashSet.add(this.getId((String)object2));
                            }
                            Glu cfr_ignored_1 = this.aladin.glu;
                            for (TreeNodeAllsky treeNodeAllsky : Glu.vGluSky) {
                                treeNodeAllsky.ok = false;
                            }
                            Glu cfr_ignored_2 = this.aladin.glu;
                            for (TreeNodeAllsky treeNodeAllsky : Glu.vGluSky) {
                                treeNodeAllsky.ok = hashSet.contains(treeNodeAllsky.internalId);
                            }
                        }
                        try {
                            TreeNode treeNode;
                            object = (MyTree.NoeudEditor)this.tree.getCellEditor();
                            if (object != null && (treeNode = (TreeNode)((MyTree.NoeudEditor)object).getCellEditorValue()) != null && treeNode.hasCheckBox()) {
                                if (treeNode.isOk()) {
                                    treeNode.checkbox.setForeground(Color.black);
                                } else {
                                    treeNode.checkbox.setForeground(Color.lightGray);
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (Aladin.levelTrace < 3) break block22;
                            exception.printStackTrace();
                        }
                    }
                    object = this.tree.getRoot();
                    this.tree.setOkTree((DefaultMutableTreeNode)object);
                    this.validate();
                    this.repaint();
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block23;
                exception.printStackTrace();
            }
        }
    }

    private String getId(String string) {
        int n = string.startsWith("ivo://") ? 6 : 0;
        int n2 = string.indexOf("/", n);
        int n3 = string.indexOf("?", n);
        if (n3 > 0) {
            n2 = Math.min(n2, n3);
        }
        String string2 = string.substring(n2 + 1);
        return string2;
    }

    @Override
    protected boolean is(String string) {
        return string.equalsIgnoreCase(this.aladinLabel);
    }

    @Override
    public void submit() {
        String string = this.fitsRadio != null && this.fitsRadio.isSelected() ? ",fits" : "";
        for (TreeNode treeNode : this.tree) {
            if (!(treeNode instanceof TreeNodeAllsky) || !treeNode.isCheckBoxSelected()) continue;
            TreeNodeAllsky treeNodeAllsky = (TreeNodeAllsky)treeNode;
            String string2 = this.getTarget(false);
            String string3 = this.getRadius(false);
            String string4 = string2 == null || string2.trim().length() == 0 ? "" : " " + string2 + (string3 == null ? "" : " " + string3);
            String string5 = treeNodeAllsky.internalId != null ? treeNodeAllsky.internalId : treeNodeAllsky.id;
            String string6 = string5 + string;
            String string7 = "get hips(" + Tok.quote(string5) + string + ")";
            this.aladin.console.printCommand(string7 + string4);
            int n = this.createPlane(string2, string3, string6, treeNodeAllsky.aladinLabel, treeNodeAllsky.copyright);
            if (n == -1) continue;
            this.aladin.calque.getPlan(n).setBookmarkCode(string7 + " $TARGET $RADIUS");
        }
        this.reset();
    }

    @Override
    protected void initTree() {
        if (this.dynTree) {
            return;
        }
        new Thread("initTree"){

            @Override
            public void run() {
                ServerHips.this.loadRemoteTree();
                Glu cfr_ignored_0 = ServerHips.this.aladin.glu;
                ServerHips.this.tree.populateTree(Glu.vGluSky.elements());
                ServerHips.this.aladin.gluSkyReload();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRemoteTree() {
        if (this.dynTree) {
            return;
        }
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream;
            this.dynTree = true;
            Aladin.trace(3, "Loading HiPS Tree definitions...");
            String string = "client_application=AladinDesktop" + (Aladin.BETA ? "*" : "") + "&hips_service_url=*&fmt=glu&get=record";
            String string2 = this.aladin.glu.getURL("MocServer", string, true).toString();
            try {
                inputStream = Aladin.cache.getWithBackup(string2);
            }
            catch (Exception exception) {
                if (!this.aladin.glu.checkIndirection("MocServer", null)) {
                    throw exception;
                }
                string2 = this.aladin.glu.getURL("MocServer", string, true).toString();
                inputStream = Util.openStream(string2);
            }
            filterInputStream = new DataInputStream(inputStream);
            this.aladin.glu.loadGluDic((DataInputStream)filterInputStream, 0, false, true, false, false);
            this.aladin.glu.tri();
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

