/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.Server;
import cds.moc.HealpixMoc;
import cds.tools.MultiPartPostOutputStream;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerMocQuery
extends Server {
    private static String[] LARGE_CATS = new String[]{"2MASS", "CMC14", "UCAC3", "UCAC4", "2MASS6X", "SDSS8", "USNOB1", "WISE_ALLSKY", "DENIS", "GLIMPSE", "GSC23", "NOMAD", "PPMX", "PPMXL", "TYCHO2", "SIMBAD", "UKIDSS_DR8_LAS", "UKIDSS_DR6_GPS"};
    private String baseUrl = "http://cdsxmatch.u-strasbg.fr/QueryCat/QueryCat";
    private JComboBox comboMoc;
    private JComboBox comboCat;
    private JTextField textCat;
    private JComboBox comboMaxNbRows;

    protected void init() {
        this.type = 2;
        this.title = "MOC query";
        this.aladinLabel = "MOC";
    }

    @Override
    protected void createChaine() {
        this.description = "Query by MOC";
        super.createChaine();
    }

    protected ServerMocQuery(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = Aladin.OUTREACH ? 60 : 50;
        int n2 = 150;
        JPanel jPanel = new JPanel();
        Dimension dimension = this.makeTitle(jPanel, this.title);
        jPanel.setBackground(Aladin.BLUE);
        jPanel.setBounds(235 - dimension.width / 2, n, dimension.width, dimension.height);
        this.add(jPanel);
        JLabel jLabel = new JLabel(this.description);
        jLabel.setBounds(90, n += dimension.height + 10, 400, 20);
        this.add(jLabel);
        JLabel jLabel2 = new JLabel("Choose a MOC");
        jLabel2.setFont(Aladin.BOLD);
        jLabel2.setBounds(10, n += 20, 150, HAUT);
        this.add(jLabel2);
        this.comboMoc = new JComboBox();
        this.comboMoc.setBounds(160, n, XWIDTH - 160, HAUT);
        this.add(this.comboMoc);
        jLabel2 = new JLabel("Catalog to query");
        jLabel2.setFont(Aladin.BOLD);
        jLabel2.setBounds(10, n += HAUT + MARGE, 150, HAUT);
        this.add(jLabel2);
        jLabel2 = new JLabel("Choose in list");
        jLabel2.setFont(Aladin.ITALIC);
        jLabel2.setBounds(10, n += HAUT + MARGE, 150, HAUT);
        this.add(jLabel2);
        this.comboCat = new JComboBox();
        this.comboCat.addItem("---");
        Arrays.sort(LARGE_CATS);
        for (String string : LARGE_CATS) {
            this.comboCat.addItem(string);
        }
        this.comboCat.setBounds(160, n, XWIDTH - 160, HAUT);
        this.add(this.comboCat);
        jLabel2 = new JLabel("Or enter a VizieR table ID");
        jLabel2.setFont(Aladin.ITALIC);
        jLabel2.setBounds(10, n += HAUT + MARGE, 150, HAUT);
        this.add(jLabel2);
        this.textCat = new JTextField();
        this.textCat.setBounds(160, n, XWIDTH - 160, HAUT);
        n += HAUT + MARGE;
        this.add(this.textCat);
        this.comboCat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getItem().equals("---")) {
                    ServerMocQuery.this.textCat.setEnabled(true);
                } else {
                    ServerMocQuery.this.textCat.setEnabled(false);
                    ServerMocQuery.this.textCat.setText("");
                }
            }
        });
        jLabel2 = new JLabel("Max nb of rows");
        jLabel2.setFont(Aladin.BOLD);
        jLabel2.setBounds(10, n, 150, HAUT);
        this.add(jLabel2);
        this.comboMaxNbRows = new JComboBox();
        this.comboMaxNbRows.addItem("10,000");
        this.comboMaxNbRows.addItem("50,000");
        this.comboMaxNbRows.addItem("100,000");
        this.comboMaxNbRows.addItem("unlimited");
        this.comboMaxNbRows.setBounds(160, n, XWIDTH - 160, HAUT);
        n += HAUT + MARGE;
        this.add(this.comboMaxNbRows);
    }

    @Override
    protected void adjustInputChoice(JComboBox jComboBox, Vector vector, int n) {
        int n2 = jComboBox.getSelectedIndex();
        String string = n2 >= 0 ? (String)jComboBox.getItemAt(n2) : null;
        jComboBox.removeAllItems();
        jComboBox.addItem(this.NOINPUTITEM);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                jComboBox.addItem(((Plan)enumeration.nextElement()).label);
            }
        }
        if (n > 0) {
            jComboBox.setSelectedIndex(n);
        } else if (string == null || string.equals(this.NOINPUTITEM)) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            Vector<Plan> vector = this.aladin.calque.getPlans(PlanMoc.class);
            this.comboMoc.removeAllItems();
            if (vector != null) {
                Iterator<Plan> iterator = vector.iterator();
                while (iterator.hasNext()) {
                    this.comboMoc.addItem(iterator.next());
                }
            }
        }
        super.setVisible(bl);
    }

    @Override
    protected boolean isDiscovery() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitThread() {
        URL uRL;
        this.waitCursor();
        try {
            uRL = new URL(this.baseUrl);
            Aladin.trace(4, "ServerMocQuery.submitThread: url=" + uRL);
        }
        catch (MalformedURLException malformedURLException) {
            this.defaultCursor();
            malformedURLException.printStackTrace();
            return;
        }
        PlanMoc planMoc = (PlanMoc)this.comboMoc.getSelectedItem();
        if (planMoc == null) {
            Aladin.warning("No MOC selected !");
            return;
        }
        try {
            MultiPartPostOutputStream.setTmpDir(Aladin.CACHEDIR);
            String string = MultiPartPostOutputStream.createBoundary();
            URLConnection uRLConnection = MultiPartPostOutputStream.createConnection(uRL);
            uRLConnection.setRequestProperty("Accept", "*/*");
            uRLConnection.setRequestProperty("Content-Type", MultiPartPostOutputStream.getContentType(string));
            uRLConnection.setRequestProperty("Connection", "Keep-Alive");
            uRLConnection.setRequestProperty("Cache-Control", "no-cache");
            MultiPartPostOutputStream multiPartPostOutputStream = new MultiPartPostOutputStream(uRLConnection.getOutputStream(), string);
            String string2 = this.comboCat.getSelectedItem().equals("---") ? this.textCat.getText().trim() : this.comboCat.getSelectedItem().toString();
            multiPartPostOutputStream.writeField("catName", string2);
            multiPartPostOutputStream.writeField("mode", "mocfile");
            multiPartPostOutputStream.writeField("format", "votable");
            String string3 = this.comboMaxNbRows.getSelectedItem().toString();
            if (!string3.equals("unlimited")) {
                string3 = string3.replaceAll(",", "");
                multiPartPostOutputStream.writeField("limit", string3);
            }
            HealpixMoc healpixMoc = planMoc.getMoc();
            File file = File.createTempFile("moc", "fits");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                healpixMoc.writeFits(fileOutputStream);
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
            multiPartPostOutputStream.writeFile("mocfile", null, file, false);
            multiPartPostOutputStream.close();
            this.aladin.calque.newPlanCatalog(new MyInputStream(uRLConnection.getInputStream()), string2 + " MOC query");
        }
        catch (Exception exception) {
            this.defaultCursor();
            exception.printStackTrace();
            Aladin.warning("An error occured while contacting the QueryCat service");
            return;
        }
        this.defaultCursor();
    }

    @Override
    public void submit() {
        new Thread(){

            @Override
            public void run() {
                ServerMocQuery.this.submitThread();
            }
        }.start();
    }
}

