/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.tools.MultiPartPostOutputStream;
import java.awt.Dimension;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ServerSWarp
extends Server {
    private String outputProj;
    private String atLeastOne;
    private JComboBox comboProj;
    private String baseUrl = "http://alasky.u-strasbg.fr/cgi/SWarp/nph-SWarp.py";
    private String[] availableProjections = new String[]{"TAN", "SIN", "ARC", "AIT", "ZEA", "ZPN", "STG"};

    protected void init() {
        this.type = 1;
        this.aladinLabel = "SWarp image co-adding service";
        this.aladinLogo = "SWarp.gif";
        this.docUser = "http://terapix.iap.fr/rubrique.php?id_rubrique=49";
    }

    @Override
    protected void createChaine() {
        this.title = Aladin.chaine.getString("SWTITLE");
        this.description = Aladin.chaine.getString("SWINFO");
        this.outputProj = Aladin.chaine.getString("SWOUTPUTPROJ");
        this.atLeastOne = Aladin.chaine.getString("SWATLEASTONE");
        super.createChaine();
    }

    protected ServerSWarp(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = Aladin.OUTREACH ? 60 : 50;
        int n2 = 150;
        JPanel jPanel = new JPanel();
        Dimension dimension = this.makeTitle(jPanel, this.title);
        jPanel.setBackground(Aladin.BLUE);
        jPanel.setBounds(235 - dimension.width / 2, n, dimension.width, dimension.height);
        this.add(jPanel);
        JLabel jLabel = new JLabel(this.description);
        jLabel.setBounds(90, n += dimension.height + 10, 400, 20);
        n += 20;
        this.add(jLabel);
        int n3 = 8;
        this.input = new JComponent[n3];
        this.modeInput = new int[n3];
        this.nbInput = n3;
        for (int i = 0; i < n3; ++i) {
            JLabel jLabel2 = new JLabel(this.addDot("Image " + (i + 1)));
            jLabel2.setFont(Aladin.BOLD);
            jLabel2.setBounds(10, n, 150, HAUT);
            this.add(jLabel2);
            JComboBox jComboBox = new JComboBox();
            jComboBox.setBounds(160, n, XWIDTH - 160, HAUT);
            n += HAUT + MARGE;
            this.add(jComboBox);
            this.input[i] = jComboBox;
            this.modeInput[i] = 1;
        }
        n = (int)((double)n + 1.3 * (double)(HAUT + MARGE));
        JLabel jLabel3 = new JLabel(this.addDot(this.outputProj));
        jLabel3.setBounds(10, n, 150, HAUT);
        this.add(jLabel3);
        this.comboProj = new JComboBox();
        this.comboProj.setBounds(160, n, XWIDTH - 160, HAUT);
        n += HAUT + MARGE;
        this.add(this.comboProj);
        for (int i = 0; i < this.availableProjections.length; ++i) {
            this.comboProj.addItem(this.availableProjections[i]);
        }
    }

    @Override
    protected void adjustInputChoice(JComboBox jComboBox, Vector vector, int n) {
        int n2 = jComboBox.getSelectedIndex();
        String string = n2 >= 0 ? (String)jComboBox.getItemAt(n2) : null;
        jComboBox.removeAllItems();
        jComboBox.addItem(this.NOINPUTITEM);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                jComboBox.addItem(((Plan)enumeration.nextElement()).label);
            }
        }
        if (n > 0) {
            jComboBox.setSelectedIndex(n);
        } else if (string == null || string.equals(this.NOINPUTITEM)) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    @Override
    protected boolean isDiscovery() {
        return false;
    }

    private void submitThread() {
        URL uRL;
        this.waitCursor();
        HashSet<Plan> hashSet = new HashSet<Plan>();
        for (int i = 0; i < this.input.length; ++i) {
            Plan[] planArray = this.getInputPlane(this.input[i]);
            if (planArray == null || planArray.length == 0) continue;
            hashSet.add(planArray[0]);
        }
        if (hashSet.size() == 0) {
            Aladin.warning(this.atLeastOne);
            return;
        }
        Iterator iterator = hashSet.iterator();
        try {
            uRL = new URL(this.baseUrl);
        }
        catch (MalformedURLException malformedURLException) {
            this.defaultCursor();
            malformedURLException.printStackTrace();
            return;
        }
        try {
            MultiPartPostOutputStream.setTmpDir(Aladin.CACHEDIR);
            String string = MultiPartPostOutputStream.createBoundary();
            URLConnection uRLConnection = MultiPartPostOutputStream.createConnection(uRL);
            uRLConnection.setRequestProperty("Accept", "*/*");
            uRLConnection.setRequestProperty("Content-Type", MultiPartPostOutputStream.getContentType(string));
            uRLConnection.setRequestProperty("Connection", "Keep-Alive");
            uRLConnection.setRequestProperty("Cache-Control", "no-cache");
            MultiPartPostOutputStream multiPartPostOutputStream = new MultiPartPostOutputStream(uRLConnection.getOutputStream(), string);
            multiPartPostOutputStream.writeField("projection", this.comboProj.getSelectedItem().toString());
            if (this.aladin.save == null) {
                this.aladin.save = new Save(this.aladin);
            }
            int n = 1;
            while (iterator.hasNext()) {
                String string2 = "img" + n;
                Plan plan = (Plan)iterator.next();
                if (plan.hasRemoteUrl()) {
                    multiPartPostOutputStream.writeField(string2, plan.getUrl());
                } else {
                    multiPartPostOutputStream.writeFile(string2, "image/fits", string2 + ".fits", this.aladin.save.saveImageFITS((OutputStream)null, (PlanImage)plan), true);
                }
                ++n;
            }
            multiPartPostOutputStream.close();
            this.aladin.calque.newPlanImage(uRLConnection.getInputStream(), "SWarp", "SWarp");
        }
        catch (Exception exception) {
            this.defaultCursor();
            exception.printStackTrace();
            Aladin.warning("An error occured while contacting the SWarp service");
            return;
        }
        this.defaultCursor();
    }

    @Override
    public void submit() {
        new Thread(){

            @Override
            public void run() {
                ServerSWarp.this.submitThread();
            }
        }.start();
    }
}

