/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MyInputStream;
import cds.aladin.Server;
import cds.aladin.prop.Filet;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ServerSimbad
extends Server {
    String tagGlu;
    String info1;
    String filter;
    protected double maxRadius = 60.0;

    private String getTagGlu() {
        if (this.TESTSERVER && !this.testServer.isSelected()) {
            return this.tagGlu.substring(0, this.tagGlu.length() - 1);
        }
        return this.tagGlu;
    }

    protected void init() {
        this.type = 2;
        this.aladinLabel = "Simbad database";
        this.tagGlu = "SimbadXML1";
        this.aladinLogo = "SimbadLogo.gif";
        this.docUser = "http://simbad.u-strasbg.fr/guide/ch15.htx";
        this.maxRadius = -1.0;
        if (!Aladin.CDS || this.aladin.glu.getURL(this.tagGlu, "", false, false) == null) {
            this.tagGlu = this.tagGlu.substring(0, this.tagGlu.length() - 1);
        } else {
            this.TESTSERVER = true;
        }
        this.filters = new String[]{"#All objects\nfilter All {\n(${OTYPE}=\"Star\" || ${OTYPE}=\"*\\**\") && (${B}!=0 || ${V}!=0 || ${R}!=0 || ${J}!=0 || ${K}!=0) {\n   draw pm(${PMRA},${PMDEC})\n   draw circle(-$[phot.mag*],3,15)\n}\n(${OTYPE}=\"Star\" ||${OTYPE}=\"*\\**\") && ${B}=\"\" && ${V}=\"\" && ${R}=\"\" && ${J}=\"\" && ${K}=\"\" {\n   draw pm(${PMRA},${PMDEC})\n   draw circle(3)\n}\n(${OTYPE}=\"G*\" || ${OTYPE}=\"*G\") && ${GALDIM_MAJAXIS}!=0 {\n   draw ellipse(0.5*${GALDIM_MAJAXIS},0.5*${GALDIM_MINAXIS},${GALDIM_ANGLE})\n}\n(${OTYPE}=\"G*\" || ${OTYPE}=\"*G\")) && ${GALDIM_MAJAXIS}==\"\" {\n   draw oval\n}\n${OTYPE}=\"Radio*\" || ${OTYPE}=\"Maser\" || ${OTYPE}=\"HI\" { draw triangle }\n${OTYPE}=\"UV\" {draw cross;draw plus}\n${OTYPE}=\"IR\" || ${OTYPE}=\"Red*\" {draw rhomb}\n${OTYPE}=\"Neb\"  || ${OTYPE}=\"PN*\" || ${OTYPE}=\"SNR*\" {draw square}\n${OTYPE}=\"HII\" { draw dot }${OTYPE}=\"X\" { draw cross }\n${OTYPE}!=\"Unknown\" { draw ${OTYPE} }\n{ draw dot }\n}", "#Star\nfilter Star {\n(${OTYPE}=\"Star\" || ${OTYPE}=\"*\\**\") && (${B}!=0 || ${V}!=0 || ${R}!=0 || ${J}!=0 || ${K}!=0) {\n   draw pm(${PMRA},${PMDEC})\n   draw circle(-$[phot.mag*],3,15)\n}\n(${OTYPE}=\"Star\" ||${OTYPE}=\"*\\**\") && ${B}=\"\" && ${V}=\"\" && ${R}=\"\" && ${J}=\"\" && ${K}=\"\" {\n   draw pm(${PMRA},${PMDEC})\n   draw circle(3)\n}\n}", "#Galaxy\nfilter Galaxy {\n(${OTYPE}=\"G*\" || ${OTYPE}=\"*G\") && ${GALDIM_MAJAXIS}!=0 {\n   draw ellipse(0.5*${GALDIM_MAJAXIS},0.5*${GALDIM_MINAXIS},${GALDIM_ANGLE})\n}\n(${OTYPE}=\"G*\" || ${OTYPE}=\"*G\")) && ${GALDIM_MAJAXIS}==\"\" {\n   draw oval\n}\n}", "#Radio\nfilter Radio {\n${OTYPE}=\"Radio*\" || ${OTYPE}=\"Maser\" || ${OTYPE}=\"HI\" { draw triangle }\n}", "#UV\nfilter UV {\n${OTYPE}=\"UV\" {draw cross;draw plus}\n}", "#IR\nfilter IR {\n${OTYPE}=\"IR\" || ${OTYPE}=\"Red*\" {draw rhomb}\n}", "#Neb\nfilter Neb {\n${OTYPE}=\"Neb\"  || ${OTYPE}=\"PN*\" || ${OTYPE}=\"SNR*\" {draw square}\n}", "#HII\nfilter HII {\n${OTYPE}=\"HII\" { draw dot }}", "#X\nfilter X {\n${OTYPE}=\"X\" { draw cross }\n}"};
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("SMBINFO");
        this.institute = Aladin.chaine.getString("SMBFROM");
        this.title = Aladin.chaine.getString("SMBTITLE");
        this.verboseDescr = Aladin.chaine.getString("SMBDESC");
        this.info1 = Aladin.chaine.getString("SMBINFO1");
        this.filter = Aladin.chaine.getString("SMBFILTER");
    }

    protected ServerSimbad(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = Aladin.OUTREACH ? 60 : 50;
        int n2 = 150;
        JPanel jPanel = new JPanel();
        Dimension dimension = this.makeTitle(jPanel, this.title);
        if (this.TESTSERVER) {
            this.testServer.setText("(live Simbad)");
            dimension.width += 80;
            this.testServer.setSelected(false);
        }
        jPanel.setBackground(Aladin.BLUE);
        jPanel.setBounds(235 - dimension.width / 2, n, dimension.width, dimension.height);
        this.add(jPanel);
        JLabel jLabel = new JLabel(this.info1);
        jLabel.setBounds(90, n += dimension.height + 10, 400, 20);
        n += 20;
        this.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Aladin.BLUE);
        int n3 = this.makeTargetPanel(jPanel2, 0);
        jPanel2.setBounds(0, n, XWIDTH, n3);
        n += n3;
        this.add(jPanel2);
        this.modeCoo = 5;
        this.modeRad = 1;
        this.getGluFilters(this.tagGlu);
        if (this.filters != null) {
            Filet filet = new Filet();
            filet.setBounds(40, n += 20, XWIDTH - 60, 5);
            n += 20;
            this.add(filet);
            this.filtersChoice = this.createFilterChoice();
            this.filtersChoice.setOpaque(false);
            JLabel jLabel2 = new JLabel(this.addDot(this.filter));
            jLabel2.setFont(Aladin.BOLD);
            jLabel2.setBounds(10, n += 10, 150, HAUT);
            this.add(jLabel2);
            this.filtersChoice.setBounds(160, n, XWIDTH - 160, HAUT);
            n += HAUT + MARGE;
            this.add(this.filtersChoice);
        }
    }

    @Override
    protected boolean isDiscovery() {
        return true;
    }

    @Override
    protected MyInputStream getMetaData(String string, String string2, StringBuffer stringBuffer) {
        try {
            double d = ServerSimbad.getRM(string2);
            string = this.resolveTarget(string);
            String string3 = Glu.quote(string) + " " + Glu.quote(d + "");
            URL uRL = this.aladin.glu.getURL(this.getTagGlu(), string3);
            if (uRL == null) {
                return null;
            }
            stringBuffer.append(uRL + "");
            return this.getMetaDataForCat(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    protected int createPlane(String string, String string2, String string3, String string4, String string5) {
        URL uRL;
        this.defaultCursor();
        double d = ServerSimbad.getRM(string2);
        if (this.maxRadius > 0.0 && d > this.maxRadius) {
            this.ball.setMode(2);
            Aladin.warning(this, this.WTOOLARGE + " (>" + Coord.getUnit(this.maxRadius / 60.0) + ")", 1);
            return -1;
        }
        string2 = d + "";
        String string6 = Glu.quote(string) + " " + Glu.quote(string2);
        if (string4 == null) {
            string4 = this.getNom();
        }
        if ((uRL = this.aladin.glu.getURL(this.getTagGlu(), string6)) == null) {
            this.ball.setMode(2);
            Aladin.warning(this, this.WERROR, 1);
            return -1;
        }
        if (!this.verif(8, string, string4 + " " + string2)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(uRL, string4, string, string4 + " " + string2, string5, this);
    }

    @Override
    public void submit() {
        String string = this.getTarget(this.flagVerif);
        if (string == null) {
            return;
        }
        String string2 = this.getRadius();
        if (string2 == null) {
            return;
        }
        double d = ServerSimbad.getRM(string2);
        this.waitCursor();
        String string3 = "get " + this.aladinLabel + " " + string + " " + Coord.getUnit(d / 60.0);
        this.aladin.console.printCommand(string3);
        int n = this.createPlane(string, d + "", null, null, this.institute);
        if (n != -1) {
            this.aladin.calque.getPlan(n).setBookmarkCode("get " + this.aladinLabel + " $TARGET $RADIUS");
        }
    }
}

