/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.MyLabel;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.tools.CDSConstants;
import cds.vizier.VizieRCatalogs;
import cds.vizier.VizieRList;
import cds.vizier.VizieRPanel;
import cds.xml.XMLParser;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class ServerVizieR
extends Server
implements CDSConstants,
Runnable {
    String CATDESC;
    String CATMOC;
    String CATDMAP;
    String INFO1;
    String TAGGLU;
    String GETALL;
    String GETALL1;
    String CAT;
    static final String MOCGLU = "getMOC";
    static final String MOCERROR = "Catalog unknown or MOC server error";
    VizieRList vizierlist;
    JTextField catalog;
    JCheckBox cbGetAll;
    JCheckBox cbGetAllCat;
    MyLabel legende;
    JButton getReadMe;
    JButton getMoc;
    JButton getDMap;
    boolean hasPreviousFocus = false;
    Thread thread;
    Vector vSurveys;
    Vector vArchives;
    ServerDialog serverDialog;
    VizieRPanel vp = null;
    Vector catalogs = new Vector();
    VizieRCatalogs vcl = null;
    JPanel panelButtonRight = new JPanel();
    JPanel actions;
    private String oCat = null;

    protected ServerVizieR(Aladin aladin, ServerDialog serverDialog, JPanel jPanel) {
        this.aladin = aladin;
        this.createChaine();
        this.type = 2;
        this.aladinLogo = "VizieRLogo.gif";
        this.docUser = "http://vizier.u-strasbg.fr";
        this.TAGGLU = "VizieRXML++1";
        this.aladinLabel = "VizieR";
        if (!Aladin.CDS || aladin.glu.getURL(this.TAGGLU, "", false, false) == null) {
            this.TAGGLU = this.TAGGLU.substring(0, this.TAGGLU.length() - 1);
        } else {
            this.TESTSERVER = true;
        }
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 0;
        this.actions = jPanel;
        this.serverDialog = serverDialog;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Aladin.BLUE);
        Dimension dimension = this.makeTitle(jPanel2, this.title);
        if (this.TESTSERVER) {
            this.testServer.setText("(beta server)");
            dimension.width += 100;
            this.testServer.setSelected(false);
        }
        jPanel2.setBounds(235 - dimension.width / 2, n, dimension.width, dimension.height);
        this.add(jPanel2);
        JLabel jLabel = new JLabel(this.INFO1);
        jLabel.setBounds(86, n += dimension.height + 10, 400, 20);
        this.add(jLabel);
        int n2 = (n += 20) + 15;
        int n3 = XWIDTH - 105;
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Aladin.BLUE);
        int n4 = this.makeTargetPanel(jPanel3, 8);
        jPanel3.setBounds(0, n, n3 - 5, n4);
        this.add(jPanel3);
        this.modeCoo = 5;
        this.modeRad = 1;
        n += n4;
        this.cbGetAll = new JCheckBox(this.GETALL, false);
        this.cbGetAll.setEnabled(false);
        this.cbGetAll.setBackground(Aladin.BLUE);
        this.cbGetAll.setBounds(n3, n2, 120, 20);
        n2 += 20;
        if (!Aladin.OUTREACH) {
            this.add(this.cbGetAll);
        }
        this.cbGetAllCat = new JCheckBox(this.GETALL1, false);
        this.cbGetAllCat.setEnabled(false);
        this.cbGetAllCat.setBackground(Aladin.BLUE);
        this.cbGetAllCat.setBounds(n3, n2, 140, 20);
        n2 += 20;
        this.cbGetAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !ServerVizieR.this.cbGetAllCat.isSelected();
                ServerVizieR.this.target.setEnabled(bl);
                ServerVizieR.this.radius.setEnabled(bl);
            }
        });
        if (!Aladin.OUTREACH) {
            this.add(this.cbGetAllCat);
        }
        JLabel jLabel2 = new JLabel(this.addDot(this.CAT));
        jLabel2.setFont(Aladin.BOLD);
        int n5 = 85;
        jLabel2.setBounds(10, n, n5, 30);
        this.add(jLabel2);
        this.catalog = new JTextField(28);
        this.catalog.setBounds(n5 + 15, n, 120, HAUT);
        this.catalog.addKeyListener(this);
        this.catalog.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ServerVizieR.this.updateWidgets();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ServerVizieR.this.updateWidgets();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ServerVizieR.this.updateWidgets();
            }
        });
        this.add(this.catalog);
        JLabel jLabel3 = new JLabel(this.addDot(this.RAD));
        jLabel3.setFont(Aladin.BOLD);
        jLabel3.setBounds(231, n, n5, HAUT);
        this.add(jLabel3);
        this.radius = new JTextField("10 arcmin");
        this.radius.setBounds(279, n, 105, HAUT);
        n += HAUT + MARGE - 2;
        this.radius.addKeyListener(this);
        this.radius.addActionListener(this);
        this.add(this.radius);
        Insets insets = new Insets(0, 10, 0, 10);
        this.getReadMe = new JButton(this.CATDESC);
        this.getReadMe.setMargin(insets);
        this.getReadMe.addActionListener(this);
        this.getReadMe.setFont(Aladin.BOLD);
        this.getReadMe.setEnabled(false);
        this.getMoc = new JButton(this.CATMOC);
        this.getMoc.setMargin(insets);
        this.getMoc.addActionListener(this);
        this.getMoc.setFont(Aladin.BOLD);
        this.getMoc.setEnabled(false);
        this.getDMap = new JButton(this.CATDMAP);
        this.getDMap.setMargin(insets);
        this.getDMap.addActionListener(this);
        this.getDMap.setFont(Aladin.BOLD);
        this.getDMap.setEnabled(false);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.setBounds(n5 + 15, n, 350, HAUT);
        jPanel4.setBackground(Aladin.BLUE);
        jPanel4.add(this.getReadMe);
        jPanel4.add(this.getMoc);
        if (Aladin.BETA) {
            jPanel4.add(this.getDMap);
        }
        if (!Aladin.OUTREACH) {
            this.add(jPanel4);
        }
        this.vp = new VizieRPanel(this, 1, false, null, null, 10);
        this.vp.setBounds(10, n += HAUT + MARGE + 5, XWIDTH - 20, 280);
        n += 280;
        this.add(this.vp);
        String[] stringArray = this.vp.getSelection("SURVEY");
        this.vSurveys = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            this.vSurveys.addElement(stringArray[i]);
        }
        String[] stringArray2 = this.vp.getSelection("MISSION");
        this.vArchives = new Vector();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.vArchives.addElement(stringArray2[i]);
        }
        this.setMaxComp(this.vp);
    }

    private String getTagGlu() {
        if (this.TESTSERVER && !this.testServer.isSelected()) {
            return this.TAGGLU.substring(0, this.TAGGLU.length() - 1);
        }
        return this.TAGGLU;
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.title = Aladin.chaine.getString("VZTITLE");
        this.aladinLabel = Aladin.chaine.getString("VZNAME");
        this.description = Aladin.chaine.getString("VZINFO");
        this.verboseDescr = Aladin.chaine.getString("VZDESC");
        this.CATDESC = Aladin.chaine.getString("VZCATDESC");
        this.CATMOC = Aladin.chaine.getString("VZCATMOC");
        this.CATDMAP = Aladin.chaine.getString("VZCATDMAP");
        this.INFO1 = Aladin.chaine.getString("VZINFO1");
        this.GETALL = Aladin.chaine.getString("VZGETALL2");
        this.GETALL1 = Aladin.chaine.getString("VZGETALL3");
        this.CAT = Aladin.chaine.getString("VZCAT");
    }

    @Override
    protected boolean is(String string) {
        return string.equalsIgnoreCase("vizier") || string.equalsIgnoreCase("vizir") || string.equalsIgnoreCase("vizierX");
    }

    @Override
    protected int createPlane(String string, String string2, String string3, String string4, String string5) {
        string3 = ServerVizieR.specialUnQuoteCriteria(string3);
        boolean bl = false;
        int n = string3.indexOf("allcolumns");
        if (n >= 0) {
            string3 = string3.substring(0, n) + string3.substring(n + "allcolumns".length());
            string3 = string3.trim();
            bl = true;
        }
        if (this.cbGetAllCat.isSelected()) {
            string = "";
        }
        if ((n = string3.indexOf("allsky")) >= 0) {
            string3 = string3.substring(0, n) + string3.substring(n + "allsky".length());
            string3 = string3.trim();
            string = "";
        }
        String string6 = string3;
        if (string4 == null) {
            string4 = string6;
        }
        return this.creatVizieRPlane(string, string2, string6, string4, this.institute, bl);
    }

    protected int creatVizieRPlane(String string, String string2, String string3, String string4, String string5, boolean bl) {
        URL uRL;
        string2 = ServerVizieR.getRM(string2) + "";
        String string6 = Glu.quote(string3) + " " + Glu.quote(string) + " " + Glu.quote(string2);
        if (bl) {
            string6 = string6 + " -out.all";
        }
        if ((uRL = this.aladin.glu.getURL(this.getTagGlu(), string6)) == null) {
            Aladin.warning(this, this.WERROR, 1);
            return -1;
        }
        String string7 = string4 + " " + string2 + (bl ? " (all columns)" : "");
        if (!this.verif(8, string, string7)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(uRL, string4, string, string7, string5, this);
    }

    @Override
    public void run() {
        String string;
        this.ball.setMode(4);
        try {
            string = ServerVizieR.getRM(this.radius.getText()) + "";
        }
        catch (Exception exception) {
            string = "";
        }
        this.vp.submit(this.target.getText(), string);
        JList jList = this.vp.getResultList();
        this.catalogs.removeAllElements();
        for (int i = 0; i < jList.getModel().getSize(); ++i) {
            this.catalogs.addElement(jList.getModel().getElementAt(i));
        }
        if (this.vcl == null) {
            JButton jButton = new JButton("SUBMIT");
            jButton.setFont(LBOLD);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ServerVizieR.this.submit();
                    ServerVizieR.this.vcl.resetCatList();
                    ServerVizieR.this.catalog.setText("");
                }
            });
            this.vcl = new VizieRCatalogs(this.catalog, null, null, this.catalogs, jButton);
        } else {
            this.vcl.show(this.catalogs);
        }
        if (this.target.getText().compareTo("") == 0) {
            this.vcl.setTitle(this.catalogs.size() + " catalog(s) found " + this.target.getText());
        } else {
            this.vcl.setTitle(this.catalogs.size() + " catalog(s) found around " + this.target.getText());
        }
        if (this.catalogs.size() == 0) {
            this.ball.setMode(3);
        } else {
            this.ball.setMode(1);
        }
    }

    @Override
    public void submit() {
        double d = 0.0;
        if (this.catalog.getText().compareTo("") == 0) {
            this.thread = new Thread((Runnable)this, "AladinVizieRQuery");
            this.thread.start();
            return;
        }
        boolean bl = this.cbGetAllCat.isSelected();
        String string = this.getTarget(false);
        String string2 = this.catalog.getText().trim();
        if (string == null || string.length() == 0) {
            if (string2.length() == 0) {
                Aladin.warning(this, this.WNEEDCAT);
                return;
            }
            if (!Aladin.confirmation(this, "Do you really want to download\nall \"" + string2 + "\" ?")) {
                return;
            }
            string = "";
            d = 0.0;
        } else if (!bl) {
            String string3 = this.getRadius();
            if (string3 == null) {
                return;
            }
            d = ServerVizieR.getRM(string3);
        }
        this.waitCursor();
        String string4 = null;
        if (this.cbGetAll.isSelected()) {
            string2 = string2 + ",allcolumns";
        }
        if (!bl && string != null && string.length() > 0) {
            string4 = "get VizieR(" + string2 + ")";
            this.aladin.console.printCommand("get VizieR(" + string2 + ") " + string + " " + Coord.getUnit(d / 60.0));
        } else {
            string4 = "get VizieRX(" + string2 + ")";
            this.aladin.console.printCommand(string4);
        }
        int n = this.createPlane(string, d + "", string2, null, null);
        if (n != -1) {
            this.aladin.calque.getPlan(n).setBookmarkCode(string4 + " $TARGET $RADIUS");
        }
        this.defaultCursor();
    }

    @Override
    protected boolean isDiscovery() {
        return true;
    }

    protected MyInputStream getMetaDataForCat(Vector vector, String string, String string2) {
        try {
            int n = vector.size();
            if (n == 0) {
                return null;
            }
            MyByteArrayStream myByteArrayStream = null;
            MyByteArrayStream myByteArrayStream2 = myByteArrayStream = new MyByteArrayStream(10000);
            Aladin.writeBytes(myByteArrayStream2, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">\n<VOTABLE version=\"v1.0\">\n<RESOURCE type=\"results\">\n   <INFO name=\"QUERY_STATUS\" value=\"OK\"/>\n   <TABLE>\n<FIELD name=\"Resource\" datatype=\"char\" ucd=\"VOX:Image_Title\" arraysize=\"*\"/>\n<FIELD name=\"url\" datatype=\"char\" ucd=\"VOX:Image_AccessReference\" arraysize=\"*\"/>\n<FIELD ID=\"FORMAT\" datatype=\"char\" arraysize=\"*\"/>\n<DATA>\n<TABLEDATA>\n");
            for (int i = 0; i < n; ++i) {
                String string3 = XMLParser.XMLEncode((String)vector.elementAt(i));
                int n2 = string3.indexOf(9);
                if (n2 < 0) continue;
                String string4 = string3.substring(0, n2);
                String string5 = Glu.quote(string4) + " " + Glu.quote(string) + " " + Glu.quote(string2);
                URL uRL = this.aladin.glu.getURL(this.getTagGlu(), string5);
                if (uRL == null) continue;
                string3 = string3.replace('\t', ' ');
                Aladin.writeBytes(myByteArrayStream2, "   <TR>\n      <TD>" + string3 + "</TD>\n      <TD><![CDATA[" + uRL + "]]></TD>\n      <TD>CATALOG</TD>\n   </TR>\n");
            }
            Aladin.writeBytes(myByteArrayStream2, "</TABLEDATA>\n</DATA>\n</TABLE>\n</RESOURCE>\n</VOTABLE>\n");
            return new MyInputStream(myByteArrayStream.getInputStream());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected MyInputStream getMetaData(String string, String string2, StringBuffer stringBuffer) {
        double d = ServerVizieR.getRM(string2);
        Vector vector = new Vector();
        if (!this.vp.getVizieRQuery().submit(string, d + "", null, null, null, null, 1, vector)) {
            return null;
        }
        return this.getMetaDataForCat(vector, string, string2);
    }

    @Override
    protected void clear() {
        super.clear();
        this.catalog.setText("");
        this.vp.resetAll();
    }

    @Override
    public void setVisible(boolean bl) {
        this.resetCatalog();
        super.setVisible(bl);
    }

    public void resetCatalog() {
        this.catalog.setText("");
    }

    @Override
    protected void reset() {
        this.resetFlagBoxes();
        super.reset();
        this.vp.resetAll();
    }

    protected void resetFlagBoxes() {
        this.cbGetAll.setSelected(false);
        this.cbGetAllCat.setSelected(false);
        this.target.setEnabled(true);
        this.radius.setEnabled(true);
    }

    @Override
    protected boolean updateWidgets() {
        if (!super.updateWidgets()) {
            return false;
        }
        if (this.catalog == null) {
            return false;
        }
        String string = this.catalog.getText().trim();
        if (this.oCat != null && this.oCat.equals(string)) {
            return true;
        }
        this.oCat = string;
        boolean bl = string.length() != 0;
        this.getReadMe.setEnabled(bl);
        this.getMoc.setEnabled(bl);
        this.getDMap.setEnabled(bl);
        this.cbGetAll.setEnabled(bl);
        this.cbGetAllCat.setEnabled(bl);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object instanceof JButton && ((string = ((JButton)object).getActionCommand()).equals(this.CATDESC) || string.equals(this.CATMOC) || string.equals(this.CATDMAP))) {
            try {
                String string2 = this.catalog.getText().trim();
                if (string2.equals("")) {
                    Aladin.warning(this, this.WNEEDCAT);
                    return;
                }
                if (string.equals(this.CATDESC)) {
                    this.aladin.glu.showDocument("getReadMe", Glu.quote(string2));
                } else if (string.equals(this.CATMOC)) {
                    URL uRL = this.aladin.glu.getURL(MOCGLU, Glu.quote(string2) + " 512");
                    this.aladin.execAsyncCommand("'" + string2 + " MOC'=get File(" + uRL + ")");
                } else if (string.equals(this.CATDMAP)) {
                    this.aladin.calque.newPlanDMap(string2);
                }
                this.defaultCursor();
                return;
            }
            catch (Exception exception) {
                Aladin.warning("Error: cannot load this product\n" + exception.getMessage());
            }
        }
    }

    protected void hideSFrame() {
    }
}

