/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MyInputStream;
import cds.aladin.MyLabel;
import cds.aladin.Server;
import cds.aladin.ServerVizieRSurvey;
import cds.tools.Util;
import cds.vizier.VizieRTable;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ServerVizieRMission
extends Server {
    static final String MOCGLU = "getMOC";
    static final String DMAPPNGGLU = "getDMapIcon";
    static final String MOCERROR = "Catalog unknown or MOC server error";
    Vector vArchives;
    VizieRTable missionlist;
    JTextField mission;
    MyLabel currentlist;
    protected String default_methode;
    protected String help_list;
    protected String nomTextfield;
    JCheckBox cbGetAll;
    JCheckBox cbGetAllCat;
    JButton getReadMe;
    JButton getMoc;
    JButton getDMap;
    protected String CATDESC;
    protected String TAGGLU = "VizieRXML++";
    protected String GETALL;
    protected String GETALL1;
    protected String CATMOC;
    protected String CATDMAP;
    protected String ALLCAT;
    private PngMap pngMap;
    private String oCat = null;

    protected void init() {
        this.aladinLogo = "VizieRMLogo.gif";
        this.docUser = "http://vizier.u-strasbg.fr";
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.aladinLabel = Aladin.chaine.getString("ARNAME");
        this.nomTextfield = Aladin.chaine.getString("ARCAT");
        this.title = Aladin.chaine.getString("ARTITLE");
        this.description = Aladin.chaine.getString("ARINFO");
        this.default_methode = Aladin.chaine.getString("ARINFO1");
        this.help_list = Aladin.chaine.getString("ARINFO2");
        this.CATDESC = Aladin.chaine.getString("VZCATDESC");
        this.CATMOC = Aladin.chaine.getString("VZCATMOC");
        this.CATDMAP = Aladin.chaine.getString("VZCATDMAP");
        this.verboseDescr = Aladin.chaine.getString("ARDESC");
        this.GETALL = Aladin.chaine.getString("VZGETALL2");
        this.GETALL1 = Aladin.chaine.getString("VZGETALL3");
        this.ALLCAT = Aladin.chaine.getString("VZALLCAT");
    }

    protected ServerVizieRMission(Aladin aladin, Vector vector) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.type = 2;
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 0;
        int n2 = 100;
        int n3 = 50;
        this.pngMap = new PngMap();
        this.pngMap.setBackground(Aladin.BLUE);
        this.pngMap.setBounds(XWIDTH - n2 - 5, 15, n2, n3);
        this.add(this.pngMap);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Aladin.BLUE);
        Dimension dimension = this.makeTitle(jPanel, this.aladinLabel);
        jPanel.setBounds(XWIDTH / 2 - dimension.width / 2, n, dimension.width, dimension.height);
        n += dimension.height + 10;
        this.add(jPanel);
        StringTokenizer stringTokenizer = new StringTokenizer(this.default_methode, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            JLabel jLabel = new JLabel(stringTokenizer.nextToken());
            jLabel.setBounds(86, n, 400, 20);
            n += 15;
            this.add(jLabel);
        }
        int n4 = (n += 5) + 15;
        int n5 = XWIDTH - 90 - 15;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(Aladin.BLUE);
        int n6 = this.makeTargetPanel(jPanel2, 8);
        jPanel2.setBounds(0, n, n5 - 5, n6);
        this.add(jPanel2);
        this.modeCoo = 5;
        this.modeRad = 1;
        n += n6;
        this.cbGetAll = new JCheckBox(this.GETALL, false);
        this.cbGetAll.setEnabled(false);
        if (!Aladin.OUTREACH) {
            this.cbGetAll.setBackground(Aladin.BLUE);
            this.cbGetAll.setBounds(n5, n4, 120, 20);
            n4 += 20;
            this.add(this.cbGetAll);
        }
        this.cbGetAllCat = new JCheckBox(this.GETALL1, false);
        this.cbGetAllCat.setEnabled(false);
        this.cbGetAllCat.setBackground(Aladin.BLUE);
        this.cbGetAllCat.setBounds(n5, n4, 120, 20);
        this.cbGetAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !ServerVizieRMission.this.cbGetAllCat.isSelected();
                ServerVizieRMission.this.target.setEnabled(bl);
                ServerVizieRMission.this.radius.setEnabled(bl);
            }
        });
        if (!Aladin.OUTREACH && !(this instanceof ServerVizieRSurvey)) {
            this.add(this.cbGetAllCat);
            n4 += 20;
        }
        JLabel jLabel = new JLabel(this.addDot(this.nomTextfield));
        jLabel.setBackground(Aladin.BLUE);
        jLabel.setFont(Aladin.BOLD);
        int n7 = 85;
        jLabel.setBounds(10, n, n7, HAUT);
        this.add(jLabel);
        this.mission = new JTextField(28);
        this.mission.setBounds(n7 + 15, n, 120, HAUT);
        this.mission.addKeyListener(this);
        this.mission.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ServerVizieRMission.this.updateWidgets();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ServerVizieRMission.this.updateWidgets();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ServerVizieRMission.this.updateWidgets();
            }
        });
        this.add(this.mission);
        JLabel jLabel2 = new JLabel(this.addDot(this.RAD));
        jLabel2.setBackground(Aladin.BLUE);
        jLabel2.setFont(Aladin.BOLD);
        jLabel2.setBounds(231, n, n7, HAUT);
        this.add(jLabel2);
        this.radius = new JTextField("10 arcmin");
        this.radius.addKeyListener(this);
        this.radius.addActionListener(this);
        this.radius.setBounds(279, n, Aladin.OUTREACH ? 60 : 105, HAUT);
        n += HAUT + MARGE - 2;
        this.add(this.radius);
        this.modeRad = 1;
        Insets insets = new Insets(0, 10, 0, 10);
        this.getReadMe = new JButton(this.CATDESC);
        this.getReadMe.setMargin(insets);
        this.getReadMe.setEnabled(false);
        this.getReadMe.addActionListener(this);
        this.getReadMe.setFont(Aladin.BOLD);
        this.getMoc = new JButton(this.CATMOC);
        this.getMoc.setMargin(insets);
        this.getMoc.setEnabled(false);
        this.getMoc.addActionListener(this);
        this.getMoc.setFont(Aladin.BOLD);
        this.getDMap = new JButton(this.CATDMAP);
        this.getDMap.setMargin(insets);
        this.getDMap.setEnabled(false);
        this.getDMap.addActionListener(this);
        this.getDMap.setFont(Aladin.BOLD);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.setBounds(n7 + 15, n, 350, HAUT);
        jPanel3.setBackground(Aladin.BLUE);
        jPanel3.add(this.getReadMe);
        jPanel3.add(this.getMoc);
        if (Aladin.BETA) {
            jPanel3.add(this.getDMap);
        }
        if (!Aladin.OUTREACH) {
            this.add(jPanel3);
        }
        JLabel jLabel3 = new JLabel(this.help_list);
        jLabel3.setBounds(56, n += HAUT + MARGE + 5, 400, 20);
        n += 20;
        this.add(jLabel3);
        this.missionlist = new VizieRTable(this.mission, null, null, vector, 12, 0);
        this.missionlist.setFont(Aladin.PLAIN);
        JScrollPane jScrollPane = new JScrollPane(this.missionlist);
        jScrollPane.setBounds(10, n, XWIDTH - 20, 180);
        n += 190;
        this.add(jScrollPane);
        this.setMaxComp(jScrollPane);
    }

    @Override
    protected boolean setParam(String string) {
        Vector vector = this.missionlist.getList();
        Enumeration enumeration = vector.elements();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            stringTokenizer = new StringTokenizer(string3, "\t");
            String string4 = stringTokenizer.nextToken();
            if (!string4.equals(string2)) continue;
            this.mission.setText(string2);
            this.missionlist.selectCatalog(string2);
            return true;
        }
        return false;
    }

    @Override
    protected String[] getNomPaths() {
        String string = super.getNomPaths()[0];
        Vector vector = this.missionlist.getList();
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), "\t");
            stringArray[n] = string + "/" + Util.slash(stringTokenizer.nextToken() + " - " + stringTokenizer.nextToken());
            ++n;
        }
        return stringArray;
    }

    @Override
    protected int createPlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = string3 = ServerVizieRMission.specialUnQuoteCriteria(string3);
        if (string4 == null) {
            string4 = string6;
        }
        return this.creatArchivePlane(string, string2, string6, string4, string5, this.cbGetAll.isSelected());
    }

    protected int creatArchivePlane(String string, String string2, String string3, String string4, String string5, boolean bl) {
        URL uRL;
        string2 = ServerVizieRMission.getRM(string2) + "";
        String string6 = Glu.quote(string3) + " " + Glu.quote(string) + " " + Glu.quote(string2);
        if (bl) {
            string6 = string6 + " -out.all";
        }
        if ((uRL = this.aladin.glu.getURL(this.TAGGLU, string6)) == null) {
            Aladin.warning(this, this.WERROR);
            return -1;
        }
        if (!this.verif(8, string, string4 + " " + string2)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(uRL, string4, string, string4 + " " + string2, string5, this);
    }

    protected int createMocPlane(String string) {
        MyInputStream myInputStream;
        URL uRL = this.aladin.glu.getURL(MOCGLU, Glu.quote(string));
        Aladin.trace(4, "ServerVizierMission.createMocPlane(" + string + ") URL= " + uRL);
        try {
            myInputStream = Util.openStream(uRL);
        }
        catch (Exception exception) {
            if (Aladin.levelTrace >= 3) {
                exception.printStackTrace();
            }
            Aladin.warning(this, MOCERROR, 1);
            return -1;
        }
        return this.aladin.calque.newPlanMOC(myInputStream, string + " MOC");
    }

    @Override
    public void submit() {
        String string = "";
        double d = 0.0;
        boolean bl = this.cbGetAllCat.isSelected();
        String string2 = this.mission.getText().trim();
        if (!bl && (string = this.getTarget()) == null) {
            return;
        }
        if (string2.equals("")) {
            Aladin.warning(this, this.WNEEDCAT);
            return;
        }
        if (bl || string == null || string.length() == 0) {
            if (string2.length() == 0) {
                Aladin.warning(this, this.WNEEDCAT);
                return;
            }
            if (!Aladin.confirmation(this, this.ALLCAT + " \"" + string2 + "\" ?")) {
                return;
            }
            string = "";
            d = 0.0;
        } else if (!bl) {
            String string3 = this.getRadius();
            if (string3 == null) {
                return;
            }
            d = ServerVizieRMission.getRM(string3);
        }
        if (bl) {
            string = "";
        }
        this.waitCursor();
        this.resetList();
        String string4 = "";
        if (this.cbGetAll.isSelected()) {
            string4 = ",allcolumns";
        }
        if (!this.cbGetAllCat.isSelected() && string != null && string.length() > 0) {
            this.aladin.console.printCommand("get VizieR(" + string2 + string4 + ") " + string + " " + Coord.getUnit(d / 60.0));
        } else {
            this.aladin.console.printCommand("get VizieR(" + string2 + string4 + ")");
        }
        int n = this.createPlane(string, d + "", string2, null, this.institute);
        if (n != -1) {
            this.aladin.calque.getPlan(n).setBookmarkCode("get VizieR(" + string2 + string4 + ") $TARGET $RADIUS");
        }
        this.resetFlagBoxes();
        this.defaultCursor();
    }

    protected void resetList() {
        this.missionlist.resetList();
        this.pngMap.setImage(null);
    }

    @Override
    protected void clear() {
        super.clear();
        this.mission.setText("");
        this.resetList();
    }

    @Override
    protected void reset() {
        super.reset();
        this.mission.setText("");
        this.resetList();
        this.resetFlagBoxes();
    }

    protected void resetFlagBoxes() {
        this.cbGetAll.setSelected(false);
        this.cbGetAllCat.setSelected(false);
        this.target.setEnabled(true);
        this.radius.setEnabled(true);
    }

    @Override
    protected boolean updateWidgets() {
        if (!super.updateWidgets()) {
            return false;
        }
        if (this.mission == null) {
            return false;
        }
        String string = this.mission.getText().trim();
        if (this.oCat != null && this.oCat.equals(string)) {
            return true;
        }
        this.oCat = string;
        boolean bl = string.length() != 0;
        this.getReadMe.setEnabled(bl);
        this.getMoc.setEnabled(bl);
        this.getDMap.setEnabled(bl);
        this.cbGetAll.setEnabled(bl);
        this.cbGetAllCat.setEnabled(bl);
        return true;
    }

    protected void reaffiche() {
        this.hide();
        this.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            try {
                String string = ((JButton)object).getActionCommand();
                if (string.equals(this.CATDESC) || string.equals(this.CATMOC) || string.equals(this.CATDMAP)) {
                    String string2 = this.mission.getText().trim();
                    if (string2.equals("")) {
                        Aladin.warning(this, this.WNEEDCAT);
                        return;
                    }
                    if (string.equals(this.CATDESC)) {
                        this.aladin.glu.showDocument("getReadMe", Glu.quote(string2));
                    } else if (string.equals(this.CATMOC)) {
                        URL uRL = this.aladin.glu.getURL(MOCGLU, Glu.quote(string2) + " 512");
                        this.aladin.execAsyncCommand("'" + string2 + " MOC'=get File(" + uRL + ")");
                    } else if (string.equals(this.CATDMAP)) {
                        this.aladin.calque.newPlanDMap(string2);
                    }
                    this.defaultCursor();
                    return;
                }
            }
            catch (Exception exception) {
                Aladin.warning("Error: cannot load this product\n" + exception.getMessage());
            }
        }
    }

    class PngMap
    extends JComponent {
        Image image = null;

        PngMap() {
        }

        void setImage(Image image) {
            this.image = image;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, this);
            }
        }
    }
}

