/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import javax.swing.JComponent;

public class Slider
extends JComponent {
    private double begin;
    private int nbSteps;
    private double stepSize = 1.0;
    private int curPos = 0;
    final int mX = 10;
    final int margeDroite = 20;
    final int mY = 0;
    final int Hp = 0;
    int W;
    final int H = 34;
    boolean selected = false;
    boolean flagDrag = false;
    MyListener listener;

    public Slider(double d, int n) {
        this.begin = d;
        this.nbSteps = n;
        this.W = n + 10 + 20;
    }

    public Slider(double d, int n, double d2) {
        this(d, n);
        this.stepSize = d2;
    }

    public Slider() {
        this.W = this.nbSteps + 10 + 20;
    }

    public void setParams(double d, int n, double d2) {
        this.begin = d;
        this.nbSteps = n;
        this.stepSize = d2;
        this.W = n + 10 + 20;
    }

    public void setListener(MyListener myListener) {
        this.listener = myListener;
    }

    public void setPosition(int n, boolean bl) {
        this.curPos = n;
        if (this.listener != null && bl) {
            this.listener.fireStateChange(this.curPos + 1 + "");
        }
    }

    public void setPosition(int n) {
        this.setPosition(n, true);
    }

    public int getPosition() {
        return this.curPos;
    }

    public double getValue() {
        return this.begin + (double)this.curPos * this.stepSize;
    }

    protected void drawTriangle(Graphics graphics, int n) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = nArray[3] = n + 10;
        nArray[1] = nArray[0] - 7;
        nArray[2] = nArray[0] + 7;
        nArray2[3] = 14;
        nArray2[0] = 14;
        nArray2[1] = nArray2[2] = nArray2[0] + 10;
        graphics.setColor(Color.blue);
        graphics.fillPolygon(nArray, nArray2, nArray.length);
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, nArray.length);
        graphics.setFont(Aladin.SPLAIN);
        double d = Slider.round(this.getValue(), 2);
        String string = Double.toString(d);
        int n2 = graphics.getFontMetrics().stringWidth(string);
        int n3 = 10 + n - n2 / 2;
        if (n3 + n2 > this.W) {
            n3 -= n3 + n2 - this.W;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        graphics.drawString(string, n3, 34);
        double d2 = Slider.round(this.begin, 2);
        double d3 = Slider.round(this.begin + (double)this.nbSteps * this.stepSize, 2);
        graphics.drawString(Double.toString(d2), 0, 10);
        String string2 = Double.toString(d3);
        n2 = graphics.getFontMetrics().stringWidth(string2);
        n3 = this.nbSteps + 10 + -n2 / 2;
        if (n3 + n2 > this.W) {
            n3 -= n3 + n2 - this.W;
        }
        graphics.drawString(string2, n3, 10);
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(this.W, 34);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    @Override
    public boolean mouseMove(Event event, int n, int n2) {
        int n3 = this.getPosition();
        this.requestFocus();
        this.selected = (n -= 10) > n3 - 5 && n < n3 + 5;
        return true;
    }

    @Override
    public boolean mouseDown(Event event, int n, int n2) {
        int n3 = this.getPosition();
        this.selected = (n -= 10) > n3 - 5 && n < n3 + 5;
        return true;
    }

    @Override
    public boolean mouseDrag(Event event, int n, int n2) {
        if (!this.selected) {
            return true;
        }
        if ((n -= 10) < 0) {
            n = 0;
        } else if (n > this.nbSteps) {
            n = this.nbSteps;
        }
        this.setPosition(n);
        this.flagDrag = true;
        this.repaint();
        return true;
    }

    @Override
    public boolean mouseUp(Event event, int n, int n2) {
        if (!this.selected) {
            return true;
        }
        if ((n -= 10) < 0) {
            n = 0;
        } else if (n > this.nbSteps) {
            n = this.nbSteps;
        }
        this.setPosition(n);
        this.flagDrag = false;
        this.repaint();
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(10, 13, 10 + this.nbSteps, 13);
        graphics.drawLine(10, 16, 10, 10);
        graphics.drawLine(10 + this.nbSteps, 16, 10 + this.nbSteps, 10);
        this.drawTriangle(graphics, this.getPosition());
    }

    @Override
    public boolean keyDown(Event event, int n) {
        int n2 = this.getPosition();
        if (n == 1007) {
            if (n2 < this.nbSteps) {
                this.setPosition(n2 + 1);
            }
        } else if (n == 1006 && n2 > 0) {
            this.setPosition(n2 - 1);
        }
        this.repaint();
        return true;
    }

    public static double round(double d, int n) {
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            return d;
        }
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }
}

