/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.SliderPlusMoins;
import java.awt.Graphics;

public class SliderCube
extends SliderPlusMoins {
    public SliderCube(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDERCUBE"), 0, 10, 1);
        this.setTooltip(aladin.getChaine().getString("SLIDERCUBETIP"));
    }

    @Override
    void submit(int n) {
        Plan plan = this.getPlanCube();
        if (plan == null) {
            return;
        }
        double d = this.getValue() + (double)n;
        plan.changeImgID();
        int[] nArray = this.aladin.view.getNumView(plan);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.aladin.view.setCubeFrame(this.aladin.view.viewSimple[nArray[i]], d, true);
            }
        } else {
            plan.setCubeFrame(d);
        }
        this.aladin.view.repaintAll();
    }

    Plan getPlanCube() {
        Plan[] planArray;
        for (Plan plan : planArray = this.aladin.calque.getPlans()) {
            if (!plan.selected || !plan.isCube()) continue;
            return plan;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Plan plan = this.getPlanCube();
        if (plan != null) {
            this.setEnabled(true);
            this.slider.setMinMax(0, plan.getDepth() - 1);
            this.slider.setValue(plan.getZ());
        } else {
            this.slider.setValue(this.slider.min);
            this.setEnabled(false);
        }
        super.paintComponent(graphics);
    }
}

