/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanMoc;
import cds.aladin.SliderPlusMoins;
import java.awt.Graphics;

public class SliderDensity
extends SliderPlusMoins {
    public SliderDensity(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDERDENSITY"), -3, 3, 1);
        this.setTooltip(aladin.getChaine().getString("SLIDERDENSITYTIP"));
    }

    @Override
    void submit(int n) {
        Plan[] planArray = this.getPlanCatalog();
        if (planArray == null) {
            return;
        }
        for (Plan plan : planArray) {
            try {
                if (plan instanceof PlanBGCat) {
                    ((PlanBGCat)plan).setGapOrder((int)this.slider.getValue() + n);
                    continue;
                }
                ((PlanMoc)plan).setGapOrder((int)this.slider.getValue() + n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.aladin.calque.repaintAll();
    }

    Plan[] getPlanCatalog() {
        Plan[] planArray = this.aladin.calque.getPlans();
        int n = 0;
        for (Plan plan : planArray) {
            if (!this.isOk(plan)) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        Plan[] planArray2 = new Plan[n];
        n = 0;
        for (Plan plan : planArray) {
            if (!this.isOk(plan)) continue;
            planArray2[n++] = plan;
        }
        return planArray2;
    }

    private boolean isOk(Plan plan) {
        return plan.selected && (plan.type == 18 || plan.type == 19);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Plan[] planArray = this.getPlanCatalog();
        if (planArray != null) {
            this.setEnabled(true);
            this.slider.setValue(((PlanBGCat)planArray[0]).getGapOrder());
        } else {
            this.slider.setValue(this.slider.min);
            this.setEnabled(false);
        }
        super.paintComponent(graphics);
    }
}

