/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.SliderPlusMoins;
import cds.astro.Astrotime;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class SliderEpoch
extends SliderPlusMoins {
    String defaultLabel;

    public SliderEpoch(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDEREPOCH"), 1500, 2500, 1, 100);
        this.setTooltip(aladin.getChaine().getString("SLIDEREPOCHTIP"));
        this.defaultLabel = this.label.getText();
        this.label.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SliderEpoch.this.setDefaultEpoch();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
        this.label.setToolTipText(aladin.getChaine().getString("SLIDEREPOCHLABELTIP"));
    }

    protected void setDefaultEpoch() {
        double d = 2000.0;
        try {
            String string;
            Plan plan = this.aladin.calque.getPlanBase();
            if (plan instanceof PlanImage && (string = ((PlanImage)plan).getDateObs()) != null) {
                Astrotime astrotime = new Astrotime();
                astrotime.set(string);
                d = astrotime.getJyr();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.slider.setValue(d);
        this.submit(0);
    }

    @Override
    void submit(int n) {
        Plan[] planArray = this.getPlanCatalog();
        if (planArray == null) {
            return;
        }
        for (Plan plan : planArray) {
            try {
                plan.setEpoch(this.slider.getValue() + (double)n + "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.aladin.view.coteDist != null) {
            this.aladin.view.getCurrentView().createCoteDist();
        }
        this.aladin.calque.repaintAll();
    }

    Plan[] getPlanCatalog() {
        Plan[] planArray = this.aladin.calque.getPlans();
        int n = 0;
        for (Plan plan : planArray) {
            if (!plan.selected || !plan.hasPM()) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        Plan[] planArray2 = new Plan[n];
        n = 0;
        for (Plan plan : planArray) {
            if (!plan.selected || !plan.hasPM()) continue;
            planArray2[n++] = plan;
        }
        return planArray2;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Plan[] planArray = this.getPlanCatalog();
        if (planArray != null) {
            this.setEnabled(true);
            int n = (int)(planArray[0].getEpoch().getJyr() + 0.5);
            this.label.setText("J" + n);
            this.slider.setValue(n);
        } else {
            this.slider.setValue(this.slider.min);
            this.label.setText(this.defaultLabel);
            this.setEnabled(false);
        }
        super.paintComponent(graphics);
    }
}

