/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class SliderPlusMoins
extends JPanel
implements MouseWheelListener,
MouseMotionListener,
MouseListener,
Widget {
    Aladin aladin;
    JLabel label;
    Slider slider;
    JButton plus;
    JButton moins;
    int wheelIncr;
    boolean enable = true;
    private WidgetControl voc = null;

    @Override
    public String toString() {
        return this.slider == null ? "null" : this.slider.toString();
    }

    public SliderPlusMoins(Aladin aladin, String string, int n, int n2, int n3) {
        this(aladin, string, n, n2, n3, n3);
    }

    public SliderPlusMoins(Aladin aladin, String string, int n, int n2, final int n3, int n4) {
        this.aladin = aladin;
        this.slider = new Slider(n, n2, n3);
        this.label = new Lab(string);
        this.label.setFont(Aladin.SBOLD);
        this.label.setBackground(this.slider.getBackground());
        Bouton bouton = new Bouton("-");
        this.moins = bouton;
        bouton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SliderPlusMoins.this.submit(-n3);
            }
        });
        bouton = new Bouton("+");
        this.plus = bouton;
        bouton.setFont(bouton.getFont().deriveFont((float)bouton.getFont().getSize() - 1.0f));
        bouton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SliderPlusMoins.this.submit(n3);
            }
        });
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        jPanel.add((Component)this.moins, "West");
        jPanel.add((Component)this.slider, "Center");
        jPanel.add((Component)this.plus, "East");
        this.add((Component)this.label, "West");
        this.add((Component)jPanel, "Center");
        this.setEnabled(false);
        this.addMouseWheelListener(this);
        this.wheelIncr = n4;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.enable) {
            return;
        }
        if (mouseWheelEvent.getClickCount() == 2) {
            return;
        }
        this.submit(-this.wheelIncr * mouseWheelEvent.getWheelRotation());
        this.slider.repaint();
    }

    public double getValue() {
        return this.slider.getValue();
    }

    public void setValue(int n) {
        this.slider.setValue(n);
    }

    abstract void submit(int var1);

    @Override
    public void setEnabled(boolean bl) {
        if (bl == this.enable) {
            return;
        }
        this.enable = bl;
        super.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.label.setForeground(bl ? Color.black : Aladin.MYGRAY);
        this.plus.setEnabled(bl);
        this.moins.setEnabled(bl);
    }

    void setTooltip(String string) {
        Util.toolTip(this.label, string);
        Util.toolTip(this.moins, string);
        Util.toolTip(this.plus, string);
        Util.toolTip(this.slider, string);
    }

    boolean setMinMax(int n, int n2) {
        return this.slider.setMinMax(n, n2);
    }

    private void shiftE(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(-(this.label.getWidth() + this.moins.getWidth()), 0);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.shiftE(mouseEvent);
        this.slider.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.shiftE(mouseEvent);
        this.slider.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.shiftE(mouseEvent);
        this.slider.mouseClicked(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.shiftE(mouseEvent);
        this.slider.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.shiftE(mouseEvent);
        this.slider.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.shiftE(mouseEvent);
        this.slider.mouseEntered(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.shiftE(mouseEvent);
        this.slider.mouseExited(mouseEvent);
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int n, int n2, int n3, int n4, float f, JComponent jComponent) {
        this.voc = new WidgetControl(this, n, n2, n3, n4, f, jComponent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics graphics) {
    }

    class Lab
    extends JLabel {
        private int width;

        public Lab(String string) {
            super(string == null ? "" : string);
            this.width = 40;
            if (string == null) {
                this.width = 0;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, 14);
        }
    }

    class Bouton
    extends JButton
    implements MouseListener {
        static final int SIZE = 10;
        boolean in = false;

        Bouton(String string) {
            super.setText(string);
            this.setFont(Aladin.LBOLD);
            this.addMouseListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(10, 10);
        }

        @Override
        public Dimension getSize() {
            return new Dimension(10, 10);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Color color;
            super.paintComponent(graphics);
            int n = this.getHeight();
            int n2 = this.getWidth();
            graphics.setColor(SliderPlusMoins.this.slider.getBackground());
            graphics.fillRect(0, 0, n2, n);
            if (!SliderPlusMoins.this.enable) {
                color = Aladin.MYGRAY;
            } else if (this.in) {
                Aladin cfr_ignored_0 = SliderPlusMoins.this.aladin;
                color = Aladin.GREEN;
            } else {
                color = Color.black;
            }
            graphics.setColor(color);
            String string = this.getText();
            graphics.drawString(string, n2 / 2 - graphics.getFontMetrics().stringWidth(string) / 2, n / 2 + 5);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SliderPlusMoins.this.enable) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.in = true;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.in = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        }
    }

    class Slider
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        int min;
        int max;
        int incr;
        double value;
        private Rectangle r;
        private boolean in = false;
        private int memoX;
        private int memoWhere;

        Slider(int n, int n2, int n3) {
            this.min = n;
            this.value = this.min;
            this.max = n2;
            this.incr = n3;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public String toString() {
            return "slider[" + this.min + " .. " + this.max + "] => " + this.value;
        }

        double getValue() {
            return this.value;
        }

        void setValue(double d) {
            this.value = d;
            this.repaint();
        }

        boolean setMinMax(int n, int n2) {
            if (this.min == n && this.max == n2) {
                return false;
            }
            this.min = n;
            this.max = n2;
            if (this.value < (double)n) {
                this.value = n;
            } else if (this.value > (double)n2) {
                this.value = n2;
            }
            return true;
        }

        private int getPos() {
            return (int)((double)this.getWidth() * ((this.value - (double)this.min) / (double)(this.max - this.min)));
        }

        private void setPos(int n) {
            this.value = (int)((double)n / (double)this.getWidth() * (double)(this.max - this.min) + (double)this.min);
            if (this.value > (double)this.max) {
                this.value = this.max;
            } else if (this.value < (double)this.min) {
                this.value = this.min;
            }
        }

        private int where(int n) {
            return n < this.r.x ? -1 : (this.r.x <= n && n <= this.r.x + this.r.width ? 0 : 1);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.memoX = mouseEvent.getX();
            this.memoWhere = this.where(this.memoX);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n;
            if (!this.isEnabled()) {
                return;
            }
            this.memoX = n = mouseEvent.getX();
            this.setPos(n);
            if (this.value > (double)this.max) {
                this.value = this.max;
            } else if (this.value < (double)this.min) {
                this.value = this.min;
            }
            SliderPlusMoins.this.submit(0);
            this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.in = false;
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.in = true;
            this.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl;
            if (!SliderPlusMoins.this.enable) {
                return;
            }
            boolean bl2 = bl = this.where(mouseEvent.getX()) == 0;
            if (bl == this.in) {
                return;
            }
            this.in = bl;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = this.getHeight();
            int n2 = this.getWidth();
            graphics.setClip(null);
            graphics.setColor(SliderPlusMoins.this.slider.getBackground());
            graphics.fillRect(0, 0, n2, n);
            Util.drawCartouche(graphics, 0, n / 2 - 2, n2, 5, 1.0f, SliderPlusMoins.this.enable ? Color.gray : Aladin.MYGRAY, Color.white);
            int n3 = this.getPos();
            if (n3 - 7 < 0) {
                n3 = 7;
            }
            if (n3 + 5 > n2) {
                n3 = n2 - 5;
            }
            this.r = new Rectangle(n3 - 7, n / 2 - 6, 14, 13);
            graphics.setColor(SliderPlusMoins.this.enable ? Color.lightGray : Aladin.MYGRAY);
            graphics.fillRect(this.r.x, this.r.y, this.r.width, this.r.height);
            if (SliderPlusMoins.this.enable) {
                Util.drawEdge(graphics, this.r.x, this.r.y, this.r.width, this.r.height);
            }
            n3 -= 4;
            for (int i = 0; i < 3; ++i) {
                graphics.setColor(!SliderPlusMoins.this.enable ? Color.lightGray : (this.in ? Aladin.GREEN : Color.black));
                graphics.drawLine(n3 + i * 3, n / 2 - 4, n3 + i * 3, n / 2 + 3);
                graphics.setColor(Color.white);
                graphics.drawLine(n3 + i * 3 + 1, n / 2 - 4, n3 + i * 3 + 1, n / 2 + 3);
            }
        }
    }
}

