/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.SliderPlusMoins;
import java.awt.Graphics;

public class SliderSize
extends SliderPlusMoins {
    public SliderSize(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDERSIZE"), 0, 300, 10);
        this.setTooltip(aladin.getChaine().getString("SLIDERSIZETIP"));
    }

    @Override
    void submit(int n) {
        Plan plan = this.getPlans();
        if (plan == null) {
            return;
        }
        float f = (float)((this.slider.getValue() + (double)n) / 100.0);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 4.0f) {
            f = 3.0f;
        }
        if (n != 0) {
            this.slider.setValue((int)(f * 100.0f));
        }
        this.aladin.calque.setScalingFactor(f);
        this.aladin.calque.repaintAll();
    }

    Plan getPlans() {
        Plan plan = this.aladin.calque.getFirstSelectedPlan();
        if (plan == null || !plan.isCatalog() && plan.type != 9) {
            return null;
        }
        return plan;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Plan plan = this.getPlans();
        if (plan != null) {
            this.setEnabled(true);
            this.slider.setValue((int)(plan.getScalingFactor() * 100.0f));
        } else {
            this.slider.setValue(this.slider.min);
            this.setEnabled(false);
        }
        super.paintComponent(graphics);
    }
}

