/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Legende;
import cds.aladin.MetaDataTree;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PlanFilter;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.SourceFootprint;
import cds.aladin.View;
import cds.aladin.ViewSimple;
import cds.image.EPSGraphics;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Source
extends Position
implements Comparator {
    static final int MDS = 2;
    static final int[] LIMIT = new int[]{3, 10, 100, 250, 500, 1000, 2000, 5000, 13000, 100000};
    static final String[] TYPENAME = new String[]{"oval", "square", "circle", "rhomb", "cross", "triangle", "plus", "small circle", "dot", "microdot", "solid oval", "solid square", "solid circle", "solid rhomb", "solid triangle"};
    protected byte sourceType = 1;
    protected String info;
    protected Legende leg;
    private String oid = null;
    protected double[][][] values;
    protected boolean[] isSelected;
    protected Action[][] actions;
    private SourceFootprint sourceFootprint;
    static int NOID = 0;
    private static Rectangle box = new Rectangle();
    private static Source sortSource;
    private static int sortNField;
    private static boolean sortNumeric;
    private static int sortSens;

    protected int getL() {
        if (this.plan == null || this.plan.getScalingFactor() == 1.0f) {
            return 3;
        }
        return (int)((double)(2.0f * this.plan.getScalingFactor()) / 3.0 * 3.0);
    }

    protected Source() {
    }

    protected Source(Plan plan, ViewSimple viewSimple, double d, double d2, double d3, double d4, int n, String string) {
        super(plan, viewSimple, d, d2, d3, d4, n, string);
    }

    protected Source(Plan plan) {
        super(plan);
    }

    protected Source(Plan plan, double d, double d2, String string, String string2) {
        super(plan, null, 0.0, 0.0, d, d2, 2, string);
        this.info = string2;
        this.sourceType = (byte)plan.sourceType;
        this.fixInfo();
    }

    protected Source(Plan plan, double d, double d2, String string, String string2, Legende legende) {
        super(plan, null, 0.0, 0.0, d, d2, 2, string);
        this.info = string2;
        this.leg = legende;
        this.sourceType = (byte)plan.sourceType;
        this.fixInfo();
    }

    protected Source(Plan plan, double d, double d2, double d3, double d4, int n, String string, String string2, Legende legende) {
        super(plan, null, d, d2, d3, d4, n, string);
        this.info = string2;
        this.leg = legende;
        this.sourceType = (byte)plan.sourceType;
        this.fixInfo();
    }

    void increaseSourceSize(int n) {
        this.sourceType = (byte)(this.sourceType + n);
        if (this.sourceType >= TYPENAME.length) {
            this.sourceType = (byte)(TYPENAME.length - 1);
        } else if (this.sourceType < 0) {
            this.sourceType = 0;
        }
    }

    @Override
    public boolean hasProp() {
        return false;
    }

    @Override
    protected void projection(ViewSimple viewSimple) {
        if (viewSimple.isPlotView()) {
            double[] dArray = viewSimple.plot.getXY(this);
            this.xv[viewSimple.n] = dArray[0];
            this.yv[viewSimple.n] = dArray[1];
        } else {
            super.projection(viewSimple);
        }
    }

    protected final void setTag(boolean bl) {
        if (this.plan != null && bl) {
            this.plan.aladin.calque.taggedSrc = true;
        }
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    protected final boolean isTagged() {
        return (this.flags & 2) != 0;
    }

    protected final void setHighlight(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    protected final boolean isHighlighted() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean hasPhot() {
        return this.leg.hasGroup();
    }

    protected static final String getShape(int n) {
        return TYPENAME[n];
    }

    protected static final int getShapeIndex(String string) {
        for (int i = 0; i < TYPENAME.length; ++i) {
            if (!string.equalsIgnoreCase(TYPENAME[i])) continue;
            return i;
        }
        return -1;
    }

    protected void fixInfo() {
        if (this.leg == null || this.leg.field == null || this.info == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.info, "\t");
        int n = this.leg.field.length;
        for (int i = stringTokenizer.countTokens() - 1; i < n; ++i) {
            this.info = new String(this.info) + "\t ";
            if (Aladin.levelTrace < 3) continue;
            System.err.println("Source.fixInfo() =>  pour " + this.id);
        }
    }

    protected String getOID() {
        return this.oid;
    }

    protected void setOID(String string) {
        this.oid = string;
    }

    protected String setOID() {
        this.oid = "Aladin." + ++NOID;
        return this.oid;
    }

    protected static int getDefaultType(int n) {
        int n2;
        for (n2 = 0; n2 < LIMIT.length && n > LIMIT[n2]; ++n2) {
        }
        if (n2 >= LIMIT.length) {
            n2 = LIMIT.length - 1;
        }
        return n2;
    }

    @Override
    protected void setText(String string) {
        super.setText(string);
    }

    @Override
    public void setInfo(String string) {
        this.info = string;
        this.oid = "";
    }

    protected void setLegende(Legende legende) {
        this.leg = legende;
        this.oid = "";
    }

    @Override
    protected void info(Aladin aladin) {
        aladin.mesure.setInfo(this);
    }

    @Override
    protected void status(Aladin aladin) {
        View cfr_ignored_0 = aladin.view;
        aladin.status.setText(this.id + " " + View.HCLIC);
    }

    @Override
    protected void setPosition(ViewSimple viewSimple, double d, double d2) {
    }

    @Override
    protected void deltaPosition(ViewSimple viewSimple, double d, double d2) {
        if (this.plan == null || !this.plan.recalibrating) {
            return;
        }
        int n = viewSimple.n;
        this.xv[n] = this.xv[n] + d;
        int n2 = viewSimple.n;
        this.yv[n2] = this.yv[n2] + d2;
    }

    private Rectangle setBox() {
        return this.setBox(null);
    }

    private Rectangle setBox(Graphics graphics) {
        int n;
        int n2;
        if (graphics != null) {
            graphics.setFont(DF);
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        int n3 = n2 = (int)(fontMetrics.stringWidth(this.id) / 2);
        int n4 = n = (int)(HF / 2);
        int n5 = this.getL();
        if (n2 > n5) {
            n2 = n5 - 1;
            n3 += n3 - n2;
        }
        if (n > n5) {
            n = n5 - 1;
            n4 += n4 - n;
        }
        Source.box.x = n2;
        Source.box.y = n;
        Source.box.width = n3;
        Source.box.height = n4;
        return box;
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        int n = this.getL();
        double d3 = (double)n / viewSimple.getZoom();
        double d4 = this.xv[viewSimple.n];
        double d5 = this.yv[viewSimple.n];
        return d4 <= d + d3 && d4 >= d - d3 && d5 <= d2 + d3 && d5 >= d2 - d3;
    }

    @Override
    protected Rectangle extendClip(ViewSimple viewSimple, Rectangle rectangle) {
        if (!this.isVisible()) {
            return rectangle;
        }
        int n = this.getL();
        Point point = this.getViewCoord(viewSimple, n * 2, n * 2);
        if (point == null) {
            return rectangle;
        }
        if (this.sourceFootprint != null) {
            // empty if block
        }
        if (!this.isWithLabel()) {
            if (this.isSelected()) {
                return Source.unionRect(rectangle, point.x - n - 2, point.y - n - 2, n * 2 + 4, n * 2 + 4);
            }
            return Source.unionRect(rectangle, point.x - n, point.y - n, n * 2, n * 2);
        }
        this.setBox();
        if (this.isSelected()) {
            return Source.unionRect(rectangle, point.x - n - 2, point.y - n - Source.box.height - 2, Source.box.width + n * 2 + 4, Source.box.height + n * 2 + 4);
        }
        return Source.unionRect(rectangle, point.x - n, point.y - n - Source.box.height, Source.box.width + n * 2, Source.box.height + n * 2);
    }

    @Override
    protected boolean inClip(ViewSimple viewSimple, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        if (!this.isVisible()) {
            return false;
        }
        int n5 = this.getL();
        Point point = this.getViewCoord(viewSimple, n5 * 2, n5 * 2);
        if (point == null) {
            return false;
        }
        if (!this.isWithLabel()) {
            if (this.isSelected()) {
                n4 = point.x - n5 - 2;
                n3 = point.y - n5 - 2;
                n = n2 = n5 * 2 + 4;
            } else {
                n4 = point.x - n5;
                n3 = point.y - n5;
                n = n2 = n5 * 2;
            }
        } else {
            this.setBox();
            if (this.isSelected()) {
                n4 = point.x - n5 - 2;
                n3 = point.y - n5 - Source.box.height - 2;
                n = Source.box.width + n5 * 2 + 4;
                n2 = Source.box.height + n5 * 2 + 4;
            } else {
                n4 = point.x - n5;
                n3 = point.y - n5 - Source.box.height;
                n = Source.box.width + n5 * 2;
                n2 = Source.box.height + n5 * 2;
            }
        }
        return Obj.intersectRect(rectangle, n4, n3, n, n2);
    }

    void drawCarre(Graphics graphics, Point point) {
        this.drawCarre(graphics, point, false);
    }

    void drawCarre(Graphics graphics, Point point, boolean bl) {
        int n = this.getL();
        if (!this.isWithLabel()) {
            graphics.drawRect(point.x - n, point.y - n, n * 2, n * 2);
            if (bl) {
                graphics.fillRect(point.x - n, point.y - n, n * 2, n * 2);
            }
        } else {
            this.setBox(graphics);
            graphics.drawLine(point.x + n, point.y - n + Source.box.y + 2, point.x + n, point.y + n);
            graphics.drawLine(point.x - n, point.y + n, point.x + n, point.y + n);
            graphics.drawLine(point.x - n, point.y + n, point.x - n, point.y - n);
            graphics.drawLine(point.x - n, point.y - n, point.x + n - Source.box.x - 2, point.y - n);
            if (bl) {
                graphics.fillRect(point.x - n, point.y - n, n * 2, n * 2);
            }
            graphics.drawString(this.id, point.x + n - Source.box.x, point.y - n + Source.box.y);
        }
    }

    void drawCircleS(Graphics graphics, Point point) {
        int n = this.getL();
        if (graphics instanceof EPSGraphics || n != 3) {
            int n2 = (int)((double)n + (double)n / 3.0);
            graphics.drawOval(point.x - n2 / 2, point.y - n2 / 2, n2, n2);
        } else {
            Util.drawCircle5(graphics, point.x, point.y);
        }
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + n - Source.box.x, point.y - n + Source.box.y);
        }
    }

    void drawOval(Graphics graphics, Point point) {
        this.drawOval(graphics, point, false);
    }

    void drawOval(Graphics graphics, Point point, boolean bl) {
        int n = this.getL();
        int n2 = (int)(((double)n + (double)n / 3.0) * 2.0);
        graphics.drawOval(point.x - n2 / 2, point.y - n2 / 3, n2, 2 * n2 / 3);
        if (bl) {
            graphics.fillOval(point.x - n2 / 2, point.y - n2 / 3, n2, 2 * n2 / 3);
        }
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + n - Source.box.x, point.y - n + Source.box.y);
        }
    }

    void drawCircle(Graphics graphics, Point point) {
        this.drawCircle(graphics, point, false);
    }

    void drawCircle(Graphics graphics, Point point, boolean bl) {
        int n = this.getL();
        if (graphics instanceof EPSGraphics || n != 3) {
            int n2 = n * 2;
            graphics.drawOval(point.x - n2 / 2, point.y - n2 / 2, n2, n2);
            if (bl) {
                graphics.fillOval(point.x - n2 / 2, point.y - n2 / 2, n2, n2);
            }
        } else if (bl) {
            Util.fillCircle7(graphics, point.x, point.y);
        } else {
            Util.drawCircle7(graphics, point.x, point.y);
        }
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + n - Source.box.x, point.y - n + Source.box.y);
        }
    }

    void drawLosange(Graphics graphics, Point point) {
        this.drawLosange(graphics, point, false);
    }

    void drawLosange(Graphics graphics, Point point, boolean bl) {
        int n = this.getL();
        Polygon polygon = new Polygon(new int[]{point.x, point.x + n, point.x, point.x - n}, new int[]{point.y - n, point.y, point.y + n, point.y}, 4);
        graphics.drawPolygon(polygon);
        if (bl) {
            graphics.fillPolygon(polygon);
        }
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + n - Source.box.x, point.y - n + Source.box.y);
        }
    }

    void drawTriangle(Graphics graphics, Point point) {
        this.drawTriangle(graphics, point, false);
    }

    void drawTriangle(Graphics graphics, Point point, boolean bl) {
        int n = this.getL();
        Polygon polygon = new Polygon(new int[]{point.x - n, point.x + n, point.x}, new int[]{point.y + n / 3, point.y + n / 3, point.y + n, point.y - 2 * n / 3}, 3);
        graphics.drawPolygon(polygon);
        if (bl) {
            graphics.fillPolygon(polygon);
        }
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + n - Source.box.x, point.y - n + Source.box.y);
        }
    }

    void drawPlus(Graphics graphics, Point point) {
        int n = this.getL();
        graphics.drawLine(point.x - n, point.y, point.x + n, point.y);
        graphics.drawLine(point.x, point.y - n, point.x, point.y + n);
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + n - Source.box.x / 2, point.y - n + Source.box.y / 2);
        }
    }

    void drawReticule(Graphics graphics, Point point) {
        int n = this.getL();
        int n2 = 4;
        graphics.drawLine(point.x - n, point.y, point.x - n2, point.y);
        graphics.drawLine(point.x + n2, point.y, point.x + n, point.y);
        graphics.drawLine(point.x, point.y - n, point.x, point.y - n2);
        graphics.drawLine(point.x, point.y + n2, point.x, point.y + n);
        graphics.drawLine(point.x, point.y, point.x, point.y);
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + n - Source.box.x / 2, point.y - n + Source.box.y / 2);
        }
    }

    void drawCroix(Graphics graphics, Point point) {
        int n = this.getL();
        graphics.drawLine(point.x - n, point.y - n, point.x + n, point.y + n);
        graphics.drawLine(point.x - n, point.y + n, point.x + n, point.y - n);
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + n, point.y + Source.box.y / 2);
        }
    }

    void drawPoint(Graphics graphics, Point point) {
        if (this.plan != null && this.plan.getScalingFactor() > 2.0f) {
            this.drawCircleS(graphics, point);
            return;
        }
        graphics.drawLine(point.x - 1, point.y, point.x + 1, point.y);
        graphics.drawLine(point.x, point.y - 1, point.x, point.y + 1);
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + 2 - Source.box.x / 2, point.y - 2 + Source.box.y / 2);
        }
    }

    void drawDot(Graphics graphics, Point point) {
        if (this.plan != null && this.plan.getScalingFactor() > 1.0f) {
            this.drawPoint(graphics, point);
            return;
        }
        graphics.drawLine(point.x, point.y, point.x, point.y);
        if (this.isWithLabel()) {
            this.setBox(graphics);
            graphics.drawString(this.id, point.x + 2 - Source.box.x / 2, point.y - 2 + Source.box.y / 2);
        }
    }

    protected void print(Graphics graphics, int n, int n2) {
        Point point = new Point(n, n2);
        boolean bl = this.isWithLabel();
        this.setWithLabel(false);
        graphics.setColor(this.plan.c);
        switch (this.sourceType) {
            case 1: {
                this.drawCarre(graphics, point);
                break;
            }
            case 4: {
                this.drawCroix(graphics, point);
                break;
            }
            case 6: {
                this.drawPlus(graphics, point);
                break;
            }
            case 3: {
                this.drawLosange(graphics, point);
                break;
            }
            case 8: {
                this.drawPoint(graphics, point);
                break;
            }
            case 9: {
                this.drawDot(graphics, point);
            }
        }
        this.setWithLabel(bl);
    }

    protected boolean isSelectedInFilter() {
        for (int i = 0; i < PlanFilter.allFilters.length; ++i) {
            PlanFilter planFilter = PlanFilter.allFilters[i];
            if (!planFilter.isOn() || this.isSelected == null || !this.isSelected[planFilter.numero]) continue;
            return true;
        }
        return false;
    }

    protected boolean noFilterInfluence() {
        for (int i = 0; i < PlanFilter.allFilters.length; ++i) {
            PlanFilter planFilter = PlanFilter.allFilters[i];
            if (!planFilter.isOn() || planFilter.numero >= this.plan.influence.length || !this.plan.influence[planFilter.numero]) continue;
            return false;
        }
        return true;
    }

    private int nbFiltersOk() {
        int n = 0;
        for (int i = 0; i < PlanFilter.allFilters.length; ++i) {
            PlanFilter planFilter = PlanFilter.allFilters[i];
            if (!planFilter.isOn() || !planFilter.flagOk || !this.plan.influence[planFilter.numero]) continue;
            ++n;
        }
        return n;
    }

    protected void writeLinkFlex(OutputStream outputStream, ViewSimple viewSimple) throws Exception {
        int n = this.getL();
        PointD pointD = this.getViewCoordDouble(viewSimple, n, n);
        if (pointD == null) {
            return;
        }
        outputStream.write((this.plan.label + "\t" + (this.id != null ? this.id : "-") + "\t" + pointD.x + "\t" + pointD.y + "\t" + this.getFirstLink() + "\n").getBytes());
    }

    @Override
    protected void writeLink(OutputStream outputStream, ViewSimple viewSimple) throws Exception {
        int n = this.getL();
        Point point = this.getViewCoord(viewSimple, n, n);
        if (point == null) {
            return;
        }
        outputStream.write((this.plan.label + "\t" + (this.id != null ? this.id : "-") + "\t" + point.x + "\t" + point.y + "\t" + this.getFirstLink() + "\n").getBytes());
    }

    protected String getFirstLink() {
        if (this.leg == null) {
            return "-";
        }
        int n = this.leg.getFirstLink();
        if (n < 0) {
            return "-";
        }
        try {
            String string = this.getCodedValue(n);
            int n2 = string.indexOf(124);
            int n3 = string.indexOf(32);
            int n4 = string.lastIndexOf(62);
            String string2 = string.substring(2, n3 > 0 ? n3 : (n2 > 0 ? n2 : n4));
            String string3 = n3 > 0 ? string.substring(n3 + 1, n2 > 0 ? n2 : n4) : "";
            boolean bl = string2.equals("Http");
            URL uRL = this.plan.aladin.glu.getURL(string2, string3, bl, false);
            return uRL.toString();
        }
        catch (Exception exception) {
            return "-";
        }
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        int n3 = this.getL();
        Point point = this.getViewCoord(viewSimple, n3, n3);
        if (point == null) {
            return false;
        }
        point.x += n;
        point.y += n2;
        if (this.plan.aladin.view.flagHighlight && !this.isHighlighted()) {
            return false;
        }
        boolean bl = this.isSelectedInFilter();
        boolean bl2 = this.noFilterInfluence();
        if (this.isSelected() && (bl2 || bl)) {
            graphics.setColor(this.isTagged() ? Color.magenta : Color.green);
            graphics.drawRect(point.x - n3 - 1, point.y - n3 - 1, n3 * 2 + 2, n3 * 2 + 2);
        }
        int n4 = this.nbFiltersOk();
        if (!bl2 && bl) {
            this.drawAssociatedFootprint(graphics, viewSimple, n, n2);
            if (n4 == 0) {
                this.doDraw(graphics, point, this.plan.c);
            } else {
                boolean bl3 = this.drawWithFilter(graphics, viewSimple, point, n, n2);
                if (!bl3) {
                    return false;
                }
            }
        } else if (bl2) {
            this.doDraw(graphics, point, this.plan.c);
            this.drawAssociatedFootprint(graphics, viewSimple, n, n2);
        } else if (!bl && n4 == 0) {
            this.doDraw(graphics, point, this.plan.c);
            this.drawAssociatedFootprint(graphics, viewSimple, n, n2);
        }
        return true;
    }

    private boolean drawWithFilter(Graphics graphics, ViewSimple viewSimple, Point point, int n, int n2) {
        for (int i = 0; i < PlanFilter.allFilters.length; ++i) {
            PlanFilter planFilter = PlanFilter.allFilters[i];
            if (!planFilter.isOn() || !this.plan.influence[planFilter.numero] || !this.isSelected[planFilter.numero] || !planFilter.flagOk) continue;
            if (this.actions[planFilter.numero] == null) {
                return false;
            }
            for (int j = 0; j < this.actions[planFilter.numero].length; ++j) {
                this.actions[planFilter.numero][j].action(this, graphics, viewSimple, point, planFilter.numero, j, n, n2);
            }
        }
        return true;
    }

    private void drawAssociatedFootprint(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (this.sourceFootprint != null) {
            this.sourceFootprint.draw(viewSimple.getProj(), graphics, viewSimple, n, n2, this.plan.c);
        }
    }

    protected void doDraw(Graphics graphics, Point point, Color color) {
        if (color == null) {
            graphics.setColor(this.plan.c);
        } else {
            graphics.setColor(color);
        }
        switch (this.sourceType) {
            case 10: {
                this.drawOval(graphics, point, true);
                break;
            }
            case 0: {
                this.drawOval(graphics, point);
                break;
            }
            case 11: {
                this.drawCarre(graphics, point, true);
                break;
            }
            case 1: {
                this.drawCarre(graphics, point);
                break;
            }
            case 4: {
                this.drawCroix(graphics, point);
                break;
            }
            case 6: {
                this.drawPlus(graphics, point);
                break;
            }
            case 13: {
                this.drawLosange(graphics, point, true);
                break;
            }
            case 3: {
                this.drawLosange(graphics, point);
                break;
            }
            case 14: {
                this.drawTriangle(graphics, point, true);
                break;
            }
            case 5: {
                this.drawTriangle(graphics, point);
                break;
            }
            case 7: {
                this.drawCircleS(graphics, point);
                break;
            }
            case 12: {
                this.drawCircle(graphics, point, true);
                break;
            }
            case 2: {
                this.drawCircle(graphics, point);
                break;
            }
            case 8: {
                this.drawPoint(graphics, point);
                break;
            }
            case 9: {
                this.drawDot(graphics, point);
                break;
            }
            case 15: {
                this.drawReticule(graphics, point);
            }
        }
    }

    private boolean match(String string, String string2, boolean bl) {
        if (bl) {
            return Util.matchMask(string, string2);
        }
        return string2.equals(string);
    }

    protected int findUCD(String string) {
        String string2 = null;
        Field[] fieldArray = this.leg.field;
        boolean bl = Source.useWildcard(string);
        string = MetaDataTree.replace(string, "\\*", "*", -1);
        string = string.toUpperCase();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string3;
            string2 = fieldArray[i].ucd;
            if (string2 != null) {
                string2 = string2.toUpperCase();
            }
            if (string2 == null || bl && ((string3 = this.getValue(i)) == null || string3.trim().length() == 0) || !this.match(string, string2, bl)) continue;
            return i;
        }
        return -1;
    }

    protected int findUtype(String string) {
        String string2 = null;
        Field[] fieldArray = this.leg.field;
        boolean bl = Source.useWildcard(string);
        string = MetaDataTree.replace(string, "\\*", "*", -1);
        string = string.toUpperCase();
        for (int i = 0; i < fieldArray.length; ++i) {
            String string3;
            string2 = fieldArray[i].utype;
            if (string2 != null) {
                string2 = string2.toUpperCase();
            }
            if (string2 == null || bl && ((string3 = this.getValue(i)) == null || string3.trim().length() == 0) || !this.match(string, string2, bl)) continue;
            return i;
        }
        return -1;
    }

    protected int findColumn(String string) {
        String string2 = null;
        string = MetaDataTree.replace(string, " ", "", -1);
        Field[] fieldArray = this.leg.field;
        boolean bl = Source.useWildcard(string);
        string = MetaDataTree.replace(string, "\\*", "*", -1);
        for (int i = 0; i < fieldArray.length; ++i) {
            string2 = MetaDataTree.replace(fieldArray[i].name.trim(), " ", "", -1);
            if (string2 == null || !this.match(string, string2, bl)) continue;
            return i;
        }
        return -1;
    }

    protected static boolean useWildcard(String string) {
        int n = 32;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '?') {
                return true;
            }
            if (c == '*' && n != 92) {
                return true;
            }
            n = c;
        }
        return false;
    }

    protected String getCatalogue() {
        if (this.info != null) {
            int n;
            int n2;
            int n3 = this.info.indexOf("\t");
            if (n3 < 0) {
                return null;
            }
            String string = this.info.substring(0, n3);
            if (string.startsWith("<&") && (n2 = string.indexOf(124)) > 0 && (n = string.indexOf(62, n2 + 1)) >= 0) {
                string = string.substring(n2 + 1, n);
            }
            return string;
        }
        return null;
    }

    protected String getCodedValue(int n) throws NoSuchElementException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.info, "\t");
        stringTokenizer.nextElement();
        for (int i = 0; i < n; ++i) {
            stringTokenizer.nextElement();
        }
        return stringTokenizer.nextElement().toString();
    }

    protected String getValue(int n) {
        String string;
        try {
            int n2;
            int n3;
            string = this.getCodedValue(n);
            if (this.leg.isNullValue(string, n)) {
                string = "";
            }
            if (string.startsWith("<&") && (n3 = string.indexOf(124)) > 0 && (n2 = string.indexOf(62, n3 + 1)) >= 0) {
                string = string.substring(n3 + 1, n2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        return string.trim();
    }

    @Override
    public String getObjType() {
        return "Source";
    }

    @Override
    public String[] getValues() {
        boolean bl;
        StringTokenizer stringTokenizer = new StringTokenizer(this.info, "\t");
        String[] stringArray = null;
        Vector<String> vector = null;
        if (this.leg.field.length > 0) {
            stringArray = new String[this.leg.field.length];
        } else {
            vector = new Vector<String>();
        }
        stringTokenizer.nextElement();
        for (int i = 0; (bl = stringTokenizer.hasMoreTokens()) || stringArray != null && i < stringArray.length; ++i) {
            int n;
            int n2;
            String string;
            String string2 = string = bl ? stringTokenizer.nextToken() : "";
            if (string.startsWith("<&") && (n2 = string.indexOf(124)) > 0 && (n = string.indexOf(62, n2 + 1)) >= 0) {
                string = string.substring(n2 + 1, n);
            }
            if (stringArray != null) {
                stringArray[i] = string;
                continue;
            }
            vector.add(string);
        }
        if (stringArray == null) {
            stringArray = new String[vector.size()];
            Enumeration enumeration = vector.elements();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    @Override
    public boolean setValue(int n, String string) {
        boolean bl;
        StringTokenizer stringTokenizer = new StringTokenizer(this.info, "\t");
        StringBuffer stringBuffer = null;
        ++n;
        for (int i = 0; (bl = stringTokenizer.hasMoreTokens()) || i <= n; ++i) {
            String string2;
            String string3 = string2 = bl ? stringTokenizer.nextToken() : "";
            if (i == n) {
                string2 = string;
            }
            if (i == 0) {
                stringBuffer = new StringBuffer(string2);
                continue;
            }
            stringBuffer.append("\t" + string2);
        }
        this.info = stringBuffer.toString();
        return true;
    }

    @Override
    public void setShape(int n) {
        this.setSourceType(n);
    }

    protected void setSourceType(int n) {
        this.sourceType = (byte)n;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.plan.aladin.view.setHighlighted(this, bl);
    }

    @Override
    public void setColumn(int n, String string, String string2, String string3, int n2) {
        this.setColumn(n, string, null, string2, string3, n2);
    }

    public void setColumn(int n, String string, String string2, String string3, String string4, int n2) {
        int n3;
        if (this.leg == null) {
            this.leg = new Legende();
        }
        if ((n3 = this.leg.setField(n, string, string2, string3, string4, n2)) > 0 && this.plan != null && this.plan.pcat != null) {
            this.plan.pcat.fixInfo(this.leg);
        }
    }

    @Override
    public int indexOf(String string) {
        int n;
        if (this.leg == null) {
            return -1;
        }
        for (n = 0; n < this.leg.field.length; ++n) {
            if (!Util.matchMask(string, this.leg.field[n].name)) continue;
            return n;
        }
        for (n = 0; n < this.leg.field.length; ++n) {
            if (!Util.matchMask(string, this.leg.field[n].ucd)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int getSize() {
        if (this.leg != null) {
            return this.leg.getSize();
        }
        if (this.info == null) {
            return 0;
        }
        return new StringTokenizer(this.info, "\t").countTokens();
    }

    @Override
    public String[] getNames() {
        return this.getMeta(0);
    }

    @Override
    public String[] getUnits() {
        return this.getMeta(1);
    }

    @Override
    public String[] getUCDs() {
        return this.getMeta(2);
    }

    @Override
    public String[] getDataTypes() {
        return this.getMeta(3);
    }

    @Override
    public String[] getArraysizes() {
        return this.getMeta(4);
    }

    @Override
    public String[] getWidths() {
        return this.getMeta(5);
    }

    @Override
    public String[] getPrecisions() {
        return this.getMeta(6);
    }

    public String[] getNullValues() {
        return this.getMeta(7);
    }

    private String[] getMeta(int n) {
        if (this.leg == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.leg.getSize()];
        block10: for (int i = 0; i < stringArray.length; ++i) {
            switch (n) {
                case 0: {
                    stringArray[i] = this.leg.field[i].name;
                    continue block10;
                }
                case 1: {
                    stringArray[i] = this.leg.field[i].unit;
                    continue block10;
                }
                case 2: {
                    stringArray[i] = this.leg.field[i].ucd;
                    continue block10;
                }
                case 3: {
                    stringArray[i] = this.leg.field[i].datatype;
                    continue block10;
                }
                case 4: {
                    stringArray[i] = this.leg.field[i].arraysize;
                    continue block10;
                }
                case 5: {
                    stringArray[i] = this.leg.field[i].width;
                    continue block10;
                }
                case 6: {
                    stringArray[i] = this.leg.field[i].precision;
                    continue block10;
                }
                case 7: {
                    stringArray[i] = this.leg.field[i].nullValue;
                }
            }
        }
        return stringArray;
    }

    @Override
    public String getXMLMetaData() {
        return this.leg.getGroup();
    }

    protected String getUnit(int n) {
        if (n < 0) {
            return "";
        }
        return this.leg.field[n].unit;
    }

    @Override
    public InputStream getVOTable() throws Exception {
        return this.plan.aladin.writeObjectInVOTable(null, this, null, true, false, false).getInputStream();
    }

    private void createSourceFootprint() {
        if (this.sourceFootprint == null) {
            this.sourceFootprint = new SourceFootprint();
        }
    }

    protected SourceFootprint getFootprint() {
        return this.sourceFootprint;
    }

    protected void setFootprint(PlanField planField) {
        this.createSourceFootprint();
        this.sourceFootprint.setFootprint(planField);
    }

    protected void setFootprint(String string) {
        this.createSourceFootprint();
        this.sourceFootprint.setStcs(this.raj, this.dej, string);
    }

    protected void switchFootprint() {
        this.setShowFootprint(!this.sourceFootprint.showFootprint(), true);
    }

    protected void setShowFootprint(boolean bl, boolean bl2) {
        this.createSourceFootprint();
        this.sourceFootprint.setShowFootprint(bl);
        if (bl2) {
            this.plan.aladin.calque.repaintAll();
        }
    }

    protected boolean isShowingFootprint() {
        if (this.sourceFootprint == null) {
            return false;
        }
        return this.sourceFootprint.showFootprint();
    }

    protected int getIdxFootprint() {
        return this.sourceFootprint == null ? -1 : this.sourceFootprint.getIdxFootprint();
    }

    public void setIdxFootprint(int n) {
        this.createSourceFootprint();
        this.sourceFootprint.setIdxFootprint(n);
    }

    public int compare(Object object, Object object2) {
        double d;
        Source source = (Source)object;
        Source source2 = (Source)object2;
        if (sortSource == null || source == null || source2 == null) {
            return 0;
        }
        if (sortNField == -1) {
            if (source.isTagged() == source2.isTagged()) {
                return 0;
            }
            return source.isTagged() ? -sortSens : sortSens;
        }
        if (source.leg != Source.sortSource.leg) {
            return 1;
        }
        if (source2.leg != Source.sortSource.leg) {
            return -1;
        }
        String string = source.getValue(sortNField);
        String string2 = source2.getValue(sortNField);
        if (!sortNumeric) {
            if (sortSens == 1) {
                return string.compareTo(string2);
            }
            return string2.compareTo(string);
        }
        double d2 = string.length() == 0 ? Double.MAX_VALUE : Double.valueOf(string);
        if (d2 == (d = string2.length() == 0 ? Double.MAX_VALUE : Double.valueOf(string2))) {
            return 0;
        }
        return d2 > d ? sortSens : -sortSens;
    }

    protected static Comparator getComparator() {
        return sortSource;
    }

    protected static void setSort(Source source, int n, int n2) {
        sortNumeric = source.leg.isNumField(n);
        sortSource = source;
        sortNField = n;
        sortSens = n2;
        Aladin.trace(1, "Measurement " + (sortNumeric ? "numerical " : "alphanumerical ") + (n2 == 1 ? "ascending" : "descending") + " sort on " + (source.leg == null || n == -1 ? "field " + n : "${" + source.leg.field[n].name) + "}");
    }
}

