/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Hist;
import cds.aladin.Legende;
import cds.aladin.Localisation;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanField;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.SourceTag;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class SourceStat
extends SourceTag {
    protected static Legende legende = SourceStat.createLegende();
    protected int L = 5;
    private double radius;
    protected int dw;
    protected int dh;
    protected Color couleur = null;
    private static final String C = "|";
    static final Color JAUNEPALE = new Color(255, 255, 225);

    protected static Legende createLegende() {
        if (legende != null) {
            return legende;
        }
        legende = Legende.adjustDefaultLegende(legende, 3, new String[]{"_RAJ2000", "_DEJ2000", "ID", "Image", "RA (ICRS)", "DE (ICRS)", "Count", "Sum", "Sigma", "Min", "Avg", "Max", "Radius", "Area"});
        legende = Legende.adjustDefaultLegende(legende, 6, new String[]{"double", "double", "char", "char", "char", "char", "integer", "double", "double", "double", "double", "double", "double", "double"});
        legende = Legende.adjustDefaultLegende(legende, 5, new String[]{"deg", "deg", "", "", "\"h:m:s\"", "\"h:m:s\"", "pixel", "", "", "", "", "", "arcmin", "arcmin^2"});
        legende = Legende.adjustDefaultLegende(legende, 9, new String[]{"10", "10", "15", "10", "13", "13", "10", "10", "10", "10", "10", "10", "10", "10"});
        legende = Legende.adjustDefaultLegende(legende, 11, new String[]{"6", "6", "", "", "4", "5", "2", "4", "4", "4", "4", "4", "4", "4"});
        legende = Legende.adjustDefaultLegende(legende, 4, new String[]{"RA", "DEC", "Identifier", "Reference image", "Right ascension", "Declination", "Pixel count", "Sum of pixel values", "Median of the distribution", "Minimum value", "Average value", "Maximum value", "Radius", "Area (pixels)"});
        legende = Legende.adjustDefaultLegende(legende, 7, new String[]{"pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "meta.id;meta.main", "", "pos.eq.ra", "pos.eq.dec", "", "", "", "", "", "", "", ""});
        SourceStat.legende.name = "Pixel statistics";
        SourceStat.hideRADECLegende(legende);
        return legende;
    }

    protected SourceStat(Plan plan) {
        super(plan);
    }

    protected SourceStat(Plan plan, ViewSimple viewSimple, double d, double d2, String string) {
        super(plan, viewSimple, d, d2, string);
    }

    protected SourceStat(Plan plan, ViewSimple viewSimple, Coord coord, String string) {
        super(plan, viewSimple, coord, string);
    }

    @Override
    protected void suite() {
        this.leg = legende;
        this.setId();
        this.resumeMesures();
    }

    @Override
    protected void resumeMesures() {
        double[] dArray = null;
        try {
            dArray = this.getStatistics(this.planBase);
        }
        catch (Exception exception) {
            dArray = null;
        }
        String string = dArray == null ? " " : "" + dArray[0];
        String string2 = dArray == null ? " " : "" + dArray[1];
        String string3 = dArray != null && dArray[0] > 0.0 ? Util.myRound(dArray[1] / dArray[0]) : " ";
        String string4 = dArray == null ? " " : "" + dArray[2];
        String string5 = dArray == null ? " " : "" + dArray[3] * 3600.0;
        String string6 = "" + this.getRadius() * 60.0;
        String string7 = dArray == null ? " " : "" + dArray[4];
        String string8 = dArray == null ? " " : "" + dArray[5];
        Coord coord = new Coord(this.raj, this.dej);
        this.info = "<&_A Phots>\t" + this.raj + "\t" + this.dej + "\t" + this.id + "\t" + this.planBase.label + "\t\t" + coord.getRA() + "\t" + coord.getDE() + "\t" + string + "\t" + string2 + "\t" + string4 + "\t" + string7 + "\t" + string3 + "\t" + string8 + "\t" + string6 + "\t" + string5;
    }

    public Vector getProp() {
        Vector<Prop> vector = super.getProp();
        final SourceStat sourceStat = this;
        final JTextField jTextField = new JTextField(10);
        final PropAction propAction = new PropAction(){

            @Override
            public int action() {
                jTextField.setText(Coord.getUnit(SourceStat.this.getRadius()));
                return 1;
            }
        };
        PropAction propAction2 = new PropAction(){

            @Override
            public int action() {
                jTextField.setForeground(Color.black);
                String string = Coord.getUnit(SourceStat.this.getRadius());
                try {
                    String string2 = jTextField.getText();
                    if (string2.equals(string)) {
                        return -1;
                    }
                    ((SourceStat)sourceStat).setRadius(string2);
                    return 1;
                }
                catch (Exception exception) {
                    propAction.action();
                    jTextField.setForeground(Color.red);
                    return 0;
                }
            }
        };
        vector.add(Prop.propFactory("radius", "Radius", "", jTextField, propAction, propAction2));
        final JCheckBox jCheckBox = new JCheckBox("mouse locked");
        jCheckBox.setSelected(this.isLocked());
        final PropAction propAction3 = new PropAction(){

            @Override
            public int action() {
                if (jCheckBox.isSelected() == SourceStat.this.isWithLabel()) {
                    return -1;
                }
                SourceStat.this.setLocked(jCheckBox.isSelected());
                return 1;
            }
        };
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction3.action();
                SourceStat.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("lock", "Locked", "Not movable and/or extensible by mouse", jCheckBox, null, propAction3));
        final Couleur couleur = new Couleur(this.couleur, true);
        final PropAction propAction4 = new PropAction(){

            @Override
            public int action() {
                Color color = couleur.getCouleur();
                if (color == SourceStat.this.couleur) {
                    return -1;
                }
                SourceStat.this.couleur = color;
                return 1;
            }
        };
        couleur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction4.action();
                SourceStat.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("color", "Color", "Alternative color", couleur, null, propAction4));
        return vector;
    }

    @Override
    protected String getSpecificAJInfo() {
        return this.id + C + (this.hasRayon() ? Double.valueOf(this.getRadius()) : "");
    }

    @Override
    protected void setSpecificAJInfo(String string) {
        block3: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, C);
            String string2 = stringTokenizer.nextToken();
            String string3 = this.id = string2.length() == 0 ? null : string2;
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    this.radius = Double.parseDouble(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    if (Aladin.levelTrace != 3) break block3;
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getObjType() {
        return "Phot";
    }

    @Override
    protected void setPosition(ViewSimple viewSimple, double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        this.setPosition1(viewSimple, d, d2);
        this.resume();
    }

    @Override
    protected void deltaPosition(ViewSimple viewSimple, double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        this.deltaPosition1(viewSimple, d, d2);
        this.resume();
    }

    @Override
    protected void deltaRaDec(double d, double d2) {
        if (this.isLocked()) {
            return;
        }
        this.deltaRaDec1(d, d2);
        this.resume();
    }

    void setD() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        this.dw = fontMetrics.stringWidth(this.id) + 4;
        this.dh = HF;
    }

    @Override
    public void setColor(Color color) {
        this.couleur = color;
    }

    protected void setRadius(String string) {
        this.radius = Server.getAngleInArcmin(string, 1) / 60.0;
        this.resume();
    }

    void setRayon(ViewSimple viewSimple, double d) {
        Coord coord = new Coord();
        Projection projection = viewSimple.getProj().copy();
        projection.setProjCenter(0.0, 0.0);
        double d2 = 0.0;
        coord.del = 0.0;
        coord.al = 0.0;
        projection.getXY(coord);
        if (Double.isNaN(coord.del)) {
            projection = viewSimple.getProj().copy();
            coord.al = this.raj;
            coord.del = this.dej;
            d2 = this.dej;
            projection.getXY(coord);
        }
        coord.y += d;
        projection.getCoord(coord);
        this.radius = Math.abs(d2 - coord.del);
        this.resume();
    }

    protected void setId(String string) {
        this.id = string;
        this.setD();
    }

    void setId() {
        if (this.id == null) {
            this.id = "Stat " + SourceStat.nextIndice();
        }
        this.setD();
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        double d3;
        if (!this.isVisible()) {
            return false;
        }
        double d4 = Math.abs(d - this.xv[viewSimple.n]);
        return Math.sqrt(d4 * d4 + (d3 = Math.abs(d2 - this.yv[viewSimple.n])) * d3) <= this.getRayon(viewSimple);
    }

    @Override
    protected Rectangle extendClip(ViewSimple viewSimple, Rectangle rectangle) {
        if (!this.isVisible()) {
            return rectangle;
        }
        int n = (int)Math.ceil(this.getRayon(viewSimple) * viewSimple.getZoom());
        Point point = this.getViewCoord(viewSimple, n, n);
        if (point == null) {
            return rectangle;
        }
        int n2 = n;
        rectangle = SourceStat.unionRect(rectangle, point.x - n2, point.y - n2, n2 * 2, n2 * 2);
        if (this.isSelected()) {
            rectangle = SourceStat.unionRect(rectangle, point.x - n - 4, point.y - n - 4, n * 2 + 8, n * 2 + 8);
        }
        if (this.isWithLabel()) {
            rectangle = SourceStat.unionRect(rectangle, point.x - this.dw / 2, point.y - this.L - 1 - this.dh - 1, this.dw, this.dh);
        }
        if (this.isWithStat()) {
            rectangle = SourceStat.unionRect(rectangle, point.x, point.y - 20, 250, 150);
        }
        return rectangle;
    }

    protected Rectangle getClipRayon(ViewSimple viewSimple) {
        Rectangle rectangle = null;
        if (!this.isVisible()) {
            return null;
        }
        int n = (int)Math.ceil(this.getRayon(viewSimple) * viewSimple.getZoom());
        Point point = this.getViewCoord(viewSimple, n, n);
        if (point == null) {
            return null;
        }
        if (this.isSelected()) {
            rectangle = SourceStat.unionRect(rectangle, point.x - n - 4, point.y - n - 4, n * 2 + 8, n * 2 + 8);
        }
        return rectangle;
    }

    @Override
    public Color getColor() {
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.plan != null) {
            if (this.plan.type != 10) {
                return this.plan.c;
            }
        } else {
            return Color.black;
        }
        this.couleur = ((PlanField)this.plan).getColor(this);
        return this.couleur;
    }

    @Override
    protected boolean statCompute(Graphics graphics, ViewSimple viewSimple) {
        boolean bl;
        boolean bl2 = bl = viewSimple == viewSimple.aladin.view.getCurrentView();
        if (viewSimple == null || viewSimple.isFree() || !this.hasPhot(viewSimple.pref)) {
            return false;
        }
        this.statInit();
        double d = this.xv[viewSimple.n] - 0.5;
        double d2 = this.yv[viewSimple.n] - 0.5;
        double d3 = this.getRayon(viewSimple);
        if (d3 > 100.0 && viewSimple.flagClicAndDrag) {
            return false;
        }
        minx = (int)Math.floor(d - d3);
        maxx = (int)Math.ceil(d + d3);
        miny = (int)Math.floor(d2 - d3);
        maxy = (int)Math.ceil(d2 + d3);
        double d4 = d3 * d3;
        double d5 = 0.0;
        Hist.HistItem histItem = null;
        if (bl) {
            Hist.HistItem histItem2 = histItem = viewSimple.aladin.view.zoomview.hist == null ? null : viewSimple.aladin.view.zoomview.hist.onMouse;
            if (histItem == null) {
                viewSimple.aladin.view.zoomview.initPixelHist();
            } else {
                bl = false;
            }
        }
        if (viewSimple.pref instanceof PlanBG) {
            try {
                PlanBG planBG = (PlanBG)viewSimple.pref;
                int n = planBG.getOrder();
                long l = CDSHealpix.pow2(n);
                long l2 = CDSHealpix.pow2(planBG.getTileOrder());
                long l3 = l * l2;
                d5 = CDSHealpix.pixRes(l3) / 3600.0;
                d5 *= d5;
                Coord coord = new Coord(this.raj, this.dej);
                coord = Localisation.frameToFrame(coord, 0, planBG.frameOrigin);
                double d6 = Math.toRadians(this.getRadius());
                long[] lArray = CDSHealpix.query_disc(l3, coord.al, coord.del, d6, false);
                for (int i = 0; i < lArray.length; ++i) {
                    long l4 = lArray[i] / (l2 * l2);
                    double d7 = planBG.getHealpixPixel(n, l4, lArray[i], 0);
                    if (Double.isNaN(d7)) continue;
                    d7 = d7 * planBG.bScale + planBG.bZero;
                    double[] dArray = CDSHealpix.pix2ang_nest(l3, lArray[i]);
                    dArray = CDSHealpix.polarToRadec(dArray);
                    coord.al = dArray[0];
                    coord.del = dArray[1];
                    coord = Localisation.frameToFrame(coord, planBG.frameOrigin, 0);
                    this.statPixel(graphics, d7, coord.al, coord.del, viewSimple, histItem);
                    if (!bl) continue;
                    viewSimple.aladin.view.zoomview.addPixelHist(d7);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                d5 = viewSimple.pref.projd.getPixResAlpha() * viewSimple.pref.projd.getPixResDelta();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (double d8 = miny; d8 <= maxy; d8 += 1.0) {
                for (double d9 = minx; d9 <= maxx; d9 += 1.0) {
                    double d10;
                    if ((d9 - d) * (d9 - d) + (d8 - d2) * (d8 - d2) > d4 || Double.isNaN(d10 = this.statPixel(graphics, (int)d9, (int)d8, viewSimple, histItem)) || !bl) continue;
                    viewSimple.aladin.view.zoomview.addPixelHist(d10);
                }
            }
        }
        if (bl) {
            viewSimple.aladin.view.zoomview.createPixelHist(viewSimple.pref.type == 16 ? "HEALPixels" : "Pixels");
        }
        d = this.xv[viewSimple.n];
        d2 = this.yv[viewSimple.n];
        minx = d - d3;
        maxx = d + d3;
        miny = d2 - d3;
        maxy = d2 + d3;
        try {
            surface = (double)nombre * d5;
            moyenne = total / (double)nombre;
            variance = carre / (double)nombre - moyenne * moyenne;
            sigma = Math.sqrt(variance);
            if (medianeArrayNb == 10000) {
                mediane = Double.NaN;
            } else {
                Arrays.sort(medianeArray, 0, medianeArrayNb);
                mediane = medianeArray[medianeArrayNb / 2];
            }
            this.setWithStat(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public double[] getStatistics(Plan plan) throws Exception {
        double d;
        PlanImage planImage;
        Projection projection = plan.projd;
        if (!plan.hasAvailablePixels()) {
            throw new Exception("getStats error: image without pixel values");
        }
        if (!this.hasPhot(plan)) {
            throw new Exception("getStats error: not compatible image");
        }
        if (!Projection.isOk(projection)) {
            throw new Exception("getStats error: image without astrometrical calibration");
        }
        if (this.radius <= 0.0) {
            throw new Exception("getStats error: no radius");
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        double d6 = Double.NaN;
        if (plan.type == 16) {
            planImage = (PlanBG)plan;
            int n = ((PlanBG)planImage).getOrder();
            long l = CDSHealpix.pow2(n);
            long l2 = CDSHealpix.pow2(((PlanBG)planImage).getTileOrder());
            long l3 = l * l2;
            d = CDSHealpix.pixRes(l3) / 3600.0;
            d *= d;
            Coord coord = new Coord(this.raj, this.dej);
            coord = Localisation.frameToFrame(coord, 0, ((PlanBG)planImage).frameOrigin);
            double d7 = Math.toRadians(this.getRadius());
            long[] lArray = CDSHealpix.query_disc(l3, coord.al, coord.del, d7, false);
            for (int i = 0; i < lArray.length; ++i) {
                long l4 = lArray[i] / (l2 * l2);
                double d8 = ((PlanBG)planImage).getHealpixPixel(n, l4, lArray[i], 0);
                if (Double.isNaN(d8)) continue;
                d8 = d8 * ((PlanBG)planImage).bScale + ((PlanBG)planImage).bZero;
                if (d2 == 0.0) {
                    d5 = d6 = d8;
                    d4 = 0.0;
                }
                if (d8 < d5) {
                    d5 = d8;
                }
                if (d8 > d6) {
                    d6 = d8;
                }
                d2 += 1.0;
                d4 += d8;
                d3 += d8 * d8;
            }
        } else {
            planImage = (PlanImage)plan;
            planImage.setLockCacheFree(true);
            planImage.pixelsOriginFromCache();
            d = projection.getPixResAlpha() * projection.getPixResDelta();
            Coord coord = new Coord(this.raj, this.dej);
            projection.getXY(coord);
            double d9 = coord.x - 0.5;
            double d10 = coord.y - 0.5;
            coord.del = this.dej + this.radius;
            projection.getXY(coord);
            double d11 = d10 + 0.5 - coord.y;
            double d12 = d9 + 0.5 - coord.x;
            double d13 = Math.sqrt(d12 * d12 + d11 * d11);
            double d14 = d13 * d13;
            int n = (int)Math.floor(d9 - d13);
            int n2 = (int)Math.ceil(d9 + d13);
            int n3 = (int)Math.floor(d10 - d13);
            int n4 = (int)Math.ceil(d10 + d13);
            for (int i = n3; i <= n4; ++i) {
                for (int j = n; j <= n2; ++j) {
                    double d15;
                    if (((double)j - d9) * ((double)j - d9) + ((double)i - d10) * ((double)i - d10) > d14 || !planImage.isIn(j, i) || Double.isNaN(d15 = planImage.getPixelInDouble(j, i))) continue;
                    if (d2 == 0.0) {
                        d5 = d6 = d15;
                        d4 = 0.0;
                    }
                    if (d15 < d5) {
                        d5 = d15;
                    }
                    if (d15 > d6) {
                        d6 = d15;
                    }
                    d2 += 1.0;
                    d4 += d15;
                    d3 += d15 * d15;
                }
            }
            planImage.setLockCacheFree(false);
        }
        double d16 = d2 * d;
        double d17 = d4 / d2;
        double d18 = d3 / d2 - d17 * d17;
        double d19 = Math.sqrt(d18);
        return new double[]{d2, d4, d19, d16, d5, d6};
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    protected boolean hasRayon() {
        return this.radius > 0.0;
    }

    @Override
    public boolean hasPhot() {
        return true;
    }

    public boolean hasPhot(Plan plan) {
        if (!this.hasPhot()) {
            return false;
        }
        return plan.hasAvailablePixels();
    }

    @Override
    public String getCommand() {
        String string = this.plan.aladin.localisation.getFrame() == 11 ? Util.myRound(this.getRayon(this.plan.aladin.view.getCurrentView())) : Coord.getUnit(this.getRadius());
        return "draw phot(" + this.getLocalisation() + "," + string + ")";
    }

    protected double getRayon(ViewSimple viewSimple) {
        Coord coord = new Coord();
        Projection projection = viewSimple.getProj();
        if (this.radius == 0.0 || viewSimple.pref == null || !Projection.isOk(projection)) {
            return 0.0;
        }
        coord.al = this.raj;
        coord.del = this.dej + this.radius;
        projection.getXY(coord);
        double d = this.yv[viewSimple.n] - coord.y;
        double d2 = this.xv[viewSimple.n] - coord.x;
        return Math.sqrt(d2 * d2 + d * d);
    }

    protected boolean onPoignee(ViewSimple viewSimple, double d, double d2) {
        if (this.isLocked()) {
            return false;
        }
        double d3 = this.getRayon(viewSimple) + 1.0;
        for (int i = 0; i < 4; ++i) {
            double d4 = this.xv[viewSimple.n];
            double d5 = this.yv[viewSimple.n];
            if (i == 0) {
                d5 += d3;
            } else if (i == 2) {
                d5 -= d3;
            } else {
                d4 = i == 1 ? (d4 += d3) : (d4 -= d3);
            }
            double d6 = d - d4;
            double d7 = d2 - d5;
            double d8 = (double)this.L / viewSimple.getZoom();
            if (d8 < 1.0) {
                d8 = 1.0;
            }
            if (!(d6 * d6 + d7 * d7 < d8 * d8)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        int n3 = (int)(this.getRayon(viewSimple) * viewSimple.getZoom());
        Point point = this.getViewCoord(viewSimple, n3, n3);
        if (point == null) {
            return false;
        }
        point.x += n;
        point.y += n2;
        graphics.setColor(this.getColor());
        if (this.hasPhot(viewSimple.pref) && viewSimple.pref == this.planBase) {
            Util.drawFillOval(graphics, point.x - n3, point.y - n3, n3 * 2, n3 * 2, 0.2f * this.plan.getOpacityLevel(), null);
        } else {
            graphics.drawOval(point.x - n3, point.y - n3, n3 * 2, n3 * 2);
        }
        if (this.isWithLabel()) {
            graphics.drawString(this.id, point.x - this.dw / 2, point.y - 1);
        }
        if (this.hasPhot(viewSimple.pref) && this.isSelected()) {
            this.statDraw(graphics, viewSimple, n, n2);
        }
        if (this.isSelected()) {
            graphics.setColor(Color.green);
            this.drawSelect(graphics, viewSimple);
        }
        return true;
    }

    @Override
    protected void drawSelect(Graphics graphics, ViewSimple viewSimple) {
        Rectangle rectangle = this.getClipRayon(viewSimple);
        int n = 0;
        int n2 = 0;
        Color color = graphics.getColor();
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    n = rectangle.x + rectangle.width / 2 - 4;
                    n2 = rectangle.y;
                    break;
                }
                case 1: {
                    n = rectangle.x + rectangle.width / 2 - 4;
                    n2 = rectangle.y + rectangle.height - 4;
                    break;
                }
                case 2: {
                    n = rectangle.x + rectangle.width - 4;
                    n2 = rectangle.y + rectangle.height / 2 - 4;
                    break;
                }
                case 3: {
                    n = rectangle.x;
                    n2 = rectangle.y + rectangle.height / 2 - 4;
                }
            }
            graphics.setColor(color);
            graphics.fillRect(n + 1, n2 + 1, 4, 4);
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, 4, 4);
        }
        graphics.setColor(color);
    }

    @Override
    protected void remove() {
        this.cutOff();
    }

    protected void cutOff() {
        this.plan.aladin.calque.zoom.zoomView.stopHist();
        this.plan.aladin.calque.zoom.zoomView.cutOff(this);
    }

    @Override
    protected boolean cutOn() {
        ViewSimple viewSimple = this.plan.aladin.view.getCurrentView();
        if (viewSimple == null || this.plan.aladin.toolBox.getTool() == 8) {
            return false;
        }
        Plan plan = viewSimple.pref;
        if (!plan.isCube()) {
            return false;
        }
        double d = this.xv[viewSimple.n];
        double d2 = this.yv[viewSimple.n];
        int n = plan.getDepth();
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                nArray[i] = plan.getPixel8bit(i, d, d2) & 0xFF;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.plan.aladin.calque.zoom.zoomView.setCut(this, nArray, 0);
        return true;
    }
}

