/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SourceTag
extends Source {
    private static int INDICE = 0;
    protected static Legende legende = SourceTag.createLegende();
    protected Plan planBase;

    protected static Legende createLegende() {
        if (legende != null) {
            return legende;
        }
        legende = Legende.adjustDefaultLegende(legende, 3, new String[]{"_RAJ2000", "_DEJ2000", "Label", "Plan", "RA (ICRS)", "DE (ICRS)", "X", "Y"});
        legende = Legende.adjustDefaultLegende(legende, 6, new String[]{"double", "double", "char", "char", "char", "char", "double", "double"});
        legende = Legende.adjustDefaultLegende(legende, 5, new String[]{"deg", "deg", "char", "", "\"h:m:s\"", "\"h:m:s\"", "", ""});
        legende = Legende.adjustDefaultLegende(legende, 9, new String[]{"10", "10", "15", "10", "13", "13", "8", "8"});
        legende = Legende.adjustDefaultLegende(legende, 11, new String[]{"6", "6", "", "", "2", "3", "2", "2"});
        legende = Legende.adjustDefaultLegende(legende, 4, new String[]{"RA", "DEC", "Identifier", "Reference plane", "Right ascension", "Declination", "Current image X axis (FITS convention)", "Current image Y axis (Fits Convention)"});
        legende = Legende.adjustDefaultLegende(legende, 7, new String[]{"pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "meta.id;meta.main", "", "pos.eq.ra", "pos.eq.dec", "", ""});
        SourceTag.legende.name = "Positional tags";
        SourceTag.hideRADECLegende(legende);
        return legende;
    }

    protected static void hideRADECLegende(Legende legende) {
        int n = legende.find("_RAJ2000");
        int n2 = legende.find("_DEJ2000");
        if (n < 0 || n2 < 0) {
            return;
        }
        Field field = legende.field[n];
        Field field2 = legende.field[n2];
        field2.type = "hidden";
        field.type = "hidden";
        field2.visible = false;
        field.visible = false;
    }

    protected static int nextIndice() {
        return ++INDICE;
    }

    protected SourceTag(Plan plan) {
        super(plan);
    }

    protected SourceTag(Plan plan, ViewSimple viewSimple, double d, double d2, String string) {
        super(plan, viewSimple, d, d2, 0.0, 0.0, 5, string);
        this.leg = legende;
        this.planBase = viewSimple.pref;
        plan.setSourceRemovable(true);
        this.suite();
    }

    protected SourceTag(Plan plan, ViewSimple viewSimple, Coord coord, String string) {
        super(plan, coord.al, coord.del, string, null);
        this.planBase = viewSimple.pref;
        plan.setSourceRemovable(true);
        this.suite();
    }

    protected void suite() {
        this.leg = legende;
        this.setShape(6);
        this.setTag(true);
        this.setWithLabel(true);
        this.resumeMesures();
    }

    protected void resume() {
        this.resumeMesures();
        this.plan.aladin.view.newView(1);
        this.plan.aladin.mesure.redisplay();
    }

    protected void resumeMesures() {
        Coord coord = new Coord(this.raj, this.dej);
        if (this.id == null) {
            this.id = "Tag " + this.plan.pcat.getNextID();
        }
        String string = " ";
        String string2 = " ";
        if (this.planBase instanceof PlanImage) {
            this.planBase.projd.getXY(coord);
            string = Util.myRound("" + (coord.x + 0.5), 4);
            string2 = Util.myRound("" + ((double)((PlanImage)this.planBase).naxis2 - coord.y + 0.5));
        }
        this.info = "<&_A Tags>\t" + this.raj + "\t" + this.dej + "\t" + this.id + "\t" + this.planBase.label + "\t" + coord.getRA() + "\t" + coord.getDE() + "\t" + string + "\t" + string2;
    }

    @Override
    public boolean hasProp() {
        return true;
    }

    @Override
    public Vector<Prop> getProp() {
        Vector<Prop> vector = new Vector<Prop>();
        JLabel jLabel = new JLabel("\"" + this.getObjType() + "\" in plane: \"" + this.plan.getLabel() + "\"");
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setFont(jLabel.getFont().deriveFont(14.0f));
        vector.add(Prop.propFactory("object", "", null, jLabel, null, null));
        final JTextField jTextField = new JTextField(this.id, 20);
        PropAction propAction = new PropAction(){

            @Override
            public int action() {
                SourceTag.this.id = jTextField.getText();
                SourceTag.this.resume();
                return 1;
            }
        };
        vector.add(Prop.propFactory("label", "Label", "Identifier", jTextField, null, propAction));
        jLabel = new JLabel("\"" + this.getObjType() + "\" object in plane: \"" + this.plan.getLabel() + "\"");
        vector.add(Prop.propFactory("Plan", "Plan", "Reference plane", jLabel, null, null));
        final SourceTag sourceTag = this;
        final JTextField jTextField2 = new JTextField(20);
        PropAction propAction2 = new PropAction(){

            @Override
            public int action() {
                jTextField2.setText(SourceTag.this.plan.aladin.localisation.getLocalisation(sourceTag));
                SourceTag.this.resume();
                return 1;
            }
        };
        PropAction propAction3 = new PropAction(){

            @Override
            public int action() {
                jTextField2.setForeground(Color.black);
                String string = SourceTag.this.plan.aladin.localisation.getLocalisation(sourceTag);
                try {
                    String string2 = jTextField2.getText();
                    if (string2.equals(string)) {
                        return -1;
                    }
                    Coord coord = new Coord(jTextField2.getText());
                    if (("" + coord).indexOf("--") >= 0) {
                        throw new Exception();
                    }
                    coord = SourceTag.this.plan.aladin.localisation.frameToICRS(coord);
                    SourceTag.this.setRaDec(coord.al, coord.del);
                    SourceTag.this.resume();
                    return 1;
                }
                catch (Exception exception) {
                    jTextField2.setForeground(Color.red);
                    jTextField2.setText(string);
                    return 0;
                }
            }
        };
        vector.add(Prop.propFactory("coord", "Coord", "Localisation", jTextField2, propAction2, propAction3));
        final JCheckBox jCheckBox = new JCheckBox("label display");
        jCheckBox.setSelected(this.isWithLabel());
        final PropAction propAction4 = new PropAction(){

            @Override
            public int action() {
                if (jCheckBox.isSelected() == SourceTag.this.isWithLabel()) {
                    return -1;
                }
                SourceTag.this.setWithLabel(jCheckBox.isSelected());
                return 1;
            }
        };
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction4.action();
                SourceTag.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("display", "Display", "Display the label in the view", jCheckBox, null, propAction4));
        final JCheckBox jCheckBox2 = new JCheckBox("tagged (permanently selected)");
        jCheckBox2.setSelected(this.isTagged());
        final PropAction propAction5 = new PropAction(){

            @Override
            public int action() {
                if (jCheckBox2.isSelected() == SourceTag.this.isTagged()) {
                    return -1;
                }
                SourceTag.this.setTag(jCheckBox2.isSelected());
                return 1;
            }
        };
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction5.action();
                SourceTag.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("tagged", "Tagged", "Check it to tag this object in the measurement panel", jCheckBox2, null, propAction5));
        return vector;
    }
}

