/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Cercle;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.Pickle;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.Position;
import cds.aladin.Tag;
import cds.tools.Util;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class SubFootprintBean {
    protected static final int POLYGON = 1;
    protected static final int CIRCLE = 2;
    protected static final int PICKLE = 3;
    protected static final int STRING = 4;
    protected int type = -1;
    private String name;
    private Vector<SubFootprintBean> subSubsFootprints = new Vector();
    private boolean inSphericalCoords = false;
    private double[] raOffset;
    private double[] decOffset;
    private double centerOffRa;
    private double centerOffDec;
    private double circleRadius;
    private double internalRad;
    private double externalRad;
    private double startAngle;
    private double angle;
    private double ra;
    private double dec;
    private String content;
    private String align;
    private Color c;

    protected SubFootprintBean() {
    }

    protected SubFootprintBean(double[] dArray, double[] dArray2, String string) {
        this();
        this.type = 1;
        this.raOffset = dArray;
        this.decOffset = dArray2;
    }

    protected SubFootprintBean(double d, double d2, double d3, String string) {
        this();
        this.type = 2;
        this.centerOffRa = d;
        this.centerOffDec = d2;
        this.circleRadius = d3;
    }

    protected SubFootprintBean(double d, double d2, double d3, double d4, double d5, double d6, String string) {
        this();
        this.type = 3;
        this.centerOffRa = d;
        this.centerOffDec = d2;
        this.startAngle = d3;
        this.angle = d4;
        this.internalRad = d5;
        this.externalRad = d6;
    }

    protected SubFootprintBean(double d, double d2, String string, String string2) {
        this();
        this.type = 4;
        this.ra = d;
        this.dec = d2;
        this.align = string;
        this.content = string2;
    }

    protected int getNbOfSubParts() {
        return this.subSubsFootprints.size();
    }

    public boolean isInSphericalCoords() {
        return this.inSphericalCoords;
    }

    public void setInSphericalCoords(boolean bl) {
        this.inSphericalCoords = bl;
    }

    protected void addSubFootprintBean(SubFootprintBean subFootprintBean) {
        this.subSubsFootprints.addElement(subFootprintBean);
    }

    protected Obj[] buildObjets(PlanField planField) {
        Object object;
        Vector<Obj> vector = new Vector<Obj>();
        switch (this.type) {
            case 1: {
                int n = this.raOffset.length;
                object = new Ligne(planField);
                vector.addElement((Obj)object);
                double d3 = this.isInSphericalCoords() ? Math.toRadians(Math.cos(Math.toRadians(this.decOffset[this.decOffset.length - 1])) * this.raOffset[this.raOffset.length - 1]) : Util.tand(this.raOffset[this.raOffset.length - 1]);
                double d2 = this.isInSphericalCoords() ? Math.toRadians(this.decOffset[this.decOffset.length - 1]) : Util.tand(this.decOffset[this.decOffset.length - 1]);
                ((Position)object).setXYTan(d3, d2);
                for (int i = 0; i < n; ++i) {
                    Ligne ligne = new Ligne(planField);
                    vector.addElement(ligne);
                    d3 = this.isInSphericalCoords() ? Math.toRadians(Math.cos(Math.toRadians(this.decOffset[i])) * this.raOffset[i]) : Util.tand(this.raOffset[i]);
                    d2 = this.isInSphericalCoords() ? Math.toRadians(this.decOffset[i]) : Util.tand(this.decOffset[i]);
                    ligne.setXYTan(Util.tand(this.raOffset[i]), Util.tand(this.decOffset[i]));
                    ligne.debligne = object;
                    object = ligne;
                }
                break;
            }
            case 2: {
                double d = this.isInSphericalCoords() ? Math.toRadians(Math.cos(Math.toRadians(this.centerOffDec)) * this.centerOffRa) : Util.tand(this.centerOffRa);
                double d3 = this.isInSphericalCoords() ? Math.toRadians(this.centerOffDec) : Util.tand(this.centerOffDec);
                double d2 = this.isInSphericalCoords() ? Math.toRadians(this.circleRadius) : Util.tand(this.circleRadius);
                Cercle cercle = new Cercle(planField, null, d, d3, d2);
                vector.addElement(cercle);
                break;
            }
            case 3: {
                if (this.angle == 0.0) {
                    Aladin.trace(3, "Can not create a pickle with an angle of 0 !");
                    break;
                }
                Pickle pickle = new Pickle((Plan)planField, null, Util.tand(this.centerOffRa), Util.tand(this.centerOffDec), Util.tand(this.internalRad), Util.tand(this.externalRad), this.startAngle, this.angle);
                vector.addElement(pickle);
                break;
            }
            case 4: {
                Tag tag = new Tag(planField);
                tag.setText(this.content);
                tag.setXYTan(Util.tand(this.ra), Util.tand(this.dec));
                vector.addElement(tag);
                break;
            }
        }
        Enumeration<SubFootprintBean> enumeration = this.subSubsFootprints.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            SubFootprintBean.addArrayObjectsToVector(vector, ((SubFootprintBean)object).buildObjets(planField));
        }
        Object[] objectArray = new Obj[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    protected static void addArrayObjectsToVector(Vector<Obj> vector, Obj[] objArray) {
        if (objArray == null) {
            return;
        }
        for (int i = 0; i < objArray.length; ++i) {
            if (objArray[i] == null) continue;
            vector.addElement(objArray[i]);
        }
    }

    protected String getName() {
        return this.name == null ? "" : this.name;
    }

    protected String getDesc() {
        return "";
    }

    protected Color getColor() {
        return this.c;
    }

    protected void setColor(Color color) {
        this.c = color;
    }

    protected void setName(String string) {
        this.name = string;
    }
}

