/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.tools.Util;
import java.util.Vector;

public final class Synchro {
    static final boolean VERBOSE = false;
    private Vector<Task> taskList;
    private long defaultDelay;
    private transient boolean lock;
    private final Object lockObj = new Object();

    public Synchro() {
        this(0L);
    }

    public Synchro(long l) {
        this.defaultDelay = l;
        this.taskList = new Vector();
    }

    public boolean isReady() {
        try {
            this.waitLock();
            this.checkTask();
            boolean bl = this.taskList.size() == 0;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public String start(String string) {
        return this.start(string, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String start(String string, long l) {
        try {
            this.waitLock();
            Task task = new Task();
            task.taskId = this.getUniqueTaskId(string);
            task.endTime = l > 0L ? System.currentTimeMillis() + l : (this.defaultDelay > 0L ? System.currentTimeMillis() + this.defaultDelay : 0L);
            this.taskList.addElement(task);
            String string2 = task.taskId;
            return string2;
        }
        finally {
            this.unlock();
        }
    }

    public void stop(String string) {
        if (string == null) {
            return;
        }
        try {
            this.waitLock();
            this.checkTask(string);
        }
        finally {
            this.unlock();
        }
    }

    public String waitingTasks() {
        try {
            this.waitLock();
            String string = this.toString();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public void reset() {
        this.unlock();
        this.taskList.clear();
    }

    public void waitUntil() {
        try {
            this.waitUntil(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void waitUntil(long l) throws Exception {
        long l2 = System.currentTimeMillis();
        while (!this.isReady()) {
            if (l > 0L && System.currentTimeMillis() - l2 > l) {
                throw new Exception("Synchro.waitUntil() time out");
            }
            this.sleep(25);
        }
    }

    private void sleep(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getUniqueTaskId(String string) {
        int n = 0;
        for (Task task : this.taskList) {
            if (!task.taskId.equals(string)) continue;
            ++n;
        }
        return n == 0 ? string : string + "~" + n;
    }

    private void checkTask() {
        this.checkTask(null);
    }

    private void checkTask(String string) {
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.taskList.size(); ++i) {
            Task task = this.taskList.get(i);
            if ((task.endTime <= 0L || task.endTime >= l) && !task.taskId.equals(string)) continue;
            this.taskList.removeElementAt(i);
            --i;
        }
    }

    public String toString() {
        if (this.taskList.size() == 0) {
            return "Synchro: no task";
        }
        StringBuffer stringBuffer = new StringBuffer("Waiting " + this.taskList.size() + " tasks:\n");
        for (Task task : this.taskList) {
            stringBuffer.append("." + task + "\n");
        }
        return stringBuffer.toString();
    }

    private void waitLock() {
        while (!this.getLock()) {
            this.sleep(100);
        }
    }

    private void unlock() {
        this.lock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLock() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.lock) {
                return false;
            }
            this.lock = true;
            return true;
        }
    }

    private static boolean testThread() {
        final Synchro synchro = new Synchro();
        Thread thread = new Thread("Thread A"){

            @Override
            public void run() {
                System.out.println("Starting thread A");
                String string = synchro.start("bidule");
                System.out.println("Thread A adds " + string);
                String string2 = synchro.start("truc");
                System.out.println("Thread A adds " + string2);
                synchro.stop(string);
                System.out.println("Thread A removes " + string);
                System.out.println("Endind thread A");
            }
        };
        Thread thread2 = new Thread("Thread B"){

            @Override
            public void run() {
                System.out.println("Starting thread B");
                String string = synchro.start("bidule");
                System.out.println("Thread B adds " + string);
                String string2 = synchro.start("truc");
                System.out.println("Thread B adds " + string2);
                synchro.stop(string2);
                System.out.println("Thread B removes " + string2);
                System.out.println("Endind thread B");
            }
        };
        Thread thread3 = new Thread("Thread c"){

            @Override
            public void run() {
                System.out.println("Starting thread C");
                synchro.waitUntil();
                System.out.println("Endind thread C");
            }
        };
        thread.start();
        try {
            Thread.currentThread();
            Thread.sleep(15L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        thread2.start();
        thread3.start();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("*******************\n" + synchro.waitingTasks() + "*******************\n");
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        synchro.reset();
        System.out.println("Termin\u00e9");
        return true;
    }

    private static boolean testBasic() {
        Synchro synchro = new Synchro(6000L);
        String string = synchro.start("TacheUne", 2000L);
        String string2 = synchro.start("TacheDeux");
        String string3 = synchro.start("TacheUne", 3000L);
        System.out.println("Les taches indiqu\u00e9es : " + string + ", " + string2 + ", " + string3);
        System.out.println(synchro.waitingTasks());
        Util.pause(2500);
        System.out.println(synchro.waitingTasks());
        synchro.stop(string2);
        System.out.println(synchro.waitingTasks());
        synchro.waitUntil();
        System.out.println(synchro.waitingTasks());
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            Synchro.testBasic();
            Synchro.testThread();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class Task {
        String taskId;
        long endTime;

        Task() {
        }

        public String toString() {
            return this.taskId + (this.endTime == 0L ? "" : " (watchdog in " + (this.endTime - System.currentTimeMillis()) / 1000L + "s)");
        }
    }
}

