/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import healpix.essentials.FastMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Tag
extends Position {
    private static final int MINDIST = 3;
    private static final int MAXDIST = 300;
    private static final int MINFONT = 7;
    private static final int MAXFONT = 60;
    public static final int RETICLE = 0;
    public static final int BIGRETICLE = 1;
    public static final int SMALLCIRCLE = 2;
    public static final int CIRCLE = 3;
    public static final int BIGCIRCLE = 4;
    public static final int ARROW = 5;
    public static final int BIGARROW = 6;
    public static final int NOPOLE = 7;
    private static final String[] TAGS = new String[]{"reticle", "bigreticle", "smallcircle", "circle", "bigcircle", "arrow", "bigarrow", "nopole"};
    private static final int[] TAGSIZE = new int[]{5, 8, 3, 5, 8, 2, 2, 0};
    private final int NOTHING = 0;
    private final int LABEL = 1;
    private final int TAG = 2;
    private final int POIGNEE = 3;
    private final int CORNER = 4;
    private int L = 5;
    private int tag = 0;
    private double angle = 0.7853981633974483;
    private double dist = 0.0;
    private int accroche = 10;
    private Color couleur = null;
    private float fond = 0.0f;
    private int bord = 0;
    private Font F = Aladin.BOLD;
    private boolean editing;
    private int on = 0;
    private double distAngulaireOrig = 0.0;
    private Rectangle rect1 = null;
    private Rectangle rect2 = null;
    private static final String C = "|";
    private static final int T = 4;

    private Tag() {
    }

    protected Tag(Plan plan, ViewSimple viewSimple, double d, double d2) {
        super(plan, viewSimple, d, d2, 0.0, 0.0, 5, "");
    }

    protected Tag(Plan plan, ViewSimple viewSimple, double d, double d2, String string) {
        super(plan, viewSimple, d, d2, 0.0, 0.0, 5, string);
        this.setText(string);
        this.setWH();
    }

    protected Tag(Plan plan, Coord coord, String string) {
        super(plan, null, 0.0, 0.0, coord.al, coord.del, 2, string);
        this.setText(string);
        this.setWH();
    }

    protected Tag(Plan plan) {
        super(plan);
    }

    protected Tag copy() {
        Tag tag = new Tag();
        tag.L = this.L;
        tag.tag = this.tag;
        tag.angle = this.angle;
        tag.dist = this.dist;
        tag.accroche = this.accroche;
        tag.couleur = this.couleur;
        tag.fond = this.fond;
        tag.F = this.F;
        tag.editing = this.editing;
        tag.on = this.on;
        tag.distAngulaireOrig = this.distAngulaireOrig;
        return tag;
    }

    public Vector getProp() {
        Vector<Prop> vector = super.getProp();
        Prop.remove(vector, "id");
        final JTextField jTextField = new JTextField(10);
        final PropAction propAction = new PropAction(){

            @Override
            public int action() {
                jTextField.setText("" + (360 - (int)Math.round(Math.toDegrees(Tag.this.angle))));
                return 1;
            }
        };
        PropAction propAction2 = new PropAction(){

            @Override
            public int action() {
                try {
                    jTextField.setForeground(Color.black);
                    int n = Integer.parseInt(jTextField.getText());
                    if (n == 360 - (int)Math.round(Math.toDegrees(Tag.this.angle))) {
                        return -1;
                    }
                    Tag.this.angle = Math.toRadians(360 - n);
                    return 1;
                }
                catch (Exception exception) {
                    propAction.action();
                    jTextField.setForeground(Color.red);
                    return 0;
                }
            }
        };
        vector.add(Prop.propFactory("angle", "Angle", "Pole orientation (in degrees - trigonometric orientation)", jTextField, propAction, propAction2));
        final JTextField jTextField2 = new JTextField(10);
        final PropAction propAction3 = new PropAction(){

            @Override
            public int action() {
                jTextField2.setText("" + (int)Tag.this.dist);
                return 1;
            }
        };
        PropAction propAction4 = new PropAction(){

            @Override
            public int action() {
                try {
                    jTextField2.setForeground(Color.black);
                    int n = Integer.parseInt(jTextField2.getText());
                    if (n == (int)Tag.this.dist) {
                        return -1;
                    }
                    Tag.this.dist = n;
                    return 1;
                }
                catch (Exception exception) {
                    propAction3.action();
                    jTextField2.setForeground(Color.red);
                    return 0;
                }
            }
        };
        vector.add(Prop.propFactory("dist", "Pole size", "Pole size (in pixels)", jTextField2, propAction3, propAction4));
        final JComboBox<String> jComboBox = new JComboBox<String>(TAGS);
        PropAction propAction5 = new PropAction(){

            @Override
            public int action() {
                jComboBox.setSelectedIndex(Tag.this.tag);
                return 1;
            }
        };
        final PropAction propAction6 = new PropAction(){

            @Override
            public int action() {
                int n = jComboBox.getSelectedIndex();
                if (Tag.this.tag == n) {
                    return -1;
                }
                Tag.this.tag = n;
                return 1;
            }
        };
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction6.action();
                Tag.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("tag", "Arrow head", "Alternative arrow head", jComboBox, propAction5, propAction6));
        final JTextField jTextField3 = new JTextField(10);
        final PropAction propAction7 = new PropAction(){

            @Override
            public int action() {
                jTextField3.setText(Tag.this.F.getSize() + "");
                return 1;
            }
        };
        PropAction propAction8 = new PropAction(){

            @Override
            public int action() {
                try {
                    jTextField3.setForeground(Color.black);
                    float f = Float.parseFloat(jTextField3.getText());
                    if (f == (float)Tag.this.F.getSize()) {
                        return -1;
                    }
                    Tag.this.F = Tag.this.F.deriveFont(f);
                    return 1;
                }
                catch (Exception exception) {
                    propAction7.action();
                    jTextField3.setForeground(Color.red);
                    return 0;
                }
            }
        };
        vector.add(Prop.propFactory("fontsize", "Font size", null, jTextField3, propAction7, propAction8));
        final Couleur couleur = new Couleur(this.couleur, true);
        final PropAction propAction9 = new PropAction(){

            @Override
            public int action() {
                Color color = couleur.getCouleur();
                if (color == Tag.this.couleur) {
                    return -1;
                }
                Tag.this.couleur = color;
                return 1;
            }
        };
        couleur.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction9.action();
                Tag.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("color", "Color", "Alternative color", couleur, null, propAction9));
        final JTextArea jTextArea = new JTextArea(3, 25);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        PropAction propAction10 = new PropAction(){

            @Override
            public int action() {
                jTextArea.setText(Tag.this.id);
                return 1;
            }
        };
        PropAction propAction11 = new PropAction(){

            @Override
            public int action() {
                String string = jTextArea.getText();
                if (string.equals(Tag.this.id)) {
                    return -1;
                }
                Tag.this.id = jTextArea.getText();
                return 1;
            }
        };
        vector.add(Prop.propFactory("id", "Label", "Tag label", jScrollPane, propAction10, propAction11));
        final JCheckBox jCheckBox = new JCheckBox("with border");
        PropAction propAction12 = new PropAction(){

            @Override
            public int action() {
                jCheckBox.setSelected(Tag.this.bord == 1);
                return 1;
            }
        };
        final PropAction propAction13 = new PropAction(){

            @Override
            public int action() {
                if (jCheckBox.isSelected() == (Tag.this.bord == 1)) {
                    return -1;
                }
                Tag.this.bord = jCheckBox.isSelected() ? 1 : 0;
                return 1;
            }
        };
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                propAction13.action();
                Tag.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("border", "Label border", null, jCheckBox, propAction12, propAction13));
        final JSlider jSlider = new JSlider();
        PropAction propAction14 = new PropAction(){

            @Override
            public int action() {
                jSlider.setValue((int)(Tag.this.fond * 100.0f));
                return 1;
            }
        };
        final PropAction propAction15 = new PropAction(){

            @Override
            public int action() {
                if (jSlider.getValue() == (int)(Tag.this.fond * 100.0f)) {
                    return -1;
                }
                Tag.this.fond = (float)((double)jSlider.getValue() / 100.0);
                return 1;
            }
        };
        jSlider.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                propAction15.action();
                Tag.this.plan.aladin.view.repaintAll();
            }
        });
        vector.add(Prop.propFactory("background", "Label background", null, jSlider, propAction14, propAction15));
        return vector;
    }

    @Override
    public String getCommand() {
        return "draw tag(" + this.getLocalisation() + "," + Tok.quote(this.id) + "," + Math.round(this.dist) + "," + Math.round(270.0 - Math.toDegrees(this.angle)) + "," + TAGS[this.tag] + "," + this.F.getSize() + ")";
    }

    @Override
    protected String getSpecificAJInfo() {
        return (!this.hasLabel() ? "" : this.id.replace("\n", "\\n")) + C + TAGS[this.tag] + C + this.L + C + this.angle + C + this.dist + C + this.fond + C + this.bord + C + this.getFont().getSize() + C + this.distAngulaireOrig;
    }

    @Override
    protected void setSpecificAJInfo(String string) {
        block3: {
            try {
                int n = string.indexOf(C);
                String string2 = string.substring(0, n);
                this.setText(string2);
                Tok tok = new Tok(string.substring(n + C.length()), C);
                this.tag = Util.indexInArrayOf(tok.nextToken(), TAGS, true);
                if (this.tag == -1) {
                    this.tag = 0;
                }
                this.L = Integer.parseInt(tok.nextToken());
                this.angle = Double.parseDouble(tok.nextToken());
                this.dist = Double.parseDouble(tok.nextToken());
                this.fond = Float.parseFloat(tok.nextToken());
                this.bord = Integer.parseInt(tok.nextToken());
                float f = Float.parseFloat(tok.nextToken());
                this.setFont(Aladin.BOLD.deriveFont(f));
                this.distAngulaireOrig = Double.parseDouble(tok.nextToken());
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block3;
                exception.printStackTrace();
            }
        }
        this.setWH();
    }

    @Override
    public String getObjType() {
        return "Tag";
    }

    protected void setDist(int n) {
        this.dist = n;
        this.setWH();
    }

    protected void setAngle(int n) {
        this.angle = Math.toRadians(270 - n);
        this.setWH();
    }

    protected void setPole(String string) {
        this.tag = Util.indexInArrayOf(string, TAGS, true);
        if (this.tag == -1) {
            this.tag = 0;
        }
        this.L = TAGSIZE[this.tag];
        this.setWH();
    }

    protected void setFontSize(int n) {
        this.setFont(this.getFont().deriveFont((float)n));
        this.setWH();
    }

    @Override
    protected void setText(String string) {
        this.id = string == null || string.length() == 0 ? "" : string.replace("\\n", "\n");
        this.setWH();
    }

    @Override
    public void setInfo(String string) {
        this.setText(string);
    }

    protected void setEditing(boolean bl) {
        this.editing = bl;
        this.setSelected(bl);
        if (this.editing) {
            this.plan.aladin.view.startTimer(500);
        }
    }

    protected void setDistAngulaireOrig(ViewSimple viewSimple) {
        Projection projection = viewSimple.getProj();
        if (!Projection.isOk(projection)) {
            this.distAngulaireOrig = 0.0;
            return;
        }
        Coord coord = new Coord();
        coord.y = this.dist;
        coord.x = 0.0;
        projection.getCoord(coord);
        this.distAngulaireOrig = Math.abs(coord.del * viewSimple.zoom);
    }

    private boolean isTooSmallForLabel(ViewSimple viewSimple) {
        if (this.distAngulaireOrig == 0.0 || viewSimple.getProj() == null) {
            return false;
        }
        Coord coord = new Coord();
        coord.y = this.dist;
        coord.x = 0.0;
        viewSimple.getProj().getCoord(coord);
        double d = Math.abs(coord.del * viewSimple.zoom);
        return d < this.distAngulaireOrig / 4.0;
    }

    protected boolean isEditing() {
        return this.editing;
    }

    void setWH() {
        this.rect2 = null;
        this.rect1 = new Rectangle(-this.L, -this.L, 2 * this.L, 2 * this.L);
        if (this.hasLabel()) {
            Point point = this.getXYLabel();
            Dimension dimension = this.getDimLabel();
            this.rect2 = new Rectangle(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
            this.rect2.add(this.getXYPoignee());
        } else if (this.isArrow()) {
            this.rect1.add(this.getXYPoignee());
        }
    }

    private boolean isArrow() {
        return this.tag == 5 || this.tag == 6;
    }

    protected boolean isReticle() {
        return this.tag == 1 || this.tag == 0;
    }

    protected boolean hasLabel() {
        return this.id != null && this.id.trim().length() > 0;
    }

    @Override
    protected boolean inside(ViewSimple viewSimple, double d, double d2) {
        return this.rect1.contains(d = (d - this.xv[viewSimple.n]) * viewSimple.zoom, d2 = (d2 - this.yv[viewSimple.n]) * viewSimple.zoom) || !this.isTooSmallForLabel(viewSimple) && this.rect2 != null && this.rect2.contains(d, d2);
    }

    protected boolean onPoignee(ViewSimple viewSimple, double d, double d2) {
        d = (d - this.xv[viewSimple.n]) * viewSimple.zoom;
        d2 = (d2 - this.yv[viewSimple.n]) * viewSimple.zoom;
        Point point = this.getXYPoignee();
        return Math.abs((double)point.x - d) < 4.0 && Math.abs((double)point.y - d2) < 4.0;
    }

    protected boolean onLabel(ViewSimple viewSimple, double d, double d2) {
        if (this.isTooSmallForLabel(viewSimple) || this.rect2 == null) {
            return false;
        }
        d = (d - this.xv[viewSimple.n]) * viewSimple.zoom;
        d2 = (d2 - this.yv[viewSimple.n]) * viewSimple.zoom;
        return this.rect2.contains(d, d2);
    }

    private Rectangle larger(Rectangle rectangle) {
        return new Rectangle(rectangle.x - 4, rectangle.y - 4, rectangle.width + 8, rectangle.height + 8);
    }

    protected boolean onTag(ViewSimple viewSimple, double d, double d2) {
        d = (d - this.xv[viewSimple.n]) * viewSimple.zoom;
        d2 = (d2 - this.yv[viewSimple.n]) * viewSimple.zoom;
        return this.larger(this.rect1).contains(d, d2);
    }

    protected boolean onCorner(ViewSimple viewSimple, double d, double d2) {
        d = (d - this.xv[viewSimple.n]) * viewSimple.zoom;
        d2 = (d2 - this.yv[viewSimple.n]) * viewSimple.zoom;
        Point point = this.getXYCorner();
        return Math.abs((double)point.x - d) < 4.0 && Math.abs((double)point.y - d2) < 4.0;
    }

    protected boolean onViaWheel(ViewSimple viewSimple, double d, double d2) {
        this.on = this.onLabel(viewSimple, d, d2) ? 1 : (this.onTag(viewSimple, d, d2) ? 2 : 0);
        return this.on != 0;
    }

    protected void resetOn() {
        this.on = 0;
    }

    protected void modifyViaWheel(int n) {
        if (this.on == 2) {
            this.modifyTag(n);
        } else if (this.on == 1) {
            this.modifyFond(n);
        }
    }

    protected boolean onViaMouse(ViewSimple viewSimple, double d, double d2) {
        if (!this.hasLabel() && !this.isArrow()) {
            return false;
        }
        this.on = this.onPoignee(viewSimple, d, d2) ? 3 : (this.onCorner(viewSimple, d, d2) ? 4 : 0);
        return this.on != 0;
    }

    protected boolean modifyViaMouse(ViewSimple viewSimple, PointD pointD, PointD pointD2) {
        if (this.on == 3) {
            return this.modifyPoignee(viewSimple, pointD.x, pointD.y);
        }
        if (this.on == 4) {
            double d = pointD.x - pointD2.x;
            pointD2.x = pointD.x;
            return this.modifyCorner(viewSimple, d);
        }
        return false;
    }

    protected boolean modifyPoignee(ViewSimple viewSimple, double d, double d2) {
        double d3;
        double d4 = Math.round(Math.sqrt((d = (d - this.xv[viewSimple.n]) * viewSimple.zoom) * d + (d2 = (d2 - this.yv[viewSimple.n]) * viewSimple.zoom) * d2));
        if (d4 < 3.0) {
            d4 = 3.0;
        }
        double d5 = d3 = d4 == 3.0 ? this.angle : Math.atan2(d2, d);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        } else if (d4 > 300.0) {
            d4 = 300.0;
        }
        if ((double)Math.round(Math.toDegrees(d3)) == Math.toDegrees(this.angle) && this.dist == d4) {
            return false;
        }
        if (this.dist == 0.0 && this.tag == 0) {
            this.tag = 5;
        }
        this.angle = d3;
        this.dist = d4;
        if (this.tag == 7) {
            this.tag = 0;
        }
        this.setWH();
        return true;
    }

    protected boolean modifyCorner(ViewSimple viewSimple, double d) {
        float f;
        float f2 = this.getFont().getSize();
        float f3 = (float)(d * viewSimple.zoom) / 3.0f;
        if (f3 == 0.0f) {
            return false;
        }
        if (this.angle > 1.5707963267948966 && this.angle < 4.71238898038469) {
            f3 = -f3;
        }
        if ((f = f2 + f3) < 7.0f) {
            f = 7.0f;
        } else if (f > 60.0f) {
            f = 60.0f;
        }
        this.setFont(this.getFont().deriveFont(f));
        this.setWH();
        return true;
    }

    protected void modifyTag(int n) {
        this.tag += n;
        if (this.tag < 0) {
            this.tag = TAGS.length - 2;
        } else if (this.tag >= TAGS.length - 1) {
            this.tag = 0;
        }
        this.adjustTagSize();
    }

    private void adjustTagSize() {
        this.L = TAGSIZE[this.tag];
    }

    protected void modifyFond(int n) {
        this.fond += (float)n * 0.2f;
        if (this.fond > 1.0f) {
            this.fond = 0.0f;
            this.bord = this.bord == 0 ? 1 : 0;
        } else if (this.fond < 0.0f) {
            this.fond = 1.0f;
            this.bord = this.bord == 0 ? 1 : 0;
        }
    }

    @Override
    protected void drawSelect(Graphics graphics, ViewSimple viewSimple) {
        if (!this.hasLabel() && !this.isArrow()) {
            super.drawSelect(graphics, viewSimple);
            return;
        }
        Point point = this.getViewCoord(viewSimple, 50, 50);
        Point point2 = this.getXYPoignee();
        int n = point.x + point2.x;
        int n2 = point.y + point2.y;
        graphics.setColor(this.on == 3 ? Color.orange : Color.green);
        Util.fillCircle5(graphics, n, n2);
        graphics.setColor(Color.black);
        Util.drawCircle5(graphics, n, n2);
        if (this.hasLabel()) {
            Point point3 = this.getXYCorner();
            n = point.x + point3.x;
            n2 = point.y + point3.y;
            graphics.setColor(this.on == 4 ? Color.orange : Color.green);
            Util.fillCircle5(graphics, n, n2);
            graphics.setColor(Color.black);
            Util.drawCircle5(graphics, n, n2);
        }
    }

    @Override
    protected Rectangle extendClip(ViewSimple viewSimple, Rectangle rectangle) {
        Point point;
        if (!this.isVisible()) {
            return rectangle;
        }
        if (this.rect1 == null) {
            this.setWH();
        }
        if ((point = this.getViewCoord(viewSimple, 50, 50)) == null) {
            return rectangle;
        }
        int n = 0;
        if (this.isSelected()) {
            n = 4;
        }
        Point point2 = new Point(point.x + this.rect1.x - n, point.y + this.rect1.y - n);
        Point point3 = new Point(point.x + this.rect1.x + this.rect1.width + n, point.y + this.rect1.y + this.rect1.height + n);
        if (rectangle == null) {
            rectangle = new Rectangle(point2.x, point2.y, point3.x - point2.x + 1, point3.y - point2.y + 1);
        } else {
            rectangle.add(point2);
            rectangle.add(point3);
        }
        if (this.hasLabel() && this.rect2 != null) {
            point2 = new Point(point.x + this.rect2.x - n, point.y + this.rect2.y - n);
            point3 = new Point(point.x + this.rect2.x + this.rect2.width + n, point.y + this.rect2.y + this.rect2.height + n);
            rectangle.add(point2);
            rectangle.add(point3);
        }
        return rectangle;
    }

    @Override
    public Color getColor() {
        if (!this.isVisible()) {
            return null;
        }
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.plan != null && this.plan.type == 10) {
            this.couleur = ((PlanField)this.plan).getColor(this);
            if (this.couleur == null) {
                return this.plan.c;
            }
            return this.couleur;
        }
        if (this.plan != null) {
            return this.plan.c;
        }
        return Color.black;
    }

    private Point getXYAncrage() {
        if (this.isReticle()) {
            int n = 0;
            int n2 = 0;
            if (this.angle <= 0.7853981633974483 || this.angle >= 5.497787143782138) {
                n = this.L;
            } else if (this.angle >= 2.356194490192345 && this.angle <= 3.9269908169872414) {
                n = -this.L;
            }
            if (this.angle > 0.7853981633974483 && this.angle < 2.356194490192345) {
                n2 = this.L;
            } else if (this.angle > 3.9269908169872414 && this.angle < 5.497787143782138) {
                n2 = -this.L;
            }
            return new Point(n, n2);
        }
        return new Point((int)Math.round((double)this.L * Math.cos(this.angle)), (int)Math.round((double)this.L * FastMath.sin(this.angle)));
    }

    private Point getXYPoignee() {
        return new Point((int)Math.round(this.dist * Math.cos(this.angle)), (int)Math.round(this.dist * FastMath.sin(this.angle)));
    }

    protected Font getFont() {
        double d;
        double d2 = d = this.plan != null ? (double)this.plan.getScalingFactor() : 1.0;
        if (d == 1.0) {
            return this.F;
        }
        float f = this.F.getSize();
        f = (float)((double)f * d);
        return this.F.deriveFont(f);
    }

    private void setFont(Font font) {
        this.F = font;
    }

    @Override
    public void setColor(Color color) {
        this.couleur = color;
    }

    private Dimension getDimLabel() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n = 0;
        int n2 = 0;
        if (!this.hasLabel()) {
            return new Dimension(n2, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.id, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            n += fontMetrics.getHeight();
            int n3 = fontMetrics.stringWidth(stringTokenizer.nextToken());
            if (n3 <= n2) continue;
            n2 = n3;
        }
        if (this.id.charAt(this.id.length() - 1) == '\n') {
            n += fontMetrics.getHeight();
        }
        return new Dimension(n2, n);
    }

    private Point getXYLabel() {
        Point point = this.getXYPoignee();
        int n = (this.tag == 7 ? 0 : this.accroche) + this.getDimLabel().width / 2;
        point.x = point.x + (this.angle > 1.5707963267948966 && this.angle < 4.71238898038469 ? -n : n);
        return point;
    }

    private Point getXYCorner() {
        Point point = this.getXYLabel();
        Dimension dimension = this.getDimLabel();
        int n = 3;
        point.x = this.angle > 1.5707963267948966 && this.angle < 4.71238898038469 ? (point.x -= dimension.width / 2 - n) : (point.x += dimension.width / 2 - n);
        point.y = this.angle > Math.PI && this.angle < Math.PI * 2 ? (point.y -= dimension.height / 2 - n) : (point.y += dimension.height / 2 - n);
        return point;
    }

    private Point getXYLastChar() {
        Dimension dimension = this.getDimLabel();
        Point point = this.getXYLabel();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        boolean bl = this.angle > 1.5707963267948966 && this.angle < 4.71238898038469;
        int n = point.y - dimension.height / 2 + fontMetrics.getAscent();
        Point point2 = new Point(point.x, n - 7);
        if (!this.hasLabel()) {
            return point2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.id, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            point2.x = point.x + (bl ? dimension.width / 2 : -dimension.width / 2 + fontMetrics.stringWidth(string));
            point2.y = n;
            n += fontMetrics.getHeight();
        }
        if (this.id.charAt(this.id.length() - 1) == '\n') {
            point2.y += fontMetrics.getHeight();
            point2.x = point.x + (bl ? dimension.width / 2 : -dimension.width / 2);
        }
        return point2;
    }

    protected void drawLabel(Graphics graphics, int n, int n2) {
        Dimension dimension = this.getDimLabel();
        Point point = this.getXYLabel();
        if (this.fond != 0.0f) {
            Util.drawArea(this.plan.aladin, graphics, point.x - (dimension.width + 4) / 2 + n, point.y - (dimension.height + 4) / 2 + n2, dimension.width + 4, dimension.height + 4, Color.white, this.fond * this.plan.getOpacityLevel(), false);
        }
        if (this.bord == 1) {
            graphics.drawRect(point.x - (dimension.width + 4) / 2 + n, point.y - (dimension.height + 4) / 2 + n2, dimension.width + 4, dimension.height + 4);
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        boolean bl = this.angle > 1.5707963267948966 && this.angle < 4.71238898038469;
        int n3 = point.y - dimension.height / 2 + fontMetrics.getAscent();
        StringTokenizer stringTokenizer = new StringTokenizer(this.id, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n4 = point.x + (bl ? dimension.width / 2 - fontMetrics.stringWidth(string) : -dimension.width / 2);
            graphics.drawString(string, n + n4, n2 + n3);
            if (this.fond == 0.0f) {
                Util.drawStringOutline(graphics, string, n + n4, n2 + n3, null, Color.black);
            } else {
                graphics.drawString(string, n + n4, n2 + n3);
            }
            n3 += fontMetrics.getHeight();
        }
    }

    private void drawHampe(Graphics graphics, int n, int n2) {
        if (this.tag == 7 || this.dist <= 3.0) {
            return;
        }
        Point point = this.getXYAncrage();
        Point point2 = this.getXYPoignee();
        if (this.isArrow()) {
            Util.drawFleche(graphics, n + point2.x, n2 + point2.y, n + point.x, n2 + point.y, this.tag == 6 ? 10 : 6, null);
        } else {
            graphics.drawLine(n + point2.x, n2 + point2.y, n + point.x, n2 + point.y);
        }
        if (this.hasLabel() || this.editing) {
            int n3 = this.angle > 1.5707963267948966 && this.angle < 4.71238898038469 ? -(this.accroche - 3) : this.accroche - 3;
            graphics.drawLine(n + point2.x, n2 + point2.y, n + point2.x + n3, n2 + point2.y);
        }
    }

    private void drawCaret(Graphics graphics, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = System.currentTimeMillis() / 500L % 2L == 0L;
        if (!bl) {
            return;
        }
        Color color = graphics.getColor();
        Point point = this.getXYLastChar();
        int n3 = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).getHeight();
        graphics.setColor(Color.black);
        graphics.drawLine(n += point.x, (n2 += point.y) + 2, n, n2 - n3 + 2);
        graphics.setColor(Color.white);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n2 - n3 + 2);
        graphics.setColor(color);
    }

    private void drawMiniFleche(Graphics graphics, int n, int n2) {
        int n3 = this.L;
        this.L = 10;
        Point point = this.getXYAncrage();
        this.L = n3;
        Util.drawFleche(graphics, n + point.x, n2 + point.y, n, n2, 4, null);
    }

    private void drawTag(Graphics graphics, int n, int n2) {
        if (this.tag == 7) {
            return;
        }
        if (this.dist < 3.0 && this.hasLabel() && !this.isEditing()) {
            return;
        }
        switch (this.tag) {
            case 0: 
            case 1: {
                graphics.drawLine(n - this.L, n2, n - 2, n2);
                graphics.drawLine(n + 2, n2, n + this.L, n2);
                graphics.drawLine(n, n2 - this.L, n, n2 - 2);
                graphics.drawLine(n, n2 + 2, n, n2 + this.L);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.L < 3) {
                    Util.drawCircle5(graphics, n, n2);
                    break;
                }
                if (this.L <= 4) {
                    Util.drawCircle8(graphics, n, n2);
                    break;
                }
                graphics.drawOval(n - this.L, n2 - this.L, this.L * 2, this.L * 2);
            }
        }
    }

    @Override
    protected boolean draw(Graphics graphics, ViewSimple viewSimple, int n, int n2) {
        if (!this.isVisible()) {
            return false;
        }
        Point point = this.getViewCoord(viewSimple, 50, 50);
        if (point == null) {
            return false;
        }
        point.x += n;
        point.y += n2;
        graphics.setFont(this.getFont());
        graphics.setColor(this.getColor());
        boolean bl = this.isTooSmallForLabel(viewSimple);
        this.drawTag(graphics, point.x, point.y);
        if (bl) {
            if (this.isArrow()) {
                this.drawMiniFleche(graphics, point.x, point.y);
            }
            return true;
        }
        if (this.hasLabel() || this.isArrow()) {
            this.drawHampe(graphics, point.x, point.y);
            if (this.hasLabel() && !bl) {
                this.drawLabel(graphics, point.x, point.y);
            }
        }
        if (this.editing) {
            this.drawHampe(graphics, point.x, point.y);
            this.drawCaret(graphics, point.x, point.y);
        }
        if (this.isSelected()) {
            if (this.plan != null && this.plan.type == 10) {
                return true;
            }
            this.drawSelect(graphics, viewSimple);
        }
        return true;
    }
}

