/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.tools.Util;

public final class Tok {
    private char[] a;
    private int i;
    private char c;
    private String separator;
    private char lastSeparator = '\u0000';
    private StringBuffer curTok = new StringBuffer();
    private static String TEST = "global color=green dashlist=8 3 width=1 font=\"helvetica 10 normal\" select=1 file=\"\\Root\\file\"";
    private static String TEST1 = "global(color=green,dashlist=8,3,width=1,\"font=\\\"helvetica 10 normal\\\"\",select=1)";
    private static String TEST2 = "box(83.468685,22.0908,163.33361\",367.7002\",96.508724)";

    public Tok(String string) {
        this(string, null);
    }

    public Tok(String string, String string2) {
        this.separator = string2;
        this.a = string.toCharArray();
        this.i = 0;
    }

    public static String quote(String string) {
        return Tok.quote(string, false);
    }

    public static String quote(String string, boolean bl) {
        int n;
        char[] cArray = string.toCharArray();
        if (!bl) {
            for (n = 0; n < cArray.length && !Character.isSpace(cArray[n]) && cArray[n] != ',' && cArray[n] != '\\' && cArray[n] != '\'' && cArray[n] != '\"'; ++n) {
            }
            if (n == cArray.length) {
                return string;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        stringBuilder.append('\"');
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] == '\"' || cArray[n] == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(cArray[n]);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private String unQuote(StringBuffer stringBuffer) {
        return Tok.unQuote(stringBuffer.toString());
    }

    public static String unQuote(String string) {
        int n = string.length();
        if (n < 2) {
            return string;
        }
        char c = string.charAt(0);
        if (c != '\"' && c != '\'' || c != string.charAt(n - 1)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        boolean bl = false;
        for (int i = 1; i < n - 1; ++i) {
            c = cArray[i];
            if (bl && (c == '\"' || c == '\'' || c == '\\')) {
                stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), c + "");
            } else {
                stringBuffer.append(c);
            }
            bl = c == '\\';
        }
        return stringBuffer.toString();
    }

    public int countTokens() {
        int n = this.i;
        int n2 = 0;
        while (this.nextToken().length() > 0) {
            ++n2;
        }
        this.i = n;
        return n2;
    }

    public String[] getStrings() {
        String[] stringArray = new String[this.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.nextToken();
        }
        return stringArray;
    }

    public boolean hasMoreTokens() {
        return this.i < this.a.length;
    }

    public int getPos() {
        return this.i;
    }

    private boolean isSeparator(char c) {
        boolean bl = false;
        if (this.separator == null) {
            bl = Character.isSpace(c);
        } else {
            boolean bl2 = bl = this.separator.indexOf(c) >= 0;
        }
        if (bl) {
            this.lastSeparator = c;
        }
        return bl;
    }

    public char getLastSeparator() {
        return this.lastSeparator;
    }

    public String nextToken() {
        Util.resetString(this.curTok);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        while (this.i < this.a.length) {
            if (!(bl2 || this.a[this.i] != '\"' && this.a[this.i] != '\'')) {
                if (!bl && bl3) {
                    this.c = this.a[this.i];
                    bl = true;
                } else if (this.a[this.i] == this.c) {
                    bl = false;
                }
            }
            boolean bl4 = bl2 = this.a[this.i] == '\\';
            if (!bl && this.isSeparator(this.a[this.i])) {
                while (++this.i < this.a.length && this.isSeparator(this.a[this.i])) {
                }
                return this.unQuote(this.curTok);
            }
            bl3 = false;
            this.curTok.append(this.a[this.i]);
            ++this.i;
        }
        return this.unQuote(this.curTok);
    }

    public static void main(String[] stringArray) {
        System.out.println("==> " + TEST2);
        Tok tok = new Tok(TEST2, "( ,)");
        StringBuffer stringBuffer = new StringBuffer(tok.nextToken() + "(");
        boolean bl = true;
        while (tok.hasMoreTokens()) {
            if (!bl) {
                stringBuffer.append(',');
            }
            bl = false;
            String string = tok.nextToken();
            String string2 = Tok.quote(string);
            System.out.println(string + " ==> " + string2);
            stringBuffer.append(string2);
        }
        stringBuffer.append(')');
        System.out.println("==> " + stringBuffer);
    }
}

