/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Cote;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanContour;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanMoc;
import cds.aladin.SourceStat;
import cds.aladin.SwingWidgetFinder;
import cds.aladin.Tag;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.tools.Util;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public final class ToolBox
extends JComponent
implements MouseMotionListener,
MouseListener,
SwingWidgetFinder,
Widget {
    static int NUMBERTOOL = 0;
    static final int SELECT = 0;
    static final int DRAW = 1;
    static final int TAG = 2;
    static final int PHOT = 3;
    static final int DIST = 4;
    static final int DEL = 5;
    static final int WEN = 6;
    static final int PROP = 7;
    static final int PAN = 8;
    public static final int HIST = 9;
    static final int BNOTE = 10;
    static final int RGB = 11;
    static final int CONTOUR = 12;
    static final int FILTER = 13;
    static final int SYNC = 14;
    static final int BLINK = 15;
    static final int ZOOM = 16;
    static final int XMATCH = 17;
    static final int RESAMP = 18;
    static final int CROP = 19;
    static final int PLOT = 20;
    static int NBTOOL = 21;
    private int[] drawn = new int[]{0, 8, 16, 4, 3, 1, 2, 13, 20, 11, 19, 12, 9, 7, 5};
    static int[] OUTREACHDRAWN = new int[]{0, 8, 4, 3, 1, 2, 12, 9, 7, 5};
    static int[] to = new int[]{19, 0, 1, 2, 3, 4, 8, 7, 16};
    static int[] exc = new int[]{19, 0, 1, 2, 3, 4, 8, 16};
    static int[] forTool = new int[]{1, 2, 3, 4};
    static int[] up = new int[]{10, 5, 7, 13, 20};
    static int[] imgmode = new int[]{20};
    static int[] imghugemode = new int[]{11, 15, 6, 20};
    static int[] contourmode = new int[]{9, 1, 2, 3, 4, 19, 20};
    static int[] toolmode = new int[]{9, 19, 20};
    static int[] catmode = new int[]{9, 19};
    static int[] fieldmode = new int[]{9, 19, 20};
    static int W = 34;
    static int HMIN = W - 5;
    static int HREC = W + 2;
    static int L = 3;
    static int ICONEGAP = 12;
    String ICONEBAR;
    String DRAWING;
    Aladin aladin;
    Calque calque;
    int ws = W;
    int hs = 600;
    int nc;
    int nb;
    int H;
    public Tool[] tool;
    boolean flagDelAll;
    private boolean firstTag = true;
    private boolean firstRepere = true;
    private int oc = 0;
    private int currentButton = -1;
    private int oldCurrentButton = -1;
    private WidgetControl voc = null;

    protected ToolBox(Aladin aladin) {
        this.aladin = aladin;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.ICONEBAR = Aladin.chaine.getString("TBBAR");
        this.DRAWING = Aladin.chaine.getString("TBDRAW");
        if (Aladin.OUTREACH) {
            this.drawn = OUTREACHDRAWN;
        }
        this.calcConf(500 - ICONEGAP);
        this.init();
    }

    protected void init() {
        this.tool = new Tool[NBTOOL];
        for (int i = 0; i < NBTOOL; ++i) {
            this.tool[i] = new Tool(i, this.aladin);
        }
    }

    protected int getTool() {
        for (int i = 0; i < to.length; ++i) {
            if (this.tool[ToolBox.to[i]].mode != -1) continue;
            return to[i];
        }
        return -1;
    }

    protected Obj newTool(Plan plan, ViewSimple viewSimple, double d, double d2) {
        int n = this.getTool();
        switch (n) {
            case 1: {
                Ligne ligne = new Ligne(plan, viewSimple, d, d2);
                ligne.bout = (byte)4;
                return ligne;
            }
            case 2: {
                if (this.firstTag && this.aladin.configuration.isHelp() && this.aladin.configuration.showHelpIfOk("TAGINFO")) {
                    this.firstTag = false;
                    return null;
                }
                return new Tag(plan, viewSimple, d, d2);
            }
            case 3: {
                if (this.firstRepere && this.aladin.configuration.isHelp() && this.aladin.calque.getPlanBase().hasAvailablePixels() && this.aladin.configuration.showHelpIfOk("REPEREINFO")) {
                    this.firstRepere = false;
                    return null;
                }
                SourceStat sourceStat = new SourceStat(plan, viewSimple, d, d2, null);
                return sourceStat;
            }
            case 4: {
                return new Cote(plan, viewSimple, d, d2);
            }
        }
        return null;
    }

    protected void setMode(int n, int n2) {
        if (this.tool[n].mode == n2) {
            return;
        }
        this.tool[n].mode = n2;
        this.repaint();
    }

    protected void setGraphicButton(int n) {
        this.tool[0].mode = 1;
        this.tool[4].mode = 1;
        this.tool[3].mode = 1;
        this.tool[2].mode = 1;
        this.tool[1].mode = 1;
        this.tool[n].mode = -1;
        this.repaint();
    }

    protected void toolMode() {
        this.toolMode(true);
    }

    protected void toolMode(boolean bl) {
        Plan plan;
        ViewSimple viewSimple;
        int n;
        Plan[] planArray = this.aladin.calque.getPlans();
        int[] nArray = new int[NBTOOL];
        int[] nArray2 = new int[NBTOOL];
        int[] nArray3 = new int[]{};
        boolean bl2 = true;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.aladin.setMemory();
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.tool[n].mode;
            nArray2[n] = 0;
        }
        for (n = 0; n < planArray.length; ++n) {
            if (planArray[n].type == 0 || !planArray[n].flagOk) continue;
            if (planArray[n].isPixel() || planArray[n] instanceof PlanImageRGB) {
                ++n2;
            }
            if (planArray[n] instanceof PlanImageBlink) {
                ++n3;
            }
            if (planArray[n].type == 8) {
                ++n4;
            }
            if (planArray[n].isCatalog()) {
                ++n5;
            }
            bl2 = false;
            if (!planArray[n].selected) continue;
            switch (planArray[n].type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 16: 
                case 20: {
                    nArray3 = imgmode;
                    break;
                }
                case 15: {
                    nArray3 = imghugemode;
                    break;
                }
                case 8: 
                case 18: {
                    nArray3 = catmode;
                    break;
                }
                case 9: {
                    nArray3 = toolmode;
                    break;
                }
                case 10: {
                    nArray3 = fieldmode;
                    break;
                }
                case 13: {
                    nArray3 = fieldmode;
                    break;
                }
                case 12: {
                    nArray3 = contourmode;
                }
            }
            if (planArray[n] instanceof PlanContour) {
                nArray3 = contourmode;
            }
            for (int i = 0; i < nArray2.length; ++i) {
                boolean bl4 = false;
                for (int j = 0; j < nArray3.length; ++j) {
                    if (i != nArray3[j]) continue;
                    bl4 = true;
                    break;
                }
                if (bl4) continue;
                nArray2[i] = 1;
            }
        }
        if (n5 == 0) {
            nArray2[13] = 0;
        }
        if (n4 < 1) {
            nArray2[17] = 0;
        }
        if (n2 < 2) {
            nArray2[15] = 0;
            nArray2[11] = 0;
        }
        if ((viewSimple = this.aladin.view.getCurrentView()) == null || viewSimple.isFree() || !viewSimple.pref.isPixel()) {
            nArray2[12] = 0;
        }
        if (this.aladin.calque.getFirstSelectedPlan() instanceof PlanMoc) {
            nArray2[19] = 1;
        }
        if ((plan = this.aladin.calque.getFirstSelectedPlan()) == null || !plan.isPixel() && plan.type != 2 && plan.type != 16) {
            nArray2[9] = 0;
        }
        if (viewSimple != null && !viewSimple.isFree() && (viewSimple.pref instanceof PlanBG || viewSimple.northUp)) {
            nArray2[6] = 0;
        }
        if (bl2) {
            for (n = 0; n < nArray2.length; ++n) {
                nArray2[n] = 0;
            }
        }
        if (!this.aladin.calque.isFree()) {
            nArray2[5] = 1;
            nArray2[7] = 1;
        }
        for (n = 0; n < nArray2.length; ++n) {
            if (nArray2[n] == 1 && nArray[n] == -1) {
                nArray2[n] = -1;
            }
            if (nArray2[n] != nArray[n]) {
                bl3 = true;
            }
            this.tool[n].setMode(nArray2[n]);
        }
        if (!bl2) {
            boolean bl5 = false;
            for (n = 0; n < exc.length; ++n) {
                if (nArray2[exc[n]] != -1) continue;
                bl5 = true;
            }
            if (!bl5) {
                this.tool[0].setMode(-1);
                bl3 = true;
            }
        }
        if (bl && bl3) {
            this.repaint();
        }
    }

    protected boolean isExcTool(int n) {
        for (int i = 0; i < exc.length; ++i) {
            if (n != exc[i]) continue;
            return true;
        }
        return false;
    }

    protected static boolean isForTool(int n) {
        for (int i = 0; i < forTool.length; ++i) {
            if (n != forTool[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = this.getToolNumber(n2, n = mouseEvent.getY());
        if (n3 < 0) {
            return;
        }
        if (n3 == 19) {
            if (this.tool[n3].mode != -1) {
                if (this.aladin.view.crop != null) {
                    this.aladin.view.crop.setVisible(false);
                } else if (this.aladin.view.crop != null) {
                    this.aladin.view.crop.reset();
                }
            }
            this.aladin.view.repaintAll();
        }
        if (n3 != 9 && n3 != 14 && n3 != 17 && this.tool[n3].mode != -1) {
            return;
        }
        switch (n3) {
            case 7: {
                if (this.aladin.view.isPropObjet()) {
                    this.aladin.view.propSelectedObj();
                    break;
                }
                this.aladin.calque.select.propertiesOfSelectedPlanes();
                break;
            }
            case 9: {
                this.aladin.updatePixel();
                break;
            }
            case 11: {
                this.aladin.updateRGB();
                break;
            }
            case 15: {
                this.aladin.updateBlink(0);
                break;
            }
            case 17: {
                if (this.tool[n3].mode == -1) {
                    this.aladin.xmatch();
                    break;
                }
                if (this.aladin.frameCDSXMatch == null) break;
                this.aladin.frameCDSXMatch.setVisible(false);
                break;
            }
            case 20: {
                if (this.tool[n3].mode != -1) break;
                this.aladin.createPlotCat();
                break;
            }
            case 12: {
                this.aladin.updateContour();
                break;
            }
            case 13: {
                this.aladin.filter();
                break;
            }
            case 5: {
                if (this.aladin.view.isDelSelObjet()) {
                    this.aladin.view.delSelObjet();
                    break;
                }
                if (mouseEvent.isShiftDown()) {
                    this.aladin.reset();
                    this.tool[5].setMode(0);
                    this.aladin.console.printCommand("reset");
                    break;
                }
                if (this.aladin.view.isViewSelected() && this.aladin.view.isMultiView()) {
                    this.aladin.view.freeSelected();
                    this.aladin.dialog.resume();
                    this.aladin.calque.repaintAll();
                    break;
                }
                this.aladin.calque.FreeSet(true);
                this.aladin.dialog.resume();
            }
        }
        for (int i = 0; i < up.length; ++i) {
            if (up[i] != n3) continue;
            this.tool[n3].Push();
            break;
        }
        this.handCursor();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = this.getToolNumber(n2, n = mouseEvent.getY());
        if (n3 < 0) {
            return;
        }
        if (this.tool[n3].mode == 0) {
            return;
        }
        this.waitCursor();
        if (this.isExcTool(n3)) {
            for (int i = 0; i < exc.length; ++i) {
                if (exc[i] == n3 || this.tool[ToolBox.exc[i]].mode != -1) continue;
                this.tool[exc[i]].setMode(1);
            }
        }
        this.tool[n3].Push();
        this.repaint();
    }

    private void handCursor() {
        this.makeCursor(2);
    }

    private void waitCursor() {
        this.makeCursor(1);
    }

    private void defaultCursor() {
        this.makeCursor(0);
    }

    private void makeCursor(int n) {
        if (this.oc == n) {
            return;
        }
        if (Aladin.makeCursor(this, n)) {
            this.oc = n;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.oc = -1;
        int n = this.getTool();
        this.showCurrentButton(-1);
        if (n == 16 || n == 2) {
            this.setMode(n, 1);
            this.setMode(0, -1);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.oc = -1;
        this.currentButton = -1;
        Aladin.makeCursor(this, 0);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.aladin.inHelp) {
            int n3 = n2 >= this.hs - 2 * L ? -2 : this.getToolNumber(n, n2);
            this.aladin.help.setText(this.Help(n3));
            return;
        }
        int n4 = this.getToolNumber(n, n2);
        if (n4 < 0) {
            return;
        }
        if (this.tool[n4].mode != 0) {
            this.handCursor();
        } else {
            this.defaultCursor();
        }
        String string = this.tool[n4].getInfo();
        Util.toolTip(this, Util.fold(string, 20, true));
        this.showCurrentButton(n4);
    }

    protected int getToolNumber(int n, int n2) {
        for (int i = 0; i < this.drawn.length; ++i) {
            if (!this.tool[this.drawn[i]].in(n, n2)) continue;
            return this.drawn[i];
        }
        return -1;
    }

    private int getToolOrder(int n) {
        for (int i = 0; i < this.drawn.length; ++i) {
            if (this.drawn[i] != n) continue;
            return i;
        }
        return -1;
    }

    protected void drawButton(int n, int n2, Graphics graphics, boolean bl) {
        int n3 = n / this.nb * W;
        int n4 = n % this.nb * this.H;
        this.tool[n2].drawIcone(graphics, n3, n4, bl);
    }

    protected void calcConf(int n) {
        int n2 = 0;
        int n3 = this.drawn.length;
        this.nc = 1;
        while (this.nc < 50) {
            n2 = n3 / this.nc;
            if (n3 % this.nc != 0) {
                ++n2;
            }
            this.H = n / n2;
            if (this.H >= HMIN) break;
            ++this.nc;
        }
        this.H = HREC;
        while (this.H > HMIN && this.H * n2 >= n) {
            --this.H;
        }
        this.nb = n / this.H;
        if (this.nb < 1) {
            this.nb = 1;
            n = this.H;
        }
        this.ws = this.ws = this.nc * W;
        this.hs = n + ICONEGAP;
        super.setSize(this.ws, n + ICONEGAP);
        Tool.resize(W, this.H);
    }

    private void showCurrentButton(int n) {
        if (this.oldCurrentButton == n) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (this.oldCurrentButton >= 0) {
            this.drawButton(this.getToolOrder(this.oldCurrentButton), this.oldCurrentButton, graphics, false);
        }
        this.oldCurrentButton = this.currentButton = n;
        if (this.currentButton >= 0) {
            this.drawButton(this.getToolOrder(this.currentButton), this.currentButton, graphics, true);
        }
    }

    @Override
    public void setSize(int n, int n2) {
        this.calcConf(n2 - ICONEGAP);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.getSize().width != this.ws || this.getSize().height != this.hs) {
            this.calcConf(this.getSize().height - ICONEGAP);
        }
        this.aladin.setAliasing(graphics);
        for (int i = 0; i < this.drawn.length; ++i) {
            this.drawButton(i, this.drawn[i], graphics, this.currentButton == i);
        }
        this.showCurrentButton(this.currentButton);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.ws, this.hs);
    }

    protected String Help(int n) {
        if (n == -1) {
            return Aladin.chaine.getString("ToolBox.HELP1");
        }
        if (n == -2) {
            return Aladin.chaine.getString("ToolBox.HELP2");
        }
        return Aladin.chaine.getString("ToolBox.HELP1") + "\n!Tool: " + Tool.label[n] + "\n" + Aladin.chaine.getString("Tool." + Tool.label[n]) + "\n";
    }

    @Override
    public boolean findWidget(String string) {
        return string.equalsIgnoreCase("contour") || string.equalsIgnoreCase("filter") || string.equalsIgnoreCase("rgb");
    }

    @Override
    public Point getWidgetLocation(String string) {
        for (int i = 0; i < this.drawn.length; ++i) {
            if (!string.equalsIgnoreCase(this.tool[this.drawn[i]].nom)) continue;
            return this.tool[this.drawn[i]].getWidgetLocation();
        }
        return new Point(0, 0);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int n, int n2, int n3, int n4, float f, JComponent jComponent) {
        this.voc = new WidgetControl(this, n, n2, n3, n4, f, jComponent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics graphics) {
        Tool.drawVOPointer(graphics, 10, 5);
    }
}

