/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.BasicNode;
import cds.aladin.BasicTree;
import cds.aladin.Coord;
import cds.aladin.Fov;
import cds.aladin.MetaDataTree;
import cds.aladin.ResourceNode;
import cds.aladin.SIAPExtBuilder;
import cds.aladin.Server;
import cds.aladin.TreeView;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCStringParser;
import cds.astro.Astrocoo;
import cds.astro.Coo;
import cds.savot.model.FieldSet;
import cds.savot.model.InfoSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotField;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotSet;
import cds.savot.model.SavotTD;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.pull.SavotPullEngine;
import cds.savot.pull.SavotPullParser;
import cds.tools.Util;
import java.awt.Color;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class TreeBuilder {
    static final int VOTABLE_IDHA = 0;
    static final int VIZIER = 1;
    static final int SIAP = 2;
    static final int SSA = 3;
    static final int SIAP_EVOL = 4;
    static final int SIAP_EXT = 5;
    private int indexCriteria = 0;
    private int indexValue = 1;
    private static final String SIAP_IMAGE_TITLE = "VOX:Image_Title";
    private static final String SIAP_IMAGE_TITLE2 = "OBS_ID";
    protected static final String SIAP_RA = "POS_EQ_RA_MAIN";
    protected static final String SIAP_DE = "POS_EQ_DEC_MAIN";
    private static final String SSAP_UTYPE_SPATIAL_COVERAGE = "Char.SpatialAxis.Coverage.Location.Value";
    protected static final String SIAP_RA_UCD1P = "pos.eq.ra;meta.main";
    protected static final String SIAP_DE_UCD1P = "pos.eq.dec;meta.main";
    private static final String SIAP_SCALE = "VOX:Image_Scale";
    private static final String SIAP_NAXIS = "VOX:Image_Naxis";
    private static final String SIAP_IMAGE_FORMAT = "VOX:Image_Format";
    private static final String SIAP_URL = "VOX:Image_AccessReference";
    private static final String SIAP_URL2 = "DATA_LINK";
    private static final String FORMAT = "FORMAT";
    private static final String ESAC_AXES = "VOX:Spectrum_axes";
    private static final String ESAC_UNITS = "VOX:Spectrum_units";
    private static final String ESAC_DIMEQ = "VOX:Spectrum_dimeq";
    private static final String ESAC_SCALEQ = "VOX:Spectrum_scaleq";
    protected static final String MAPPARAM = "MapPare";
    protected static final String SIAP_BANDPASS_ID = "VOX:BandPass_ID";
    private static final String FOOTPRINT_REF_UTYPE = "dal:footprint.geom.id";
    private static final String RESTYPE = "resourceType";
    private static final String IDSURVEY = "ObservingProgram";
    private static final String IDBAND = "Observation_Group";
    private static final String IDIMAGE = "Observation";
    private static final String IDMAPPING = "StorageMapping";
    private static final String IDSTORED = "StoredImage";
    private static final String OBS_NAME = "Observation_Name";
    private static final String CUTOUT = "CUTOUTS";
    private static final String AVAILABLE_CODINGS = "COMPRESSION";
    private static final String AVAILABLE_PROCESSINGS = "MODE";
    private static final String OBS_DATE = "date";
    private static final String ORIGIN = "Origin";
    private static final String INDEXING = "Indexing";
    protected static final String NB_OF_PATCHES = "number";
    private static final String RESOLUTION = "RESOLUTION";
    private static final String MACHINE = "MACHINE";
    private static final String MAX_SIZE = "size";
    private static final String LOCATION = "Location";
    private static final String GLULINK = "GLink";
    private static final String FILTER_NAME = "Filter_Name";
    private static final String UTYPE_DM_SSA = "Dataset.DataModel";
    private static final String UTYPE_DSLENGTH_SSA = "Dataset.Length";
    private static final String UTYPE_ACREF_SSA = "Access.Reference";
    private static final String UTYPE_DATATITLE_SSA = "DataID.Title";
    private static final String UCD1P_TITLE = "meta.title";
    public static final String UTYPE_STCS_REGION1 = "stc:ObservationLocation.AstroCoordArea.Region";
    public static final String UTYPE_STCS_REGION2 = "Char.SpatialAxis.Coverage.Support.Area";
    private double xVal;
    private double yVal;
    private double alphaVal;
    private double deltaVal;
    private double[] xValTab;
    private double[] yValTab;
    String[] descFilter;
    double angleVal = Double.NaN;
    private int type;
    private Server server = null;
    private static Color[] colTab = new Color[]{Color.green, Color.orange, Color.magenta, Color.cyan, Color.pink};
    private static int colorNb = 0;
    private ResourceNode nodeMemo;
    private Color fovColor;
    private double maxSize;
    private double pixSize;
    private String pixSizeUnit = "";
    private Astrocoo frame = new Astrocoo();
    String nameSiapEvolStr;
    private InputStream is;
    private URL url;
    private String file;
    private SavotPullParser savotParser;
    private String objet;
    private String targetObjet;
    private Coord targetObjetCoo;
    private String error;
    protected String[] sortItems;
    private int nameIndex = 0;
    private String currentSurvey;
    private String currentColor;
    private String currentWavelength;
    private String currentFilterName;
    private FieldSet surveyFieldSet;
    private FieldSet bandFieldSet;
    private FieldSet imageFieldSet;
    private FieldSet filterFieldSet;
    private FieldSet mappingFieldSet;
    private FieldSet storedFieldSet;
    private Hashtable fieldSetMapping = new Hashtable();
    Aladin aladin;
    private String targetFound = null;
    private String requestedPos;
    Hashtable ACSFilters = new Hashtable();
    Hashtable fieldsPool = new Hashtable();
    int myIndexRA;
    int myIndexDE;

    TreeBuilder(Aladin aladin, URL uRL, int n, Server server, String string) {
        this.aladin = aladin;
        this.url = uRL;
        this.type = n;
        this.server = server;
        this.objet = string;
    }

    TreeBuilder(Aladin aladin, String string) {
        this.aladin = aladin;
        this.objet = string;
    }

    TreeBuilder(Aladin aladin, InputStream inputStream, int n, Server server, String string) {
        this.aladin = aladin;
        this.is = inputStream;
        this.type = n;
        this.server = server;
        this.objet = string;
    }

    private void suite() {
        if (this.objet == null && this.server != null && this.server.target != null) {
            this.objet = this.server.target.getText();
        }
        this.targetObjet = TreeView.resolveTarget(this.objet, this.aladin);
        this.targetObjetCoo = TreeView.resolveTargetCoo(this.objet, this.aladin);
        this.createSavotParser();
    }

    protected boolean mayBeSSA(SavotVOTable savotVOTable) {
        SavotResource savotResource = (SavotResource)savotVOTable.getResources().getItemAt(0);
        InfoSet infoSet = savotResource.getInfos();
        for (int i = 0; i < infoSet.getItemCount(); ++i) {
            SavotInfo savotInfo = (SavotInfo)infoSet.getItemAt(i);
            if (!savotInfo.getContent().equals("SSAP")) continue;
            return true;
        }
        if (savotResource.getFieldSet(0) == null || savotResource.getFieldSet(0).getItems() == null) {
            return false;
        }
        Enumeration<Object> enumeration = savotResource.getFieldSet(0).getItems().elements();
        while (enumeration.hasMoreElements()) {
            SavotField savotField = (SavotField)enumeration.nextElement();
            String string = this.stripNSForUtype(savotField.getUtype().trim());
            String string2 = savotField.getUcd();
            if ((!string.equalsIgnoreCase(UTYPE_ACREF_SSA) || string2.equalsIgnoreCase(SIAP_URL)) && !string.equalsIgnoreCase(UTYPE_DM_SSA) && !string.equalsIgnoreCase(UTYPE_DSLENGTH_SSA)) continue;
            return true;
        }
        return false;
    }

    private void detectFormat() {
        Object object;
        Object object2;
        String string;
        String string2 = this.file != null ? this.file : (string = this.url != null ? this.url.toString() : "stream");
        if (this.type >= 0) {
            Aladin.trace(3, "detect format of " + string + ": format was already specified");
            return;
        }
        SavotResource savotResource = (SavotResource)this.savotParser.getVOTable().getResources().getItemAt(0);
        int n = this.savotParser.getVOTable().getResources().getItemCount();
        SavotResource savotResource2 = null;
        if (n >= 2) {
            savotResource2 = (SavotResource)this.savotParser.getVOTable().getResources().getItemAt(1);
        }
        if (savotResource == null) {
            Aladin.trace(3, "Could not determine type, stream contains no RESOURCE");
            return;
        }
        String string3 = savotResource.getUtype();
        if (string3 != null && string3.equals("dal:SimpleQueryResponse")) {
            this.type = 5;
            return;
        }
        if (savotResource.getTableCount() > 0 && (object2 = savotResource.getFieldSet(0)) != null && ((SavotSet)object2).getItems() != null) {
            object = ((SavotSet)object2).getItems().elements();
            while (object.hasMoreElements()) {
                if (!((SavotField)object.nextElement()).getUtype().equalsIgnoreCase(FOOTPRINT_REF_UTYPE)) continue;
                this.type = 5;
                return;
            }
        }
        if (this.mayBeSSA(this.savotParser.getVOTable())) {
            this.type = 3;
            return;
        }
        object2 = savotResource.getType();
        if (object2 == null) {
            object2 = "";
        }
        if (((String)object2).equals("results")) {
            if (savotResource2 != null && savotResource2.getType() != null && (savotResource2.getType().equals("GeneralFeatures") || savotResource2.getName().equals("GeneralFeatures"))) {
                this.type = 4;
                return;
            }
            this.type = 2;
            return;
        }
        object = savotResource.getId();
        if (object == null || ((String)object).length() == 0) {
            object = savotResource.getName();
        }
        if (object != null && (((String)object).equalsIgnoreCase(IDSURVEY) || ((String)object).equals(IDBAND))) {
            this.type = 0;
            return;
        }
    }

    private String stripNSForUtype(String string) {
        String string2;
        int n = string.indexOf(58);
        String string3 = string2 = n != -1 && string.length() > n + 1 ? string.substring(n + 1) : string;
        if (string2.startsWith("SSA.")) {
            string2 = string2.substring("SSA.".length());
        }
        return string2;
    }

    protected ResourceNode build() throws Exception {
        this.suite();
        this.searchTarget();
        this.detectFormat();
        Aladin.trace(3, "Detected format of document : " + this.readableFormat(this.type));
        if (this.type == 0) {
            return this.buildVotable();
        }
        if (this.type == 1) {
            return this.buildCatVotable();
        }
        if (this.type == 2 || this.type == 3) {
            return this.buildSIAPVotable();
        }
        if (this.type == 4) {
            return this.buildSIAPEvolVotable();
        }
        if (this.type == 5) {
            return this.buildSIAPExtVotable();
        }
        return this.buildSIAPVotable();
    }

    private String readableFormat(int n) {
        if (n == 0) {
            return "VOTABLE_IDHA";
        }
        if (n == 1) {
            return "VIZIER";
        }
        if (n == 2) {
            return "SIAP";
        }
        if (n == 3) {
            return "SSA";
        }
        if (n == 4) {
            return "SIAP_EVOL";
        }
        if (n == 5) {
            return "SIAP_EXT";
        }
        return "unknown";
    }

    private void searchTarget() {
        ParamSet paramSet;
        if (this.savotParser == null) {
            return;
        }
        InfoSet infoSet = this.savotParser.getVOTable().getInfos();
        for (int i = 0; i < infoSet.getItemCount(); ++i) {
            SavotInfo savotInfo = (SavotInfo)infoSet.getItemAt(i);
            if (!savotInfo.getId().equalsIgnoreCase("position")) continue;
            this.targetFound = savotInfo.getValue();
            if (this.targetObjet == null) {
                this.targetObjet = this.targetFound;
            }
            return;
        }
        try {
            paramSet = ((SavotResource)this.savotParser.getVOTable().getResources().getItemAt(0)).getParams();
        }
        catch (Exception exception) {
            return;
        }
        for (int i = 0; i < paramSet.getItemCount(); ++i) {
            SavotParam savotParam = (SavotParam)paramSet.getItemAt(i);
            if (!savotParam.getName().equalsIgnoreCase("INPUT:POS")) continue;
            this.targetFound = savotParam.getValue();
            return;
        }
    }

    protected String getTarget() {
        return this.targetFound;
    }

    protected void setRequestedPos(String string) {
        this.requestedPos = string;
    }

    protected String getRequestedPos() {
        return this.requestedPos;
    }

    private ResourceNode buildCatVotable() {
        if (this.savotParser == null) {
            return null;
        }
        ResourceNode resourceNode = new ResourceNode(this.aladin, "root");
        resourceNode.type = 0;
        SavotVOTable savotVOTable = this.savotParser.getVOTable();
        ResourceSet resourceSet = savotVOTable.getResources();
        for (int i = 0; i < resourceSet.getItemCount(); ++i) {
            SavotResource savotResource = (SavotResource)resourceSet.getItemAt(i);
            ResourceNode resourceNode2 = new ResourceNode(this.aladin, savotResource.getName());
            resourceNode2.isLeaf = true;
            resourceNode2.type = 2;
            InfoSet infoSet = savotResource.getInfos();
            String[] stringArray = new String[infoSet.getItemCount()];
            String[] stringArray2 = new String[infoSet.getItemCount()];
            String string = null;
            for (int j = 0; j < infoSet.getItemCount(); ++j) {
                SavotInfo savotInfo = (SavotInfo)infoSet.getItemAt(j);
                String string2 = savotInfo.getName();
                String string3 = savotInfo.getValue();
                if (string2.startsWith("-")) {
                    string2 = string2.substring(1);
                }
                if (string2.startsWith("kw.")) {
                    string2 = string2.substring(3);
                }
                if (string == null || !string2.equals(string)) {
                    stringArray2[j] = string2;
                    stringArray[j] = string3;
                    string = string2;
                    continue;
                }
                stringArray2[j] = "  \"   \"";
                stringArray[j] = string3;
            }
            resourceNode.addChild(resourceNode2);
            resourceNode2.description = stringArray2;
            resourceNode2.explanation = stringArray;
        }
        return resourceNode;
    }

    private void createSavotParser() {
        if (this.url != null) {
            try {
                this.savotParser = new SavotPullParser(this.url, SavotPullEngine.FULL, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.savotParser = null;
            }
        } else if (this.file != null) {
            try {
                this.savotParser = new SavotPullParser(this.file, SavotPullEngine.FULL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.savotParser = null;
            }
        } else if (this.is != null) {
            this.savotParser = new SavotPullParser(this.is, SavotPullEngine.FULL, null);
        }
    }

    private ResourceNode buildSIAPExtVotable() throws Exception {
        SIAPExtBuilder sIAPExtBuilder = new SIAPExtBuilder(this.aladin, this.objet);
        sIAPExtBuilder.setRequestedPos(this.getRequestedPos());
        return sIAPExtBuilder.build(this.savotParser);
    }

    private ResourceNode buildSIAPEvolVotable() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        SavotField[] savotFieldArray;
        int n2 = -1;
        if (this.savotParser == null) {
            return null;
        }
        SavotVOTable savotVOTable = this.savotParser.getVOTable();
        ResourceSet resourceSet = savotVOTable.getResources();
        ResourceNode resourceNode = new ResourceNode(this.aladin, "root");
        resourceNode.type = 0;
        resourceNode.isSIAPEvol = true;
        SavotResource savotResource = null;
        savotResource = (SavotResource)resourceSet.getItemAt(0);
        if (savotResource == null) {
            return null;
        }
        SavotField[] savotFieldArray2 = this.createDescription(savotResource.getFieldSet(0));
        String[] stringArray = new String[savotFieldArray2.length];
        for (int i = 0; i < savotFieldArray2.length; ++i) {
            stringArray[i] = savotFieldArray2[i].getId();
        }
        SavotResource savotResource2 = (SavotResource)resourceSet.getItemAt(2);
        SavotField[] savotFieldArray3 = this.createDescription(savotResource2.getFieldSet(0));
        int n3 = this.findFieldByID("RelatedObservation", savotFieldArray3);
        String string = savotFieldArray3[n3].getRef();
        this.nameSiapEvolStr = string.trim();
        this.processSIAPEvolResource(savotResource, resourceNode);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable hashtable2 = new Hashtable();
        String string2 = ((SavotField)((SavotResource)resourceSet.getItemAt(2)).getFieldSet(0).getItemAt(0)).getRef();
        savotResource = (SavotResource)resourceSet.getItemAt(1);
        if (savotResource != null && resourceNode.nbChildren > 0) {
            savotFieldArray = new Vector();
            object5 = (ResourceNode)resourceNode.getChildrenAt(0);
            int n4 = this.findValIndex(stringArray, string2);
            n2 = this.findValIndex(stringArray, LOCATION);
            n = this.findValIndex(stringArray, string);
            for (int i = 0; i < ((ResourceNode)object5).description.length; ++i) {
                savotFieldArray.addElement(((ResourceNode)object5).description[i]);
            }
            object4 = new Hashtable();
            this.processGenFeat(savotResource, (Hashtable)object4, (Vector)savotFieldArray);
            object3 = resourceNode.getChildren();
            while (object3.hasMoreElements()) {
                object5 = (ResourceNode)object3.nextElement();
                hashtable.put(((ResourceNode)object5).explanation[n4], object5);
                if (hashtable2.get(((ResourceNode)object5).explanation[n]) == null) {
                    hashtable2.put(((ResourceNode)object5).explanation[n], new Vector());
                }
                ((Vector)hashtable2.get(((ResourceNode)object5).explanation[n])).addElement(object5);
                ((ResourceNode)object5).links = new Hashtable();
                for (int i = 0; i < ((ResourceNode)object5).description.length; ++i) {
                    object2 = ((ResourceNode)object5).description[i] + ((ResourceNode)object5).explanation[i];
                    object = (ResourceNode)((Hashtable)object4).get(object2);
                    if (object == null) continue;
                    ((ResourceNode)object).isLeaf = false;
                    ((ResourceNode)object5).links.put(((ResourceNode)object5).description[i], object);
                }
            }
        }
        if ((savotResource = (SavotResource)resourceSet.getItemAt(2)) != null) {
            resourceNode.removeAllChild();
            savotFieldArray = this.createDescription(savotResource.getFieldSet(0));
            int n5 = savotResource.getTRCount(0);
            TRSet tRSet = savotResource.getData(0).getTableData().getTRs();
            Hashtable hashtable3 = new Hashtable();
            Vector<Object> vector = new Vector<Object>();
            int n6 = this.findFieldByUtype("Observation.Provenance.DataViewsAndAccess.AccessReference", savotFieldArray);
            if (n6 < 0) {
                n6 = this.findFieldByID("LinktoPixels", savotFieldArray);
            }
            int n7 = this.findFieldByID("DataOrganisation", savotFieldArray);
            int n8 = this.findFieldByID("RelatedObservation", savotFieldArray);
            int n9 = this.findFieldByID("ObservationReference", savotFieldArray);
            int n10 = this.findFieldByID(NB_OF_PATCHES, savotFieldArray);
            int n11 = this.findFieldByID(MAPPARAM, savotFieldArray);
            int n12 = this.findFieldByID(INDEXING, savotFieldArray);
            int n13 = this.findFieldByID("desc", savotFieldArray);
            for (int i = 0; i < n5; ++i) {
                Object object6;
                object = tRSet.getTDSet(i);
                int n14 = ((SavotSet)object).getItemCount();
                object4 = ((TDSet)object).getContent(0).trim();
                String string3 = ((TDSet)object).getContent(n7).trim();
                n = string3.equals(CUTOUT) ? 1 : 0;
                boolean bl = string3.equals("LOWERLEVEL");
                object3 = ((TDSet)object).getContent(n6);
                String string4 = "";
                if (n10 >= 0 && n10 < n14) {
                    string4 = ((TDSet)object).getContent(n10).trim();
                }
                String string5 = "";
                if (n11 >= 0 && n11 < n14) {
                    string5 = ((TDSet)object).getContent(n11).trim();
                }
                String string6 = "";
                if (n12 >= 0 && n12 < n14) {
                    string6 = ((TDSet)object).getContent(n12).trim();
                }
                String string7 = ((TDSet)object).getContent(n8);
                object2 = (ResourceNode)hashtable.get(object4);
                if (object2 == null) continue;
                ResourceNode resourceNode2 = new ResourceNode(this.aladin, (ResourceNode)object2);
                if (string4.length() > 0) {
                    resourceNode2.maxImgNumber = string4;
                }
                if (string5.length() > 0 && ((String[])(object6 = TreeBuilder.split(string5, ","))).length == 2) {
                    try {
                        resourceNode2.beginVel = Double.valueOf(object6[0]);
                        resourceNode2.velStep = Double.valueOf(object6[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (string6.length() > 0) {
                    resourceNode2.indexing = string6;
                }
                resourceNode2.cutout = n;
                resourceNode2.location = object3;
                if (string3 != null && string3.length() > 0) {
                    resourceNode2.altName = string3;
                }
                if (string3.equals("PREVIEW")) {
                    resourceNode2.name = resourceNode2.name + "_PREVIEW";
                }
                if (resourceNode2.cutout) {
                    if (this.targetObjet != null) {
                        resourceNode2.setCutoutTarget(this.targetObjet);
                        resourceNode2.targetObjet = this.targetObjet;
                    } else {
                        resourceNode2.setCutoutTarget(resourceNode2.explanation[resourceNode2.ra] + " " + resourceNode2.explanation[resourceNode2.de], false);
                    }
                }
                resourceNode2.name = string3;
                if (n13 >= 0 && n13 < n14) {
                    object6 = ((TDSet)object).getContent(n13);
                    if (object6 != null) {
                        object6 = ((String)object6).trim();
                    }
                    if (((String)object6).length() > 0) {
                        resourceNode2.name = object6;
                    }
                }
                if (!bl) {
                    ((BasicNode)object2).addChild(resourceNode2);
                    ((ResourceNode)object2).isLeaf = false;
                    resourceNode2.isLeaf = true;
                } else {
                    resourceNode2.description = null;
                    ((ResourceNode)object2).isLeaf = false;
                    resourceNode2.isLeaf = false;
                    object6 = (Vector)hashtable2.get(string7);
                    Enumeration enumeration = ((Vector)object6).elements();
                    int n15 = 0;
                    boolean bl2 = false;
                    while (enumeration.hasMoreElements()) {
                        ResourceNode resourceNode3 = (ResourceNode)enumeration.nextElement();
                        resourceNode2.addChild(resourceNode3);
                        if (resourceNode3 == object2) {
                            bl2 = true;
                        }
                        vector.addElement(resourceNode3);
                        resourceNode3.name = resourceNode3.name + "-" + ++n15;
                    }
                    if (bl2) {
                        System.out.println("cycle detected !");
                        ResourceNode resourceNode4 = new ResourceNode(this.aladin, (ResourceNode)object2);
                        ((ResourceNode)object2).isLeaf = true;
                        resourceNode.addChild(resourceNode4);
                        resourceNode4.isLeaf = false;
                        resourceNode4.addChild(resourceNode2);
                    } else {
                        ((BasicNode)object2).addChild(resourceNode2);
                    }
                }
                if (!vector.contains(object2)) {
                    resourceNode.addChild((BasicNode)object2);
                    ((ResourceNode)object2).isLeaf = false;
                    vector.addElement(object2);
                }
                object6 = resourceNode.getChildren();
                while (object6.hasMoreElements()) {
                    ((ResourceNode)object6.nextElement()).isObs = true;
                }
            }
        }
        if (n2 >= 0) {
            savotFieldArray = new Vector();
            BasicTree.getAllNonLeaves(resourceNode, (Vector)savotFieldArray);
            object5 = savotFieldArray.elements();
            while (object5.hasMoreElements()) {
                ResourceNode resourceNode5 = (ResourceNode)object5.nextElement();
                resourceNode5.explanation[n2] = "";
            }
        }
        return resourceNode;
    }

    protected void processGenFeat(SavotResource savotResource, Hashtable hashtable, Vector vector) {
        int n = savotResource.getTableCount();
        for (int i = 0; i < n; ++i) {
            SavotField[] savotFieldArray = this.createDescription(savotResource.getFieldSet(i));
            if (savotResource.getData(i) == null || savotResource.getData(i).getTableData() == null) continue;
            TRSet tRSet = savotResource.getData(i).getTableData().getTRs();
            int n2 = tRSet.getItemCount();
            for (int j = 0; j < n2; ++j) {
                ResourceNode resourceNode = this.createSIAPNode((SavotTR)tRSet.getItemAt(j), savotFieldArray);
                resourceNode.name = resourceNode.explanation[0];
                hashtable.put(resourceNode.description[0] + resourceNode.name, resourceNode);
            }
        }
    }

    private void processSIAPEvolResource(SavotResource savotResource, ResourceNode resourceNode) {
        SavotField[] savotFieldArray = this.createDescription(savotResource.getFieldSet(0));
        if (savotResource.getData(0) == null) {
            return;
        }
        if (savotResource.getData(0).getTableData() == null) {
            return;
        }
        TRSet tRSet = savotResource.getData(0).getTableData().getTRs();
        ResourceNode[] resourceNodeArray = new ResourceNode[tRSet.getItemCount()];
        for (int i = 0; i < resourceNodeArray.length; ++i) {
            resourceNodeArray[i] = this.createSIAPNode((SavotTR)tRSet.getItemAt(i), savotFieldArray);
            resourceNodeArray[i].isSIAPEvol = true;
            resourceNode.addChild(resourceNodeArray[i]);
        }
    }

    private ResourceNode buildSIAPVotable() {
        if (this.savotParser == null) {
            return null;
        }
        SavotVOTable savotVOTable = this.savotParser.getVOTable();
        this.searchSortOrder(savotVOTable);
        ResourceSet resourceSet = savotVOTable.getResources();
        ResourceNode resourceNode = new ResourceNode(this.aladin, "root");
        resourceNode.type = 0;
        SavotResource savotResource = null;
        SavotResource savotResource2 = null;
        for (int i = 0; i < resourceSet.getItemCount(); ++i) {
            savotResource2 = (SavotResource)resourceSet.getItemAt(i);
            if (!savotResource2.getType().equals("results")) continue;
            savotResource = savotResource2;
            break;
        }
        if (savotResource == null && (savotResource = savotResource2) == null) {
            return null;
        }
        this.processSIAPResource(savotResource, resourceNode);
        if (this.type == 3) {
            resourceNode.type = 3;
        }
        if (this.sortItems != null) {
            MetaDataTree.doSortSiapEvol(this.sortItems, resourceNode);
        }
        return resourceNode;
    }

    private void processSIAPResource(SavotResource savotResource, ResourceNode resourceNode, boolean bl) {
        this.processInfo(savotResource);
        if (savotResource.getTables().getItemCount() == 0) {
            return;
        }
        SavotField[] savotFieldArray = this.createDescription(savotResource.getFieldSet(0));
        if (savotResource.getData(0) == null) {
            return;
        }
        if (savotResource.getData(0).getTableData() == null) {
            return;
        }
        TRSet tRSet = savotResource.getData(0).getTableData().getTRs();
        ResourceNode[] resourceNodeArray = new ResourceNode[tRSet.getItemCount()];
        if (bl) {
            ResourceNode resourceNode2 = null;
            ResourceNode resourceNode3 = null;
            for (int i = 0; i < resourceNodeArray.length; ++i) {
                resourceNodeArray[i] = this.createSIAPNode((SavotTR)tRSet.getItemAt(i), savotFieldArray);
                if (resourceNode2 == null || !resourceNodeArray[i].survey.equals(resourceNode2.name)) {
                    resourceNode2 = new ResourceNode(this.aladin, resourceNodeArray[i].survey);
                    resourceNode2.type = 1;
                    resourceNode.addChild(resourceNode2);
                    resourceNode3 = null;
                }
                if (resourceNode3 == null || !resourceNodeArray[i].bandPass.equals(resourceNode3.name)) {
                    resourceNode3 = new ResourceNode(this.aladin, resourceNodeArray[i].bandPass);
                    resourceNode3.type = 1;
                    resourceNode2.addChild(resourceNode3);
                }
                resourceNode3.addChild(resourceNodeArray[i]);
            }
        } else {
            Hashtable<String, ResourceNode> hashtable = new Hashtable<String, ResourceNode>();
            for (int i = 0; i < resourceNodeArray.length; ++i) {
                ResourceNode resourceNode4 = resourceNode;
                resourceNodeArray[i] = this.createSIAPNode((SavotTR)tRSet.getItemAt(i), savotFieldArray);
                if (resourceNodeArray[i].bandPass != null) {
                    ResourceNode resourceNode5 = (ResourceNode)hashtable.get(resourceNodeArray[i].bandPass);
                    if (resourceNode5 != null) {
                        resourceNode4 = resourceNode5;
                    } else {
                        resourceNode4 = new ResourceNode(this.aladin);
                        resourceNode4.name = resourceNodeArray[i].bandPass;
                        resourceNode4.type = 1;
                        hashtable.put(resourceNode4.name, resourceNode4);
                        resourceNode.addChild(resourceNode4);
                    }
                }
                resourceNode4.addChild(resourceNodeArray[i]);
            }
        }
    }

    private void processInfo(SavotResource savotResource) {
        InfoSet infoSet = savotResource.getInfos();
        if (infoSet.getItemCount() == 0) {
            return;
        }
        SavotInfo savotInfo = null;
        for (int i = 0; i < infoSet.getItemCount(); ++i) {
            SavotInfo savotInfo2 = (SavotInfo)infoSet.getItemAt(i);
            if (!savotInfo2.getName().equalsIgnoreCase("QUERY_STATUS")) continue;
            savotInfo = savotInfo2;
            break;
        }
        if (savotInfo == null) {
            return;
        }
        String string = savotInfo.getValue();
        String string2 = savotInfo.getContent();
        if (!string.equalsIgnoreCase("OK")) {
            this.error = string + ": " + string2;
        }
    }

    protected String getError() {
        return this.error;
    }

    private void processSIAPResource(SavotResource savotResource, ResourceNode resourceNode) {
        this.processSIAPResource(savotResource, resourceNode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceNode createSIAPNode(SavotTR savotTR, SavotField[] savotFieldArray) {
        String string;
        double d;
        Object object;
        String[] stringArray;
        this.myIndexDE = -1;
        this.myIndexRA = -1;
        boolean bl = false;
        TDSet tDSet = savotTR.getTDs();
        int n = tDSet.getItemCount();
        String[] stringArray2 = new String[n];
        boolean[] blArray = new boolean[n];
        String[] stringArray3 = new String[n];
        String[] stringArray4 = new String[n];
        String[] stringArray5 = new String[n];
        String[] stringArray6 = new String[savotFieldArray.length];
        String[] stringArray7 = new String[n];
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        String[] stringArray8 = new String[savotFieldArray.length];
        String string15 = null;
        for (int i = 0; i < savotFieldArray.length; ++i) {
            String string16 = savotFieldArray[i].getName();
            stringArray6[i] = string16.length() > 0 ? string16 : savotFieldArray[i].getId();
            stringArray8[i] = savotFieldArray[i].getId();
            blArray[i] = false;
        }
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = ((SavotTD)tDSet.getItemAt(i)).getContent();
            stringArray7[i] = stringArray2[i];
            try {
                String string17;
                String string18;
                stringArray3[i] = string18 = savotFieldArray[i].getUcd().trim();
                stringArray4[i] = string17 = savotFieldArray[i].getUtype().trim();
                String string19 = this.stripNSForUtype(string17);
                stringArray5[i] = savotFieldArray[i].getUnit();
                if (string18.equalsIgnoreCase(SIAP_IMAGE_TITLE) || string18.equalsIgnoreCase(UCD1P_TITLE) || string18.equalsIgnoreCase(SIAP_IMAGE_TITLE2) || string19.equalsIgnoreCase(UTYPE_DATATITLE_SSA)) {
                    n2 = i;
                    continue;
                }
                if (string17.toLowerCase().endsWith(SSAP_UTYPE_SPATIAL_COVERAGE.toLowerCase())) {
                    n11 = i;
                    String[] stringArray9 = Util.split(stringArray2[i], " ");
                    this.alphaVal = new Double(stringArray9[0]);
                    this.deltaVal = new Double(stringArray9[1]);
                    stringArray2[n11] = this.alphaVal + " " + this.deltaVal;
                    continue;
                }
                if (string18.equalsIgnoreCase(SIAP_RA) || string18.equalsIgnoreCase(SIAP_RA_UCD1P) || string19.equalsIgnoreCase("Char.SpatialAxis.Coverage.Ra")) {
                    n4 = i;
                    this.alphaVal = new Double(stringArray2[i]);
                    continue;
                }
                if (string18.equalsIgnoreCase(SIAP_DE) || string18.equalsIgnoreCase(SIAP_DE_UCD1P) || string19.equalsIgnoreCase("Char.SpatialAxis.Coverage.Dec")) {
                    n3 = i;
                    this.deltaVal = new Double(stringArray2[i]);
                    continue;
                }
                if (stringArray8[i].equals(ORIGIN)) {
                    n9 = i;
                    continue;
                }
                if (string18.equalsIgnoreCase(SIAP_URL) || string18.equalsIgnoreCase(SIAP_URL2) && n5 == -1 || string19.equalsIgnoreCase(UTYPE_ACREF_SSA)) {
                    n5 = i;
                    continue;
                }
                if (n5 == -1 && (savotFieldArray[i].getName().toLowerCase().startsWith("url") || savotFieldArray[i].getId().toLowerCase().startsWith("url"))) {
                    Aladin.trace(3, "Using field starting with 'url' for location, possible misrespect of SIAP standard");
                    n5 = i;
                    continue;
                }
                if (string18.equalsIgnoreCase(SIAP_SCALE)) {
                    n7 = i;
                    string2 = stringArray2[i];
                    continue;
                }
                if (string18.equalsIgnoreCase(SIAP_NAXIS)) {
                    n6 = i;
                    string3 = stringArray2[i];
                    continue;
                }
                if (string18.equalsIgnoreCase(SIAP_IMAGE_FORMAT)) {
                    n8 = i;
                    string4 = stringArray2[i];
                    continue;
                }
                if (savotFieldArray[i].getId().equalsIgnoreCase(FORMAT) || savotFieldArray[i].getName().equalsIgnoreCase(FORMAT)) {
                    string15 = stringArray2[i];
                    continue;
                }
                if (string18.equalsIgnoreCase(ESAC_AXES)) {
                    string14 = stringArray2[i];
                    continue;
                }
                if (string18.equalsIgnoreCase(ESAC_UNITS)) {
                    string13 = stringArray2[i];
                    continue;
                }
                if (string18.equalsIgnoreCase(ESAC_DIMEQ)) {
                    string12 = stringArray2[i];
                    continue;
                }
                if (string18.equalsIgnoreCase(ESAC_SCALEQ)) {
                    string11 = stringArray2[i];
                    continue;
                }
                if (stringArray8[i].equals("regionSTCS") || stringArray6[i].equals("stcs") || stringArray6[i].equals("position_bounds") || stringArray4[i].equals(UTYPE_STCS_REGION1)) {
                    string10 = stringArray2[i];
                    continue;
                }
                if (string18.equalsIgnoreCase(SIAP_BANDPASS_ID)) {
                    string5 = stringArray2[i];
                    continue;
                }
                if (savotFieldArray[i].getId().equalsIgnoreCase(IDSURVEY)) {
                    string6 = stringArray2[i];
                    continue;
                }
                if (savotFieldArray[i].getId().equalsIgnoreCase("Machine_Name")) {
                    string7 = stringArray2[i];
                    continue;
                }
                if (savotFieldArray[i].getId().equalsIgnoreCase("Resolution")) {
                    string8 = stringArray2[i];
                    continue;
                }
                if (savotFieldArray[i].getId().equalsIgnoreCase("PlateNumber")) {
                    string9 = stringArray2[i];
                    continue;
                }
                if (savotFieldArray[i].getId().equalsIgnoreCase("Cutout")) {
                    bl = stringArray2[i].equals("CUTOUT");
                    continue;
                }
                if (!stringArray8[i].equals("AP") && !stringArray8[i].equals("PA") && !stringArray6[i].equals("Position Angle")) continue;
                n10 = i;
                this.angleVal = new Double(stringArray2[i]);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                if (i < savotFieldArray.length && i != n11 && i != n4 && i != n3 && i != n5 && i != n2) {
                    String string20 = savotFieldArray[i].getUnit();
                    if (stringArray2[i].length() > 0 && string20.length() > 0) {
                        stringArray2[i] = TreeBuilder.getUnit(stringArray2[i], string20);
                    }
                }
            }
        }
        if (n4 >= 0 && n3 >= 0 || n11 >= 0) {
            try {
                if (n11 >= 0) {
                    this.frame.set(stringArray2[n11]);
                } else {
                    this.frame.set(stringArray2[n4] + " " + stringArray2[n3]);
                }
                this.frame.setPrecision(6);
                String string21 = this.frame.toString(":");
                int n12 = string21.indexOf("+");
                if (n12 == -1) {
                    n12 = string21.indexOf("-");
                }
                if (n11 >= 0) {
                    stringArray2[n11] = string21;
                } else {
                    stringArray2[n4] = string21.substring(0, n12);
                    stringArray2[n3] = string21.substring(n12);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.myIndexRA = n4;
        this.myIndexDE = n3;
        ResourceNode resourceNode = new ResourceNode(this.aladin);
        resourceNode.type = 1;
        resourceNode.server = this.server;
        if (this.objet != null) {
            resourceNode.objet = this.objet;
        }
        resourceNode.description = stringArray6;
        resourceNode.ra = n4;
        resourceNode.de = n3;
        if (n9 >= 0) {
            resourceNode.origin = stringArray2[n9];
        }
        for (int i = 0; i < stringArray6.length; ++i) {
            if (!savotFieldArray[i].getType().equals("hidden")) continue;
            blArray[i] = true;
        }
        resourceNode.explanation = stringArray2;
        resourceNode.hidden = blArray;
        resourceNode.originalExpla = stringArray7;
        resourceNode.ucds = stringArray3;
        resourceNode.utypes = stringArray4;
        resourceNode.allUnits = stringArray5;
        resourceNode.bandPass = string5;
        resourceNode.survey = string6;
        resourceNode.machine = string7;
        resourceNode.resol = string8;
        resourceNode.plateNumber = string9;
        resourceNode.isLeaf = true;
        if (n2 >= 0) {
            resourceNode.name = stringArray2[n2];
        }
        if (string5 == null && resourceNode.server != null && resourceNode.server.aladinLabel.indexOf("SDSS") >= 0) {
            resourceNode.bandPass = this.guessBandIDFromTitle(resourceNode.name);
        }
        if (bl) {
            MetaDataTree cfr_ignored_0 = this.server.tree;
            String string22 = MetaDataTree.resolveTarget(this.server.getTarget(), this.aladin);
            stringArray = null;
            try {
                this.frame.set(string22);
                this.frame.setPrecision(6);
                stringArray = TreeView.getDeciCoord(string22).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray != null) {
                int n13 = stringArray.indexOf("+");
                if (n13 == -1) {
                    n13 = stringArray.indexOf("-");
                }
                this.alphaVal = new Double(stringArray.substring(0, n13));
                this.deltaVal = new Double(stringArray.substring(n13));
            }
        }
        if (resourceNode.cutout && this.myIndexRA >= 0 && this.myIndexDE >= 0 && this.targetObjet != null) {
            resourceNode.setCutoutTarget(this.targetObjet);
            resourceNode.targetObjet = this.targetObjet;
        }
        if (n5 >= 0) {
            resourceNode.location = stringArray2[n5];
        }
        if (string15 == null) {
            string15 = resourceNode.getFieldValFromUtype("Access.Format");
        }
        if (string15 != null && string15.equalsIgnoreCase("catalog")) {
            resourceNode.type = 2;
        } else if (string15 != null && string15.toLowerCase().startsWith("catalog")) {
            resourceNode.type = 2;
        } else if (string15 != null && string15.startsWith("spectrum") || this.type == 3) {
            resourceNode.type = 3;
            resourceNode.format = string15;
        }
        if (string14 != null) {
            resourceNode.axes = TreeBuilder.split(string14, " ");
        }
        if (string13 != null) {
            resourceNode.units = TreeBuilder.split(string13, " ");
        }
        if (string12 != null) {
            resourceNode.dimeq = TreeBuilder.split(string12, " ");
        }
        if (string11 != null) {
            resourceNode.scaleq = TreeBuilder.split(string11, " ");
        }
        if (n7 >= 0 && n6 >= 0) {
            Object object2 = TreeBuilder.split(string2, ", ");
            stringArray = TreeBuilder.split(string3, ", ");
            if (((String[])object2).length == 1) {
                object = new String[]{object2[0], object[0]};
                object2 = object;
            }
            if (stringArray.length >= 2 && ((String[])object2).length >= 2) {
                try {
                    this.xVal = Math.abs(new Double(object2[0]) * new Double(stringArray[0]));
                    this.yVal = Math.abs(new Double(object2[1]) * new Double(stringArray[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((object = savotFieldArray[n7].getUnit()) != null && ((String)object).length() > 0 && ((String[])object2).length > 1) {
                stringArray2[n7] = TreeBuilder.getUnit(object2[0], (String)object) + "  " + TreeBuilder.getUnit(object2[1], (String)object);
                resourceNode.setPixSize(TreeBuilder.getUnit(object2[0], (String)object) + "/pix");
                try {
                    double d2 = new Double(object2[0]);
                    d2 = TreeBuilder.toDegrees((String)object, d2);
                    resourceNode.setPixSizeDeg(d2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (stringArray.length >= 2 && ((String[])object2).length >= 2) {
                    try {
                        double d3 = TreeBuilder.toDegrees((String)object, new Double(object2[0]));
                        d = TreeBuilder.toDegrees((String)object, new Double(object2[1]));
                        this.xVal = Math.abs(d3 * new Double(stringArray[0]));
                        this.yVal = Math.abs(d * new Double(stringArray[1]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (n8 >= 0) {
            resourceNode.formats = TreeBuilder.split(string4, ",");
            resourceNode.curFormat = resourceNode.formats[0];
        }
        if (n10 == -1 && (string = resourceNode.getFieldValFromUcd("VOX:WCS_CDMatrix")) != null) {
            boolean bl2 = true;
            object = TreeBuilder.split(string, " ,");
            d = 0.0;
            double d4 = 0.0;
            try {
                d4 = Double.valueOf(object[1]);
                d = Double.valueOf((String)object[3]);
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (bl2) {
                this.angleVal = Math.atan2(d4, d) * 180.0 / Math.PI;
                if (Double.isNaN(this.angleVal)) {
                    this.angleVal = 0.0;
                }
            }
        }
        this.setDistanceToCenter(resourceNode, this.alphaVal, this.deltaVal);
        this.createFov(resourceNode, string10);
        this.setProperties(resourceNode);
        return resourceNode;
    }

    private void setDistanceToCenter(ResourceNode resourceNode, double d, double d2) {
        if (this.targetObjetCoo != null && !Double.isNaN(d) && !Double.isNaN(d2)) {
            double d3 = Coo.distance(d, d2, this.targetObjetCoo.al, this.targetObjetCoo.del);
            resourceNode.setDistanceToCenter(d3);
        }
    }

    private String guessBandIDFromTitle(String string) {
        int n = string.lastIndexOf(45);
        return n != -1 && n + 1 < string.length() ? string.substring(n + 1).trim() : null;
    }

    protected static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    private ResourceNode buildVotable() {
        if (this.savotParser == null) {
            return null;
        }
        SavotVOTable savotVOTable = this.savotParser.getVOTable();
        ResourceSet resourceSet = savotVOTable.getResources();
        ResourceNode resourceNode = new ResourceNode(this.aladin, "root");
        resourceNode.type = 0;
        for (int i = 0; i < resourceSet.getItemCount(); ++i) {
            this.processResource(resourceSet, i, resourceNode);
        }
        return resourceNode;
    }

    private void processObsGroup(SavotResource savotResource, ResourceNode resourceNode) {
        String string;
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        TRSet tRSet = savotResource.getTRSet(0);
        int n3 = tRSet.getItemCount();
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, SavotResource> hashtable2 = new Hashtable<String, SavotResource>();
        SavotResource savotResource2 = null;
        SavotResource savotResource3 = null;
        SavotResource savotResource4 = null;
        String string2 = null;
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            TDSet tDSet = tRSet.getTDSet(i);
            stringArray[i] = tDSet.getContent(this.indexCriteria).replace('\"', ' ').trim().toLowerCase();
            stringArray2[i] = tDSet.getContent(this.indexValue);
            hashtable.put(stringArray[i], stringArray2[i]);
            if (stringArray[i].equals("filter")) {
                if (stringArray2[i].equals(this.currentColor)) {
                    bl = false;
                }
                this.currentColor = stringArray2[i];
            }
            if (!stringArray[i].equals("epoch")) continue;
            string2 = stringArray2[i];
        }
        if (bl) {
            this.currentWavelength = null;
            this.currentFilterName = null;
        }
        if (resourceNode.sortCriteria == null) {
            resourceNode.sortCriteria = stringArray;
        }
        ResourceSet resourceSet = savotResource.getResources();
        for (int i = 0; i < resourceSet.getItemCount(); ++i) {
            SavotResource savotResource5 = (SavotResource)resourceSet.getItemAt(i);
            if (savotResource5.getName().equalsIgnoreCase(IDIMAGE)) {
                savotResource4 = savotResource5;
                continue;
            }
            if (savotResource5.getName().equalsIgnoreCase(IDMAPPING)) {
                savotResource2 = savotResource5;
                continue;
            }
            if (savotResource5.getName().equalsIgnoreCase(IDSTORED)) {
                savotResource3 = savotResource5;
                continue;
            }
            hashtable2.put(savotResource5.getName().toLowerCase(), savotResource5);
        }
        TRSet tRSet2 = savotResource4.getData(0).getTableData().getTRs();
        ResourceNode[] resourceNodeArray = new ResourceNode[tRSet2.getItemCount()];
        Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
        double[] dArray = new double[resourceNodeArray.length];
        double[] dArray2 = new double[resourceNodeArray.length];
        double[][] dArrayArray = new double[resourceNodeArray.length][];
        double[][] dArrayArray2 = new double[resourceNodeArray.length][];
        double[] dArray3 = new double[resourceNodeArray.length];
        double[] dArray4 = new double[resourceNodeArray.length];
        double[] dArray5 = new double[resourceNodeArray.length];
        if (this.imageFieldSet == null) {
            this.imageFieldSet = savotResource4.getFieldSet(0);
        }
        SavotField[] savotFieldArray = this.getDescription(savotResource4);
        TRSet tRSet3 = savotResource2.getData(0).getTableData().getTRs();
        if (this.mappingFieldSet == null) {
            this.mappingFieldSet = savotResource2.getFieldSet(0);
        }
        SavotField[] savotFieldArray2 = this.getDescription(savotResource2);
        TRSet tRSet4 = savotResource3.getData(0).getTableData().getTRs();
        if (this.storedFieldSet == null) {
            this.storedFieldSet = savotResource3.getFieldSet(0);
        }
        SavotField[] savotFieldArray3 = this.getDescription(savotResource3);
        for (n2 = 0; n2 < resourceNodeArray.length; ++n2) {
            resourceNodeArray[n2] = this.createNode((SavotTR)tRSet2.getItemAt(n2), 0, savotFieldArray, IDIMAGE);
            resourceNodeArray[n2].criteriaVal = hashtable;
            dArray[n2] = this.xVal;
            dArray2[n2] = this.yVal;
            dArrayArray[n2] = this.xValTab;
            dArrayArray2[n2] = this.yValTab;
            dArray3[n2] = this.alphaVal;
            dArray4[n2] = this.deltaVal;
            dArray5[n2] = this.angleVal;
            this.yVal = Double.NaN;
            this.xVal = Double.NaN;
            this.deltaVal = Double.NaN;
            this.alphaVal = Double.NaN;
            this.angleVal = Double.NaN;
            this.yValTab = null;
            this.xValTab = null;
            resourceNodeArray[n2].survey = this.currentSurvey;
            resourceNodeArray[n2].bandPass = this.currentColor;
            resourceNodeArray[n2].epoch = string2;
            if (this.pixSize > 0.0) {
                resourceNodeArray[n2].setPixSize(TreeBuilder.getUnit(Double.toString(this.pixSize), this.pixSizeUnit) + "/pix");
                try {
                    double d = TreeBuilder.toDegrees(this.pixSizeUnit, this.pixSize);
                    resourceNodeArray[n2].setPixSizeDeg(d);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            hashtable3.put(resourceNodeArray[n2].name, new Integer(n2));
        }
        n2 = this.findFieldByID(OBS_NAME, savotFieldArray2);
        if (savotResource2 != null && n2 >= 0) {
            for (n = 0; n < tRSet3.getItemCount(); ++n) {
                int n4;
                ResourceNode resourceNode2;
                object3 = ((SavotTR)tRSet3.getItemAt(n)).getTDs();
                object2 = ((SavotTD)((SavotSet)object3).getItemAt(n2)).getContent();
                object = (Integer)hashtable3.get(object2);
                if (object == null) {
                    object = new Integer(n);
                }
                if ((resourceNode2 = resourceNodeArray[n4 = ((Integer)object).intValue()]) == null) continue;
                ResourceNode resourceNode3 = new ResourceNode(this.aladin);
                resourceNode3.type = resourceNode2.type;
                resourceNode3.survey = resourceNode2.survey;
                resourceNode3.origin = resourceNode2.origin;
                resourceNode3.isLeaf = true;
                resourceNode2.addChild(resourceNode3);
                for (int i = 0; i < ((SavotSet)object3).getItemCount(); ++i) {
                    String[] stringArray3;
                    String string3;
                    SavotTD savotTD = (SavotTD)((SavotSet)object3).getItemAt(i);
                    string = savotFieldArray2[i].getId();
                    if (string.length() == 0) {
                        string = savotFieldArray2[i].getName();
                    }
                    if (string.equalsIgnoreCase("Cutout")) {
                        resourceNode3.name = savotTD.getContent();
                        if (!savotTD.getContent().equals(CUTOUT)) continue;
                        resourceNode3.cutout = true;
                        if (this.myIndexRA < 0 || this.myIndexDE < 0 || this.targetObjet == null) continue;
                        resourceNode3.setCutoutTarget(this.targetObjet);
                        resourceNode3.targetObjet = this.targetObjet;
                        continue;
                    }
                    if (string.equalsIgnoreCase("desc")) {
                        resourceNode3.desc = savotTD.getContent();
                        continue;
                    }
                    if (string.equalsIgnoreCase(INDEXING)) {
                        resourceNode3.indexing = savotTD.getContent();
                        continue;
                    }
                    if (string.equalsIgnoreCase(MAX_SIZE)) {
                        try {
                            this.maxSize = new Double(savotTD.getContent());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.maxSize = -1.0;
                        }
                        continue;
                    }
                    if (string.equals(RESOLUTION)) {
                        resourceNode3.resol = savotTD.getContent();
                        continue;
                    }
                    if (string.equals(NB_OF_PATCHES)) {
                        string3 = savotTD.getContent();
                        if (string3.length() <= 0) continue;
                        resourceNode3.maxImgNumber = string3;
                        continue;
                    }
                    if (!string.equals(MAPPARAM) || (string3 = savotTD.getContent()).trim().length() <= 0 || (stringArray3 = TreeBuilder.split(string3, ",")).length != 2) continue;
                    try {
                        resourceNode3.beginVel = Double.valueOf(stringArray3[0]);
                        resourceNode3.velStep = Double.valueOf(stringArray3[1]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.xVal = dArray[n4];
                this.yVal = dArray2[n4];
                this.xValTab = dArrayArray[n4];
                this.yValTab = dArrayArray2[n4];
                this.alphaVal = dArray3[n4];
                this.deltaVal = dArray4[n4];
                this.angleVal = dArray5[n4];
                this.pixSize = resourceNode2.getPixSizeDeg();
                this.createFov(resourceNode3, null);
                this.maxSize = -1.0;
            }
        }
        ResourceNode[] resourceNodeArray2 = new ResourceNode[tRSet3.getItemCount()];
        int n5 = 0;
        for (n = 0; n < resourceNodeArray.length; ++n) {
            if (resourceNodeArray[n].nbChildren == 1) {
                object3 = (ResourceNode)resourceNodeArray[n].getChildrenAt(0);
                resourceNodeArray[n].removeAllChild();
                resourceNodeArray[n].cutout = ((ResourceNode)object3).cutout;
                resourceNodeArray[n].targetObjet = ((ResourceNode)object3).targetObjet;
                resourceNodeArray[n].setCutoutTarget(((ResourceNode)object3).targetObjet);
                if (resourceNodeArray[n].cutout && resourceNodeArray[n].name != null && resourceNodeArray[n].name.indexOf("CDF-SOUTH") >= 0) {
                    resourceNodeArray[n].setCutoutTarget(resourceNodeArray[n].explanation[this.myIndexRA] + " " + resourceNodeArray[n].explanation[this.myIndexDE], false);
                }
                resourceNodeArray[n].resol = ((ResourceNode)object3).resol;
                resourceNodeArray[n].setFov(((ResourceNode)object3).getFov());
                resourceNodeArray[n].isLeaf = true;
                resourceNodeArray2[n5++] = resourceNodeArray[n];
                continue;
            }
            if (resourceNodeArray[n].nbChildren <= 1) continue;
            object2 = resourceNodeArray[n].getChildren();
            while (object2.hasMoreElements()) {
                resourceNodeArray2[n5++] = (ResourceNode)object2.nextElement();
            }
        }
        Hashtable<String, Object> hashtable4 = new Hashtable<String, Object>();
        if (savotResource3 != null) {
            for (int i = 0; i < tRSet4.getItemCount(); ++i) {
                object3 = resourceNodeArray2[i];
                if (object3 == null) continue;
                object = ((SavotTR)tRSet4.getItemAt(i)).getTDs();
                for (int j = 0; j < ((SavotSet)object).getItemCount(); ++j) {
                    SavotTD savotTD = (SavotTD)((SavotSet)object).getItemAt(j);
                    String string4 = savotFieldArray3[j].getId();
                    if (string4.length() == 0) {
                        string4 = savotFieldArray3[j].getName();
                    }
                    if (string4.equalsIgnoreCase(LOCATION) && (string = savotTD.getContent()) != null && string.length() > 0) {
                        ((ResourceNode)object3).location = string;
                    }
                    if (!string4.equalsIgnoreCase(GLULINK) || (string = savotTD.getContent()) == null || string.trim().length() <= 0) continue;
                    ((ResourceNode)object3).gluLink = string;
                }
                if (!((ResourceNode)object3).name.startsWith("LOWERLEVEL")) continue;
                ((ResourceNode)object3).isLeaf = false;
                hashtable4.put(((ResourceNode)object3).location, object3);
            }
            if (hashtable4.size() > 0) {
                this.processLowerLevel(hashtable4, savotResource3, savotFieldArray);
            }
        }
        this.sortAndCreate(resourceNodeArray, resourceNode, resourceNode.sortCriteria, hashtable2);
    }

    private void processLowerLevel(Hashtable hashtable, SavotResource savotResource, SavotField[] savotFieldArray) {
        String[] stringArray;
        String string;
        SavotTD savotTD;
        Object object;
        Object object2;
        ResourceNode resourceNode;
        SavotResource savotResource2 = (SavotResource)savotResource.getResources().getItemAt(0);
        SavotResource savotResource3 = (SavotResource)savotResource.getResources().getItemAt(1);
        SavotResource savotResource4 = (SavotResource)savotResource.getResources().getItemAt(2);
        TRSet tRSet = savotResource2.getData(0).getTableData().getTRs();
        int n = tRSet.getItemCount();
        Hashtable<String, ResourceNode> hashtable2 = new Hashtable<String, ResourceNode>();
        for (int i = 0; i < n; ++i) {
            SavotTR savotTR = (SavotTR)tRSet.getItemAt(i);
            resourceNode = this.createNode(savotTR, 0, savotFieldArray, IDIMAGE);
            ResourceNode resourceNode2 = (ResourceNode)hashtable.get(resourceNode.name);
            if (resourceNode2 == null) continue;
            resourceNode.name = resourceNode.refNumber;
            resourceNode.isLeaf = true;
            resourceNode2.addChild(resourceNode);
            hashtable2.put(resourceNode.name, resourceNode);
            this.createFov(resourceNode, null);
        }
        SavotField[] savotFieldArray2 = this.getDescription(savotResource3);
        TRSet tRSet2 = savotResource3.getData(0).getTableData().getTRs();
        int n2 = this.findFieldByID(OBS_NAME, savotFieldArray2);
        if (this.type == 4) {
            n2 = this.findFieldByID(this.nameSiapEvolStr, savotFieldArray2);
        }
        if (savotResource3 != null && n2 >= 0) {
            for (int i = 0; i < tRSet2.getItemCount(); ++i) {
                TDSet tDSet = ((SavotTR)tRSet2.getItemAt(i)).getTDs();
                object2 = ((SavotTD)tDSet.getItemAt(n2)).getContent();
                object = (ResourceNode)hashtable2.get(object2);
                if (object == null) continue;
                for (int j = 0; j < tDSet.getItemCount(); ++j) {
                    savotTD = (SavotTD)tDSet.getItemAt(j);
                    String string2 = savotFieldArray2[j].getId();
                    if (string2.length() == 0) {
                        string2 = savotFieldArray2[j].getName();
                        continue;
                    }
                    if (string2.equalsIgnoreCase("desc")) {
                        ((ResourceNode)object).desc = savotTD.getContent();
                        continue;
                    }
                    if (string2.equalsIgnoreCase(INDEXING)) {
                        ((ResourceNode)object).indexing = savotTD.getContent();
                        continue;
                    }
                    if (string2.equalsIgnoreCase(MAX_SIZE)) {
                        try {
                            this.maxSize = new Double(savotTD.getContent());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.maxSize = -1.0;
                        }
                        continue;
                    }
                    if (string2.equals(RESOLUTION)) {
                        ((ResourceNode)object).resol = savotTD.getContent();
                        continue;
                    }
                    if (string2.equals(NB_OF_PATCHES)) {
                        string = savotTD.getContent();
                        if (string.length() <= 0) continue;
                        ((ResourceNode)object).maxImgNumber = string;
                        continue;
                    }
                    if (!string2.equals(MAPPARAM) || (string = savotTD.getContent()).trim().length() <= 0 || (stringArray = TreeBuilder.split(string, ",")).length != 2) continue;
                    try {
                        ((ResourceNode)object).beginVel = Double.valueOf(stringArray[0]);
                        ((ResourceNode)object).velStep = Double.valueOf(stringArray[1]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.maxSize = -1.0;
            }
        }
        if (savotResource4 != null) {
            object = savotResource4.getData(0).getTableData().getTRs();
            SavotField[] savotFieldArray3 = this.getDescription(savotResource4);
            for (int i = 0; i < ((SavotSet)object).getItemCount(); ++i) {
                object2 = ((SavotTR)((SavotSet)object).getItemAt(i)).getTDs();
                String string3 = ((SavotTD)((SavotSet)object2).getItemAt(n2)).getContent();
                resourceNode = (ResourceNode)hashtable2.get(string3);
                if (resourceNode == null) continue;
                for (int j = 0; j < ((SavotSet)object2).getItemCount(); ++j) {
                    savotTD = (SavotTD)((SavotSet)object2).getItemAt(j);
                    string = savotFieldArray3[j].getId();
                    if (string.length() == 0) {
                        string = savotFieldArray3[j].getName();
                    }
                    if (string.equalsIgnoreCase(LOCATION) && (stringArray = savotTD.getContent()) != null && stringArray.length() > 0) {
                        resourceNode.location = stringArray;
                    }
                    if (!string.equalsIgnoreCase(GLULINK) || (stringArray = savotTD.getContent()) == null || stringArray.trim().length() <= 0) continue;
                    resourceNode.gluLink = stringArray;
                }
            }
        }
    }

    protected int findFieldByUtype(String string, SavotField[] savotFieldArray) {
        for (int i = 0; i < savotFieldArray.length; ++i) {
            if (!savotFieldArray[i].getUtype().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    protected int findFieldByID(String string, SavotField[] savotFieldArray) {
        for (int i = 0; i < savotFieldArray.length; ++i) {
            if (!savotFieldArray[i].getId().equalsIgnoreCase(string) && !savotFieldArray[i].getRef().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    protected int findValIndex(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected int findFieldByUCD(String string, SavotField[] savotFieldArray) {
        for (int i = 0; i < savotFieldArray.length; ++i) {
            if (!savotFieldArray[i].getUcd().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public static String URLDecode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '+') {
                stringBuffer.append(" ");
                ++n;
                continue;
            }
            if (c == '%') {
                String string2 = string.substring(n + 1, n + 3);
                char c2 = (char)Integer.parseInt(string2, 16);
                stringBuffer.append(c2);
                n += 3;
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void sortAndCreate(ResourceNode[] resourceNodeArray, ResourceNode resourceNode, String[] stringArray, Hashtable hashtable) {
        int n;
        if (resourceNodeArray.length == 0) {
            return;
        }
        Hashtable hashtable2 = resourceNodeArray[0].criteriaVal;
        ResourceNode resourceNode2 = resourceNode;
        String string = null;
        for (n = 0; n < stringArray.length; ++n) {
            string = (String)hashtable2.get(stringArray[n]);
            ResourceNode resourceNode3 = (ResourceNode)resourceNode2.getChild(string);
            if (resourceNode3 == null) {
                SavotResource savotResource = (SavotResource)hashtable.get(stringArray[n]);
                if (savotResource != null) {
                    resourceNode3 = this.createNode((SavotTR)savotResource.getData(0).getTableData().getTRs().getItemAt(0), -1, this.getDescription(savotResource), stringArray[n]);
                } else {
                    resourceNode3 = new ResourceNode(this.aladin);
                    resourceNode3.type = 1;
                }
                resourceNode3.name = string;
                resourceNode3.criteria = stringArray[n];
                resourceNode3.valueCriteria = string;
                resourceNode2.addChild(resourceNode3);
            }
            resourceNode2 = resourceNode3;
        }
        resourceNode2.col = TreeBuilder.getNextColor();
        for (n = 0; n < resourceNodeArray.length; ++n) {
            resourceNode2.addChild(resourceNodeArray[n]);
            resourceNodeArray[n].col = resourceNode2.col;
            if (resourceNodeArray[n].getFov() != null) {
                resourceNodeArray[n].getFov().color = resourceNode2.col;
            }
            resourceNodeArray[n].wavelength = this.currentWavelength;
            if (this.currentFilterName == null || this.currentFilterName.length() <= 0) continue;
            resourceNodeArray[n].wavelengthExpla = this.currentFilterName;
        }
    }

    private void processResource(ResourceSet resourceSet, int n, ResourceNode resourceNode) {
        SavotResource savotResource = (SavotResource)resourceSet.getItemAt(n);
        if (savotResource.getType().equals("results")) {
            this.processSIAPResource(savotResource, resourceNode, true);
            return;
        }
        SavotField[] savotFieldArray = null;
        String string = ((SavotTable)savotResource.getTables().getItemAt(0)).getId();
        String string2 = ((SavotTable)savotResource.getTables().getItemAt(0)).getRef();
        if (string.length() != 0) {
            if (string.equalsIgnoreCase(IDSURVEY)) {
                this.surveyFieldSet = savotResource.getFieldSet(0);
            } else if (string.equalsIgnoreCase(IDBAND)) {
                this.bandFieldSet = savotResource.getFieldSet(0);
            } else if (string.equalsIgnoreCase(IDIMAGE)) {
                this.imageFieldSet = savotResource.getFieldSet(0);
            }
        } else {
            string = string2;
        }
        savotFieldArray = this.getDescription(savotResource);
        if (string.equalsIgnoreCase(IDMAPPING)) {
            return;
        }
        TRSet tRSet = savotResource.getData(0).getTableData().getTRs();
        String string3 = savotResource.getName();
        int n2 = tRSet.getItemCount();
        this.nameIndex = string3.equalsIgnoreCase(IDBAND) ? 1 : 0;
        ResourceNode resourceNode2 = null;
        if (string3.equalsIgnoreCase(IDBAND)) {
            this.processObsGroup(savotResource, resourceNode);
            return;
        }
        for (int i = 0; i < n2; ++i) {
            resourceNode2 = this.createNode((SavotTR)tRSet.getItemAt(i), this.nameIndex, savotFieldArray, string3);
            resourceNode.addChild(resourceNode2);
        }
        if (string.equalsIgnoreCase(IDSURVEY) && resourceNode2 != null) {
            this.currentSurvey = resourceNode2.explanation[0];
        }
        ResourceSet resourceSet2 = savotResource.getResources();
        for (int i = 0; i < resourceSet2.getItemCount(); ++i) {
            this.processResource(resourceSet2, i, resourceNode2);
        }
    }

    private static Color getNextColor() {
        float f = 0.3f * (float)colorNb + 0.05f;
        ++colorNb;
        return Color.getHSBColor((float)((double)f - Math.floor(f)), 0.7f, 1.0f);
    }

    private void createFov(ResourceNode resourceNode, String string) {
        boolean bl;
        boolean bl2 = bl = resourceNode.type == 3;
        if (!(this.xValTab != null && this.yValTab != null || !Double.isNaN(this.xVal) && !Double.isNaN(this.yVal) || bl || string != null)) {
            return;
        }
        if (Double.isNaN(this.angleVal)) {
            this.angleVal = 0.0;
        }
        if (string != null) {
            STCStringParser sTCStringParser = new STCStringParser();
            List<STCObj> list = sTCStringParser.parse(string);
            resourceNode.setFov(new Fov(list));
        } else if (this.xValTab != null && this.yValTab != null) {
            resourceNode.setFov(new Fov(this.alphaVal, this.deltaVal, this.xValTab, this.yValTab, this.angleVal, this.xVal, this.yVal));
        } else if (bl) {
            resourceNode.setFov(new Fov(this.alphaVal, this.deltaVal, this.angleVal));
        } else {
            resourceNode.setFov(new Fov(this.alphaVal, this.deltaVal, this.xVal, this.yVal, this.angleVal));
        }
        this.yVal = Double.NaN;
        this.xVal = Double.NaN;
        this.deltaVal = Double.NaN;
        this.alphaVal = Double.NaN;
        this.angleVal = Double.NaN;
        this.yValTab = null;
        this.xValTab = null;
        if (resourceNode.getParent() != null) {
            resourceNode.getFov().color = ((ResourceNode)resourceNode.getParent()).col;
        }
        if (resourceNode.cutout) {
            resourceNode.getFov().cutout_x = resourceNode.getFov().cutout_y = this.maxSize * this.pixSize;
        }
    }

    private SavotField[] getDescription(SavotResource savotResource) {
        SavotField[] savotFieldArray;
        String string = ((SavotTable)savotResource.getTables().getItemAt(0)).getId();
        String string2 = ((SavotTable)savotResource.getTables().getItemAt(0)).getRef();
        if (string.length() != 0) {
            savotFieldArray = this.createDescription(savotResource.getFieldSet(0));
            this.fieldSetMapping.put(string, savotFieldArray);
        } else {
            savotFieldArray = (SavotField[])this.fieldSetMapping.get(string2);
        }
        return savotFieldArray;
    }

    protected SavotField[] createDescription(FieldSet fieldSet) {
        int n = fieldSet.getItemCount();
        SavotField[] savotFieldArray = new SavotField[n];
        for (int i = 0; i < n; ++i) {
            SavotField savotField;
            savotFieldArray[i] = (SavotField)fieldSet.getItemAt(i);
            String string = savotFieldArray[i].getId();
            String string2 = savotFieldArray[i].getRef();
            if (string.length() == 0 && string2.length() > 0 && (savotField = (SavotField)this.fieldsPool.get(string2)) != null) {
                savotFieldArray[i] = savotField;
                continue;
            }
            if (string.length() <= 0) continue;
            this.fieldsPool.put(string, savotFieldArray[i]);
        }
        return savotFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceNode createNode(SavotTR savotTR, int n, SavotField[] savotFieldArray, String string) {
        this.myIndexDE = -1;
        this.myIndexRA = -1;
        TDSet tDSet = savotTR.getTDs();
        int n2 = tDSet.getItemCount();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[savotFieldArray.length];
        String[] stringArray3 = new String[n2];
        double d = 0.0;
        double d2 = 0.0;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        String[] stringArray4 = new String[savotFieldArray.length];
        for (int i = 0; i < savotFieldArray.length; ++i) {
            String string2 = savotFieldArray[i].getName();
            stringArray2[i] = string2.length() > 0 ? string2 : savotFieldArray[i].getId();
            stringArray4[i] = savotFieldArray[i].getId();
        }
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = ((SavotTD)tDSet.getItemAt(i)).getContent();
            stringArray3[i] = stringArray[i];
            try {
                int n13;
                String[] stringArray5;
                if (stringArray4[i].equals("PixelSize")) {
                    this.pixSize = Math.abs(new Double(stringArray[i]));
                    this.pixSizeUnit = savotFieldArray[i].getUnit();
                }
                if (stringArray4[i].equals("Size_alpha")) {
                    this.xVal = Math.abs(new Double(stringArray[i]));
                    continue;
                }
                if (stringArray4[i].equals("Size_delta")) {
                    this.yVal = Math.abs(new Double(stringArray[i]));
                    continue;
                }
                if (stringArray4[i].equals("alpha")) {
                    this.alphaVal = new Double(stringArray[i]);
                    n4 = i;
                    continue;
                }
                if (stringArray4[i].equals("delta")) {
                    this.deltaVal = new Double(stringArray[i]);
                    n3 = i;
                    continue;
                }
                if (stringArray4[i].equals("AP") || stringArray2[i].equals("Position Angle")) {
                    n6 = i;
                    this.angleVal = new Double(stringArray[i]);
                    continue;
                }
                if (stringArray4[i].equals("XLim")) {
                    stringArray5 = TreeBuilder.split(stringArray[i], ", ");
                    if (stringArray5.length == 1) {
                        d2 = new Double(stringArray[i]);
                        continue;
                    }
                    this.xValTab = new double[stringArray5.length];
                    for (n13 = 0; n13 < stringArray5.length; ++n13) {
                        this.xValTab[n13] = new Double(stringArray5[n13]) / 2.0;
                    }
                    continue;
                }
                if (stringArray4[i].equals("YLim")) {
                    stringArray5 = TreeBuilder.split(stringArray[i], ", ");
                    if (stringArray5.length == 1) {
                        d = new Double(stringArray[i]);
                        continue;
                    }
                    this.yValTab = new double[stringArray5.length];
                    for (n13 = 0; n13 < stringArray5.length; ++n13) {
                        this.yValTab[n13] = new Double(stringArray5[n13]) / 2.0;
                    }
                    continue;
                }
                if (stringArray4[i].equals(AVAILABLE_CODINGS)) {
                    n5 = i;
                    continue;
                }
                if (stringArray4[i].equals(AVAILABLE_PROCESSINGS)) {
                    n8 = i;
                    continue;
                }
                if (stringArray4[i].equals(MACHINE)) {
                    n10 = i;
                    continue;
                }
                if (stringArray4[i].equals(ORIGIN)) {
                    n9 = i;
                    continue;
                }
                if (stringArray4[i].equals(OBS_DATE)) {
                    n7 = i;
                    continue;
                }
                if (stringArray4[i].endsWith("wavelength") && stringArray[i].length() > 0) {
                    if (stringArray4[i].equals("Effective_wavelength")) {
                        this.currentWavelength = TreeBuilder.getUnit(stringArray[i], savotFieldArray[i].getUnit());
                        continue;
                    }
                    if (this.currentWavelength != null) continue;
                    this.currentWavelength = TreeBuilder.getUnit(stringArray[i], savotFieldArray[i].getUnit());
                    continue;
                }
                if (stringArray4[i].equals(FILTER_NAME)) {
                    this.currentFilterName = stringArray[i];
                    continue;
                }
                if (stringArray4[i].equalsIgnoreCase(RESTYPE)) {
                    n11 = i;
                    continue;
                }
                if (!stringArray4[i].equalsIgnoreCase("ReferenceNumber")) continue;
                n12 = i;
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                if (i < savotFieldArray.length && i != n4 && i != n3 && i != n) {
                    String string3 = savotFieldArray[i].getUnit();
                    if (stringArray[i].length() > 0 && string3.length() > 0) {
                        stringArray[i] = i != n6 ? TreeBuilder.getUnit(stringArray[i], string3) : TreeBuilder.floor(this.angleVal, 2, 3) + TreeBuilder.getUnit(string3);
                    }
                }
            }
        }
        if (n4 >= 0 && n3 >= 0) {
            try {
                this.frame.set(stringArray[n4] + " " + stringArray[n3]);
                this.frame.setPrecision(6);
                String string4 = this.frame.toString(":");
                int n14 = string4.indexOf("+");
                if (n14 == -1) {
                    n14 = string4.indexOf("-");
                }
                stringArray[n4] = string4.substring(0, n14);
                stringArray[n3] = string4.substring(n14);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ResourceNode resourceNode = new ResourceNode(this.aladin);
        resourceNode.type = 1;
        resourceNode.server = this.server;
        if (this.objet != null) {
            resourceNode.objet = this.objet;
        }
        resourceNode.description = stringArray2;
        resourceNode.explanation = stringArray;
        resourceNode.originalExpla = stringArray3;
        resourceNode.ra = n4;
        resourceNode.de = n3;
        if (d2 != 0.0 && d != 0.0) {
            this.xVal = Math.abs(2.0 * d2);
            this.yVal = Math.abs(2.0 * d);
        }
        if (n >= 0) {
            resourceNode.name = stringArray[n];
        }
        this.myIndexRA = n4;
        this.myIndexDE = n3;
        if (n5 >= 0) {
            resourceNode.formats = TreeBuilder.split(stringArray[n5], " ");
            if (resourceNode.formats != null && resourceNode.formats.length > 0) {
                resourceNode.curFormat = resourceNode.formats[0];
            }
        }
        if (n8 >= 0) {
            resourceNode.modes = TreeBuilder.split(stringArray[n8], " ");
            if (resourceNode.modes != null && resourceNode.modes.length > 0) {
                resourceNode.curMode = resourceNode.modes[0];
            }
            if (resourceNode.modes != null && resourceNode.modes.length > 1 && this.targetObjet != null) {
                resourceNode.setMosaicTarget(this.targetObjet);
                resourceNode.targetObjet = this.targetObjet;
            }
        }
        if (n10 >= 0) {
            resourceNode.machine = stringArray[n10];
        }
        if (n9 >= 0) {
            resourceNode.origin = stringArray[n9];
        }
        if (n7 >= 0) {
            resourceNode.obsDate = stringArray[n7];
        }
        if (n11 >= 0) {
            if (stringArray[n11].equalsIgnoreCase("SPECTRUM")) {
                resourceNode.type = 3;
            } else if (stringArray[n11].equalsIgnoreCase("CUBE")) {
                resourceNode.type = 4;
            }
        }
        if (n12 >= 0) {
            resourceNode.refNumber = stringArray[n12];
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!savotFieldArray[i].getType().equals("hidden")) continue;
            stringArray[i] = "";
        }
        return resourceNode;
    }

    private void setProperties(ResourceNode resourceNode) {
        if (resourceNode == null) {
            return;
        }
        resourceNode.properties = new Hashtable();
        resourceNode.propertiesUnits = new Hashtable();
        for (int i = 0; i < resourceNode.description.length; ++i) {
            String string = resourceNode.description[i];
            if (string == null) continue;
            try {
                resourceNode.properties.put(string, resourceNode.originalExpla[i]);
                resourceNode.propertiesUnits.put(string, resourceNode.allUnits[i]);
                continue;
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) continue;
                exception.printStackTrace();
            }
        }
        resourceNode.isObs = true;
    }

    protected static String getUnit(String string, String string2) {
        double d;
        if (string2 == null) {
            return string;
        }
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string + string2;
        }
        if (Double.isNaN(d)) {
            return d + "";
        }
        try {
            d = TreeBuilder.toDegrees(string2, d);
        }
        catch (Exception exception) {
            d = TreeBuilder.floor(d, 1, 3);
            return d + string2;
        }
        String string3 = null;
        if (Math.abs(d) >= 1.0) {
            string3 = "deg";
        }
        if (Math.abs(d) < 1.0) {
            string3 = "arcmin";
            d *= 60.0;
        }
        if (Math.abs(d) < 1.0) {
            string3 = "arcsec";
            d *= 60.0;
        }
        d = TreeBuilder.floor(d, 1, 3);
        string3 = d + TreeBuilder.getUnit(string3);
        return string3;
    }

    private static double floor(double d, int n, int n2) {
        double d2 = 1.0;
        int n3 = Math.abs(d) > 1.0 ? n : n2;
        for (int i = 0; i < n3; ++i) {
            d2 *= 10.0;
        }
        return Math.ceil(d * d2) / d2;
    }

    protected static double toDegrees(String string, double d) throws Exception {
        if (string.equalsIgnoreCase("deg")) {
            d /= 1.0;
        } else if (string.equalsIgnoreCase("arcmin")) {
            d /= 60.0;
        } else if (string.equalsIgnoreCase("arcsec")) {
            d /= 3600.0;
        } else {
            throw new Exception("Unknown unit");
        }
        return d;
    }

    private static String getUnit(String string) {
        if (string.equalsIgnoreCase("deg")) {
            return "\u00b0";
        }
        if (string.equalsIgnoreCase("arcmin")) {
            return "'";
        }
        if (string.equalsIgnoreCase("arcsec")) {
            return "\"";
        }
        return string;
    }

    protected void searchSortOrder(SavotVOTable savotVOTable) {
        ParamSet paramSet = savotVOTable.getParams();
        int n = paramSet.getItemCount();
        for (int i = 0; i < n; ++i) {
            SavotParam savotParam = (SavotParam)paramSet.getItemAt(i);
            if (!savotParam.getName().equalsIgnoreCase("SORTORDER")) continue;
            String string = savotParam.getValue();
            if (string != null && string.length() > 0) {
                this.sortItems = TreeBuilder.split(savotParam.getValue(), " ");
            }
            return;
        }
    }
}

