/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.GluApp;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Server;
import cds.aladin.Tok;
import cds.aladin.TreeNode;
import cds.moc.Healpix;
import cds.tools.Util;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class TreeNodeAllsky
extends TreeNode {
    public String internalId;
    private String url;
    public String description;
    public String verboseDescr;
    public String ack;
    public String copyright;
    public String copyrightUrl;
    public String hpxParam;
    public String version;
    public String aladinProfile;
    private String skyFraction;
    public String aladinLabel;
    public int minOrder;
    public int maxOrder;
    private boolean useCache;
    private boolean cube;
    private boolean color;
    private boolean inFits;
    private boolean inJPEG;
    private boolean inPNG;
    private boolean truePixels;
    private boolean truePixelsSet;
    private boolean cat;
    private boolean progen;
    private boolean map;
    private boolean moc;
    public int cubeDepth;
    public int cubeFirstFrame;
    public int frame;
    public Coord target;
    public double radius;
    public int nside;
    public boolean local;

    public TreeNodeAllsky(Aladin aladin, String string) {
        String string2;
        MyProperties myProperties;
        block60: {
            Object object;
            this.version = "";
            this.minOrder = -1;
            this.maxOrder = -1;
            this.useCache = true;
            this.cube = false;
            this.color = false;
            this.inFits = false;
            this.inJPEG = false;
            this.inPNG = false;
            this.truePixels = false;
            this.truePixelsSet = false;
            this.cat = false;
            this.progen = false;
            this.map = false;
            this.moc = false;
            this.cubeDepth = -1;
            this.cubeFirstFrame = 0;
            this.frame = 3;
            this.target = null;
            this.radius = -1.0;
            this.nside = -1;
            this.local = false;
            this.aladin = aladin;
            this.local = !string.startsWith("http:") && !string.startsWith("https:") && !string.startsWith("ftp:");
            myProperties = new MyProperties();
            try {
                object = null;
                object = !this.local ? new URL(string + "/" + "properties").openStream() : new FileInputStream(new File(string + Util.FS + "properties"));
                if (object != null) {
                    myProperties.load((InputStream)object);
                    ((InputStream)object).close();
                }
            }
            catch (Exception exception) {
                Aladin.trace(3, "No properties file found => auto discovery...");
            }
            object = myProperties.getProperty("hips_frame");
            if (object == null) {
                object = myProperties.getProperty("coordsys");
            }
            if (object == null) {
                object = "galactic";
            }
            if (((String)object).equals("equatorial") || ((String)object).equals("C") || ((String)object).equals("Q")) {
                this.frame = 0;
            } else if (((String)object).equals("ecliptic") || ((String)object).equals("E")) {
                this.frame = 2;
            } else if (((String)object).equals("galactic") || ((String)object).equals("G")) {
                this.frame = 3;
            }
            this.url = string;
            string2 = myProperties.getProperty("obs_collection");
            if (string2 == null) {
                string2 = myProperties.getProperty("label");
            }
            if (string2 != null) {
                this.label = string2;
            } else {
                int n = this.local ? (int)Util.FS.charAt(0) : 47;
                int n2 = string.length();
                int n3 = string.lastIndexOf(n);
                if (n3 == n2 - 1 && n3 > 0) {
                    n2 = n3;
                    n3 = string.lastIndexOf(n, n2 - 1);
                }
                this.label = string.substring(n3 + 1, n2);
            }
            this.id = "__" + this.label;
            string2 = myProperties.getProperty("version");
            if (string2 != null) {
                this.version = string2;
            }
            this.description = myProperties.getProperty("obs_title");
            if (this.description == null) {
                this.description = myProperties.getProperty("description");
            }
            this.verboseDescr = myProperties.getProperty("obs_description");
            if (this.verboseDescr == null) {
                this.verboseDescr = myProperties.getProperty("verboseDescription");
            }
            this.copyright = myProperties.getProperty("obs_copyright");
            if (this.copyright == null) {
                this.copyright = myProperties.getProperty("copyright");
            }
            this.copyrightUrl = myProperties.getProperty("obs_copyright_url");
            if (this.copyrightUrl == null) {
                this.copyrightUrl = myProperties.getProperty("copyrightUrl");
            }
            this.useCache = !this.local && Boolean.parseBoolean(myProperties.getProperty("useCache", "True"));
            this.skyFraction = myProperties.getProperty("moc_sky_fraction");
            string2 = myProperties.getProperty("hips_initial_ra");
            if (string2 != null) {
                String string3 = myProperties.getProperty("hips_initial_dec");
                string2 = string3 != null ? string2 + " " + string3 : null;
            }
            if (string2 == null) {
                string2 = myProperties.getProperty("target");
            }
            if (string2 == null) {
                this.target = null;
            } else {
                try {
                    this.target = new Coord(string2);
                }
                catch (Exception exception) {
                    Aladin.trace(3, "target error!");
                    this.target = null;
                }
            }
            double d = 2.0;
            string2 = myProperties.getProperty("hips_initial_fov");
            if (string2 == null) {
                string2 = myProperties.getProperty("targetRadius");
                d = 1.0;
            }
            if (string2 == null) {
                this.radius = -1.0;
            } else {
                try {
                    this.radius = Server.getAngleInArcmin(string2, 8) / 60.0 / d;
                }
                catch (Exception exception) {
                    Aladin.trace(3, "radius error!");
                    this.radius = -1.0;
                }
            }
            string2 = myProperties.getProperty("hips_tile_width");
            if (string2 == null) {
                string2 = myProperties.getProperty("nside");
            }
            if (string2 != null) {
                try {
                    this.nside = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    Aladin.trace(3, "NSIDE number not parsable !");
                    this.nside = -1;
                }
            }
            if ((string2 = myProperties.getProperty("hips_order")) == null) {
                string2 = myProperties.getProperty("maxOrder");
            }
            try {
                this.maxOrder = new Integer(string2);
            }
            catch (Exception exception) {
                this.maxOrder = this.getMaxOrderByPath(string, this.local);
                if (this.maxOrder != -1) break block60;
                Aladin.trace(3, "No maxOrder found (even with scanning dir.) => assuming 11");
                this.maxOrder = 11;
            }
        }
        String string4 = myProperties.getProperty("dataproduct_type");
        if (string4 != null) {
            this.cube = string4.indexOf("cube") >= 0;
        } else {
            try {
                this.cube = new Boolean(myProperties.getProperty("isCube"));
            }
            catch (Exception exception) {
                this.cube = false;
            }
        }
        if (this.cube) {
            string2 = myProperties.getProperty("hips_cube_depth");
            if (string2 == null) {
                string2 = myProperties.getProperty("cubeDepth");
            }
            if (string2 != null) {
                try {
                    this.cubeDepth = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    Aladin.trace(3, "CubeDepth syntax error [" + string2 + "] => trying autodetection");
                    this.cubeDepth = -1;
                }
            }
            if ((string2 = myProperties.getProperty("hips_cube_firstframe")) == null) {
                string2 = myProperties.getProperty("cubeFirstFrame");
            }
            if (string2 != null) {
                try {
                    this.cubeFirstFrame = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    Aladin.trace(3, "cubeFirstFrame syntax error [" + string2 + "] => assuming frame 0");
                    this.cubeFirstFrame = -1;
                }
            }
        }
        this.progen = string.endsWith("HpxFinder") || string.endsWith("HpxFinder/");
        string2 = myProperties.getProperty("dataproduct_type");
        this.cat = string2 != null ? string2.indexOf("catalog") >= 0 : ((string2 = myProperties.getProperty("isCatalog")) != null ? new Boolean(string2).booleanValue() : this.getFormatByPath(string, this.local, 2));
        String string5 = myProperties.getProperty("dataproduct_subtype");
        if (string5 != null) {
            this.color = string5.indexOf("color") >= 0;
        } else {
            string5 = myProperties.getProperty("isColored");
            if (string5 != null) {
                this.color = new Boolean(string5);
            }
        }
        if (!this.cat && !this.progen) {
            String string6 = myProperties.getProperty("hips_tile_format");
            if (string6 == null) {
                string6 = myProperties.getProperty("format");
            }
            if (string6 != null) {
                int n = Util.indexOfIgnoreCase(string6, "fit");
                this.inFits = n >= 0;
                int n4 = Util.indexOfIgnoreCase(string6, "jpeg");
                this.inJPEG = n4 >= 0 || (n4 = Util.indexOfIgnoreCase(string6, "jpg")) >= 0;
                n4 = Util.indexOfIgnoreCase(string6, "png");
                this.inPNG = n4 >= 0;
                this.truePixels = this.inFits && n < n4;
            } else {
                this.inFits = this.getFormatByPath(string, this.local, 0);
                this.inJPEG = this.getFormatByPath(string, this.local, 1);
                this.inPNG = this.getFormatByPath(string, this.local, 3);
                boolean bl = this.truePixels = this.local && this.inFits || this.local || !this.inJPEG && !this.inPNG;
            }
            if (string5 == null) {
                this.color = this.getIsColorByPath(string, this.local);
            }
            if (this.color) {
                this.truePixels = false;
            }
        }
        if (this.color && !this.inJPEG && !this.inPNG) {
            this.inJPEG = true;
        }
        Aladin.trace(4, this.toString1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getIsColorByPath(String string, boolean bl) {
        boolean bl2;
        String string2 = this.inPNG ? ".png" : ".jpg";
        MyInputStream myInputStream = null;
        try {
            if (bl) {
                boolean bl3 = Util.isJPEGColored(string + Util.FS + "Norder3" + Util.FS + "Allsky" + string2);
                return bl3;
            }
            myInputStream = new MyInputStream(Util.openStream(string + "/Norder3/Allsky" + string2));
            byte[] byArray = myInputStream.readFully();
            bl2 = Util.isColoredImage(byArray);
        }
        catch (Exception exception) {
            Aladin.trace(3, "Allsky" + string2 + " not found => assume B&W survey");
            boolean bl4 = false;
            return bl4;
        }
        finally {
            try {
                if (myInputStream != null) {
                    myInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    private boolean getFormatByPath(String string, boolean bl, int n) {
        String string2 = n == 0 ? ".fits" : (n == 1 ? ".jpg" : (n == 3 ? ".png" : ".xml"));
        return bl && new File(string + Util.FS + "Norder3" + Util.FS + "Allsky" + string2).exists() || !bl && Util.isUrlResponding(string + "/Norder3/Allsky" + string2);
    }

    private int getMaxOrderByPath(String string, boolean bl) {
        for (int i = 25; i >= 1; --i) {
            if ((!bl || !new File(string + Util.FS + "Norder" + i).isDirectory()) && (bl || !Util.isUrlResponding(string + "/Norder" + i))) continue;
            return i;
        }
        return -1;
    }

    public TreeNodeAllsky(Aladin aladin, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14) {
        super(aladin, string, string3, string5, string12);
        char c;
        this.version = "";
        this.minOrder = -1;
        this.maxOrder = -1;
        this.useCache = true;
        this.cube = false;
        this.color = false;
        this.inFits = false;
        this.inJPEG = false;
        this.inPNG = false;
        this.truePixels = false;
        this.truePixelsSet = false;
        this.cat = false;
        this.progen = false;
        this.map = false;
        this.moc = false;
        this.cubeDepth = -1;
        this.cubeFirstFrame = 0;
        this.frame = 3;
        this.target = null;
        this.radius = -1.0;
        this.nside = -1;
        this.local = false;
        this.aladinLabel = string5;
        this.url = string4;
        this.description = string6;
        this.verboseDescr = string7;
        this.ack = string8;
        this.copyright = string10;
        this.copyrightUrl = string11;
        this.hpxParam = string13;
        this.aladinProfile = string9;
        this.internalId = string2;
        this.skyFraction = string14;
        if (this.url != null && ((c = this.url.charAt(this.url.length() - 1)) == '/' || c == '\\')) {
            this.url = this.url.substring(0, this.url.length() - 1);
        }
        c = '\u0001';
        if (this.hpxParam != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.hpxParam);
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    String string15 = stringTokenizer.nextToken();
                    try {
                        int n = Integer.parseInt(string15);
                        if (this.maxOrder != -1) {
                            this.minOrder = this.maxOrder;
                            this.maxOrder = n;
                        } else {
                            this.maxOrder = n;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (Util.indexOfIgnoreCase(string15, "nocache") >= 0) {
                        this.useCache = false;
                    }
                    if (Util.indexOfIgnoreCase(string15, "color") >= 0) {
                        this.color = true;
                    }
                    if (Util.indexOfIgnoreCase(string15, "cube") >= 0) {
                        this.cube = true;
                    }
                    if (Util.indexOfIgnoreCase(string15, "fits") >= 0) {
                        this.inFits = true;
                        if (c != '\u0000') {
                            c = '\u0000';
                            this.truePixels = true;
                        }
                    }
                    if (Util.indexOfIgnoreCase(string15, "jpeg") >= 0 || Util.indexOfIgnoreCase(string15, "jpg") >= 0) {
                        this.inJPEG = true;
                        if (c != '\u0000') {
                            c = '\u0000';
                            this.truePixels = false;
                        }
                    }
                    if (Util.indexOfIgnoreCase(string15, "png") >= 0) {
                        this.inPNG = true;
                        if (c != '\u0000') {
                            c = '\u0000';
                            this.truePixels = false;
                        }
                    }
                    if (Util.indexOfIgnoreCase(string15, "gal") >= 0) {
                        this.frame = 3;
                    }
                    if (Util.indexOfIgnoreCase(string15, "ecl") >= 0) {
                        this.frame = 2;
                    }
                    if (Util.indexOfIgnoreCase(string15, "equ") >= 0) {
                        this.frame = 0;
                    }
                    if (Util.indexOfIgnoreCase(string15, "cat") >= 0) {
                        this.cat = true;
                    }
                    if (Util.indexOfIgnoreCase(string15, "progen") >= 0) {
                        this.progen = true;
                    }
                    if (Util.indexOfIgnoreCase(string15, "map") >= 0) {
                        this.map = true;
                    }
                    if (Util.indexOfIgnoreCase(string15, "moc") >= 0) {
                        this.moc = true;
                    }
                    if (string15.charAt(0) != 'v') continue;
                    try {
                        double d = Double.parseDouble(string15.substring(1));
                        this.version = "-" + string15;
                    }
                    catch (Exception exception) {}
                }
                if (this.minOrder == -1) {
                    this.minOrder = 2;
                }
                if (this.maxOrder == -1) {
                    this.maxOrder = 8;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string4 != null && !string4.startsWith("http") && !string4.startsWith("ftp")) {
            this.useCache = false;
        }
        if (string10 != null || string11 != null) {
            this.setCopyright(string10);
        }
        if (this.color && !this.inJPEG && !this.inPNG) {
            this.inJPEG = true;
        }
        this.setMoc();
    }

    public String toString1() {
        Coord coord = this.getTarget();
        double d = this.getRadius();
        return "GluSky [" + this.id + "]" + (this.isCatalog() ? " catalog" : (this.isProgen() ? " progen" : (this.isMap() ? " fitsMap" : " survey"))) + " maxOrder:" + this.getMaxOrder() + (this.getLosangeOrder() >= 0 ? " cellOrder:" + this.getLosangeOrder() : "") + (!this.isCatalog() && this.isColored() ? " colored" : " B&W") + (!this.isCube() ? "" : " cube" + (this.cubeDepth == -1 ? "" : "/" + this.cubeDepth + (this.cubeFirstFrame == 0 ? "" : "/" + this.cubeFirstFrame))) + (!this.isFits() ? "" : (this.isTruePixels() ? " *inFits*" : " inFits")) + (!this.isJPEG() ? "" : (this.isTruePixels() ? " inJPEG" : " *inJPEG*")) + (!this.isPNG() ? "" : (this.isTruePixels() ? " inPNG" : " *inPNG*")) + (this.loadMocNow() ? " withMoc" : "") + (this.useCache() ? " cache" : " nocache") + " " + Localisation.getFrameName(this.getFrame()) + (this.isLocalDef() ? " localDef" : "") + (this.isLocal() ? " local" : "") + (coord != null ? " target:" + coord : "") + (d != -1.0 ? "/" + Coord.getUnit(d) : "") + " \"" + this.label + "\" => " + this.getUrl();
    }

    protected boolean isLocalDef() {
        return this.aladinProfile != null && this.aladinProfile.indexOf("localdef") >= 0;
    }

    protected boolean isMap() {
        return this.map;
    }

    protected boolean isCatalog() {
        return this.cat;
    }

    protected boolean isProgen() {
        return this.progen;
    }

    protected boolean isColored() {
        return this.color;
    }

    protected boolean isCube() {
        return this.cube;
    }

    protected int getFrame() {
        return this.frame;
    }

    protected boolean isFits() {
        return this.inFits;
    }

    protected int getMaxOrder() {
        return this.maxOrder;
    }

    protected Coord getTarget() {
        return this.target;
    }

    protected double getRadius() {
        return this.radius;
    }

    protected String getVersion() {
        return this.version == null ? "" : this.version;
    }

    protected int getLosangeOrder() {
        if (this.progen || this.cat || this.nside == -1) {
            return -1;
        }
        return (int)Healpix.log2(this.nside);
    }

    protected boolean isLocal() {
        return this.local;
    }

    protected boolean loadMocNow() {
        return this.moc;
    }

    protected boolean isJPEG() {
        return this.inJPEG;
    }

    protected boolean isPNG() {
        return this.inPNG;
    }

    protected boolean isTruePixels() {
        if (this.truePixelsSet) {
            return this.truePixels;
        }
        return !this.isColored() && (this.inFits && this.local || !this.inJPEG && !this.inPNG && !this.local);
    }

    protected boolean useCache() {
        return this.useCache;
    }

    protected String getUrl() {
        try {
            if (this.id != null && this.aladin.glu.aladinDic.get(this.id) != null) {
                return this.aladin.glu.getURL(this.id, "", false, false, 1) + "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.url;
    }

    protected String getAladinTree() {
        int n = this.path.lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        return this.path.substring(0, n);
    }

    public String getGluDic() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(GluApp.glu("ActionName", this.id));
        stringBuffer.append(GluApp.glu("Description", this.description));
        stringBuffer.append(GluApp.glu("Url", this.getUrl()));
        stringBuffer.append(GluApp.glu("Aladin.Label", this.label));
        stringBuffer.append(GluApp.glu("Aladin.Tree", this.getAladinTree()));
        stringBuffer.append(GluApp.glu("Aladin.HpxParam", this.hpxParam));
        stringBuffer.append(GluApp.glu("Aladin.Profile", this.aladinProfile));
        stringBuffer.append(GluApp.glu("Copyright", this.copyright));
        stringBuffer.append(GluApp.glu("Copyright.Url", this.copyrightUrl));
        stringBuffer.append(GluApp.glu("VerboseDescr", this.verboseDescr));
        stringBuffer.append(Util.CR);
        return stringBuffer.toString();
    }

    @Override
    protected void submit() {
        String string = this.isTruePixels() ? ",fits" : "";
        this.aladin.console.printCommand("get allsky(" + Tok.quote(this.label) + string + ")");
        this.aladin.allsky(this);
    }

    void loadCopyright() {
        this.aladin.glu.showDocument(this.copyrightUrl);
    }

    void setDefaultMode(int n) {
        this.truePixelsSet = true;
        if (n == 2 && this.inFits) {
            this.truePixels = true;
        } else if (n == 1 && (this.inJPEG || this.inPNG)) {
            this.truePixels = false;
        }
    }

    protected void reset() {
        this.truePixelsSet = false;
    }

    void setMoc() {
        if (this.skyFraction == null || this.skyFraction.equals("1")) {
            return;
        }
        JButton jButton = new JButton(" (get Moc)");
        jButton.setFont(jButton.getFont().deriveFont(2));
        jButton.setForeground(Color.blue);
        jButton.setBackground(background);
        jButton.setContentAreaFilled(false);
        jButton.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeNodeAllsky.this.loadMoc();
            }
        });
        this.gc.insets.bottom = 7;
        this.gb.setConstraints(jButton, this.gc);
        this.getPanel().add(jButton);
    }

    void loadMoc() {
        block2: {
            MyInputStream myInputStream = null;
            try {
                myInputStream = Util.openAnyStream(this.getUrl() + "/Moc.fits");
                this.aladin.calque.newPlanMOC(myInputStream, this.label + " MOC");
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block2;
                exception.printStackTrace();
            }
        }
    }

    void setUrl(String string) {
        this.url = string;
    }

    void setCopyright(String string) {
        JComponent jComponent = null;
        if (this.copyrightUrl == null) {
            JLabel jLabel;
            jComponent = jLabel = new JLabel("(" + string + ")");
            this.gc.insets.bottom = 0;
        } else {
            JButton jButton = new JButton(string != null ? string : "Copyright");
            jButton.setFont(jButton.getFont().deriveFont(2));
            jButton.setForeground(Color.blue);
            jButton.setBackground(background);
            jButton.setContentAreaFilled(false);
            jButton.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.blue));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TreeNodeAllsky.this.loadCopyright();
                }
            });
            jComponent = jButton;
            this.gc.insets.bottom = 5;
        }
        this.gb.setConstraints(jComponent, this.gc);
        this.getPanel().add(jComponent);
    }
}

