/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.MetaDataTree;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.aladin.Server;
import cds.aladin.ServerAladin;
import cds.aladin.ServerDialog;
import cds.aladin.ServerVizieR;
import cds.aladin.TreeBuilder;
import cds.aladin.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class TreeView
extends JFrame
implements WindowListener,
ActionListener {
    static String NOM;
    static String SUBMIT;
    static String RESET;
    static String CLOSE;
    static String CLEAR;
    static String WERR;
    static String UNKNOWNOBJ;
    static String NODATA;
    MetaDataTree mTree;
    JScrollPane scrollTree;
    private static final int SCROLL_TREE_WIDTH = 320;
    private static final int SCROLL_INFO_WIDTH = 360;
    String targetFound;
    String error;
    Aladin aladin;

    protected void createChaine() {
        NOM = Aladin.chaine.getString("TREETITLE");
        UNKNOWNOBJ = Aladin.chaine.getString("UNKNOWNOBJ");
        SUBMIT = Aladin.chaine.getString("SUBMIT");
        RESET = Aladin.chaine.getString("RESET");
        CLOSE = Aladin.chaine.getString("CLOSE");
        CLEAR = Aladin.chaine.getString("CLEAR");
        WERR = Aladin.chaine.getString("ERROR");
        NODATA = Aladin.chaine.getString("NODATA");
    }

    protected TreeView(Aladin aladin) {
        this.aladin = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(NOM);
        this.setSize(450, 500);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, NOM, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(4, 4, 4, 4))));
        this.addWindowListener(this);
        ResourceNode resourceNode = new ResourceNode(aladin, "root");
        resourceNode.hide = true;
        resourceNode.isOpen = true;
        this.mTree = new MetaDataTree(resourceNode, aladin, null, true);
        this.mTree.setAllowSortByFields(false);
        this.mTree.setFullExpandAtStart(false);
        this.scrollTree = new JScrollPane(this.mTree, 20, 30);
        this.scrollTree.setSize(320, this.getSize().height - 70);
        this.mTree.setScroll(this.scrollTree);
        this.scrollTree.setBackground(this.mTree.bkgColor);
        jPanel.add((Component)this.scrollTree, "Center");
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel(), "South");
    }

    private JPanel buttonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.setFont(Aladin.LBOLD);
        jPanel.add(this.createButton(RESET));
        jPanel.add(this.createButton(CLEAR));
        JButton jButton = this.createButton(SUBMIT);
        jPanel.add(jButton);
        jButton.setFont(Aladin.BOLD);
        jPanel.add(this.createButton(CLOSE));
        return jPanel;
    }

    private JButton createButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public boolean updateTree(InputStream inputStream, MetaDataTree metaDataTree, Server server, String string, String string2) {
        if (server != null && server.target != null && (string == null || string.length() == 0)) {
            string = server.target.getText();
        }
        ResourceNode resourceNode = this.createNewBranch(null, inputStream, string, null, server, null, string2);
        if (this.error != null) {
            Aladin.warning(metaDataTree, this.error);
            return false;
        }
        if (resourceNode.nbChildren <= 0) {
            Aladin.warning(metaDataTree, NODATA);
            return false;
        }
        if ((string == null || string.length() == 0) && this.targetFound != null) {
            string = this.targetFound;
        }
        if (string != null && string.length() != 0) {
            this.mTree.addNode(this.getTargetNode(string, this.mTree), resourceNode);
        } else {
            this.mTree.addNode((ResourceNode)this.mTree.getRootNode(), resourceNode);
        }
        ResourceNode resourceNode2 = (ResourceNode)resourceNode.clone();
        resourceNode2.hide = true;
        metaDataTree.setRoot(resourceNode2);
        metaDataTree.requestFocus();
        this.targetFound = null;
        this.error = null;
        return true;
    }

    public boolean appendToTree(InputStream inputStream, MetaDataTree metaDataTree, Server server, String string, String string2) {
        if (server != null && server.target != null && (string == null || string.length() == 0)) {
            string = server.target.getText();
        }
        ResourceNode resourceNode = this.createNewBranch(null, inputStream, string, null, server, null, string2);
        if (this.error != null) {
            this.aladin.command.println("!!! " + this.error);
            return false;
        }
        if (resourceNode != null && resourceNode.nbChildren <= 0) {
            return false;
        }
        if ((string == null || string.length() == 0) && this.targetFound != null) {
            string = this.targetFound;
        }
        if (string != null && string.length() != 0) {
            this.mTree.addNode(this.getTargetNode(string, this.mTree), resourceNode);
        } else {
            this.mTree.addNode((ResourceNode)this.mTree.getRootNode(), resourceNode);
        }
        ResourceNode resourceNode2 = (ResourceNode)resourceNode.clone();
        resourceNode2.hide = false;
        metaDataTree.addNode((ResourceNode)metaDataTree.getRootNode(), resourceNode2);
        this.targetFound = null;
        this.error = null;
        return true;
    }

    private ResourceNode getTargetNode(String string, MetaDataTree metaDataTree) {
        ResourceNode resourceNode = (ResourceNode)metaDataTree.searchNodeByName(string);
        if (resourceNode == null) {
            resourceNode = new ResourceNode(this.aladin, string);
            metaDataTree.getRootNode().addChild(resourceNode);
            metaDataTree.traverseTree();
        }
        resourceNode.isOpen = true;
        return resourceNode;
    }

    protected static String resolveTarget(String string, Aladin aladin) {
        Coord coord;
        try {
            coord = !View.notCoord(string) ? new Coord(string) : aladin.view.sesame(string);
        }
        catch (Exception exception) {
            return null;
        }
        return coord.getSexa(":");
    }

    protected static Coord resolveTargetCoo(String string, Aladin aladin) {
        Coord coord = null;
        try {
            coord = !View.notCoord(string) ? new Coord(string) : aladin.view.sesame(string);
        }
        catch (Exception exception) {
            return null;
        }
        return coord;
    }

    private ResourceNode createNewBranch(URL uRL, InputStream inputStream, String string, String string2, Server server, String string3, String string4) {
        String string5 = null;
        if (uRL == null && inputStream == null && (string5 = TreeView.resolveTarget(string, this.aladin)) == null) {
            Aladin.warning(UNKNOWNOBJ + " " + string, 1);
            return null;
        }
        ResourceNode resourceNode = uRL == null && inputStream == null ? this.createNode(string5, string2, server, string4) : this.createNode(uRL, inputStream, server, string4, string);
        if (resourceNode == null) {
            Aladin.trace(3, "The new branch of the tree could not be built");
            return null;
        }
        if (string3 == null) {
            if (server instanceof ServerAladin) {
                string3 = "Aladin";
            } else if (server instanceof ServerVizieR) {
                string3 = "VizieR";
            } else if (uRL == null) {
                string3 = server == null ? null : server.aladinLabel;
            } else {
                string3 = uRL.toString();
                string3 = "..." + string3.substring(Math.max(0, string3.length() - 20));
            }
        }
        resourceNode.name = string3;
        return resourceNode;
    }

    private URL buildURL(String string, String string2, Server server) {
        URL uRL;
        double d = Server.getAngleInArcmin(string2, 1) / 60.0;
        try {
            if (server instanceof ServerAladin) {
                uRL = new URL("http://aladin.u-strasbg.fr/cgi-bin/nph-HTTP.cgi?out=qualifier&position=" + URLEncoder.encode(TreeView.getDeciCoord(string)) + "&radius=" + d + "&mode=xml_votable");
            }
            if (server instanceof ServerVizieR) {
                uRL = new URL("http://vizier.u-strasbg.fr/cgi-bin/votable/-w?-meta&-c=" + URLEncoder.encode(string) + "&-c.r=" + d + "&-c.u=degree&-c.eq=J2000");
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            Aladin.trace(1, "URL could not be built");
            return null;
        }
        Aladin.trace(3, "Building url " + uRL);
        return uRL;
    }

    protected int creatCatPlane(String string, String string2, String string3) {
        String string4 = "10";
        return ((ServerVizieR)this.aladin.dialog.server[ServerDialog.VIZIER]).creatVizieRPlane(string2, string4, string, string3, "", false);
    }

    static String getDeciCoord(String string) {
        Coord coord;
        try {
            coord = new Coord(string);
        }
        catch (Exception exception) {
            return "";
        }
        return coord.al + " " + (coord.del >= 0.0 ? "+" : "") + coord.del;
    }

    static double[] getDeciCoord(String string, String string2) {
        Coord coord;
        try {
            coord = new Coord(string + " " + string2);
        }
        catch (Exception exception) {
            return null;
        }
        return new double[]{coord.al, coord.del};
    }

    private ResourceNode createNode(String string, String string2, Server server, String string3) {
        URL uRL = this.buildURL(string, string2, server);
        return this.createNode(uRL, null, server, string3, string);
    }

    private ResourceNode createNode(URL uRL, InputStream inputStream, Server server, String string, String string2) {
        if (uRL == null && inputStream == null) {
            return null;
        }
        int n = -1;
        if (server instanceof ServerAladin) {
            n = 0;
        }
        Aladin.trace(1, "Updating the data tree view, using " + (uRL != null ? "URL " + uRL : "input stream"));
        ResourceNode resourceNode = null;
        try {
            TreeBuilder treeBuilder = uRL != null ? new TreeBuilder(this.aladin, uRL, n, server, string2) : new TreeBuilder(this.aladin, inputStream, n, server, string2);
            if (string != null) {
                treeBuilder.setRequestedPos(string);
            }
            resourceNode = treeBuilder.build();
            this.targetFound = treeBuilder.getTarget();
            this.error = treeBuilder.getError();
            if (resourceNode != null) {
                resourceNode.hide = false;
            }
        }
        catch (Exception exception) {
            System.out.println("An error occured while building the tree :");
            exception.printStackTrace();
            this.error = resourceNode == null ? "Could not build the tree for server " + server.aladinLabel : exception.getMessage();
        }
        return resourceNode;
    }

    public void submit() {
        this.mTree.loadSelected();
        this.mTree.resetCb();
    }

    protected static String getPlanLabel(String string, String string2) {
        return TreeView.getPlanLabel(PlanImage.getRes(string), string2);
    }

    protected static String getPlanLabel(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        for (int i = 0; i < 3; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        if (stringArray[0].indexOf("2MASS") >= 0) {
            stringArray[2] = stringArray[0];
            stringArray[0] = null;
        }
        if (n == 3) {
            stringBuffer.append("Pl-");
        } else if (n == 2) {
            stringBuffer.append("Lw-");
        }
        if (stringArray[2].equals("STScI") || stringArray[2].equals("STSCI")) {
            stringBuffer.append("DSS1");
        } else if (!stringArray[2].startsWith("___")) {
            stringBuffer.append(stringArray[2] + ".");
        }
        stringBuffer.append(stringArray[1]);
        if (stringArray[0] != null) {
            stringBuffer.append("." + (stringArray[0].startsWith("GOODS-") ? stringArray[0].substring(6) : stringArray[0]));
        }
        return stringBuffer.toString();
    }

    protected void reset() {
        this.mTree.resetCb();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(SUBMIT)) {
            this.submit();
        } else if (string.equals(RESET)) {
            this.reset();
        } else if (string.equals(CLEAR)) {
            this.mTree.clear();
        } else if (string.equals(CLOSE)) {
            this.setVisible(false);
        }
    }
}

