/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.MetaDataTree;
import cds.aladin.PlanFilter;
import cds.aladin.Source;
import cds.astro.Unit;
import cds.tools.Util;
import cds.tools.parser.Parser;
import cds.tools.parser.ParserException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class UCDFilter {
    static final String UNDEFINED = "undefined";
    static String ERR1;
    static String ERR2;
    static String ERR3;
    static String ERR4;
    static String ERR5;
    static String ERR6;
    static String ERR7;
    static String ERR8;
    static String ERR9;
    static String ERR10;
    static String ERR11;
    static String ERR12;
    static String ERR13;
    private static final String GT = ">";
    private static final String GE = ">=";
    private static final String LT = "<";
    private static final String LE = "<=";
    private static final String EQ = "=";
    private static final String NE = "!=";
    private boolean convertProblem = false;
    private int nbConvertProblem = 0;
    private int numero;
    private int position;
    private String curOperator = null;
    private Vector<ConstraintsBlock> constraintsBlocks;
    private ConstraintsBlock block;
    protected String definition;
    boolean isValidated = false;
    boolean badSyntax = false;
    String name = null;
    Aladin a;
    PlanFilter pf;

    protected void createChaine() {
        ERR1 = Aladin.chaine.getString("UFERR1");
        ERR2 = Aladin.chaine.getString("UFERR2");
        ERR3 = Aladin.chaine.getString("UFERR3");
        ERR4 = Aladin.chaine.getString("UFERR4");
        ERR5 = Aladin.chaine.getString("UFERR5");
        ERR6 = Aladin.chaine.getString("UFERR6");
        ERR7 = Aladin.chaine.getString("UFERR7");
        ERR8 = Aladin.chaine.getString("UFERR8");
        ERR9 = Aladin.chaine.getString("UFERR9");
        ERR10 = Aladin.chaine.getString("UFERR10");
        ERR11 = Aladin.chaine.getString("UFERR11");
        ERR12 = Aladin.chaine.getString("UFERR12");
        ERR13 = Aladin.chaine.getString("UFERR13");
    }

    UCDFilter(String string, String string2, Aladin aladin, PlanFilter planFilter) {
        this.a = aladin;
        this.createChaine();
        this.name = string;
        this.pf = planFilter;
        this.decodeConstraints(string2);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    UCDFilter(String string, Aladin aladin, PlanFilter planFilter) {
        this.a = aladin;
        this.pf = planFilter;
        this.decodeDefinition(string);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    protected void changeDefinition(String string) {
        this.isValidated = false;
        this.badSyntax = false;
        String string2 = this.definition;
        this.decodeConstraints(string);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    void setNumero(int n) {
        this.numero = n;
    }

    protected void resetActions() {
        Enumeration<ConstraintsBlock> enumeration = this.constraintsBlocks.elements();
        ConstraintsBlock constraintsBlock = null;
        while (enumeration.hasMoreElements()) {
            constraintsBlock = enumeration.nextElement();
            for (int i = 0; i < constraintsBlock.actions.length; ++i) {
                constraintsBlock.actions[i].reset();
            }
        }
    }

    private void decodeConstraints(String string) {
        this.constraintsBlocks = new Vector();
        while (string.length() > 0 && string.charAt(0) == '\n') {
            string = string.substring(1);
        }
        this.definition = new String(string);
        string = string.replace('\t', ' ');
        String string2 = new String("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (UCDFilter.skipSpaces(string3).startsWith("#")) continue;
            string2 = string2 + string3 + "\n";
        }
        string = string2;
        if (Action.countNbOcc('{', string) != Action.countNbOcc('}', string)) {
            this.badSyntax = true;
            Aladin.warning(ERR1, 1);
            return;
        }
        if (Action.countNbOcc('[', string) != Action.countNbOcc(']', string)) {
            this.badSyntax = true;
            Aladin.warning(ERR2, 1);
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int n5;
            this.block = new ConstraintsBlock();
            int n6 = this.getOpeningBracket(string, n2);
            if (n6 < 0) {
                if (n2 != 0 || !string.trim().startsWith("draw")) break;
                string = "{" + string + "}";
                this.definition = "{\n" + this.definition + "\n}";
                n += 2;
                n6 = 0;
            }
            if ((n5 = this.getClosingBracket(string, n6 + 1)) < 0) {
                this.badSyntax = true;
                Aladin.warning(ERR3, 1);
                return;
            }
            String string4 = string.replace('$', ' ').substring(n2, n6);
            String string5 = string.replace('$', ' ').substring(n6 + 1, n5);
            this.block.actions = this.getActions(string5);
            for (n4 = 0; n4 < this.block.actions.length; ++n4) {
                if (!this.block.actions[n4].badSyntax) continue;
                this.badSyntax = true;
                return;
            }
            if (UCDFilter.skipSpaces(string4 = string4.replace('\n', ' ')).length() == 0) {
                string4 = "1=1";
            }
            n4 = 0;
            String string6 = new String();
            while (n4 < string4.length()) {
                int n7 = string4.substring(n4).indexOf("\"");
                if (n7 >= 0) {
                    n3 = string4.substring((n7 += n4) + 1).indexOf("\"");
                    if (n3 >= 0) {
                        string6 = string6 + UCDFilter.skipSpaces(string4.substring(n4, n7));
                        string6 = string6 + string4.substring(n7, (n3 += n7 + 1) + 1);
                        n4 = n3 + 1;
                        continue;
                    }
                    string6 = string6 + UCDFilter.skipSpaces(string4.substring(n4));
                    n4 = string4.length();
                    continue;
                }
                string6 = string6 + UCDFilter.skipSpaces(string4.substring(n4));
                n4 = string4.length();
            }
            string4 = MetaDataTree.replace(string6, "==", EQ, -1);
            String[] stringArray = this.getConditions(string4);
            this.block.valueConstraints = new Constraint[stringArray.length];
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3].startsWith(UNDEFINED)) {
                    this.block.valueConstraints[n3] = this.decodeUndefinedConstraint(stringArray[n3]);
                } else {
                    if (!this.containsOperator(stringArray[n3])) {
                        Aladin.warning(ERR9, 1);
                        this.badSyntax = true;
                        return;
                    }
                    this.block.valueConstraints[n3] = this.decodeValueConstraint(stringArray[n3]);
                }
                if (!this.badSyntax) continue;
                return;
            }
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                string4 = UCDFilter.replace(string4, stringArray[n3], "\\" + n3);
            }
            this.block.checkExpr = string4 = UCDFilter.replace(UCDFilter.replace(string4, "||", "+"), "&&", "*");
            this.constraintsBlocks.addElement(this.block);
            this.block = new ConstraintsBlock();
            n2 = n5 + 1;
        }
    }

    private String[] getConditions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|&");
        String string2 = null;
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            int n3;
            String string3 = stringTokenizer.nextToken();
            String string4 = new String(string3);
            if (string3.startsWith(UNDEFINED)) {
                stringArray[n] = string3;
                ++n;
                continue;
            }
            if (string3.indexOf("\"") > 0 && (n3 = string3.indexOf("\"")) != (n2 = string3.lastIndexOf("\""))) {
                String string5 = string3.substring(n3, n2 + 1);
                string5 = string5.replace('(', 'X');
                string5 = string5.replace(')', 'X');
                string5 = string5.replace('{', 'X');
                string5 = string5.replace('}', 'X');
                string5 = string5.replace('[', 'X');
                string5 = string5.replace(']', 'X');
                string3 = string4.substring(0, n3) + string5 + string4.substring(n2 + 1);
            }
            this.containsOperator(string3);
            String string6 = string3.substring(0, this.position);
            if (string6.indexOf("(") >= 0) {
                n3 = n2 = string6.length();
                string2 = "";
                while (n3 > 0 && Action.countNbOcc(')', string2) >= Action.countNbOcc('(', string2)) {
                    string2 = string6.substring(--n3);
                }
                if (Action.countNbOcc('(', string2) > Action.countNbOcc(')', string2)) {
                    string2 = string2.substring(1);
                    ++n3;
                }
            } else {
                n3 = 0;
            }
            n2 = string3.substring(this.position).indexOf(41);
            n2 = n2 < 0 ? string3.length() : (n2 += this.position);
            stringArray[n] = string2 = string4.substring(n3, n2);
            ++n;
        }
        return stringArray;
    }

    private Constraint decodeUndefinedConstraint(String string) {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n < 0 || n2 < 0 || n > n2) {
            Aladin.warning(ERR10 + " " + UNDEFINED + " " + ERR11, 1);
            this.badSyntax = true;
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        return new Constraint(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Constraint decodeValueConstraint(String string) {
        Parser parser;
        int n = string.indexOf(this.curOperator);
        String string2 = string.substring(0, n);
        boolean bl = false;
        String string3 = this.curOperator;
        double d = 0.0;
        String string4 = null;
        String string5 = string.substring(n + this.curOperator.length(), string.length());
        Unit unit = null;
        if (this.isStrValue(string5)) {
            if (!this.curOperator.equals(EQ) && !this.curOperator.equals(NE)) {
                Aladin.warning(ERR12, 1);
                this.badSyntax = true;
                return null;
            }
            string4 = string5;
            bl = true;
        } else {
            try {
                unit = new Unit(string5);
            }
            catch (ParseException parseException) {
                Aladin.warning(ERR12, 1);
                this.badSyntax = true;
                return null;
            }
            catch (ArithmeticException arithmeticException) {
                this.badSyntax = true;
                Aladin.warning(ERR4, 1);
                return null;
            }
        }
        if (bl) {
            int n2 = Action.countNbOcc('\"', string4);
            if (n2 != 0 && n2 != 2) {
                Aladin.warning(ERR5, 1);
                this.badSyntax = true;
                return null;
            }
            return new Constraint(string2, string3, string4);
        }
        try {
            parser = UCDFilter.createParser(string2, this.a);
        }
        catch (ParserException parserException) {
            Aladin.warning(ERR13 + "\n" + parserException.getMessage(), 1);
            this.badSyntax = true;
            return null;
        }
        d = unit.value;
        if (unit.symbol.length() > 0) {
            return new Constraint(parser, string3, d, unit);
        }
        return new Constraint(parser, string3, d);
    }

    private boolean isStrValue(String string) {
        return string.trim().charAt(0) == '\"';
    }

    public static String replace(String string, String string2, String string3) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        int n3 = 0;
        while ((n2 = string.indexOf(string2, n3)) != -1) {
            stringBuffer.append(string.substring(n3, n2));
            stringBuffer.append(string3);
            n3 = n2 + n;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    private static String[] getVariables(String string, Aladin aladin) {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        while (string.length() > 0) {
            int n;
            int n2;
            int n3 = string.indexOf("[");
            int n4 = string.indexOf("{");
            if (n3 < 0 && n4 < 0) break;
            if (n4 < 0 || n3 >= 0 && n3 < n4) {
                n2 = n3;
                n = string.indexOf("]");
                string2 = string.substring(n2, n + 1);
                try {
                    while (Action.countNbOcc('[', string2) != Action.countNbOcc(']', string2)) {
                        string2 = string.substring(n2, ++n + 1);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    Aladin.warning(ERR6, 1);
                    return null;
                }
            }
            n2 = n4;
            n = string.indexOf("}");
            string2 = string.substring(n2, n + 1);
            try {
                while (Action.countNbOcc('{', string2) != Action.countNbOcc('}', string2)) {
                    string2 = string.substring(n2, ++n + 1);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                Aladin.warning(ERR7);
                return null;
            }
            vector.addElement(string2);
            string = string.substring(n + 1, string.length());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean containsOperator(String string) {
        int n = string.indexOf(NE);
        if (n >= 0) {
            this.curOperator = NE;
            this.position = n;
            return true;
        }
        n = string.indexOf(GE);
        if (n >= 0) {
            this.curOperator = GE;
            this.position = n;
            return true;
        }
        n = string.indexOf(LE);
        if (n >= 0) {
            this.curOperator = LE;
            this.position = n;
            return true;
        }
        n = string.indexOf(EQ);
        if (n >= 0) {
            this.curOperator = EQ;
            this.position = n;
            return true;
        }
        n = string.indexOf(GT);
        if (n >= 0) {
            this.curOperator = GT;
            this.position = n;
            return true;
        }
        n = string.indexOf(LT);
        if (n >= 0) {
            this.curOperator = LT;
            this.position = n;
            return true;
        }
        return false;
    }

    public static String skipSpaces(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    void decodeDefinition(String string) {
        int n = -1;
        this.name = "";
        this.definition = string;
        if (string.indexOf("}") < 0 || (n = string.indexOf("{")) < 0) {
            this.badSyntax = true;
            Aladin.warning(ERR8, 1);
            return;
        }
        int n2 = string.indexOf("filter") + 6;
        if (n2 < 0) {
            this.badSyntax = true;
            Aladin.warning(ERR8, 1);
            return;
        }
        this.name = UCDFilter.skipSpaces(string.substring(n2, n));
        int n3 = string.lastIndexOf("}");
        if ((string = string.substring(n + 1, n3)).startsWith(Util.CR)) {
            string = string.substring(Util.CR.length());
        }
        if (string.endsWith(Util.CR)) {
            string = string.substring(0, string.lastIndexOf(Util.CR));
        } else if (string.endsWith("\n")) {
            string = string.substring(0, string.lastIndexOf("\n"));
        }
        this.decodeConstraints(string);
    }

    protected void select(Source[] sourceArray) {
        int n;
        ConstraintsBlock constraintsBlock = null;
        Vector<Source> vector = new Vector<Source>();
        this.nbConvertProblem = 0;
        Enumeration<ConstraintsBlock> enumeration = this.constraintsBlocks.elements();
        this.a.view.deSelect();
        while (enumeration.hasMoreElements()) {
            constraintsBlock = enumeration.nextElement();
            vector.removeAllElements();
            for (n = sourceArray.length - 1; n >= 0; --n) {
                if (Aladin.isSlow && n % 50 == 0) {
                    Util.pause(10);
                }
                if (this.verifyValueConstraints(sourceArray[n], constraintsBlock)) {
                    sourceArray[n].setSelect(true);
                    this.a.view.vselobj.addElement(sourceArray[n]);
                    continue;
                }
                if (this.convertProblem) {
                    ++this.nbConvertProblem;
                    continue;
                }
                vector.addElement(sourceArray[n]);
            }
            if (vector.size() <= 0) break;
            sourceArray = new Source[vector.size()];
            vector.copyInto(sourceArray);
        }
        if (vector.size() > 0) {
            for (n = sourceArray.length - 1; n >= 0; --n) {
                sourceArray[n].setSelect(false);
            }
        }
        if (this.nbConvertProblem > 0) {
            Aladin.warning("Warning : there were conversion problems for " + this.nbConvertProblem + " sources", 1);
        }
    }

    protected Source[] getFilteredSources(Source[] sourceArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        long l = System.currentTimeMillis();
        Vector<Source> vector = new Vector<Source>();
        int n5 = sourceArray.length;
        this.nbConvertProblem = 0;
        Enumeration<ConstraintsBlock> enumeration = this.constraintsBlocks.elements();
        ConstraintsBlock constraintsBlock = null;
        ConstraintsBlock[] constraintsBlockArray = new ConstraintsBlock[this.constraintsBlocks.size()];
        int n6 = 0;
        while (enumeration.hasMoreElements()) {
            constraintsBlockArray[n6] = enumeration.nextElement();
            ++n6;
        }
        Vector[] vectorArray = new Vector[constraintsBlockArray.length];
        for (n4 = 0; n4 < vectorArray.length; ++n4) {
            vectorArray[n4] = new Vector();
        }
        for (n4 = sourceArray.length - 1; n4 >= 0; --n4) {
            if (sourceArray[n4].values == null) {
                sourceArray[n4].values = new double[PlanFilter.LIMIT][][];
            }
            if (sourceArray[n4].isSelected == null) {
                sourceArray[n4].isSelected = new boolean[PlanFilter.LIMIT];
            }
            if (sourceArray[n4].actions == null) {
                sourceArray[n4].actions = new Action[PlanFilter.LIMIT][];
            }
            if (n4 % 50 == 0) {
                this.pf.setPourcent(100.0 * ((double)(n5 - n4) / (double)n5));
                if (Aladin.isSlow) {
                    Util.pause(10);
                }
            }
            if (bl && n4 % 100 == 0 && this.pf.runme == null) {
                return null;
            }
            n3 = 0;
            for (n2 = 0; n3 == 0 && n2 < constraintsBlockArray.length; ++n2) {
                constraintsBlock = constraintsBlockArray[n2];
                if (this.verifyValueConstraints(sourceArray[n4], constraintsBlock)) {
                    vector.add(sourceArray[n4]);
                    vectorArray[n2].add(sourceArray[n4]);
                    n3 = 1;
                    sourceArray[n4].isSelected[this.numero] = true;
                    sourceArray[n4].actions[this.numero] = constraintsBlock.actions;
                    sourceArray[n4].values[this.numero] = new double[sourceArray[n4].actions[this.numero].length][4];
                    for (n = 0; n < sourceArray[n4].actions[this.numero].length; ++n) {
                        sourceArray[n4].actions[this.numero][n].computeValues(sourceArray[n4], this.numero, n);
                    }
                    continue;
                }
                if (!this.convertProblem) continue;
                ++this.nbConvertProblem;
                n3 = 1;
            }
            if (n3 != 0) continue;
            sourceArray[n4].actions[this.numero] = null;
        }
        Source[][] sourceArrayArray = new Source[constraintsBlockArray.length][];
        for (n3 = 0; n3 < vectorArray.length; ++n3) {
            sourceArrayArray[n3] = new Source[vectorArray[n3].size()];
            vectorArray[n3].copyInto(sourceArrayArray[n3]);
            vectorArray[n3] = null;
        }
        for (n3 = 0; n3 < constraintsBlockArray.length; ++n3) {
            for (n2 = 0; n2 < constraintsBlockArray[n3].actions.length; ++n2) {
                constraintsBlockArray[n3].actions[n2].computeExtremum(sourceArrayArray[n3]);
            }
            for (n2 = 0; n2 < sourceArrayArray[n3].length; ++n2) {
                if (bl && n2 % 100 == 0 && this.pf.runme == null) {
                    return null;
                }
                for (n = 0; n < constraintsBlockArray[n3].actions.length; ++n) {
                    constraintsBlockArray[n3].actions[n].finalcomputeValues(sourceArrayArray[n3][n2], this.numero, n);
                }
            }
        }
        Object[] objectArray = new Source[vector.size()];
        vector.copyInto(objectArray);
        if (this.nbConvertProblem > 0) {
            Aladin.warning("Warning : there were conversion problems for " + this.nbConvertProblem + " sources", 1);
        }
        long l2 = System.currentTimeMillis();
        Aladin.trace(3, "Total time for filtering: " + (l2 - l));
        return objectArray;
    }

    protected Source[] getFilteredSources(Source[] sourceArray) {
        return this.getFilteredSources(sourceArray, false);
    }

    protected boolean hasRainbowFunction() {
        return this.definition.toLowerCase().indexOf("rainbow") >= 0;
    }

    protected double[] getRainbowMinMax() {
        for (ConstraintsBlock constraintsBlock : this.constraintsBlocks) {
            if (constraintsBlock.actions == null) continue;
            for (Action action : constraintsBlock.actions) {
                if (action.rainbowMinValue == action.rainbowMaxValue) continue;
                return new double[]{action.rainbowMinValue, action.rainbowMaxValue};
            }
        }
        return new double[]{0.0, 0.0};
    }

    protected boolean verifyValueConstraints(Source source, int n) {
        return this.verifyValueConstraints(source, this.constraintsBlocks.elementAt(n));
    }

    private boolean verifyValueConstraints(Source source, ConstraintsBlock constraintsBlock) {
        int n;
        Constraint constraint = null;
        if (constraintsBlock.valueConstraints == null) {
            return true;
        }
        int n2 = constraintsBlock.valueConstraints.length;
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            constraint = constraintsBlock.valueConstraints[n];
            blArray[n] = this.verifyOneValueConstraint(source, constraint);
            if (!this.convertProblem) continue;
            return false;
        }
        String string = new String(constraintsBlock.checkExpr);
        for (n = n2 - 1; n >= 0; --n) {
            String string2 = blArray[n] ? "1" : "0";
            string = MetaDataTree.replace(string, "\\" + n, string2, 1);
        }
        Parser parser = new Parser(string);
        parser.parseString();
        return parser.eval() > 0.0;
    }

    private boolean verifyOneValueConstraint(Source source, Constraint constraint) {
        double d = 0.0;
        String string = null;
        this.convertProblem = false;
        if (constraint.stringConstraint) {
            String string2 = constraint.ucd.substring(1, constraint.ucd.length() - 1);
            int n = constraint.ucd.startsWith("[") ? source.findUCD(string2.toUpperCase()) : source.findColumn(string2);
            if (n < 0) {
                return false;
            }
            string = source.getValue(n);
            if (string == null) {
                return false;
            }
            if (constraint.operator.equals(EQ)) {
                return this.match(constraint.strValue, string);
            }
            if (constraint.operator.equals(NE)) {
                return !this.match(constraint.strValue, string);
            }
        } else {
            if (constraint.undefinedConstraint) {
                String string3 = constraint.ucd.substring(1, constraint.ucd.length() - 1);
                if (constraint.ucd.startsWith("[")) {
                    return source.findUCD(string3.toUpperCase()) < 0;
                }
                return source.findColumn(string3) < 0;
            }
            if (!Action.setAllVariables(constraint.parser, source, false, constraint.convertUnit)) {
                return false;
            }
            d = constraint.parser.eval();
            if (constraint.convertUnit) {
                Unit unit;
                try {
                    unit = new Unit(constraint.unit);
                    Unit unit2 = constraint.parser.evalUnit();
                    unit.convertFrom(unit2);
                }
                catch (ArithmeticException arithmeticException) {
                    System.err.println(arithmeticException);
                    this.convertProblem = true;
                    return false;
                }
                catch (ParseException parseException) {
                    System.err.println(parseException);
                    this.convertProblem = true;
                    return false;
                }
                d = unit.value;
            } else {
                d = constraint.parser.eval();
            }
            return this.checkExpr(d, constraint.operator, constraint.value);
        }
        return true;
    }

    private boolean checkExpr(double d, String string, double d2) {
        if (string.equals(EQ)) {
            return d == d2;
        }
        if (string.equals(GT)) {
            return d > d2;
        }
        if (string.equals(GE)) {
            return d >= d2;
        }
        if (string.equals(LT)) {
            return d < d2;
        }
        if (string.equals(LE)) {
            return d <= d2;
        }
        if (string.equals(NE)) {
            return d != d2;
        }
        return false;
    }

    private boolean match(String string, String string2) {
        if (Source.useWildcard(string)) {
            return Util.matchMask(string, string2);
        }
        return string2.equals(MetaDataTree.replace(string, "\\*", "*", -1));
    }

    protected static Parser createParser(String string, Aladin aladin) throws ParserException {
        String[] stringArray = UCDFilter.getVariables(string, aladin);
        if (stringArray == null) {
            throw new ParserException();
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        string = new String(string);
        Parser parser = new Parser(string);
        for (int i = 0; i < stringArray.length; ++i) {
            parser.addVar(stringArray2[i]);
        }
        try {
            parser.parseString();
        }
        catch (ParserException parserException) {
            parserException.printStackTrace();
            throw new ParserException("Maybe a problem with your variables names");
        }
        return parser;
    }

    private Action[] getActions(String string) {
        Action[] actionArray;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string3 = new String("");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens() && Action.countNbOcc('(', string4) != Action.countNbOcc(')', string4)) {
                string4 = string4 + stringTokenizer.nextToken();
            }
            string4.replace('\n', ' ');
            string3 = string3 + string4 + "\n";
        }
        string = string3;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\n' || c == ';' && n4 == n2 && n3 == n) {
                string2 = stringBuffer.toString();
                if (string2.trim().length() > 0) {
                    vector.addElement(stringBuffer.toString());
                }
                stringBuffer = new StringBuffer();
                n = 0;
                n2 = 0;
                n3 = 0;
                n4 = 0;
                continue;
            }
            if (c == '{') {
                ++n4;
            } else if (c == '}') {
                ++n2;
            } else if (c == '[') {
                ++n3;
            } else if (c == ']') {
                ++n;
            }
            stringBuffer.append(c);
        }
        string2 = stringBuffer.toString();
        if (string2.trim().length() > 0) {
            vector.addElement(string2);
        }
        if (vector.size() == 0) {
            actionArray = new Action[]{new Action("drawobject", this.a, this.pf)};
        } else {
            actionArray = new Action[vector.size()];
            Enumeration enumeration = vector.elements();
            int n5 = 0;
            while (enumeration.hasMoreElements()) {
                actionArray[n5++] = new Action((String)enumeration.nextElement(), this.a, this.pf);
            }
        }
        return actionArray;
    }

    private int getOpeningBracket(String string, int n) {
        int n2;
        while (true) {
            if ((n2 = string.indexOf("{", n)) == -1) {
                return -1;
            }
            if (n2 <= 0 || string.charAt(n2 - 1) != '$') break;
            n = n2 + 1;
        }
        return n2;
    }

    private int getClosingBracket(String string, int n) {
        int n2 = n;
        int n3;
        while ((n3 = string.indexOf("}", n)) != -1) {
            String string2 = string.substring(n2, n3 + 1);
            if (Action.countNbOcc('{', string2) + 1 == Action.countNbOcc('}', string2)) {
                return n3;
            }
            n = n3 + 1;
        }
        return -1;
    }

    protected void Free() {
        if (this.constraintsBlocks != null) {
            this.constraintsBlocks.removeAllElements();
            this.constraintsBlocks = null;
        }
        this.block = null;
    }

    class ConstraintsBlock {
        Action[] actions = null;
        Constraint[] valueConstraints;
        String checkExpr;

        ConstraintsBlock() {
        }
    }

    class Constraint {
        Parser parser;
        double value;
        Unit unit;
        String operator;
        boolean stringConstraint;
        boolean convertUnit = false;
        boolean undefinedConstraint = false;
        String strValue = null;
        String ucd = null;

        Constraint(Parser parser, String string, double d) {
            this.parser = parser;
            this.operator = string;
            this.value = d;
            this.stringConstraint = false;
        }

        Constraint(Parser parser, String string, double d, Unit unit) {
            this(parser, string, d);
            this.unit = unit;
            this.convertUnit = true;
        }

        Constraint(String string, String string2, String string3) {
            this.ucd = string;
            this.operator = string2;
            this.strValue = string3;
            this.stringConstraint = true;
            if (string3.length() > 0 && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                this.strValue = string3.substring(1, string3.length() - 1);
            }
        }

        Constraint(String string) {
            this.ucd = string;
            this.undefinedConstraint = true;
        }
    }
}

