/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.GluApp;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;

public class VOToolDescription
extends JPanel {
    private static String INSTITUTE;
    private static String VERSION;
    private static String URL;
    private static String STATE;
    private static String COPYRIGHT;
    private static String SYSTEM;
    private static String DIR;
    private static String INSTALL;
    private static String[] MODEINSTALL;
    private Aladin aladin;
    private EventListener listener;
    protected GluApp vo;
    private boolean editable;
    private MyLabel name;
    private MyLabel institute;
    private MyLabel version;
    private MyLabel right;
    private MyLabel doc;
    private MyLabel install;
    private MyLabel system;
    private MyLabel dir;
    private JTextArea descr;
    private JCheckBox state;
    protected Timer timer;
    private JButton browse;
    private static final Dimension DIM;
    protected int modeB = 0;
    private static Color BG;

    protected VOToolDescription(Aladin aladin, EventListener eventListener) {
        this.aladin = aladin;
        this.listener = eventListener;
        INSTITUTE = "Origin";
        VERSION = "Version";
        STATE = "Available in the Aladin menu";
        URL = "Documentation";
        COPYRIGHT = "Copyright";
        SYSTEM = "Command line";
        DIR = "Running directory";
        INSTALL = "Install. method";
        MODEINSTALL = new String[]{"Local", "Java jar package", "Web download page", "Java Webstart (no installation)", "Java Applet (no installation)"};
        this.createPanel();
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VOToolDescription.this.downloading();
            }
        });
        this.timer.setRepeats(true);
        this.editable = false;
    }

    private String getInfo(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string;
    }

    private void createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.top += 5;
        gridBagConstraints.insets.bottom += 10;
        MyLabel myLabel = this.name = new MyLabel(this.listener);
        jPanel.add((Component)this.name, gridBagConstraints);
        myLabel.setFont(myLabel.getFont().deriveFont(1, myLabel.getFont().getSize2D() + 3.0f));
        myLabel.setForeground(Aladin.GREEN);
        gridBagConstraints.insets.top -= 5;
        gridBagConstraints.insets.bottom -= 10;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        JLabel jLabel = new JLabel(INSTITUTE + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        this.institute = new MyLabel(this.listener);
        jPanel.add((Component)this.institute, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(COPYRIGHT + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        myLabel = this.right = new MyLabel(this.listener);
        jPanel.add((Component)this.right, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(URL + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        myLabel = this.doc = new MyLabel(this.listener);
        jPanel.add((Component)this.doc, gridBagConstraints);
        myLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (VOToolDescription.this.doc.getToolTipText() == null) {
                    return;
                }
                ((VOToolDescription)VOToolDescription.this).aladin.glu.showDocument("Http", ((JLabel)mouseEvent.getSource()).getToolTipText(), true);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (VOToolDescription.this.doc.getToolTipText() == null) {
                    return;
                }
                VOToolDescription.this.doc.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (VOToolDescription.this.doc.getToolTipText() == null) {
                    return;
                }
                VOToolDescription.this.doc.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (VOToolDescription.this.doc.getToolTipText() == null) {
                    return;
                }
                VOToolDescription.this.doc.setForeground(new Color(128, 0, 128));
            }
        });
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top += 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        JTextArea jTextArea = this.descr = new JTextArea();
        jPanel.add((Component)new JScrollPane(this.descr), gridBagConstraints);
        jTextArea.setFont(Aladin.PLAIN);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top -= 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top += 10;
        jLabel = new JLabel(VERSION + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        myLabel = this.version = new MyLabel(this.listener);
        jPanel.add((Component)this.version, gridBagConstraints);
        myLabel.setFont(myLabel.getFont().deriveFont(1));
        gridBagConstraints.insets.top -= 10;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(INSTALL + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        myLabel = this.install = new MyLabel(this.listener);
        jPanel.add((Component)this.install, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(DIR + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.dir = new MyLabel(this.listener);
        jPanel2.add((Component)this.dir, "Center");
        JButton jButton = this.browse = new JButton("Browse");
        jPanel2.add((Component)this.browse, "East");
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VOToolDescription.this.dirBrowser();
            }
        });
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(SYSTEM + " : ");
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        ++gridBagConstraints.gridx;
        this.system = new MyLabel(50, this.listener);
        jPanel.add((Component)this.system, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        this.state = new JCheckBox(STATE);
        jPanel.add((Component)this.state, gridBagConstraints);
        this.state.setFont(this.state.getFont().deriveFont(1));
        this.state.addActionListener((ActionListener)this.listener);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)jPanel, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public Dimension getPreferredSize() {
        return DIM;
    }

    private void dirBrowser() {
        FileDialog fileDialog = new FileDialog((Frame)this.aladin.dialog, "Running directory selection");
        if (this.dir != null) {
            fileDialog.setDirectory(this.dir.getText());
        }
        fileDialog.setFile("-");
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 != null && string2.equals("-")) {
            string2 = "";
        }
        String string3 = (string == null ? "" : string) + (string2 == null ? "" : string2);
        this.dir.setText(string3);
        this.aladin.frameVOTool.apply.setEnabled(this.hasBeenChanged());
    }

    protected boolean hasBeenChanged() {
        if (this.vo == null) {
            return false;
        }
        if (this.editable && this.name.getText().trim().length() > 0) {
            return true;
        }
        if (this.vo.isActivated() != this.state.isSelected()) {
            return true;
        }
        if (this.system.hasBeenEdited()) {
            return true;
        }
        return this.dir.hasBeenEdited();
    }

    protected GluApp apply() {
        this.vo.activated = this.state.isSelected() ? "Yes" : "No";
        String string = this.dir.getText().trim();
        this.vo.dir = string.length() > 0 ? string : null;
        string = this.system.getText().trim();
        String string2 = this.vo.getJavaCommand();
        if (string2 != null && string2.equals(string)) {
            string = "";
        }
        this.vo.system = string.length() > 0 ? string : null;
        if (this.editable) {
            string = this.name.getText().trim();
            this.vo.aladinLabel = string.length() > 0 ? string : null;
            string = this.institute.getText().trim();
            this.vo.institute = string.length() > 0 ? string : null;
            string = this.version.getText().trim();
            this.vo.releaseNumber = string.length() > 0 ? string : "0";
            string = this.right.getText().trim();
            this.vo.copyright = string.length() > 0 ? string : null;
            this.setEditable(false);
        }
        this.setVOtool(this.vo);
        return this.vo;
    }

    private void downloading() {
        String string = this.modeB == 3 ? "..." : (this.modeB == 2 ? ".." : (this.modeB == 1 ? "." : ""));
        ++this.modeB;
        if (this.modeB > 3) {
            this.modeB = 0;
        }
        String string2 = (this.vo.nextNumber != null ? this.vo.nextNumber : this.vo.releaseNumber) + " downloading (" + this.vo.downloading / 1024L + " KB)" + string;
        this.version.setText(string2);
    }

    protected void setEditable(boolean bl) {
        this.editable = bl;
        this.name.setEditable(bl);
        this.institute.setEditable(bl);
        this.version.setEditable(bl);
        this.right.setEditable(bl);
        this.descr.setEditable(bl);
    }

    protected void setVOtool(GluApp gluApp) {
        String string;
        this.vo = gluApp;
        int n = gluApp == null ? 0 : gluApp.getInstallMode();
        this.name.setText(gluApp == null ? "" : this.getInfo(gluApp.aladinLabel));
        this.institute.setText(gluApp == null ? "" : this.getInfo(gluApp.institute));
        this.version.setForeground(Color.black);
        if (gluApp == null) {
            string = null;
            this.setEditable(false);
        } else if (this.editable) {
            string = this.getInfo(gluApp.releaseNumber);
        } else if (gluApp.downloading != -1L) {
            string = "";
            this.version.setForeground(Color.orange.darker());
            this.timer.start();
        } else {
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            if (gluApp.releaseNumber == null) {
                string = "";
                this.version.setForeground(Color.black);
            } else if (gluApp.canBeRun()) {
                string = this.getInfo(gluApp.releaseNumber + (n == 3 || n == 4 ? "" : " installed"));
                this.version.setForeground(Aladin.GREEN);
                if (gluApp.nextNumber != null) {
                    string = string + " - new available version: " + gluApp.nextNumber;
                    this.version.setForeground(Color.orange.darker());
                }
            } else {
                string = gluApp.nextNumber != null ? this.getInfo(gluApp.nextNumber + " not installed") : this.getInfo(gluApp.releaseNumber + " not installed");
                this.version.setForeground(Color.red);
            }
        }
        this.version.setText(string);
        this.install.setText(gluApp == null ? "" : MODEINSTALL[n]);
        if (n == 4 || n == 3) {
            this.dir.setMemo(" --");
            this.dir.setEditable(false);
            this.system.setMemo(" -- ");
            this.system.setEditable(false);
            this.browse.setEnabled(false);
        } else {
            this.dir.setMemo(gluApp.jarUrl != null ? this.aladin.getVOPath() : "", gluApp == null ? null : gluApp.dir);
            this.system.setMemo(gluApp.javaParam != null ? gluApp.getJavaCommand() : "", gluApp == null ? "" : gluApp.getCommand());
            this.browse.setEnabled(true);
        }
        this.descr.setText(gluApp == null ? "" : this.getInfo(gluApp.verboseDescr != null ? gluApp.verboseDescr : gluApp.description));
        this.descr.setCaretPosition(0);
        this.right.setText(gluApp == null ? "" : this.getInfo(gluApp.copyright));
        if (gluApp == null || gluApp.docUrl == null) {
            this.doc.setText("");
        } else if (gluApp.docUrl != null) {
            this.doc.setForeground(Color.blue);
            Util.toolTip(this.doc, gluApp.docUrl);
            this.doc.setText(VOToolDescription.cut(gluApp.docUrl, 60));
        } else {
            Util.toolTip(this.doc, null);
        }
        this.state.setSelected(gluApp != null && gluApp.isActivated());
        this.state.setEnabled(gluApp != null && gluApp.canBeRun());
    }

    static String cut(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n - 2) + "...";
    }

    static {
        DIM = new Dimension(550, 350);
        BG = new JLabel().getBackground();
    }

    class MyLabel
    extends JTextField
    implements KeyListener {
        private Border border;
        private Border emptyBorder;
        private String memo;
        private String init;
        private boolean listen;

        MyLabel(EventListener eventListener) {
            this.emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.listen = false;
            this.suite(eventListener);
        }

        MyLabel(int n, EventListener eventListener) {
            super(n);
            this.emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.listen = false;
            this.suite(eventListener);
        }

        private void suite(EventListener eventListener) {
            this.border = this.getBorder();
            this.setEditable(false);
            this.addKeyListener((KeyListener)eventListener);
        }

        protected void setMemo(String string) {
            this.setMemo(string, null);
        }

        protected void setMemo(String string, String string2) {
            this.memo = string;
            this.init = string2 == null ? string : string2;
            this.setText(this.init);
            this.setEditable(true);
            if (!this.listen) {
                this.addKeyListener(this);
                this.listen = true;
            }
        }

        public boolean hasBeenChanged() {
            if (!this.isEditable() || this.memo == null) {
                return false;
            }
            return !this.getText().trim().equals(this.memo);
        }

        public boolean hasBeenEdited() {
            if (!this.isEditable() || this.init == null) {
                return false;
            }
            return !this.getText().trim().equals(this.init);
        }

        @Override
        public void setEditable(boolean bl) {
            super.setEditable(bl);
            this.setBackground(bl ? Color.white : BG);
            this.setBorder(bl ? this.border : this.emptyBorder);
            this.setCaretPosition(0);
        }

        @Override
        public void setText(String string) {
            super.setText(string);
            if (this.memo != null || this.init != null) {
                this.testChange();
            }
        }

        private void testChange() {
            Color color;
            Color color2 = color = this.hasBeenChanged() || this.hasBeenEdited() ? Color.black : Color.gray;
            if (this.getForeground() != color) {
                this.setForeground(color);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.testChange();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

