/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public final class ViewControl
extends JComponent
implements MouseMotionListener,
MouseListener {
    static final int MVIEW1 = 1;
    static final int MVIEW2C = 2;
    static final int MVIEW2L = 3;
    static final int MVIEW4 = 4;
    static final int MVIEW9 = 9;
    static final int MVIEW16 = 16;
    static final int DEFAULT = 1;
    static final int[] MODE = new int[]{1, 2, 3, 4, 9, 16};
    static final int MAXVIEW = 16;
    String INFOMVIEW;
    String INFOSYNC;
    String LABEL;
    static final int SL = 18;
    static final int L = 12;
    static final int H = 24;
    static final int W = 14 * MODE.length + 2;
    protected int modeView = 1;
    private int nMode = -1;
    Aladin aladin;
    private boolean enabled = false;

    protected ViewControl(Aladin aladin) {
        this.aladin = aladin;
        this.INFOMVIEW = Aladin.chaine.getString("MVIEWDESC");
        this.LABEL = Aladin.chaine.getString("MVIEWLABEL");
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(W, 24);
    }

    protected static int getLevel(int n) {
        for (int i = 0; i < MODE.length; ++i) {
            if (MODE[i] != n) continue;
            return i;
        }
        return -1;
    }

    protected static int nextModeView(int n) {
        int n2 = ViewControl.getLevel(n) + 1;
        if (n2 >= MODE.length) {
            return -1;
        }
        return MODE[n2];
    }

    protected static void moveViewOrder(ViewSimple[] viewSimpleArray, int n, int n2, boolean bl) {
        viewSimpleArray[n].copyIn(viewSimpleArray[n2]);
        if (!bl) {
            viewSimpleArray[n].free();
        }
        ViewControl.setGoodViewNumber(viewSimpleArray);
    }

    protected static void setGoodViewNumber(ViewSimple[] viewSimpleArray) {
        for (int i = 0; i < 16; ++i) {
            viewSimpleArray[i].n = i;
        }
    }

    protected int getNbView(int n) {
        return n == 3 ? 2 : n;
    }

    protected int getNbLig() {
        return this.getNbLig(this.modeView);
    }

    protected int getNbLig(int n) {
        if (n == 3) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        return (int)Math.sqrt(n);
    }

    protected int getNbCol() {
        return this.getNbCol(this.modeView);
    }

    protected int getNbCol(int n) {
        if (n == 3) {
            return 2;
        }
        if (n == 2) {
            return 1;
        }
        return (int)Math.sqrt(n);
    }

    private void drawLogo(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, W, 24);
        for (int i = 0; i < MODE.length; ++i) {
            int n = MODE[i];
            boolean bl = this.modeView == n;
            boolean bl2 = !bl && this.nMode == i;
            int n2 = this.getNbLig(n);
            int n3 = this.getNbCol(n);
            int n4 = 12 / n3;
            int n5 = 12 / n2;
            int n6 = 12 / n3 - 2;
            int n7 = 12 / n2 - 2;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    int n8 = 5 + i * 14 + j * n4;
                    int n9 = 2 + k * n5;
                    if (bl || bl2) {
                        graphics.setColor(!this.enabled ? Aladin.MYGRAY : (bl2 ? Aladin.MYBLUE : Aladin.DARKBLUE));
                        graphics.fillRect(n8, n9, n6, n7);
                    }
                    graphics.setColor(!this.enabled ? Aladin.MYGRAY : (bl || bl2 ? Color.black : Color.white));
                    graphics.drawLine(n8, n9, n8 + n6, n9);
                    graphics.drawLine(n8, n9, n8, n9 + n7);
                    graphics.setColor(!this.enabled ? Aladin.MYGRAY : (!bl || bl2 ? Color.black : Color.white));
                    graphics.drawLine(n8 + n6, n9, n8 + n6, n9 + n7);
                    graphics.drawLine(n8, n9 + n7, n8 + n6, n9 + n7);
                }
            }
        }
        graphics.setColor(!this.enabled ? Aladin.MYGRAY : Color.black);
        graphics.setFont(Aladin.SPLAIN);
        graphics.drawString(this.LABEL, (W + 6) / 2 - graphics.getFontMetrics().stringWidth(this.LABEL) / 2, 22);
    }

    private void computeModeView(int n) {
        this.modeView = MODE[this.getN(n)];
    }

    private int getN(int n) {
        int n2 = n / (W / MODE.length);
        if (n2 >= MODE.length) {
            n2 = MODE.length - 1;
        }
        return n2;
    }

    protected void setModeView(int n) {
        this.modeView = n;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
        Aladin.makeCursor(this, 2);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Aladin.makeCursor(this, 0);
        this.nMode = -1;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            return;
        }
        this.computeModeView(mouseEvent.getX());
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        Aladin.makeCursor(this, 1);
        this.computeModeView(mouseEvent.getX());
        this.aladin.view.setModeView(this.modeView);
        this.aladin.console.printCommand("modeview " + this.modeView);
        this.aladin.toolBox.toolMode();
        Aladin.makeCursor(this, 0);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            return;
        }
        int n = this.getN(mouseEvent.getX());
        if (n != this.nMode) {
            this.nMode = n;
            this.repaint();
        }
        Util.toolTip(this, n == -2 ? this.INFOSYNC : this.INFOMVIEW);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.enabled = !this.aladin.msgOn;
        this.drawLogo(graphics);
    }

    protected String Help() {
        return Aladin.chaine.getString("ViewControl.HELP");
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

