/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Plan;
import cds.aladin.ViewMemoItem;
import cds.aladin.ViewSimple;

public final class ViewMemo {
    private static int BLOC = 64;
    protected ViewMemoItem[] memo;
    private int nb = 0;

    protected ViewMemo() {
    }

    protected int size() {
        return this.nb;
    }

    protected ViewMemo copy() {
        ViewMemo viewMemo = new ViewMemo();
        viewMemo.memo = new ViewMemoItem[this.memo.length];
        viewMemo.nb = this.nb;
        for (int i = 0; i < this.nb; ++i) {
            viewMemo.memo[i] = this.memo[i].copy();
        }
        return viewMemo;
    }

    private void fixeNb() {
    }

    private void extension(int n) {
        if (this.memo == null || this.memo.length <= n) {
            ViewMemoItem[] viewMemoItemArray = new ViewMemoItem[n + BLOC];
            if (this.memo != null) {
                System.arraycopy(this.memo, 0, viewMemoItemArray, 0, this.memo.length);
            }
            this.memo = viewMemoItemArray;
        }
    }

    protected void set(int n, ViewSimple viewSimple) {
        this.extension(n);
        ViewMemoItem viewMemoItem = this.memo[n] = viewSimple == null ? null : new ViewMemoItem(viewSimple);
        if (n >= this.nb) {
            this.nb = n + 1;
        }
    }

    protected void set(int n, ViewMemoItem viewMemoItem) {
        this.extension(n);
        this.memo[n] = viewMemoItem;
        if (n >= this.nb) {
            this.nb = n + 1;
        }
    }

    protected void cale(int n) {
        for (int i = n; i < this.nb; ++i) {
            this.memo[i - 1] = this.memo[i];
        }
        this.memo[--this.nb] = null;
    }

    protected void decale(int n) {
        this.set(this.nb, (ViewSimple)null);
        for (int i = this.nb - 1; i > n; --i) {
            this.memo[i] = this.memo[i - 1];
        }
        this.memo[n] = null;
    }

    protected boolean isUsed(Plan plan) {
        return this.find(plan, 0) != -1;
    }

    protected int find(Plan plan, int n) {
        int n2 = 0;
        while (n2 < this.nb) {
            if (n == this.nb) {
                n = 0;
            }
            if (this.memo[n] != null && this.memo[n].pref == plan) {
                return n;
            }
            ++n2;
            ++n;
        }
        return -1;
    }

    protected int getLastUsed() {
        int n = -1;
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || this.memo[i].pref == null) continue;
            n = i;
        }
        return n;
    }

    protected int getNbUsed() {
        int n = 0;
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || this.memo[i].pref == null) continue;
            ++n;
        }
        return n;
    }

    protected int setAfter(int n, ViewSimple viewSimple) {
        ++n;
        while (n < this.nb && this.memo[n] != null && this.memo[n].pref != null) {
            ++n;
        }
        this.set(n, viewSimple);
        return n;
    }

    protected ViewSimple get(int n, ViewSimple viewSimple) {
        if (viewSimple == null || n >= this.nb || this.memo[n] == null) {
            return null;
        }
        return this.memo[n].get(viewSimple);
    }

    protected void free(int n) {
        if (n < this.memo.length) {
            this.memo[n] = null;
        }
        this.fixeNb();
    }

    protected void freeAll() {
        for (int i = 0; i < this.nb; ++i) {
            this.memo[i] = null;
        }
        this.fixeNb();
    }

    protected void freeLock() {
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || !this.memo[i].locked) continue;
            this.memo[i] = null;
        }
        this.fixeNb();
    }

    protected boolean hasLock() {
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || !this.memo[i].locked) continue;
            return true;
        }
        return false;
    }

    protected void freeSelected() {
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || !this.memo[i].selected) continue;
            this.memo[i] = null;
        }
        this.fixeNb();
    }

    protected boolean freeRef(Plan plan) {
        boolean bl = false;
        for (int i = 0; i < this.nb; ++i) {
            if (this.memo[i] == null || this.memo[i].pref != plan) continue;
            bl = true;
            this.memo[i] = null;
        }
        this.fixeNb();
        return bl;
    }
}

