/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Widget;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;

public class WidgetControl {
    private static final int IN = 0;
    private static final int HG = 1;
    private static final int H = 2;
    private static final int HD = 3;
    private static final int D = 4;
    private static final int BD = 5;
    private static final int B = 6;
    private static final int BG = 7;
    private static final int G = 8;
    private static final int INHEAD = 9;
    private static final int INCOLLAPSED = 10;
    private static final int NW = 0;
    private static final int NE = 16;
    private static final int SE = 17;
    private static final int SW = 1;
    public static final int NOTHING = 0;
    public static final int DISPOSE = 1;
    public static final int UP = 2;
    static final int[] CURSOR = new int[]{12, 6, 8, 7, 11, 5, 9, 4, 10};
    private static final Color BLUE = new Color(150, 150, 255);
    private static final int HB = 12;
    private static final int WCOLLAPSED = 25;
    private static final int DS = 5;
    private static final int W = 16;
    private int position = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private float opacity = 1.0f;
    private JComponent c;
    private Rectangle closeButton;
    private boolean movable = true;
    private boolean resizable = false;
    private boolean collapsable = true;
    private JComponent parent = null;
    private boolean isCollapsed = false;
    private boolean in = false;
    private boolean inHead = false;
    private boolean inCollapsed = false;
    private boolean inShowHead = false;
    private boolean flagControl = false;
    private int poignee = -1;
    private int dragPoignee = -1;
    private int xDrag = 0;
    private int yDrag = 0;
    private boolean flagMove = false;
    private boolean draggedDone = false;

    public WidgetControl(JComponent jComponent, int n, int n2, int n3, int n4, float f, JComponent jComponent2) {
        this.c = jComponent;
        this.parent = jComponent2;
        this.setX(n);
        this.setY(n2);
        if (f <= 0.0f) {
            f = 1.0f;
        }
        this.setOpacity(f);
        if (n3 <= 0) {
            n3 = jComponent.getWidth();
        }
        if (n4 <= 0) {
            n4 = jComponent.getHeight();
        }
        this.setSize(n3, n4);
        this.setCollapsed(true);
    }

    public void setSize(int n, int n2) {
        this.c.setSize(n, n2);
        this.width = this.c.getWidth();
        this.height = this.c.getHeight();
    }

    public void setOpacity(float f) {
        this.opacity = f;
    }

    public void setMovable(boolean bl) {
        this.movable = bl;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public void setCollapsable(boolean bl) {
        this.collapsable = bl;
    }

    public void setCollapsed(boolean bl) {
        if (bl == this.isCollapsed) {
            return;
        }
        this.isCollapsed = bl;
        int n = this.getX();
        int n2 = this.getY();
        int n3 = 0;
        int n4 = 0;
        if (this.aDroite()) {
            n3 = this.width - 25;
        }
        if (this.enBas()) {
            n4 = this.height - 25;
        }
        if (this.isCollapsed) {
            n += n3;
            n2 += n4;
        } else {
            n -= n3;
            n2 -= n4;
        }
        this.setX(n);
        this.setY(n2);
        this.draggedDone = false;
        this.flagMove = false;
    }

    public int getX() {
        if (this.parent == null) {
            return this.x;
        }
        if (this.aDroite()) {
            return this.parent.getWidth() - this.x;
        }
        return this.x;
    }

    public int getY() {
        if (this.parent == null) {
            return this.y;
        }
        if (this.enBas()) {
            return this.parent.getHeight() - this.y;
        }
        return this.y;
    }

    private void setX(int n) {
        if (this.parent == null) {
            this.x = n;
        } else {
            this.position = n > this.parent.getWidth() / 2 ? (this.position |= 0x10) : (this.position &= 1);
        }
        this.x = this.aDroite() ? this.parent.getWidth() - n : n;
    }

    private void setY(int n) {
        if (this.parent == null) {
            this.y = n;
        } else {
            this.position = n > this.parent.getHeight() / 2 ? (this.position |= 1) : (this.position &= 0x10);
        }
        this.y = this.enBas() ? this.parent.getHeight() - n : n;
    }

    private boolean aDroite() {
        return (this.position & 0x10) != 0;
    }

    private boolean enBas() {
        return (this.position & 1) != 0;
    }

    public Cursor getCursor() {
        if (this.parent == null) {
            return null;
        }
        Cursor cursor = this.c.getCursor();
        this.parent.setCursor(cursor);
        return cursor;
    }

    public boolean isActivated(MouseEvent mouseEvent) {
        this.isMouseIn(mouseEvent);
        return this.flagMove || this.flagControl;
    }

    public boolean isCollapsed() {
        return this.collapsable;
    }

    public boolean isMouseIn(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getX();
        int n4 = this.getY();
        if (this.isCollapsed) {
            this.in = n3 <= n && n <= n3 + 25 && n4 <= n2 && n2 < n4 + 25;
            return this.in;
        }
        int n5 = this.flagControl ? 8 : 0;
        boolean bl2 = bl = n3 - n5 <= n && n <= n3 + this.width + n5 && n4 - 12 - n5 <= n2 && n2 < n4 + this.height + n5;
        if (this.c instanceof MouseListener && this.in != bl) {
            mouseEvent.translatePoint(-n3, -n4);
            if (!this.in && bl) {
                ((MouseListener)((Object)this.c)).mouseEntered(mouseEvent);
            } else if (this.in && !bl) {
                ((MouseListener)((Object)this.c)).mouseExited(mouseEvent);
            }
            mouseEvent.translatePoint(n3, n4);
        }
        this.in = bl;
        this.inHead = (this.movable || this.resizable || this.collapsable) && n3 <= n && n <= n3 + this.width && n4 - 12 <= n2 && n2 <= n4;
        this.inShowHead = (this.movable || this.resizable || this.collapsable) && n3 <= n && n <= n3 + this.width && n4 - 12 <= n2 && n2 <= n4 + 12;
        return bl || this.inHead;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getX();
        int n2 = this.getY();
        boolean bl = this.inCollapsed = this.closeButton != null && this.closeButton.contains(mouseEvent.getX() - n, mouseEvent.getY() - n2);
        if (this.flagControl) {
            this.poignee = this.getPoignee(mouseEvent.getX() - n, mouseEvent.getY() - n2);
            if (this.poignee >= 0 && this.poignee < CURSOR.length) {
                Cursor cursor = Cursor.getPredefinedCursor(CURSOR[this.poignee]);
                this.c.setCursor(cursor);
            }
        }
        if (!(this.c instanceof MouseMotionListener)) {
            return;
        }
        mouseEvent.translatePoint(-n, -n2);
        ((MouseMotionListener)((Object)this.c)).mouseMoved(mouseEvent);
        mouseEvent.translatePoint(n, n2);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.inHead && !this.flagControl && this.movable) {
            this.startMove(mouseEvent);
        } else if (this.flagControl && this.resizable) {
            this.startResize(mouseEvent);
        } else {
            if (!(this.c instanceof MouseListener)) {
                return;
            }
            int n = this.getX();
            int n2 = this.getY();
            mouseEvent.translatePoint(-n, -n2);
            ((MouseListener)((Object)this.c)).mousePressed(mouseEvent);
            mouseEvent.translatePoint(n, n2);
        }
        this.draggedDone = false;
    }

    private void startMove(MouseEvent mouseEvent) {
        this.xDrag = mouseEvent.getX();
        this.yDrag = mouseEvent.getY();
        this.dragPoignee = 9;
        this.flagMove = true;
    }

    private void startResize(MouseEvent mouseEvent) {
        this.xDrag = mouseEvent.getX();
        this.yDrag = mouseEvent.getY();
        int n = this.getX();
        int n2 = this.getY();
        this.dragPoignee = this.getPoignee(this.xDrag - n, this.yDrag - n2);
    }

    public int mouseReleased(MouseEvent mouseEvent) {
        int n = this.inHead && !this.draggedDone ? 2 : 0;
        int n2 = this.getX();
        int n3 = this.getY();
        int n4 = this.getAction(mouseEvent.getX() - n2, mouseEvent.getY() - n3);
        if (n4 == 10 && !this.draggedDone) {
            this.setCollapsed(!this.isCollapsed);
        } else if (this.flagControl) {
            this.flagControl = this.draggedDone || this.poignee > 0 && this.poignee < 9;
            this.draggedDone = false;
            this.setSize(this.width, this.height);
        } else if (this.flagMove && !this.draggedDone && this.resizable) {
            this.flagControl = true;
            this.flagMove = false;
        } else if (this.flagMove) {
            this.flagMove = false;
        } else {
            if (!(this.c instanceof MouseListener)) {
                return n;
            }
            mouseEvent.translatePoint(-n2, -n3);
            ((MouseListener)((Object)this.c)).mouseReleased(mouseEvent);
            mouseEvent.translatePoint(n2, n3);
        }
        this.draggedDone = false;
        return n;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isCollapsed) {
            return;
        }
        this.draggedDone = true;
        if (this.flagMove || this.flagControl) {
            this.mouseDrag(mouseEvent);
            return;
        }
        if (this.c instanceof MouseMotionListener) {
            int n = this.getX();
            int n2 = this.getY();
            mouseEvent.translatePoint(-n, -n2);
            ((MouseMotionListener)((Object)this.c)).mouseDragged(mouseEvent);
            mouseEvent.translatePoint(n, n2);
        }
    }

    public void mouseWheel(MouseWheelEvent mouseWheelEvent) {
        if (this.inHead) {
            this.opacity = (float)((double)this.opacity + (double)mouseWheelEvent.getWheelRotation() / 5.0);
            if ((double)this.opacity < 0.2) {
                this.opacity = 0.2f;
            } else if (this.opacity > 1.0f) {
                this.opacity = 1.0f;
            }
        } else if (this.c instanceof MouseWheelListener) {
            int n = this.getX();
            int n2 = this.getY();
            mouseWheelEvent.translatePoint(-n, -n2);
            ((MouseWheelListener)((Object)this.c)).mouseWheelMoved(mouseWheelEvent);
            mouseWheelEvent.translatePoint(n, n2);
        }
    }

    private void mouseDrag(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.xDrag;
        int n2 = mouseEvent.getY() - this.yDrag;
        if (n == 0 && n2 == 0) {
            return;
        }
        int n3 = this.getX();
        int n4 = this.getY();
        this.xDrag = mouseEvent.getX();
        this.yDrag = mouseEvent.getY();
        switch (this.dragPoignee) {
            case 0: 
            case 9: {
                n3 += n;
                n4 += n2;
                break;
            }
            case 1: {
                n3 += n;
                n4 += n2;
                this.width -= n;
                this.height -= n2;
                break;
            }
            case 3: {
                n4 += n2;
                this.width += n;
                this.height -= n2;
                break;
            }
            case 5: {
                this.width += n;
                this.height += n2;
                break;
            }
            case 7: {
                n3 += n;
                this.width -= n;
                this.height += n2;
                break;
            }
            case 2: {
                n4 += n2;
                this.height -= n2;
                break;
            }
            case 4: {
                this.width += n;
                break;
            }
            case 6: {
                this.height += n2;
                break;
            }
            case 8: {
                n3 += n;
                this.width -= n;
            }
        }
        this.setX(n3);
        this.setY(n4);
    }

    private int getPoignee(int n, int n2) {
        if (this.width == 1 || this.height == 1) {
            return 5;
        }
        if (this.closeButton != null && this.closeButton.contains(n, n2)) {
            return 10;
        }
        for (int i = 1; i <= 8; ++i) {
            Rectangle rectangle = this.getRectPoignee(i);
            if (!rectangle.contains(n, n2)) continue;
            return i;
        }
        return this.inHead ? 9 : (this.in ? 0 : -1);
    }

    private int getAction(int n, int n2) {
        if (this.isCollapsed && this.in) {
            return 10;
        }
        if (this.closeButton != null && this.closeButton.contains(n, n2)) {
            return 10;
        }
        return -1;
    }

    private Rectangle getRectPoignee(int n) {
        int n2 = 16;
        int n3 = n2 / 2;
        switch (n) {
            case 1: {
                return new Rectangle(-n3, -n3 - 12, n2, n2);
            }
            case 3: {
                return new Rectangle(this.width - n3, -n3 - 12, n2, n2);
            }
            case 5: {
                return new Rectangle(this.width - n3, this.height - n3, n2, n2);
            }
            case 7: {
                return new Rectangle(-n3, this.height - n3, n2, n2);
            }
            case 2: {
                return new Rectangle(this.width / 2 - n3, -n3 - 12, n2, n2);
            }
            case 4: {
                return new Rectangle(this.width - n3, this.height / 2 - n3, n2, n2);
            }
            case 8: {
                return new Rectangle(-n3, this.height / 2 - n3, n2, n2);
            }
            case 6: {
                return new Rectangle(this.width / 2 - n3, this.height - n3, n2, n2);
            }
        }
        return null;
    }

    private void drawControl(Graphics graphics) {
        if (!this.movable && !this.resizable) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int n = (i == 0 || i >= 6 ? 0 : (i == 1 || i == 5 ? this.width / 2 : this.width)) - 2;
            int n2 = (i <= 2 ? -12 : (i == 3 || i == 7 ? this.height / 2 : this.height)) - 2;
            graphics.setColor(i + 1 == this.poignee ? Color.red : Color.green);
            this.drawPoignee(graphics, n, n2);
        }
    }

    protected void drawPoignee(Graphics graphics, int n, int n2) {
        graphics.fillRect(n + 1, n2 + 1, 5, 5);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, 5, 5);
    }

    private void drawClose(Graphics graphics) {
        if (!this.collapsable) {
            return;
        }
        int n = 7;
        int n2 = -(12 + n) / 2 - 1;
        int n3 = this.width - n - 3;
        graphics.setColor(this.inCollapsed ? Color.red : new Color(220, 220, 220));
        graphics.fillRect(n3, n2, n + 1, n + 1);
        graphics.setColor(this.inCollapsed ? Color.white : Color.red);
        graphics.drawLine(n3 + n / 2 - 3, n2 + n / 2 - 3, n3 + n / 2 + 3, n2 + n / 2 + 3);
        graphics.drawLine(n3 + n / 2 - 2, n2 + n / 2 - 3, n3 + n / 2 + 4, n2 + n / 2 + 3);
        graphics.drawLine(n3 + n / 2 - 3, n2 + n / 2 + 3, n3 + n / 2 + 3, n2 + n / 2 - 3);
        graphics.drawLine(n3 + n / 2 - 2, n2 + n / 2 + 3, n3 + n / 2 + 4, n2 + n / 2 - 3);
        this.closeButton = new Rectangle(n3, n2, n, n);
    }

    private void drawHead(Graphics graphics) {
        if (!(this.movable || this.resizable || this.collapsable)) {
            return;
        }
        graphics.setColor(BLUE);
        graphics.fillRect(0, -12, this.width, 12);
        this.drawClose(graphics);
    }

    private void drawBorder(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawRect(0, -12, this.width, this.height + 12);
    }

    private void paintControl(Graphics graphics) {
        if (!(this.in || this.inHead || this.flagControl)) {
            return;
        }
        graphics.setClip(-2, -14, this.width + 5 + 1, this.height + 12 + 5 + 1);
        if (this.inShowHead || this.flagControl) {
            this.drawHead(graphics);
        }
        if (this.flagControl) {
            this.drawBorder(graphics);
            this.drawControl(graphics);
        }
    }

    private void paintCollapsed(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        int n = this.getX();
        int n2 = this.getY();
        graphics2D.translate(n, n2);
        graphics2D.setClip(0, 0, this.width, this.height);
        graphics.setColor(Color.lightGray);
        graphics.fillRoundRect(0, 0, 25, 25, 3, 3);
        ((Widget)((Object)this.c)).paintCollapsed(graphics);
        graphics.setColor(Color.gray);
        graphics.drawRoundRect(0, 0, 25, 25, 3, 3);
        graphics.drawRoundRect(1, 1, 23, 23, 3, 3);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    public void paint(Graphics graphics) {
        if (this.isCollapsed) {
            this.paintCollapsed(graphics);
            return;
        }
        this.setSize(this.width, this.height);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Composite composite = graphics2D.getComposite();
        Shape shape = graphics2D.getClip();
        if (this.opacity != 1.0f) {
            Composite composite2 = Util.getImageComposite(this.opacity);
            graphics2D.setComposite(composite2);
        }
        int n = this.getX();
        int n2 = this.getY();
        graphics2D.translate(n, n2);
        graphics2D.setClip(0, 0, this.width, this.height);
        this.c.paint(graphics2D);
        if (this.opacity != 1.0f) {
            graphics2D.setComposite(composite);
        }
        this.paintControl(graphics);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
    }

    private String getPosCode() {
        return this.position == 0 ? "NW" : (this.position == 16 ? "NE" : (this.position == 1 ? "SW" : "SE"));
    }

    public String toString() {
        return this.c.getClass().getCanonicalName() + " (" + this.x + "," + this.y + " " + this.width + "x" + this.height + ") pos=" + this.getPosCode();
    }
}

