/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

public class WidgetController {
    private ArrayList<Widget> widgets = new ArrayList();
    private Cursor cursor = null;

    public void addWidget(Widget widget) {
        if (this.widgets.contains(widget)) {
            return;
        }
        this.widgets.add(widget);
    }

    public void removeWidget(Widget widget) {
        this.widgets.remove(widget);
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void paint(Graphics graphics) {
        for (Widget widget : this.widgets) {
            widget.getWidgetControl().paint(graphics);
        }
    }

    public boolean mouseMoved(MouseEvent mouseEvent) {
        return this.mouseAction(mouseEvent, 0);
    }

    public boolean mouseDragged(MouseEvent mouseEvent) {
        return this.mouseAction(mouseEvent, 1);
    }

    public boolean mousePressed(MouseEvent mouseEvent) {
        return this.mouseAction(mouseEvent, 2);
    }

    public boolean mouseReleased(MouseEvent mouseEvent) {
        return this.mouseAction(mouseEvent, 3);
    }

    public boolean mouseWheel(MouseEvent mouseEvent) {
        return this.mouseAction(mouseEvent, 4);
    }

    private boolean mouseAction(MouseEvent mouseEvent, int n) {
        boolean bl = false;
        WidgetControl widgetControl = null;
        for (Widget widget : this.widgets) {
            widgetControl = widget.getWidgetControl();
            if (!widgetControl.isActivated(mouseEvent)) continue;
            bl = this.mouseActionOne(mouseEvent, widget, n);
            break;
        }
        if (!bl) {
            for (int i = this.widgets.size() - 1; i >= 0; --i) {
                Widget widget;
                widget = this.widgets.get(i);
                widgetControl = widget.getWidgetControl();
                if (!widgetControl.isMouseIn(mouseEvent)) continue;
                bl = this.mouseActionOne(mouseEvent, widget, n);
                break;
            }
        }
        if (bl) {
            this.cursor = widgetControl.getCursor();
        }
        return bl;
    }

    private boolean mouseActionOne(MouseEvent mouseEvent, Widget widget, int n) {
        WidgetControl widgetControl = widget.getWidgetControl();
        switch (n) {
            case 0: {
                widgetControl.mouseMoved(mouseEvent);
                return true;
            }
            case 1: {
                widgetControl.mouseDragged(mouseEvent);
                return true;
            }
            case 2: {
                widgetControl.mousePressed(mouseEvent);
                return true;
            }
            case 3: {
                int n2 = widgetControl.mouseReleased(mouseEvent);
                if (n2 == 1) {
                    this.widgets.remove(widget);
                } else if (n2 == 2) {
                    this.widgets.remove(widget);
                    this.widgets.add(widget);
                }
                return true;
            }
            case 4: {
                widgetControl.mouseWheel((MouseWheelEvent)mouseEvent);
                return true;
            }
        }
        return false;
    }
}

