/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Glu;
import cds.aladin.MCanvas;
import cds.aladin.MyLabel;
import cds.aladin.Obj;
import cds.tools.Util;

public final class Words
implements Runnable {
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final int CENTER = 2;
    static final int COORD = 3;
    String text;
    int width;
    int precision;
    String id;
    String param;
    int x;
    int y;
    int w;
    int h;
    int align;
    int size;
    int sort;
    boolean computed = false;
    boolean glu;
    boolean repere;
    boolean pin;
    boolean archive;
    boolean samp;
    boolean footprint;
    boolean onMouse;
    boolean show;
    boolean pushed = false;
    boolean haspushed = false;
    Thread thread;
    MCanvas m;
    Glu g;
    private boolean callArchive = false;
    private Aladin _aladin;
    private Obj _o;

    protected Words(String string) {
        this(string, null, 0, -1, 0, false, 0);
    }

    protected Words(String string, int n) {
        this(string, null, n, -1, 0, false, 0);
    }

    protected Words(String string, int n, int n2, int n3) {
        this(string, null, n, n2, n3, false, 0);
    }

    protected Words(String string, String string2, int n, int n2, int n3, boolean bl, int n4) {
        this.width = n;
        this.precision = n2;
        this.align = n3;
        this.computed = bl;
        this.sort = n4;
        char[] cArray = string.toCharArray();
        this.glu = this.tagGlu(cArray);
        if (!this.glu) {
            this.text = string;
        }
        if (string2 != null) {
            this.text = string2;
        }
        this.setRepere();
    }

    protected Words(String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        this(string, n, n2, n3);
        this.computed = bl;
        this.footprint = bl2;
    }

    void setRepere() {
        this.repere = false;
        if (!this.glu) {
            return;
        }
        String string = this.id.substring(0, 1);
        if (string.equals("_")) {
            this.repere = true;
        } else if (string.equals("^")) {
            this.archive = true;
        } else if (string.equals("\u00a3")) {
            this.archive = true;
            this.samp = true;
        } else {
            return;
        }
        this.id = this.id.substring(1);
    }

    protected void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    protected String getText() {
        return this.text;
    }

    protected void urlStatus(MyLabel myLabel) {
        String string = this.id.equals("Http") ? this.param : (this.param.length() > 0 ? "Glu tag: <&" + this.id + " " + this.param + ">" : "Glu: <&" + this.id + ">");
        myLabel.setText(string);
    }

    protected void setPosition(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
    }

    int anchorGlu(char[] cArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = n + 1; n2 < cArray.length && cArray[n2] != '>'; ++n2) {
            stringBuffer.append(cArray[n2]);
        }
        if (n2 == n) {
            return n2;
        }
        this.text = stringBuffer.toString();
        return n2 == cArray.length ? -1 : n2;
    }

    int paramGlu(char[] cArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = n; n2 < cArray.length && cArray[n2] == ' ' && cArray[n2] != '>' && cArray[n2] != '|'; ++n2) {
        }
        while (n2 < cArray.length && cArray[n2] != '>' && cArray[n2] != '|') {
            stringBuffer.append(cArray[n2]);
            ++n2;
        }
        if (n2 == n) {
            return n2;
        }
        this.param = this.text = stringBuffer.toString();
        return n2 == cArray.length ? -1 : n2;
    }

    int idGlu(char[] cArray, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = n; n2 < cArray.length && cArray[n2] != ' ' && cArray[n2] != '>' && cArray[n2] != '|'; ++n2) {
            stringBuffer.append(cArray[n2]);
        }
        if (n2 == n) {
            return -1;
        }
        this.id = this.text = stringBuffer.toString();
        return n2 == cArray.length ? -1 : n2;
    }

    protected boolean tagGlu(char[] cArray) {
        if (cArray.length < 2 || cArray[0] != '<' || cArray[1] != '&') {
            return false;
        }
        int n = 2;
        if ((n = this.idGlu(cArray, n)) < 0) {
            return false;
        }
        if ((n = this.paramGlu(cArray, n)) < 0) {
            return false;
        }
        if (cArray[n] == '|' && (n = this.anchorGlu(cArray, n)) < 0) {
            return false;
        }
        if (cArray[n] != '>') {
            return false;
        }
        this.size = n + 1;
        return true;
    }

    protected boolean inside(int n, int n2) {
        return n >= this.x - 4 && n <= this.x + this.w + 2 && n2 >= this.y - 1 && n2 <= this.y + this.h + 1;
    }

    protected boolean onBord(int n, int n2) {
        return n >= this.x + this.w - 3 && n <= this.x + this.w + 3 && n2 >= this.y - 1 && n2 <= this.y + this.h + 1;
    }

    protected void callGlu(Glu glu, MCanvas mCanvas) {
        this.g = glu;
        this.m = mCanvas;
        this.pushed = true;
        this.haspushed = true;
        this.thread = new Thread((Runnable)this, "AladinCallGlu");
        this.thread.setPriority(4);
        this.thread.start();
    }

    @Override
    public void run() {
        if (this.callArchive) {
            this.callArchive = false;
            this.callArchive1(this._aladin, this._o);
        } else {
            this.g.showDocument(this.id, this.param, this.id.equals("Http"));
        }
        Util.pause(3000);
        this.pushed = false;
        if (this.m != null) {
            this.m.repaint();
        }
    }

    protected void callArchive(Aladin aladin, Obj obj) {
        this.pushed = true;
        this.haspushed = true;
        this.callArchive = true;
        this._aladin = aladin;
        this._o = obj;
        this.thread = new Thread((Runnable)this, "AladinCallGlu");
        this.thread.setPriority(4);
        this.thread.start();
    }

    private void callArchive1(Aladin aladin, Obj obj) {
        String string = this.param;
        String string2 = this.getURL(aladin);
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://")) {
            string = this.text;
        }
        if (this.samp) {
            aladin.mesure.mcanvas.toSamp(string2, this.x + this.w / 2, this.y);
            return;
        }
        aladin.calque.newPlan(string2, string, "provided by the original archive server", obj);
    }

    String getURL(Aladin aladin) {
        String string;
        if (this.id == null) {
            return "";
        }
        boolean bl = this.id.equals("Http");
        if (bl) {
            string = this.param;
        } else {
            try {
                string = aladin.glu.getURL(this.id, this.param, bl) + "";
            }
            catch (Exception exception) {
                Aladin.warning(aladin, "URL error");
                if (Aladin.levelTrace >= 3) {
                    exception.printStackTrace();
                }
                return "";
            }
        }
        return string;
    }
}

