/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.Server;
import cds.aladin.SliderCube;
import cds.aladin.SliderDensity;
import cds.aladin.SliderEpoch;
import cds.aladin.SliderOpacity;
import cds.aladin.SliderSize;
import cds.aladin.SliderZoom;
import cds.aladin.ViewSimple;
import cds.aladin.ZoomChoice;
import cds.aladin.ZoomView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class Zoom
extends JPanel {
    static int[] mzn = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2};
    static int[] mzd = new int[]{1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 3};
    static final int MINZOOM = mzn.length;
    static final int MAXZOOM = 67;
    public static final int MINSLIDERBG = 0;
    public static final int MAXSLIDERBG = 60;
    public static final int MINSLIDER = mzn.length - 7;
    public static final int MAXSLIDER = mzn.length + 7;
    ZoomView zoomView;
    JComboBox cZoom;
    protected ZoomChoice zoomChoicePanel;
    protected SliderSize sizeSlider;
    protected SliderOpacity opacitySlider;
    protected SliderZoom zoomSlider;
    protected SliderEpoch epochSlider;
    protected SliderCube cubeSlider;
    protected SliderDensity densitySlider;
    protected JPanel sliderPanel;
    Aladin aladin;
    private JPanel slp = null;
    private boolean flagNoAction = false;

    protected Zoom() {
    }

    protected Zoom(Aladin aladin) {
        int n;
        this.aladin = aladin;
        this.zoomView = new ZoomView(aladin);
        this.setLayout(new BorderLayout(5, 10));
        this.cZoom = new JComboBox();
        this.cZoom.setFont(this.cZoom.getFont().deriveFont(0));
        for (n = 0; n < MINZOOM; ++n) {
            this.cZoom.addItem(mzn[n] + "/" + mzd[n] + "x");
        }
        for (n = 0; n < 67; ++n) {
            this.cZoom.addItem((1 << n) + "x");
        }
        this.cZoom.setSelectedIndex(MINZOOM);
        this.zoomChoicePanel = new ZoomChoice(aladin, this.cZoom);
        this.cubeSlider = new SliderCube(aladin);
        this.epochSlider = new SliderEpoch(aladin);
        this.sizeSlider = new SliderSize(aladin);
        this.densitySlider = new SliderDensity(aladin);
        this.opacitySlider = new SliderOpacity(aladin);
        this.zoomSlider = new SliderZoom(this);
        this.sliderPanel = new JPanel(new BorderLayout(0, 0));
        this.adjustSliderPanel();
        this.add((Component)this.sliderPanel, "North");
        Aladin.makeAdd(this, this.zoomView, "Center");
    }

    protected void adjustSliderPanel() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 1, 1));
        if (!Aladin.OUTREACH) {
            if (this.aladin.configuration.isSliderEpoch()) {
                jPanel.add(this.epochSlider);
            }
            if (this.aladin.configuration.isSliderSize()) {
                jPanel.add(this.sizeSlider);
            }
            if (this.aladin.configuration.isSliderDensity()) {
                jPanel.add(this.densitySlider);
            }
            if (this.aladin.configuration.isSliderCube()) {
                jPanel.add(this.cubeSlider);
            }
        }
        if (this.aladin.configuration.isSliderOpac()) {
            jPanel.add(this.opacitySlider);
        }
        if (this.aladin.configuration.isSliderZoom()) {
            jPanel.add(this.zoomSlider);
        }
        if (this.slp != null) {
            this.sliderPanel.remove(this.slp);
        }
        this.sliderPanel.add((Component)jPanel, "Center");
        this.slp = jPanel;
    }

    protected JPanel getZoomChoicePanel() {
        return this.zoomChoicePanel;
    }

    protected double getNearestZoomFct(double d) {
        if (this.aladin.calque.getPlanBase() instanceof PlanBG) {
            return d;
        }
        int n = this.cZoom.getItemCount();
        double d2 = Double.MAX_VALUE;
        double d3 = this.getValue(0);
        for (int i = 1; i < n; ++i) {
            double d4 = this.getValue(i);
            double d5 = Math.abs(d - d4);
            if (!(d5 < d2)) continue;
            d2 = d5;
            d3 = d4;
        }
        return d3;
    }

    protected double getNearestZoom(String string) {
        double d = string.indexOf(120) > 0 ? this.parseZoomString(string) : this.getNearestZoomFromRadius(string);
        return this.getNearestZoomFct(d);
    }

    private double parseZoomString(String string) {
        int n = string.indexOf(120);
        if (n < 0) {
            n = string.length();
        }
        int n2 = string.indexOf(47);
        boolean bl = true;
        if (n2 < 0) {
            bl = false;
            n2 = n;
        }
        double d = Double.parseDouble(string.substring(0, n2));
        if (bl) {
            double d2 = Double.parseDouble(string.substring(n2 + 1, n));
            d /= d2;
        }
        return d;
    }

    protected double getNearestZoomFromRadius(String string) {
        try {
            double d = Server.getAngleInArcmin(string, 1) / 60.0;
            ViewSimple viewSimple = this.aladin.view.getCurrentView();
            double d2 = viewSimple.getProj().getPixResDelta();
            double d3 = d / d2;
            double d4 = viewSimple.getWidth();
            double d5 = d4 / d3;
            return this.getNearestZoomFct(d5);
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    protected double getValue() {
        int n;
        if (this.zoomSlider != null) {
            n = (int)this.zoomSlider.getValue();
            try {
                this.cZoom.setSelectedIndex(n);
            }
            catch (Exception exception) {}
        } else {
            n = this.cZoom.getSelectedIndex();
        }
        return this.getValue(n);
    }

    protected double getValue(int n) {
        return this.getValue(n, false);
    }

    protected double getValue(int n, boolean bl) {
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        Plan plan = this.aladin.calque.getPlanBase();
        if (!bl && (plan != null && plan instanceof PlanBG || viewSimple != null && viewSimple.isPlotView())) {
            return this.getValueTest(n);
        }
        return this.getValuePow2(n);
    }

    protected double getValueTest(int n) {
        double d = Math.pow(1.2, n - MINZOOM);
        return d /= 10.0;
    }

    protected double getValuePow2(int n) {
        double d = n >= MINZOOM ? (double)(1 << n - MINZOOM) : (double)mzn[n] / (double)mzd[n];
        return d;
    }

    protected int getNbPixelSrc(double d) {
        int n = this.getIndex(d);
        return n >= MINZOOM ? 1 : mzd[n];
    }

    protected int getNbPixelDst(double d) {
        int n = this.getIndex(d);
        return n >= MINZOOM ? 1 << n - MINZOOM : mzn[n];
    }

    protected String getItem(double d) {
        return (String)this.cZoom.getItemAt(this.getIndex(d));
    }

    protected int getIndex() {
        return this.cZoom.getSelectedIndex();
    }

    protected double getNextValue(double d, int n, boolean bl) {
        int n2 = this.getIndex(d, bl);
        if (n2 + n < 0 || n2 + n > MINZOOM + 67) {
            return -1.0;
        }
        return this.getValue(n2 += n, bl);
    }

    protected boolean setZoom(String string) {
        if (string.equals("+") || string.equals("plus")) {
            this.incZoom(1);
        } else if (string.equals("-")) {
            this.incZoom(-1);
        } else {
            double d = this.getNearestZoom(string);
            if (d < 0.0) {
                return false;
            }
            this.aladin.view.setZoomRaDecForSelectedViews(d, null);
        }
        return true;
    }

    protected void incZoom(int n) {
        double d = this.getValue();
        double d2 = this.getNextValue(d, n, false);
        if (d2 == -1.0) {
            return;
        }
        this.aladin.view.setZoomRaDecForSelectedViews(d2, null);
    }

    protected void newZoom() {
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        if (viewSimple != null) {
            this.zoomView.newZoom(viewSimple.xzoomView, viewSimple.yzoomView);
        }
    }

    protected void submit() {
        if (!this.flagNoAction) {
            this.aladin.view.setZoomRaDecForSelectedViews(this.getValue(), null);
        }
    }

    protected Rectangle getZoom() {
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        if (viewSimple == null || viewSimple.rzoom == null) {
            return null;
        }
        return new Rectangle(Zoom.floor(viewSimple.rzoom.x), Zoom.floor(viewSimple.rzoom.y), Zoom.top(viewSimple.rzoom.width), Zoom.top(viewSimple.rzoom.height));
    }

    protected void setValue(double d) {
        int n = this.getIndex(d);
        if (n != -1 && this.cZoom.getSelectedIndex() != n) {
            this.flagNoAction = true;
            try {
                this.cZoom.setSelectedIndex(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.zoomSlider != null) {
                this.zoomSlider.setValue(n);
            }
            this.flagNoAction = false;
        }
    }

    protected boolean isBG() {
        Plan plan = this.aladin.calque.getPlanBase();
        return plan != null && plan instanceof PlanBG;
    }

    private int getIndex(double d) {
        return this.getIndex(d, false);
    }

    private int getIndex(double d, boolean bl) {
        int n = this.cZoom.getItemCount() + 250;
        for (int i = 0; i < n; ++i) {
            if (!(this.getValue(i, bl) >= d)) continue;
            return i;
        }
        return -1;
    }

    public void zoomSliderReset() {
        if (this.zoomSlider != null) {
            this.zoomSlider.setEnabled(!this.aladin.calque.isFree());
        }
    }

    protected void reset() {
        this.reset(true);
    }

    protected void reset(boolean bl) {
        if (bl) {
            this.zoomView.resetImgID();
        }
        this.newZoom();
    }

    protected void wenOn() {
        if (this.aladin.toolBox.tool[6].mode == -1) {
            this.zoomView.wenOn();
        }
    }

    protected void wenOff() {
        if (this.aladin.toolBox.tool[6].mode != 1) {
            this.zoomView.wenOff();
        }
    }

    protected boolean redrawWen(double d, double d2) {
        if (this.aladin.toolBox.tool[6].mode == -1) {
            this.zoomView.wen(d, d2);
            return true;
        }
        return false;
    }

    protected void redrawCut() {
        if (this.zoomView.flagCut) {
            this.zoomView.repaint();
        }
    }

    protected static int round(double d) {
        return (int)(d + 0.5);
    }

    protected static int floor(double d) {
        return (int)d;
    }

    protected static int top(double d) {
        return (double)((int)d) == d ? (int)d : (int)(d + 1.0);
    }
}

