/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.Hist;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.Obj;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanRGBInterface;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.SED;
import cds.aladin.Select;
import cds.aladin.Source;
import cds.aladin.SourceStat;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;

public final class ZoomView
extends JComponent
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
Widget {
    protected int WENZOOM = 8;
    static int SIZE;
    Aladin aladin;
    Image img;
    Image imgwen;
    MemoryImageSource mImgWen;
    Graphics gwen;
    Image imgbuf;
    Graphics gbuf;
    int lastImgID = -1;
    RectangleD rectzoom;
    RectangleD or;
    boolean flagdrag;
    boolean imgok;
    Rectangle clip;
    int W;
    int H;
    double xwen;
    double ywen;
    private PointD oc;
    private int oframe;
    boolean zoomok;
    int xmwen;
    int ymwen;
    boolean memInv;
    boolean flagRGB;
    boolean flagwen;
    private int[] cut;
    private int[] cutR;
    private int[] cutG;
    private int[] cutB;
    protected boolean flagCut = false;
    private Obj objCut;
    Hist hist = null;
    SED sed = null;
    protected boolean flagHist = false;
    protected boolean flagSED = false;
    private boolean flagSynchronized = false;
    static Dimension DIM;
    private int cutX = -1;
    private int cutY = -1;
    private String INFO = null;
    private int ov = 0;
    private short oiz = (short)-2;
    private Projection proj = null;
    static final int CUTNORMAL = 0;
    static final int CUTRGB = 1;
    static final int CUTHIST = 2;
    private String oSrcSed = "";
    private byte[] pixels = null;
    private byte[] scalepixels = null;
    private int[] pixelsRGB = null;
    private int[] scalepixelsRGB = null;
    private static int WF;
    static int[] XF;
    static int[] YF;
    private int owidth;
    private int oheight;
    protected long startTaquinTime = 0L;
    private WidgetControl voc = null;

    protected ZoomView(Aladin aladin) {
        this.aladin = aladin;
        this.setOpaque(true);
        this.setBackground(Aladin.BLUE);
        SIZE = Select.ws + 16;
        this.setSize(SIZE, SIZE);
        this.cut = new int[SIZE];
        this.cutR = new int[SIZE];
        this.cutG = new int[SIZE];
        this.cutB = new int[SIZE];
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.WENZOOM = 8;
    }

    @Override
    public Dimension getPreferredSize() {
        return DIM;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.aladin.inHelp) {
            return;
        }
        if (mouseWheelEvent.getClickCount() == 2) {
            return;
        }
        if (this.flagSED) {
            if (this.sed.mouseWheel(mouseWheelEvent)) {
                this.repaint();
            }
            return;
        }
        if (this.flagHist) {
            if (this.hist.mouseWheelMoved(mouseWheelEvent)) {
                this.repaint();
            }
            return;
        }
        this.synchronize(mouseWheelEvent);
        this.aladin.calque.zoom.incZoom(-mouseWheelEvent.getWheelRotation());
    }

    protected void free() {
        this.hist = null;
        this.sed = null;
        this.flagSED = false;
        this.flagHist = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagCut || this.flagHist || this.flagSED) {
            return;
        }
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        viewSimple.stopAutomaticScroll();
        this.or = null;
        if (!viewSimple.isFree() && viewSimple.pref instanceof PlanBG) {
            this.setAllSkyCenter(viewSimple, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.flagdrag = true;
            this.newZoom(mouseEvent.getX(), mouseEvent.getY());
            this.synchronize(mouseEvent);
        }
    }

    protected void synchronize(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown() && this.flagSynchronized || !this.aladin.view.isMultiView()) {
            return;
        }
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        if (viewSimple == null || viewSimple.isFree() || !Projection.isOk(viewSimple.pref.projd)) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            this.aladin.view.selectCompatibleViews();
            this.aladin.view.setZoomRaDecForSelectedViews(this.aladin.calque.zoom.getValue(), null);
            this.flagSynchronized = true;
        } else {
            this.flagSynchronized = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagSED) {
            return;
        }
        if (this.flagHist) {
            if (this.hist.mouseDragged(mouseEvent)) {
                this.repaint();
            }
            return;
        }
        if (this.flagCut) {
            if (this.objCut instanceof SourceStat) {
                this.setFrameCube(mouseEvent.getX());
            }
            return;
        }
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        if (viewSimple.isPlotView()) {
            return;
        }
        this.flagdrag = true;
        if (!viewSimple.isFree() && viewSimple.pref instanceof PlanBG) {
            this.setAllSkyCenter(viewSimple, mouseEvent.getX(), mouseEvent.getY());
        } else {
            this.synchronize(mouseEvent);
            this.newZoom(mouseEvent.getX(), mouseEvent.getY());
            this.drawInViewNow(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagSED) {
            this.sed.mouseMove(mouseEvent.getX(), mouseEvent.getY());
            this.repaint();
            return;
        }
        if (this.INFO == null) {
            this.INFO = Aladin.chaine.getString("ZINFO");
        }
        this.aladin.status.setText(this.INFO);
        this.cutX = mouseEvent.getX();
        this.cutY = mouseEvent.getY();
        if (this.flagHist && this.hist.setOnMouse(mouseEvent.getX(), mouseEvent.getY())) {
            this.repaint();
            if (this.hist.flagHistPixel) {
                this.aladin.view.getCurrentView().repaint();
            }
        } else if (this.flagCut) {
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagSED) {
            this.sed.mouseExit();
            this.repaint();
            return;
        }
        Aladin.makeCursor(this, 0);
        if (this.aladin.view.flagHighlight) {
            this.hist.resetHighlightSource();
            this.aladin.view.flagHighlight = false;
            this.aladin.view.repaint();
        }
        if (this.flagCut || this.flagHist) {
            if (this.flagHist) {
                this.hist.setOnMouse(-1, -1);
            }
            this.cutY = -1;
            this.cutX = -1;
            this.repaint();
            if (this.hist != null && this.hist.flagHistPixel) {
                this.aladin.view.getCurrentView().repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
        if (this.flagSED) {
            this.sed.mouseEnter();
            return;
        }
        boolean bl = this.flagCut;
        if (this.objCut instanceof SourceStat) {
            bl = false;
        }
        if (Ligne.isLigne(this.objCut)) {
            bl = false;
        }
        Aladin.makeCursor(this, bl ? 5 : 2);
    }

    protected Coord drawInViewNow(double d, double d2) {
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        if (viewSimple == null || viewSimple.isFree()) {
            return null;
        }
        Coord coord = null;
        if (!viewSimple.isPlotView()) {
            try {
                Projection projection = viewSimple.getProj();
                if (Projection.isOk(projection)) {
                    PointD pointD = viewSimple.zoomViewToImage(d, d2);
                    coord = new Coord();
                    coord.x = pointD.x;
                    coord.y = pointD.y;
                    projection.getCoord(coord);
                    if (Double.isNaN(coord.al)) {
                        coord = null;
                    }
                }
            }
            catch (Exception exception) {
                coord = null;
            }
        }
        if (coord == null) {
            this.calculZoom(viewSimple, d, d2);
            this.repaint();
            viewSimple.repaint();
        } else {
            this.aladin.view.setZoomRaDecForSelectedViews(0.0, coord, viewSimple, false, true);
            this.aladin.view.syncView(1.0, coord, null);
        }
        return coord;
    }

    private void setFrameCube(int n) {
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        int n2 = viewSimple.cubeControl.nbFrame;
        int n3 = (int)((double)n2 * ((double)n / (double)SIZE));
        if (n3 >= n2) {
            n3 = n2 - 1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        viewSimple.cubeControl.setFrameLevel(n3);
        viewSimple.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        if (this.flagSED) {
            this.sed.mouseRelease(mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        if (this.flagCut) {
            if (this.objCut instanceof SourceStat) {
                this.setFrameCube(mouseEvent.getX());
            }
            this.flagdrag = false;
            return;
        }
        if (this.flagHist) {
            if (mouseEvent.getX() < 10) {
                if (this.hist.mouseDragged(mouseEvent)) {
                    this.repaint();
                }
            } else {
                if (this.hist.inCroix(mouseEvent.getX(), mouseEvent.getY())) {
                    this.stopHist();
                } else {
                    this.hist.selectHighlightSource();
                }
                this.aladin.calque.repaintAll();
            }
            return;
        }
        this.flagSynchronized = false;
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        if (mouseEvent.isControlDown() || viewSimple.isPlotView()) {
            viewSimple.reInitZoom(true);
            return;
        }
        Coord coord = this.drawInViewNow(mouseEvent.getX(), mouseEvent.getY());
        if (coord != null) {
            this.aladin.view.setRepere(coord);
        }
        this.flagdrag = false;
    }

    protected void startDrag() {
        this.flagdrag = true;
    }

    protected void stopDrag() {
        this.flagdrag = false;
        this.or = null;
        this.repaint();
    }

    protected boolean newZoom(double d, double d2) {
        return this.newZoom(this.aladin.view.getCurrentView(), d, d2);
    }

    protected boolean newZoom(ViewSimple viewSimple, double d, double d2) {
        if (viewSimple.locked) {
            return false;
        }
        if (!this.calculZoom(viewSimple, d, d2)) {
            return false;
        }
        this.repaint();
        return true;
    }

    protected boolean calculZoom(ViewSimple viewSimple, double d, double d2) {
        this.zoomok = false;
        if (viewSimple.isFree()) {
            return false;
        }
        viewSimple.setZoomXY(viewSimple.zoom, d, d2);
        if (this.rectzoom != null && viewSimple.rzoomView.equals(this.rectzoom)) {
            this.zoomok = true;
            return false;
        }
        this.rectzoom = viewSimple.rzoomView;
        this.aladin.calque.zoom.setValue(viewSimple.zoom);
        viewSimple.newView();
        this.zoomok = true;
        return true;
    }

    protected void resetImgID() {
        this.lastImgID = -1;
    }

    protected boolean drawImgZoom(ViewSimple viewSimple) {
        this.mImgWen = null;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.imgbuf == null || this.imgbuf.getWidth(this.aladin) != n || this.imgbuf.getHeight(this.aladin) != n2) {
            if (this.gbuf != null) {
                this.gbuf.dispose();
            }
            this.imgbuf = this.aladin.createImage(n, n2);
            this.gbuf = this.imgbuf.getGraphics();
        }
        if (viewSimple == null || viewSimple.isFree() || !viewSimple.pref.isImage() || viewSimple.northUp) {
            if (this.lastImgID != -2) {
                this.gbuf.setColor(Aladin.LBLUE);
                this.gbuf.fillRect(0, 0, n, n2);
                this.drawBord(this.gbuf);
                this.lastImgID = -2;
            }
            if (viewSimple != null && !viewSimple.isFree()) {
                this.calculZoom(viewSimple, viewSimple.xzoomView, viewSimple.yzoomView);
            }
        } else {
            try {
                PlanImage planImage = (PlanImage)viewSimple.pref;
                if (this.lastImgID != planImage.getImgID() || planImage.pixelsZoom == null || planImage.pixelsZoom.length != n * n2) {
                    Image image;
                    this.gbuf.setColor(Aladin.LBLUE);
                    this.gbuf.fillRect(0, 0, n, n2);
                    if (planImage.type == 2 || planImage.type == 20) {
                        if (((PlanRGBInterface)((Object)planImage)).getPixelsZoomRGB() == null) {
                            ((PlanRGBInterface)((Object)planImage)).calculPixelsZoomRGB();
                        }
                        image = this.createImage(new MemoryImageSource(n, n2, ((PlanRGBInterface)((Object)planImage)).getPixelsZoomRGB(), 0, n));
                    } else {
                        planImage.calculPixelsZoom();
                        image = this.createImage(new MemoryImageSource(n, n2, planImage.cm, planImage.pixelsZoom, 0, n));
                    }
                    this.gbuf.drawImage(image, 0, 0, this);
                    this.drawBord(this.gbuf);
                    this.lastImgID = planImage.getImgID();
                    this.calculZoom(viewSimple, viewSimple.xzoomView, viewSimple.yzoomView);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.aladin.gc();
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Try ezoom error: " + exception);
                return false;
            }
        }
        this.img = this.imgbuf;
        return true;
    }

    protected void setAllSkyCenter(ViewSimple viewSimple, double d, double d2) {
        Coord coord = new Coord();
        coord.x = d;
        coord.y = d2;
        this.proj.getCoord(coord);
        if (Double.isNaN(coord.al)) {
            return;
        }
        viewSimple.goToAllSky(coord);
    }

    private void drawHipsControl(Graphics graphics, ViewSimple viewSimple) {
        block10: {
            try {
                int n = this.getWidth();
                int n2 = this.getHeight();
                if (this.imgbuf == null || this.imgbuf.getWidth(this.aladin) != n || this.imgbuf.getHeight(this.aladin) != n2) {
                    if (this.gbuf != null) {
                        this.gbuf.dispose();
                    }
                    this.imgbuf = this.aladin.createImage(n, n2);
                    this.gbuf = this.imgbuf.getGraphics();
                }
                if (this.oiz != viewSimple.iz || this.ov != viewSimple.hashCode()) {
                    int n3 = n / 2;
                    int n4 = n2 / 2;
                    int n5 = 4 * n / 10;
                    this.gbuf.setColor(Color.white);
                    this.gbuf.fillRect(0, 0, n, n2);
                    this.oiz = viewSimple.iz;
                    this.ov = viewSimple.hashCode();
                    if (this.proj == null) {
                        this.proj = new Projection(null, 0, 0.0, 0.0, 21600.0, (double)(n / 2), (double)(n2 / 2), (double)n, 0.0, false, 4, Calib.FK5);
                    } else {
                        this.proj.frame = 0;
                    }
                    Coord coord = new Coord(0.0, 0.0);
                    this.proj.getXY(coord);
                    n3 = (int)coord.x;
                    n4 = (int)coord.y;
                    coord.al = 180.0;
                    this.proj.getXY(coord);
                    n5 = (int)Math.abs(coord.x - (double)n3);
                    int n6 = n5 / 2;
                    this.gbuf.setColor(Aladin.GREEN);
                    this.gbuf.drawOval(n3 - n5, n4 - n6, n5 * 2, n6 * 2);
                    this.gbuf.drawOval(n3 - (n5 + n6) / 2, n4 - n6, n5 + n6, n6 * 2);
                    this.gbuf.drawOval(n3 - n6, n4 - n6, n6 * 2, n6 * 2);
                    this.gbuf.drawOval(n3 - n6 / 2, n4 - n6, n6, n6 * 2);
                    this.gbuf.drawLine(n3 - n5, n4, n3 + n5, n4);
                    this.gbuf.drawLine(n3, n4 - n6, n3, n4 + n6);
                    Coord[] coordArray = viewSimple.getCouverture();
                    if (coordArray != null) {
                        this.proj.frame = this.aladin.localisation.getFrame();
                        this.gbuf.setColor(Color.blue);
                        for (int i = 0; i < coordArray.length; ++i) {
                            if (Double.isNaN(coordArray[i].al)) continue;
                            coord.al = coordArray[i].al;
                            coord.del = coordArray[i].del;
                            this.proj.getXY(coord);
                            this.gbuf.drawLine((int)coord.x, (int)coord.y, (int)coord.x, (int)coord.y);
                        }
                        coord = viewSimple.getCooCentre();
                        if (coord == null) {
                            System.err.println("ZommView.drawHipsControl bug++ (v.getCooCenter() returns null ! => switch in SIN");
                            this.proj = viewSimple.pref.projd = new Projection("allsky", 2, 0.0, 0.0, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, false, 1, Calib.FK5);
                            viewSimple.pref.projd.frame = this.aladin.localisation.getFrame();
                            viewSimple.projLocal = viewSimple.pref.projd.copy();
                            this.drawHipsControl(graphics, viewSimple);
                            return;
                        }
                        this.proj.getXY(coord);
                        this.gbuf.setColor(Color.red);
                        Util.fillCircle7(this.gbuf, (int)coord.x, (int)coord.y);
                    }
                    this.gbuf.setFont(Aladin.SPLAIN);
                    this.gbuf.setColor(Aladin.GREEN);
                    this.gbuf.drawString("+90", n3 - 5, n4 - n6 - 2);
                    this.gbuf.drawString("-90", n3 - 5, n4 + n6 + 10);
                    this.gbuf.drawString("-180", n - this.gbuf.getFontMetrics().stringWidth("+270"), n4 + 35);
                    this.gbuf.drawString("+180", 1, n4 - 25);
                    this.gbuf.setFont(Aladin.SPLAIN);
                    FontMetrics fontMetrics = this.gbuf.getFontMetrics();
                    String string = "Frame: " + Localisation.REPERE[this.aladin.localisation.getFrame()];
                    this.gbuf.drawString(string, SIZE - fontMetrics.stringWidth(string) - 2, 10);
                    this.gbuf.setColor(Color.red);
                    string = this.aladin.localisation.J2000ToString(coord.al, coord.del);
                    this.gbuf.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, n2 - 16);
                    this.gbuf.setColor(Color.blue);
                    string = viewSimple.getTaille(0);
                    this.gbuf.drawString(string, n / 2 - fontMetrics.stringWidth(string) / 2, n2 - 4);
                    this.drawBord(this.gbuf);
                }
                graphics.drawImage(this.imgbuf, 0, 0, this);
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block10;
                exception.printStackTrace();
            }
        }
    }

    private void drawBord(Graphics graphics) {
        Util.drawEdge(graphics, this.getWidth(), this.getHeight());
    }

    protected void setCM(IndexColorModel indexColorModel) {
        this.repaint();
    }

    protected void drawImgHist(Graphics graphics) {
        this.hist.draw(graphics);
        this.drawBord(graphics);
    }

    protected boolean drawImgSED(Graphics graphics) {
        if (this.sed.getCount() == 0) {
            return false;
        }
        this.sed.draw(graphics);
        this.drawBord(graphics);
        return true;
    }

    protected void drawImgCut(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        graphics.clearRect(1, 1, n2 - 2, n3 - 2);
        this.drawBord(graphics);
        boolean bl = false;
        for (n = 1; n < this.cut.length - 1; ++n) {
            if (this.cut[n] == 0 && this.cutR[n] == 0 && this.cutG[n] == 0 && this.cutB[n] == 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.aladin.status.setText("Nothing in cut graph !!");
            return;
        }
        if (this.cut[0] != -1) {
            graphics.setColor(Color.cyan);
            for (n = 1; n < this.cut.length - 1; ++n) {
                graphics.drawLine(n, n3 - this.cut[n], n, n3);
            }
            graphics.setColor(Color.blue);
            for (n = 1; n < this.cut.length - 1; ++n) {
                graphics.drawLine(n, n3 - this.cut[n - 1], n, n3 - this.cut[n]);
            }
        } else {
            graphics.setColor(Color.red);
            for (n = 1; n < this.cutR.length - 1; ++n) {
                graphics.drawLine(n - 1, n3 - this.cutR[n - 1], n, n3 - this.cutR[n]);
            }
            graphics.setColor(Color.green);
            for (n = 1; n < this.cutG.length - 1; ++n) {
                graphics.drawLine(n - 1, n3 - this.cutG[n - 1], n, n3 - this.cutG[n]);
            }
            graphics.setColor(Color.blue);
            for (n = 1; n < this.cutB.length - 1; ++n) {
                graphics.drawLine(n - 1, n3 - this.cutB[n - 1], n, n3 - this.cutB[n]);
            }
        }
    }

    private void drawFWHM(Graphics graphics) {
        int n;
        int n2;
        if (this.cutX < 0 || this.cut[0] == -1) {
            return;
        }
        int n3 = SIZE - this.cutY;
        PlanImage planImage = (PlanImage)this.aladin.calque.getPlanBase();
        String string = "pixel value: " + planImage.getPixelInfoFromGrey(n3 * 256 / SIZE);
        graphics.setFont(Aladin.SPLAIN);
        graphics.setColor(Color.black);
        graphics.drawLine(1, this.cutY, 4, this.cutY);
        graphics.drawLine(SIZE - 4, this.cutY, SIZE, this.cutY);
        graphics.drawString(string, 25, this.cutY < 20 ? SIZE - 2 : 10);
        for (n2 = this.cutX; n2 > 0 && n3 <= this.cut[n2]; --n2) {
        }
        for (n = this.cutX; n < SIZE && n3 <= this.cut[n]; ++n) {
        }
        if (n <= n2) {
            return;
        }
        graphics.setColor(Color.red);
        graphics.drawLine(n2 + 1, this.cutY, n - 1, this.cutY);
        graphics.drawLine(n2 + 1, this.cutY + 1, n - 1, this.cutY + 1);
        double d = ((Cote)this.objCut).getDistXY();
        if (d == -1.0) {
            return;
        }
        double d2 = (double)(n - n2) * d / (double)SIZE;
        String string2 = Util.myRound(d2 + "", 1) + "pix";
        int n4 = SIZE - this.cutX < 40 ? this.cutX - 50 : this.cutX + 7;
        graphics.drawString(string2, n4, this.cutY - 2);
        double d3 = ((Cote)this.objCut).getDist();
        if (d3 != -1.0) {
            graphics.drawString(Coord.getUnit(d3 * d2 / d), n4, this.cutY + 15);
        }
    }

    private void drawPixelCourant(Graphics graphics) {
        block4: {
            try {
                PlanImage planImage = (PlanImage)this.aladin.calque.getPlanBase();
                if (planImage == null) {
                    return;
                }
                graphics.setColor(Color.blue);
                graphics.setFont(Aladin.SPLAIN);
                String string = planImage.getPixelInfoFromGrey(0);
                graphics.drawString(string, 2, 10);
                string = planImage.getPixelInfoFromGrey(255);
                graphics.drawString(string, SIZE - graphics.getFontMetrics().stringWidth(string) - 2, 10);
                if (this.cutX > 0) {
                    string = planImage.getPixelInfoFromGrey((int)Math.floor((double)this.cutX * (256.0 / (double)SIZE)));
                    int n = this.cutX;
                    graphics.setColor(Color.red);
                    graphics.drawLine(n, 0, n, SIZE);
                    int n2 = graphics.getFontMetrics().stringWidth(string);
                    n = n + n2 > SIZE - 5 ? n - 5 - n2 : (n += 5);
                    graphics.drawString(string, n, SIZE - 5);
                }
            }
            catch (Exception exception) {
                if (Aladin.levelTrace < 3) break block4;
                exception.printStackTrace();
            }
        }
    }

    private void drawCubeFrame(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        int n3 = viewSimple.cubeControl.lastFrame;
        int n4 = viewSimple.cubeControl.nbFrame;
        int n5 = (int)((double)n * ((double)n3 / (double)n4));
        int n6 = Math.max(1, (int)((double)n / (double)n4));
        graphics.setColor(Color.red);
        graphics.fillRect(n5, 0, n6, n2);
        PlanImageCube planImageCube = null;
        planImageCube = viewSimple.pref.type == 4 ? (PlanImageCube)viewSimple.pref : null;
        graphics.setFont(Aladin.SPLAIN);
        String string = planImageCube != null && planImageCube.fromCanal ? planImageCube.getCanalValue(n3) : "" + (n3 + 1);
        int n7 = graphics.getFontMetrics().stringWidth(string);
        graphics.drawString(string, n5 + n7 + n6 > n ? n5 - n7 - 2 : n5 + n6 + 2, n2 - 2);
        int n8 = n2 - this.cutY;
        String string2 = ((PlanImage)viewSimple.pref).getPixelInfoFromGrey(n8 * 256 / n2);
        if (string2.length() == 0) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(1, this.cutY, n, this.cutY);
        graphics.drawString(string2, 10, this.cutY < 20 ? this.cutY + 10 : this.cutY - 2);
    }

    protected void suspendCut() {
        this.flagCut = false;
        this.repaint();
    }

    protected Obj getObjCut() {
        return this.objCut;
    }

    protected void cutOff(Obj obj) {
        if (obj != this.objCut) {
            return;
        }
        this.setCut(null);
    }

    protected void setCut(int[] nArray) {
        this.setCut(null, nArray, 0);
    }

    protected void setCut(Obj obj, int[] nArray, int n) {
        this.cutX = -1;
        this.objCut = obj;
        if (obj == null || nArray == null || this.aladin.toolBox.tool[6].mode == -1) {
            if (this.flagCut) {
                this.repaint();
            }
            this.flagCut = false;
            return;
        }
        this.flagCut = true;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.cut == null || this.cut.length != n2) {
            this.cut = new int[n2];
            this.cutR = new int[n2];
            this.cutG = new int[n2];
            this.cutB = new int[n2];
        }
        double d = (double)n3 / 256.0;
        double d2 = (double)nArray.length / (double)n2;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            double d3;
            int n5 = 0;
            double d4 = d2 * (double)i;
            if (n == 1) {
                this.cut[0] = -1;
                boolean bl = true;
                double d5 = 0.0;
                double d6 = 0.0;
                d3 = 0.0;
                while ((double)n4 < d4 && n4 < nArray.length) {
                    if (bl && nArray[n4] == -1) {
                        bl = false;
                    }
                    d3 += (double)(nArray[n4] >> 16 & 0xFF);
                    d5 += (double)(nArray[n4] >> 8 & 0xFF);
                    d6 += (double)(nArray[n4] & 0xFF);
                    ++n4;
                    ++n5;
                }
                d3 /= (double)n5;
                d5 /= (double)n5;
                d6 /= (double)n5;
                if (!bl) {
                    this.cutG[i] = this.cutB[i] = SIZE;
                    this.cutR[i] = this.cutB[i];
                    continue;
                }
                this.cutR[i] = (int)(d * d3);
                this.cutG[i] = (int)(d * d5);
                this.cutB[i] = (int)(d * d6);
                if (this.cutR[i] == 0 && i > 0) {
                    this.cutR[i] = this.cutR[i - 1];
                }
                if (this.cutG[i] == 0 && i > 0) {
                    this.cutG[i] = this.cutG[i - 1];
                }
                if (this.cutB[i] != 0 || i <= 0) continue;
                this.cutB[i] = this.cutB[i - 1];
                continue;
            }
            d3 = 0.0;
            boolean bl = true;
            while ((double)n4 < d4 && n4 < nArray.length) {
                if (bl && nArray[n4] == -1) {
                    bl = false;
                }
                d3 += (double)nArray[n4++];
                ++n5;
            }
            d3 /= (double)n5;
            if (!bl) {
                this.cut[i] = 0;
                continue;
            }
            this.cut[i] = (int)(d * d3);
            if (n != 0 || this.cut[i] != 0 || i <= 0) continue;
            this.cut[i] = this.cut[i - 1];
        }
        this.repaint();
    }

    protected void clearSED() {
        this.flagSED = false;
        this.oSrcSed = "";
        this.aladin.view.simRep = null;
        this.aladin.calque.repaintAll();
    }

    protected void setSED(String string) {
        this.setSED(string, null);
    }

    protected void setSED(String string, Repere repere) {
        if (string == null) {
            string = "";
        }
        if (this.oSrcSed.equals(string)) {
            return;
        }
        this.oSrcSed = string;
        if (string.length() == 0) {
            this.clearSED();
        } else {
            if (this.sed == null) {
                this.sed = new SED(this.aladin);
            }
            this.flagSED = true;
            this.flagHist = false;
            this.sed.setRepere(repere);
            this.sed.loadFromSource(string);
        }
        this.repaint();
    }

    protected void setSED(Source source) {
        String string;
        String string2 = string = source == null ? null : source.id;
        if (string == null) {
            string = "";
        }
        this.oSrcSed = string;
        if (string.length() == 0) {
            this.clearSED();
        } else {
            if (this.sed == null) {
                this.sed = new SED(this.aladin);
            }
            this.sed.clear();
            this.flagSED = true;
            this.flagHist = false;
            this.sed.addFromIterator(this.aladin.mesure.iterator());
            this.sed.setHighLight(source);
        }
        this.repaint();
    }

    protected void resumeSED() {
        Source source = this.aladin.mesure.getFirstSrc();
        if (!(source != null && source.leg != null && source.leg.isSED() || this.flagSED)) {
            return;
        }
        this.setSED(source);
    }

    protected void stopHist() {
        if (!this.flagHist) {
            return;
        }
        this.flagHist = false;
        this.aladin.view.flagHighlight = false;
        this.hist.resetHighlightSource();
        this.repaint();
    }

    protected void initPixelHist() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.hist == null || this.hist.width != n || this.hist.height != n2) {
            this.hist = new Hist(this.aladin, n, n2);
        }
        this.hist.startHistPixel();
    }

    protected void addPixelHist(double d) {
        this.hist.addPixel(d);
    }

    protected void createPixelHist(String string) {
        this.hist.createHistPixel(string);
    }

    protected void activeHistPixel(String string) {
        this.flagHist = true;
        this.hist.setText(string);
        this.repaint();
    }

    protected boolean setHist(Source source, int n) {
        boolean bl = false;
        this.flagSED = false;
        this.oSrcSed = "";
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.hist == null || this.hist.width != n2 || this.hist.height != n3) {
            this.hist = new Hist(this.aladin, n2, n3);
            bl = true;
        }
        boolean bl2 = this.hist.o != source || this.hist.nField != n;
        this.flagHist = this.hist.init(source, n);
        this.repaint();
        return bl |= bl2;
    }

    protected void changeWen(int n) {
        if (n == -1 && this.WENZOOM > 8) {
            this.WENZOOM /= 2;
            this.oc = null;
            this.mImgWen = null;
        } else if (n == 1 && this.WENZOOM < 64) {
            this.WENZOOM *= 2;
            this.oc = null;
            this.mImgWen = null;
        }
        this.repaint();
    }

    protected void setPixelTable(boolean bl) {
        this.WENZOOM = bl ? 32 : 8;
    }

    protected void drawImgWen() {
        ViewSimple viewSimple = this.aladin.view.getMouseView();
        if (viewSimple == null || viewSimple.isFree() || !viewSimple.pref.isImage() || viewSimple.isProjSync() || viewSimple.northUp) {
            this.img = null;
            this.imgok = false;
            return;
        }
        PointD pointD = viewSimple.getPosition(this.xwen, this.ywen);
        int n = viewSimple.pref.type == 3 || viewSimple.pref.type == 4 ? viewSimple.cubeControl.lastFrame : this.oframe;
        if (pointD.equals(this.oc) && n == this.oframe) {
            return;
        }
        this.oc = pointD;
        this.oframe = n;
        this.calculWen(viewSimple, (int)pointD.x, (int)pointD.y);
    }

    protected void calculWen(ViewSimple viewSimple, int n, int n2) {
        boolean bl;
        this.xmwen = n;
        this.ymwen = n2;
        int n3 = (int)Math.ceil((double)SIZE / (double)this.WENZOOM);
        int n4 = this.xmwen - n3 / 2;
        int n5 = this.ymwen - n3 / 2;
        PlanImage planImage = (PlanImage)viewSimple.pref;
        boolean bl2 = bl = planImage.type == 2;
        if (viewSimple.hashCode() != this.ov) {
            this.mImgWen = null;
        }
        this.ov = viewSimple.hashCode();
        if (bl) {
            if (this.pixelsRGB == null || this.pixelsRGB.length != n3 * n3) {
                this.pixelsRGB = new int[n3 * n3];
            }
            if (this.scalepixelsRGB == null || this.scalepixelsRGB.length != n3 * n3 * this.WENZOOM * this.WENZOOM) {
                this.scalepixelsRGB = new int[n3 * n3 * this.WENZOOM * this.WENZOOM];
            }
        } else {
            if (this.pixels == null || this.pixels.length != n3 * n3) {
                this.pixels = new byte[n3 * n3];
            }
            if (this.scalepixels == null || this.scalepixels.length != n3 * n3 * this.WENZOOM * this.WENZOOM) {
                this.scalepixels = new byte[n3 * n3 * this.WENZOOM * this.WENZOOM];
            }
        }
        if (n4 >= 0 && n5 >= 0 && n4 + n3 < planImage.width && n5 + n3 < planImage.height) {
            if (bl) {
                PlanImageRGB planImageRGB = (PlanImageRGB)planImage;
                planImageRGB.getPixels(this.pixelsRGB, n4, n5, n3, n3);
                this.flagRGB = true;
                int n6 = 0;
                for (int i = 0; i < n3; ++i) {
                    int n7 = n6;
                    for (int j = 0; j < n3; ++j) {
                        int n8 = this.pixelsRGB[i * n3 + j];
                        for (int k = 0; k < this.WENZOOM; ++k) {
                            this.scalepixelsRGB[n6 + k] = n8;
                        }
                        n6 += this.WENZOOM;
                    }
                    for (int j = 1; j < this.WENZOOM; j += j) {
                        System.arraycopy(this.scalepixelsRGB, n7, this.scalepixelsRGB, n7 + j * n3 * this.WENZOOM, j * this.WENZOOM * n3);
                    }
                    n6 += (this.WENZOOM - 1) * this.WENZOOM * n3;
                }
            } else {
                planImage.getPixels(this.pixels, n4, n5, n3, n3);
                this.flagRGB = false;
                int n9 = 0;
                for (int i = 0; i < n3; ++i) {
                    int n10 = n9;
                    for (int j = 0; j < n3; ++j) {
                        byte by = this.pixels[i * n3 + j];
                        for (int k = 0; k < this.WENZOOM; ++k) {
                            this.scalepixels[n9 + k] = by;
                        }
                        n9 += this.WENZOOM;
                    }
                    for (int j = 1; j < this.WENZOOM; j += j) {
                        System.arraycopy(this.scalepixels, n10, this.scalepixels, n10 + j * n3 * this.WENZOOM, j * this.WENZOOM * n3);
                    }
                    n9 += (this.WENZOOM - 1) * this.WENZOOM * n3;
                }
            }
        }
        if (bl) {
            if (this.mImgWen == null) {
                this.mImgWen = new MemoryImageSource(n3 * this.WENZOOM, n3 * this.WENZOOM, this.scalepixelsRGB, 0, n3 * this.WENZOOM);
                this.mImgWen.setAnimated(true);
                this.imgwen = this.getToolkit().createImage(this.mImgWen);
            } else {
                this.mImgWen.newPixels(this.scalepixelsRGB, ColorModel.getRGBdefault(), 0, n3 * this.WENZOOM);
            }
        } else if (this.mImgWen == null) {
            this.mImgWen = new MemoryImageSource(n3 * this.WENZOOM, n3 * this.WENZOOM, planImage.cm, this.scalepixels, 0, n3 * this.WENZOOM);
            this.mImgWen.setAnimated(true);
            this.imgwen = this.getToolkit().createImage(this.mImgWen);
        } else {
            this.mImgWen.newPixels(this.scalepixels, planImage.cm, 0, n3 * this.WENZOOM);
        }
        if (this.flagwen) {
            this.imgok = true;
            this.img = this.imgwen;
        }
    }

    private void drawInfo(Graphics graphics, int n, int n2) {
        try {
            Projection projection = this.aladin.view.getCurrentView().pref.projd;
            if (projection.isXYLinear()) {
                return;
            }
            Calib calib = projection.c;
            String string = Coord.getUnit(calib.getImgWidth());
            String string2 = Coord.getUnit(calib.getImgHeight());
            graphics.setFont(Aladin.SPLAIN);
            graphics.setColor(Color.blue);
            String string3 = string + " x " + string2;
            graphics.drawString(string3, n / 2 - graphics.getFontMetrics().stringWidth(string3) / 2, n2 - 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void drawFleche(Graphics graphics, int n, int n2, char c) {
        int n3;
        int n4 = c == 'W' ? -WF : (n3 = c == 'E' ? WF : 0);
        int n5 = c == 'N' ? -WF : (c == 'S' ? WF : 0);
        int n6 = n + n3;
        int n7 = n2 + n5;
        graphics.drawLine(n, n2, n6, n7);
        ZoomView.XF[0] = n6;
        ZoomView.YF[0] = n7;
        ZoomView.XF[1] = n6 + (n5 /= 3) - (n3 /= 3);
        ZoomView.YF[1] = n7 - n5 - n3;
        ZoomView.XF[2] = n6 - n5 - n3;
        ZoomView.YF[2] = n7 - n5 + n3;
        graphics.fillPolygon(XF, YF, 3);
        graphics.drawPolygon(XF, YF, 3);
    }

    String getTaquinTime() {
        long l = (System.currentTimeMillis() - this.startTaquinTime) / 1000L;
        return Util.align2((int)l / 60) + ":" + Util.align2((int)l % 60);
    }

    protected boolean isPixelTable() {
        return this.WENZOOM >= 32;
    }

    protected void copier() {
        if (!this.flagHist) {
            return;
        }
        String string = this.hist.getCopier();
        this.aladin.copyToClipBoard(string);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension;
        if (Aladin.NOGUI) {
            return;
        }
        this.aladin.setAliasing(graphics);
        ViewSimple viewSimple = this.aladin.view.getCurrentView();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (viewSimple == null || viewSimple.isFree()) {
            graphics.setColor(Aladin.LBLUE);
            graphics.fillRect(0, 0, n, n2);
            this.drawBord(graphics);
            return;
        }
        Dimension dimension2 = dimension = viewSimple == null ? new Dimension(0, 0) : viewSimple.getSize();
        if (this.flagwen) {
            this.imgok = true;
            this.drawImgWen();
        } else if (!this.flagdrag) {
            this.imgok = this.drawImgZoom(viewSimple);
        }
        if (this.flagHist) {
            this.drawImgHist(graphics);
            return;
        }
        if (this.flagSED && this.drawImgSED(graphics)) {
            return;
        }
        if (this.flagCut) {
            this.drawImgCut(graphics);
            try {
                if (this.objCut instanceof Cote) {
                    this.drawFWHM(graphics);
                } else if (this.objCut instanceof SourceStat) {
                    if (((SourceStat)this.objCut).hasRayon()) {
                        this.drawPixelCourant(graphics);
                    } else {
                        this.drawCubeFrame(graphics);
                    }
                } else if (Ligne.isLigne(this.objCut)) {
                    this.drawPixelCourant(graphics);
                }
            }
            catch (Exception exception) {
                this.setCut(null);
            }
            return;
        }
        if (viewSimple.isPlotView()) {
            graphics.clearRect(0, 0, n, n2);
            this.drawBord(graphics);
            return;
        }
        if (viewSimple.pref instanceof PlanBG) {
            this.drawHipsControl(graphics, viewSimple);
            return;
        }
        if (!(Aladin.NOGUI || viewSimple == null || viewSimple.isFree() || dimension.width == this.owidth && dimension.height == this.oheight)) {
            this.owidth = dimension.width;
            this.oheight = dimension.height;
            this.newZoom(viewSimple.xzoomView, viewSimple.yzoomView);
            return;
        }
        if (this.imgok) {
            graphics.drawImage(this.img, 0, 0, this);
        } else {
            graphics.clearRect(0, 0, n, n2);
        }
        if (this.aladin.view.flagTaquin) {
            graphics.setFont(new Font("Helvetica", 1, 30));
            graphics.setColor(Color.red);
            if (this.startTaquinTime == 0L) {
                this.startTaquinTime = System.currentTimeMillis();
            }
            graphics.drawString(this.getTaquinTime(), 38, n / 2 + 15);
            this.drawBord(graphics);
            return;
        }
        if (!(viewSimple == null || viewSimple.isFree() || this.flagwen || this.flagCut || this.rectzoom == null)) {
            this.drawArea(graphics, (int)Math.round(this.rectzoom.x), (int)Math.round(this.rectzoom.y), (int)Math.round(this.rectzoom.width - 1.0), (int)Math.round(this.rectzoom.height - 1.0));
            graphics.setColor(Color.blue);
            this.drawInfo(graphics, n, n2);
        }
        if (this.flagwen && this.imgok) {
            int n3 = (int)Math.ceil((double)SIZE / (double)this.WENZOOM);
            int n4 = n3 / 2 * this.WENZOOM;
            int n5 = this.WENZOOM / 2;
            graphics.setColor(Color.blue);
            graphics.drawRect(n4, n4, this.WENZOOM, this.WENZOOM);
            if (this.WENZOOM <= 16) {
                ZoomView.drawFleche(graphics, n4 + n5, n4 - this.WENZOOM, 'N');
                ZoomView.drawFleche(graphics, n4 + n5, n4 + 2 * this.WENZOOM, 'S');
                ZoomView.drawFleche(graphics, n4 - this.WENZOOM, n4 + n5, 'W');
                ZoomView.drawFleche(graphics, n4 + 2 * this.WENZOOM, n4 + n5, 'E');
            }
            graphics.setFont(Aladin.LBOLD);
            graphics.setColor(Color.red);
            if (this.WENZOOM > 8) {
                graphics.drawString("-", n - 11, n2 - 15);
            }
            if (this.WENZOOM < 64) {
                graphics.drawString("+", n - 12, n2 - 5);
            }
            if (this.isPixelTable() && viewSimple.pref.type != 2) {
                viewSimple = this.aladin.view.getMouseView();
                int n6 = this.WENZOOM == 32 ? 2 : 1;
                graphics.setFont(Aladin.BOLD);
                graphics.setColor(Color.black);
                int n7 = 0;
                int n8 = this.ymwen - n6;
                while (n8 <= this.ymwen + n6) {
                    int n9 = 0;
                    int n10 = this.xmwen - n6;
                    while (n10 <= this.xmwen + n6) {
                        int n11 = n9 * this.WENZOOM + 8;
                        int n12 = n7 * this.WENZOOM + 2 * this.WENZOOM / 3 - 7 + n9 % 2 * this.WENZOOM / 2;
                        String string = ((PlanImage)viewSimple.pref).getPixelInfo(n10, n8, 3);
                        Util.drawStringOutline(graphics, string, n11, n12, n8 == this.ymwen && n10 == this.xmwen ? Color.cyan : Color.white, Color.black);
                        ++n10;
                        ++n9;
                    }
                    ++n8;
                    ++n7;
                }
            }
        }
        this.drawBord(graphics);
    }

    private void drawArea(Graphics graphics, int n, int n2, int n3, int n4) {
        Util.drawArea(this.aladin, graphics, n, n2, n3, n4, Color.blue, 0.15f, true);
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        graphics.setColor(Color.red);
        if (n + n3 < 0) {
            ZoomView.drawFleche(graphics, 15, n6 / 2, 'W');
        }
        if (n2 + n4 < 0) {
            ZoomView.drawFleche(graphics, n5 / 2, 15, 'N');
        }
        if (n >= SIZE) {
            ZoomView.drawFleche(graphics, n5 - 15, n6 / 2, 'E');
        }
        if (n2 >= SIZE) {
            ZoomView.drawFleche(graphics, n5 / 2, n6 - 15, 'S');
        }
    }

    protected void wen(double d, double d2) {
        if (!this.flagwen) {
            return;
        }
        if (this.xwen == d && this.ywen == d2) {
            return;
        }
        this.xwen = d;
        this.ywen = d2;
        this.repaint();
    }

    protected void wenOn() {
        this.flagwen = true;
    }

    void wenOff() {
        this.flagwen = false;
        this.repaint();
    }

    protected String Help() {
        return Aladin.chaine.getString("ZoomView.HELP");
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int n, int n2, int n3, int n4, float f, JComponent jComponent) {
        this.voc = new WidgetControl(this, n, n2, n3, n4, f, jComponent);
        this.voc.setResizable(Aladin.PROTO);
    }

    @Override
    public void paintCollapsed(Graphics graphics) {
        Tool.drawVOHand(graphics, 3, 2);
    }

    static {
        DIM = new Dimension(Select.ws + 16, Select.ws + 16);
        WF = 12;
        XF = new int[3];
        YF = new int[3];
    }
}

