/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.bookmark;

import cds.aladin.Aladin;
import cds.aladin.Cache;
import cds.aladin.Command;
import cds.aladin.Function;
import cds.aladin.Glu;
import cds.aladin.MyInputStream;
import cds.aladin.Tok;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.aladin.bookmark.ButtonBookmark;
import cds.aladin.bookmark.FrameBookmarks;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class Bookmarks
extends JToolBar
implements Widget {
    private Aladin aladin;
    private FrameBookmarks frameBookmarks;
    private String memoDefaultList = "";
    private boolean remoteBookmarksLoaded = false;
    private String defaultBookmarkListByGlu = null;
    private String gluTag = null;
    private WidgetControl voc = null;

    public Bookmarks(Aladin aladin) {
        this.aladin = aladin;
        this.frameBookmarks = null;
        this.setRollover(true);
        this.setFloatable(false);
        this.setBorderPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(aladin.getBackground());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, 16);
    }

    public void init(boolean bl) {
        this.createBookmarks(bl);
        this.aladin.getCommand().setFunctionModif(false);
    }

    public FrameBookmarks getFrameBookmarks() {
        if (this.frameBookmarks == null) {
            this.frameBookmarks = new FrameBookmarks(this.aladin, this);
        }
        return this.frameBookmarks;
    }

    public void reload() {
        String string = this.aladin.configuration.getBookmarks();
        this.aladin.configuration.resetBookmarks();
        this.init(true);
        StringTokenizer stringTokenizer = new StringTokenizer(string == null ? "" : string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Function function = this.aladin.getCommand().getFunction(string2);
            if (!function.isLocalDefinition()) continue;
            function.setBookmark(true);
        }
        Bookmarks bookmarks = this;
        if (bookmarks.aladin.hasGUI()) {
            this.resumeToolBar();
        }
    }

    public JToolBar getToolBar() {
        return this;
    }

    public String getUniqueName(String string) {
        int n = string.indexOf(40);
        if (n > 0) {
            string = string.substring(0, n);
        }
        Vector<Function> vector = this.aladin.getCommand().getBookmarkFunctions();
        int n2 = 0;
        while (true) {
            boolean bl = false;
            String string2 = string + (n2 == 0 ? "" : "~" + n2);
            Enumeration<Function> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Function function = enumeration.nextElement();
                if (!string2.equals(function.getName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return string2;
            }
            ++n2;
        }
    }

    private void populateToolBar(JToolBar jToolBar) {
        Object object;
        Enumeration<Function> enumeration;
        try {
            enumeration = this.aladin.getCommand().getBookmarkFunctions().elements();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            ButtonBookmark buttonBookmark = new ButtonBookmark(this.aladin, (Function)object);
            jToolBar.add(buttonBookmark);
        }
        if (!Aladin.OUTREACH) {
            object = new JButton("+");
            ((JComponent)object).setBackground(this.aladin.getBackground());
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
            Bookmarks bookmarks = this;
            ((JComponent)object).setToolTipText(bookmarks.aladin.getChaine().getString("BKMEDITOR"));
            ((JComponent)object).setFont(((Component)object).getFont().deriveFont(1));
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Bookmarks.this.editFrame();
                }
            });
            jToolBar.add((Component)object);
        }
    }

    public void resumeToolBar() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.resumeToolBar1();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Bookmarks.this.resumeToolBar1();
                }
            });
        }
    }

    private void resumeToolBar1() {
        this.removeAll();
        this.populateToolBar(this);
        this.revalidate();
        this.aladin.repaint();
        if (this.aladin.f != null) {
            this.aladin.f.repaint();
        }
    }

    public void showFrame() {
        this.getFrameBookmarks().setVisible(true);
    }

    public void editFrame() {
        this.getFrameBookmarks().setVisibleEdit();
    }

    public boolean isDefaultList() {
        return this.memoDefaultList.equals(this.getBookmarkList());
    }

    public void memoDefaultList(String string) {
        this.memoDefaultList = string;
    }

    public String getBookmarkList() {
        return this.getBookmarkList(false);
    }

    public String getBookmarkList(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Function> enumeration = this.aladin.getCommand().getBookmarkFunctions().elements();
        while (enumeration.hasMoreElements()) {
            Function function = enumeration.nextElement();
            if (bl && !function.isLocalDefinition()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(function.getName());
        }
        return stringBuffer.toString();
    }

    public boolean canBeSaved() {
        return this.remoteBookmarksLoaded;
    }

    public void setBookmarkList(String string) {
        int n = 0;
        if (string.length() > 1) {
            if (string.charAt(0) == '+') {
                n = 1;
                string = string.substring(1);
            } else if (string.charAt(0) == '-') {
                n = -1;
                string = string.substring(1);
            }
        }
        if (n == 0) {
            this.aladin.getCommand().resetBookmarks();
            n = 1;
        }
        Tok tok = new Tok(string, ",");
        while (tok.hasMoreTokens()) {
            String string2 = tok.nextToken().trim();
            Function function = this.aladin.getCommand().getFunction(string2);
            if (function == null) continue;
            function.setBookmark(n == 1);
        }
        this.resumeToolBar();
    }

    public void memoGluBookmarks(String string, String string2) {
        Aladin.trace(4, "Bookmarks.memoBookmarks() %A=" + string + " %Aladin.Bookmarks=" + string2);
        this.gluTag = string;
        this.defaultBookmarkListByGlu = string2;
    }

    public void createBookmarks(boolean bl) {
        Object object;
        Object object2;
        Glu glu = this.aladin.getGlu();
        Cache cache = this.aladin.getCache();
        Command command = this.aladin.getCommand();
        if (this.gluTag != null) {
            try {
                Aladin.trace(3, "Remote bookmarks loaded...");
                command.setFunctionLocalDefinition(false);
                if (bl) {
                    object2 = glu.getURL(this.gluTag, "", false, false) + "";
                    cache.putInCache((String)object2);
                }
                object2 = new MyInputStream(cache.get(glu.getURL(this.gluTag, "", false, false)));
                this.aladin.getCommand().execScript(new String(((MyInputStream)object2).readFully()), false, true);
                ((MyInputStream)object2).close();
                this.remoteBookmarksLoaded = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Remote bookmarks error: " + exception.getMessage());
            }
        }
        object2 = new File(this.aladin.getConfiguration().getLocalBookmarksFileName());
        if (!this.aladin.isOutreach() && ((File)object2).canRead()) {
            try {
                Aladin.trace(3, "Local bookmarks loaded [" + ((File)object2).getCanonicalPath() + "]...");
                command.setFunctionLocalDefinition(true);
                object = new MyInputStream(new FileInputStream((File)object2));
                command.execScript(new String(((MyInputStream)object).readFully()), false, true);
                ((MyInputStream)object).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Local bookmarks error: " + exception.getMessage());
            }
        }
        if (this.defaultBookmarkListByGlu != null) {
            this.memoDefaultList(this.defaultBookmarkListByGlu);
        }
        object = "Default ";
        String string = this.aladin.configuration.getBookmarks();
        if (string == null || string.trim().length() == 0) {
            string = this.defaultBookmarkListByGlu;
        } else {
            object = "Local ";
        }
        if (string != null) {
            Aladin.trace(2, (String)object + "bookmarks: " + string);
            this.setBookmarkList(string);
        }
        command.setFunctionLocalDefinition(true);
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int n, int n2, int n3, int n4, float f, JComponent jComponent) {
        this.voc = new WidgetControl(this, n, n2, n3, n4, f, jComponent);
        this.voc.setResizable(true);
        this.voc.setCollapsed(false);
    }

    @Override
    public void paintCollapsed(Graphics graphics) {
    }
}

