/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.bookmark;

import cds.aladin.Aladin;
import cds.aladin.Function;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class ButtonBookmark
extends JButton {
    private Aladin aladin;
    private Function fct;
    public static final Color Orange = new Color(255, 175, 0);

    public ButtonBookmark(Aladin aladin, String string, String string2, String string3) {
        this.aladin = aladin;
        this.fct = new Function(string, null, string3, string2);
        this.suite();
    }

    public ButtonBookmark(Aladin aladin, Function function) {
        this.aladin = aladin;
        this.fct = function;
        this.suite();
    }

    private void suite() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 12, 2, 5));
        this.setToolTipText("<html><b>" + Util.fold(this.fct.getDescription(), 20) + "</b><br><i>" + this.fct.getCode().replaceAll(";", "<br>").replaceAll("\n", "<br>") + "</i></html>");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ButtonBookmark.this.exec();
            }
        });
    }

    public Function getFunction() {
        return this.fct;
    }

    @Override
    public String getText() {
        return this.fct == null ? "X" : this.fct.getName();
    }

    private void exec() {
        try {
            this.fct.exec(this.aladin, "", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.fct.isLocalDefinition() ? Color.blue : Orange);
        Util.drawStar(graphics, 6, 9);
    }
}

