/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.bookmark;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.Function;
import cds.aladin.bookmark.Bookmarks;
import cds.aladin.bookmark.ButtonBookmark;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class FrameBookmarks
extends JFrame {
    private Aladin aladin;
    private Bookmarks bookmarks;
    private boolean expertMode = false;
    private JPanel expertPanel = null;
    private JPanel amateurPanel = null;
    private JTextArea edit;
    private Function fctEdit = null;
    private JButton apply;
    private JButton delete;
    private JPanel genPanel = null;
    static final int BKM = 0;
    static final int LOC = 1;
    static final int NAME = 2;
    static final int DESC = 3;
    private JTable table;
    private BookmarkTable tableModel;

    public FrameBookmarks(Aladin aladin, Bookmarks bookmarks) {
        this.aladin = aladin;
        this.bookmarks = bookmarks;
        Aladin.setIcon(this);
        this.setTitle(aladin.getChaine().getString("BKMTITLE"));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
    }

    private Function addBookmark(String string, String string2, String string3, String string4) {
        Function function = new Function(string, string2, string4, string3);
        function.setBookmark(true);
        this.aladin.getCommand().addFunction(function);
        return function;
    }

    @Override
    public void show() {
        if (this.genPanel == null) {
            this.createPanel();
            this.pack();
        }
        super.show();
    }

    private void createPanel() {
        this.genPanel = (JPanel)this.getContentPane();
        this.genPanel.setLayout(new BorderLayout(5, 5));
        this.genPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.genPanel.add((Component)this.getBookmarksPanel(), "North");
        this.genPanel.add((Component)this.getAmateurPanel(), "South");
        this.getExpertPanel();
    }

    private JPanel getExpertPanel() {
        if (this.expertPanel != null) {
            return this.expertPanel;
        }
        JPanel jPanel = this.expertPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this.getEditPanel(), "Center");
        jPanel.add((Component)this.getControlPanel(), "South");
        return jPanel;
    }

    private JPanel getAmateurPanel() {
        if (this.amateurPanel != null) {
            return this.amateurPanel;
        }
        JPanel jPanel = this.amateurPanel = new JPanel();
        FrameBookmarks frameBookmarks = this;
        Chaine chaine = frameBookmarks.aladin.getChaine();
        JButton jButton = new JButton(chaine.getString("EXEC"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.execute();
            }
        });
        jButton = new JButton(chaine.getString("BKMEDITOR"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.genPanel.remove(FrameBookmarks.this.amateurPanel);
                FrameBookmarks.this.genPanel.add((Component)FrameBookmarks.this.getExpertPanel(), "Center");
                FrameBookmarks.this.expertMode = true;
                FrameBookmarks.this.pack();
            }
        });
        jButton = new JButton(chaine.getString("PROPCLOSE"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.dispose();
            }
        });
        jPanel.add(Util.getHelpButton(this, chaine.getString("BKMHELP")));
        return jPanel;
    }

    public void setVisibleEdit() {
        if (this.genPanel == null) {
            this.createPanel();
        }
        this.genPanel.remove(this.amateurPanel);
        this.genPanel.add((Component)this.getExpertPanel(), "Center");
        this.expertMode = true;
        this.pack();
        this.setVisible(true);
    }

    protected JPanel getEditPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.edit = new JTextArea(8, 50);
        this.edit.setFont(Aladin.COURIER);
        this.edit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FrameBookmarks.this.apply.setEnabled(FrameBookmarks.this.isModif());
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.edit);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void resumeEdit(Function function, boolean bl) {
        if (bl) {
            this.valide(true);
        }
        this.fctEdit = function;
        boolean bl2 = function == null ? false : function.isLocalDefinition();
        this.edit.setText(function == null ? "" : function.toString());
        this.edit.setEditable(bl2);
        this.delete.setEnabled(bl2);
        this.apply.setEnabled(this.isModif());
    }

    private boolean isModif() {
        if (this.fctEdit == null) {
            return false;
        }
        if (!this.fctEdit.isLocalDefinition()) {
            return false;
        }
        return !this.fctEdit.toString().trim().equals(this.edit.getText().trim());
    }

    private void valide(boolean bl) {
        block7: {
            block6: {
                if (!this.isModif()) {
                    return;
                }
                if (!bl) break block6;
                FrameBookmarks frameBookmarks = this;
                if (!Aladin.confirmation(this, frameBookmarks.aladin.getChaine().getString("BKMAPPLY"))) break block7;
            }
            try {
                Function function = new Function(this.edit.getText());
                this.fctEdit.setDescription(function.getDescription());
                this.fctEdit.setName(function.getName());
                this.fctEdit.setParam(function.getParam());
                this.fctEdit.setCode(function.getCode());
                this.fctEdit.setLocalDefinition(true);
                this.edit.setText(this.fctEdit.toString());
                this.resumeTable();
                this.bookmarks.resumeToolBar();
                this.aladin.log("Bookmark", "create");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void execute() {
        try {
            Function function;
            if (!this.isModif()) {
                int n = this.table.getSelectedRow();
                function = this.aladin.getCommand().getFunction(n);
            } else {
                function = new Function(this.edit.getText());
            }
            function.exec(this.aladin, "", true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JPanel getControlPanel() {
        JPanel jPanel = new JPanel();
        FrameBookmarks frameBookmarks = this;
        Chaine chaine = frameBookmarks.aladin.getChaine();
        JButton jButton = new JButton(chaine.getString("PROPNEWCALIB"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.createNewBookmark();
            }
        });
        jButton = this.delete = new JButton(chaine.getString("SLMDEL"));
        jPanel.add(this.delete);
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.deleteBookmark();
            }
        });
        jButton = new JButton(chaine.getString("BKMDEFAULT"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.resetBookmarks(true);
            }
        });
        jPanel.add(new JLabel(" - "));
        jButton = new JButton(chaine.getString("EXEC"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.execute();
            }
        });
        jButton = this.apply = new JButton(chaine.getString("PROPAPPLY"));
        jPanel.add(this.apply);
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.valide(false);
            }
        });
        jButton = new JButton(chaine.getString("PROPCLOSE"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FrameBookmarks.this.dispose();
            }
        });
        return jPanel;
    }

    private void createNewBookmark() {
        this.createNewBookmark("YourName", "$TARGET,$RADIUS", "Your description", null);
    }

    public void createNewBookmark(String string, String string2, String string3, String string4) {
        Function function = this.addBookmark(string, string2, string3, string4);
        this.aladin.getCommand().addFunction(function);
        this.resumeEdit(function, true);
        if (string4 != null) {
            this.fctEdit.setCode(null);
            this.valide(false);
        }
        this.resumeTable();
        int n = this.table.getRowCount() - 1;
        this.table.scrollRectToVisible(this.table.getCellRect(n, 2, true));
        this.table.setRowSelectionInterval(n, n);
    }

    private void deleteBookmark() {
        int n = this.table.getSelectedRow();
        Function function = this.aladin.getCommand().getFunction(n);
        this.aladin.getCommand().removeFunction(function);
        this.resumeTable();
        this.bookmarks.resumeToolBar();
        this.resumeEdit(null, false);
    }

    protected void resetBookmarks(boolean bl) {
        if (bl) {
            FrameBookmarks frameBookmarks = this;
            if (!Aladin.confirmation(this, frameBookmarks.aladin.getChaine().getString("BKMCONFIRM"))) {
                return;
            }
        }
        this.bookmarks.reload();
        this.resumeTable();
        this.resumeEdit(null, false);
    }

    @Override
    public void dispose() {
        if (this.expertMode) {
            this.genPanel.remove(this.expertPanel);
            this.genPanel.add((Component)this.getAmateurPanel(), "South");
            this.pack();
            this.expertMode = false;
        }
        this.setVisible(false);
    }

    protected JPanel getBookmarksPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.createBookmarksTable());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    private void resumeTable() {
        this.tableModel.fireTableDataChanged();
    }

    private JTable createBookmarksTable() {
        this.tableModel = new BookmarkTable();
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getColumnModel().getColumn(0).setMinWidth(60);
        this.table.getColumnModel().getColumn(0).setMaxWidth(60);
        this.table.getColumnModel().getColumn(2).setMinWidth(70);
        this.table.getColumnModel().getColumn(2).setMaxWidth(70);
        this.table.setPreferredScrollableViewportSize(new Dimension(420, 456));
        MyRenderer myRenderer = new MyRenderer();
        this.table.getColumnModel().getColumn(1).setCellRenderer(myRenderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = FrameBookmarks.this.table.rowAtPoint(mouseEvent.getPoint());
                Function function = FrameBookmarks.this.aladin.getCommand().getFunction(n);
                if (FrameBookmarks.this.delete != null) {
                    FrameBookmarks.this.delete.setEnabled(true);
                }
                FrameBookmarks.this.resumeEdit(function, true);
            }
        });
        return this.table;
    }

    private LabelIcon getIcon(Function function) {
        return new LabelIcon(function);
    }

    class LabelIcon
    extends JLabel {
        Function f;

        LabelIcon() {
        }

        LabelIcon(Function function) {
            this.f = function;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(this.f.isLocalDefinition() ? Color.blue : ButtonBookmark.Orange);
            Util.drawStar(graphics, 6, 7);
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return (Component)object;
        }
    }

    class BookmarkTable
    extends AbstractTableModel {
        BookmarkTable() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return FrameBookmarks.this.aladin.getCommand().getNbFunctions();
        }

        @Override
        public String getColumnName(int n) {
            return n == 1 ? "" : (n == 0 ? "Bookmark" : (n == 2 ? "Name" : "Description"));
        }

        public Class getColumnClass(int n) {
            if (n == 1) {
                return new LabelIcon().getClass();
            }
            if (n == 0) {
                return new Boolean(true).getClass();
            }
            return super.getColumnClass(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Function function = FrameBookmarks.this.aladin.getCommand().getFunction(n);
            switch (n2) {
                case 1: {
                    return FrameBookmarks.this.getIcon(function);
                }
                case 0: {
                    return new Boolean(function.isBookmark());
                }
                case 2: {
                    return function.getName();
                }
            }
            return function.getDescription();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return true;
            }
            Function function = FrameBookmarks.this.aladin.getCommand().getFunction(n);
            return function.isLocalDefinition();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Function function = FrameBookmarks.this.aladin.getCommand().getFunction(n);
            if (n2 == 0) {
                function.setBookmark(!function.isBookmark());
                FrameBookmarks.this.bookmarks.resumeToolBar();
            } else if (n2 == 2 || n2 == 3) {
                if (n2 == 2) {
                    function.setName((String)object);
                } else {
                    function.setDescription((String)object);
                }
                function.setLocalDefinition(true);
                FrameBookmarks.this.resumeEdit(function, false);
                FrameBookmarks.this.bookmarks.resumeToolBar();
            }
        }
    }
}

