/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.prop;

import cds.aladin.prop.Filet;
import cds.aladin.prop.Prop;
import cds.aladin.prop.Propable;
import cds.tools.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropPanel
extends JPanel {
    private JFrame frame;
    private Vector<Prop> propList;

    public PropPanel(Propable propable) {
        this(null, propable);
    }

    public PropPanel(JFrame jFrame, Propable propable) {
        this.frame = jFrame;
        this.propList = propable.getProp();
        this.createPanel();
    }

    public int apply() {
        int n = -1;
        for (Prop prop : this.propList) {
            int n2 = prop.apply();
            if (n2 == 0) {
                n = n2;
                continue;
            }
            if (n != -1 || n2 != 1) continue;
            n = n2;
        }
        return n;
    }

    public void resume() {
        for (Prop prop : this.propList) {
            prop.resume();
        }
    }

    private void createPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.setLayout(gridBagLayout);
        for (Prop prop : this.propList) {
            PropPanel.addCouple(this.frame, this, prop.getLabel(), prop.getHelp(), prop.getWidget(), gridBagLayout, gridBagConstraints, 13);
        }
    }

    public static void addCouple(JFrame jFrame, JPanel jPanel, Object object, String string, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        PropPanel.addCouple(jFrame, jPanel, object, string, component, gridBagLayout, gridBagConstraints, 17);
    }

    public static void addCouple(JPanel jPanel, Object object, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        PropPanel.addCouple(null, jPanel, object, null, component, gridBagLayout, gridBagConstraints, 17);
    }

    public static void addCouple(JFrame jFrame, JPanel jPanel, Object object, String string, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n) {
        Component component2;
        JComponent jComponent;
        if (object instanceof String) {
            jComponent = new JLabel((String)object);
            jComponent.setFont(jComponent.getFont().deriveFont(2));
            component2 = jComponent;
        } else {
            component2 = (Component)object;
        }
        if (string != null) {
            jComponent = new JPanel();
            jComponent.add(component2);
            JButton jButton = Util.getHelpButton(jFrame, string);
            jComponent.add(jButton);
            component2 = jComponent;
        }
        gridBagConstraints.anchor = n;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(component2, gridBagConstraints);
        jPanel.add(component2);
        if (component instanceof JButton) {
            jComponent = new JPanel();
            jComponent.add(component);
            component2 = jComponent;
        } else {
            component2 = component;
        }
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(component2, gridBagConstraints);
        jPanel.add(component2);
    }

    public static void addInfo(JPanel jPanel, String string, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(Util.fold("<center>" + string + "</center>", 80, true), 0);
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
    }

    public static void addSectionTitle(JPanel jPanel, String string, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(string);
        PropPanel.addSectionTitle(jPanel, jLabel, gridBagLayout, gridBagConstraints);
    }

    public static void addSectionTitle(JPanel jPanel, JLabel jLabel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
    }

    public static void addFilet(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2) {
        Filet filet = new Filet(n, n2);
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(filet, gridBagConstraints);
        jPanel.add(filet);
        gridBagConstraints = gridBagConstraints2;
    }

    public static void addFilet(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        PropPanel.addFilet(jPanel, gridBagLayout, gridBagConstraints, 5, 1);
    }
}

