/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.stc;

import cds.aladin.stc.STCFrame;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class STCStringParser {
    public List<STCObj> parse(String string) {
        String[] stringArray;
        string = string.toUpperCase();
        ArrayList<STCObj> arrayList = new ArrayList<STCObj>();
        for (String string2 : stringArray = this.splitShapesStrings(string)) {
            Iterator<String> iterator = Arrays.asList(string2.split("[ \t]+", -1)).iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if (!string3.equals("POLYGON")) continue;
                try {
                    arrayList.add(this.parsePolygon(iterator));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    private String[] splitShapesStrings(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = new String();
        for (STCObj.ShapeType shapeType : STCObj.ShapeType.values()) {
            string2 = string2 + shapeType.name() + "|";
        }
        string2 = string2.substring(0, string2.length() - 1);
        String string4 = new String(string2);
        string4 = string4 + "( +[A-Za-z0-9]+)( +[-]?[0-9\\.]+)+";
        Pattern pattern = Pattern.compile(string4);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private STCPolygon parsePolygon(Iterator<String> iterator) throws Exception {
        STCPolygon sTCPolygon = new STCPolygon();
        sTCPolygon.setFrame(STCFrame.valueOf(iterator.next()));
        while (iterator.hasNext()) {
            double d = Double.NaN;
            double d2 = Double.NaN;
            try {
                d2 = Double.parseDouble(iterator.next());
                d = Double.parseDouble(iterator.next());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            sTCPolygon.addCorner(d2, d);
        }
        return sTCPolygon;
    }

    public static void main(String[] stringArray) {
        STCStringParser sTCStringParser = new STCStringParser();
        sTCStringParser.parse("Polygon   ICRS   211.115036    54.280565  211.115135    54.336616  210.971306    54.336617  210.971403    54.280566  Polygon   J2000   211.115036    54.280565  211.115135    54.336616  210.971306    54.336617  210.971403    54.280566");
        sTCStringParser.parse("Polygon J2000 40.57741 0.07310 40.57741 0.06771 40.60596 -0.06867 40.60597 -0.06868 40.61360 -0.06868 40.74998 -0.04013 40.74999 -0.04012 40.74999 -0.03473 40.72144 0.10165 40.72142 0.10166 40.71380 0.10166 40.57742 0.07311");
    }
}

