/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.prop.PropPanel;
import cds.fits.CacheFits;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class BuildProgressPanel
extends JPanel {
    private JPanel p1Index = new JPanel();
    private JPanel p2Tess = new JPanel();
    private String string1 = "Healpix Indexation";
    private String string2 = "Sky tesselation";
    private JLabel labelIndex = new JLabel(this.string1);
    private JLabel labelTess = new JLabel(this.string2);
    private JProgressBar progressBarIndex = new JProgressBar(0, 100);
    private JProgressBar progressBarTile = new JProgressBar(0, 100);
    private JLabel srcFileStat;
    private JLabel memStat;
    private JLabel lowTileStat;
    private JLabel nodeTileStat;
    private JLabel timeStat;

    public BuildProgressPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createProgressPanel(), "North");
        this.add((Component)this.createStatPanel(), "Center");
    }

    protected void setSrcStat(int n, int n2, long l, long l2, int n3, int n4, int n5, int n6) {
        String string = n == -1 ? "--" : n + " file" + (n > 1 ? "s" : "") + (n2 == n ? " (all gzipped)" : (n2 > 0 ? " (" + n2 + " gzipped)" : "")) + " using " + Util.getUnitDisk(l) + (n > 1 && l2 < 0L ? "" : " => biggest: [" + n3 + "x" + n4 + (n5 > 1 ? "x" + n5 : "") + " x" + n6 + "]");
        this.srcFileStat.setText(string);
    }

    protected void srcFileStat(String string) {
        this.srcFileStat.setText(string);
    }

    protected void setMemStat(int n, int n2, CacheFits cacheFits) {
        long l = Runtime.getRuntime().maxMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        long l4 = l2 - l3;
        String string = (n2 > 1 ? "thread: " + (n == -1 ? "" : n + " / " + n2) + " - " : "") + "RAM: " + Util.getUnitDisk(l4) + "/" + Util.getUnitDisk(l) + " (FITS cache: " + Util.getUnitDisk(cacheFits.getMem()) + ")";
        this.setMemStat(string);
    }

    protected void setMemStat(String string) {
        this.memStat.setText(string);
    }

    protected void setLowTileStat(int n, int n2, long l, long l2, long l3, long l4, long l5) {
        String string = n == -1 ? "" : n + "+" + n2 + "/" + l + " tile" + (n > 1 ? "s" : "") + " for " + Util.getUnitDisk(l2 * (long)n) + " - avg.proc.time: " + Util.getTemps(l5) + " [" + Util.getTemps(l3) + " .. " + Util.getTemps(l4) + "]";
        this.setLowTileStat(string);
    }

    protected void setLowTileStat(String string) {
        this.lowTileStat.setText(string);
    }

    protected void setNodeTileStat(int n, long l, long l2) {
        String string = n == -1 ? "" : n + " tile" + (n > 1 ? "s" : "") + " for " + Util.getUnitDisk(l * (long)n) + " - avg.proc.time: " + Util.getTemps(l2);
        this.setNodeTileStat(string);
    }

    protected void setNodeTileStat(String string) {
        this.nodeTileStat.setText(string);
    }

    protected void setTimeStat(long l, long l2, long l3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (l != -1L) {
            stringBuilder.append((l3 > 0L ? "running " : "") + Util.getTemps(l, true));
        }
        if (l > 5000L && l3 > 0L) {
            stringBuilder.append(" - " + l2 + " tiles/mn");
        }
        if (l > 20000L && l3 > 0L) {
            stringBuilder.append(" - ends in " + Util.getTemps(l3, true));
        }
        this.setTimeStat(stringBuilder + "");
    }

    protected void setTimeStat(String string) {
        this.timeStat.setText(string);
    }

    private JPanel createStatPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        JPanel jPanel = new JPanel(gridBagLayout);
        this.srcFileStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".Original images: ", this.srcFileStat, gridBagLayout, gridBagConstraints);
        this.memStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".Processing info: ", this.memStat, gridBagLayout, gridBagConstraints);
        this.lowTileStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".Low level tiles: ", this.lowTileStat, gridBagLayout, gridBagConstraints);
        this.nodeTileStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".Tree tiles: ", this.nodeTileStat, gridBagLayout, gridBagConstraints);
        this.timeStat = new JLabel("--");
        PropPanel.addCouple(jPanel, ".Time: ", this.timeStat, gridBagLayout, gridBagConstraints);
        return jPanel;
    }

    private JPanel createProgressPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        this.p1Index.setLayout(new BorderLayout());
        this.p2Tess.setLayout(new BorderLayout());
        this.select(true, 0);
        this.select(true, 1);
        this.p1Index.add((Component)this.labelIndex, "North");
        this.p2Tess.add((Component)this.labelTess, "North");
        this.progressBarIndex.setStringPainted(true);
        this.progressBarTile.setStringPainted(true);
        this.p1Index.add((Component)this.progressBarIndex, "South");
        this.p2Tess.add((Component)this.progressBarTile, "South");
        jPanel.add(this.p1Index);
        jPanel.add(this.p2Tess);
        return jPanel;
    }

    protected void resetProgressBar() {
        for (JProgressBar jProgressBar : new JProgressBar[]{this.progressBarIndex, this.progressBarTile}) {
            jProgressBar.setIndeterminate(false);
            jProgressBar.setValue(0);
            jProgressBar.setMaximum(100);
            jProgressBar.setString(null);
        }
    }

    public void clearForms() {
        this.progressBarTile.setValue(0);
        this.progressBarIndex.setValue(0);
        this.labelIndex.setText(this.string1);
        this.select(true, 0);
        this.select(true, 1);
        this.resetProgressBar();
    }

    public void select(boolean bl, int n) {
        JLabel jLabel = null;
        switch (n) {
            case 0: {
                jLabel = this.labelIndex;
                break;
            }
            case 1: {
                jLabel = this.labelTess;
            }
        }
        if (!bl) {
            jLabel.setFont(this.getFont().deriveFont(2));
            jLabel.setForeground(Color.LIGHT_GRAY);
        } else {
            jLabel.setFont(this.getFont().deriveFont(0));
            jLabel.setForeground(Color.BLACK);
        }
        this.repaint();
    }

    public JProgressBar getProgressBarTile() {
        return this.progressBarTile;
    }

    public JProgressBar getProgressBarIndex() {
        return this.progressBarIndex;
    }

    public void setProgressIndexDir(String string) {
        this.labelIndex.setText(this.string1 + " " + string);
        this.labelIndex.setPreferredSize(this.labelIndex.getSize());
    }
}

