/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Coord;
import cds.allsky.Context;
import cds.allsky.TabBuild;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class BuildTable
extends JTable {
    static int DEFAULT_BITPIX = -32;
    private Context context;
    private TabBuild tabBuild;
    private static final int MAXHEALPIXORDER = 21;
    private static final int CHECK_IDX = 0;
    private static final int RES_IDX = 1;
    private static final int NSIDE_IDX = 2;
    private static final int TILES_IDX = 3;
    private static final int VOL_IDX = 4;
    private static int[] columnSize = new int[]{60, 100, 120, 120, 80};
    private static String[] columnNames = new String[]{"", "<html>Pixel angular<br>resolution</html>", "<html>HEALPix:<br>order / NSIDE</html>", "<html>Tiles: (*)<br>Depth / Nb</html>", "<html>Space<br>required (*)</html>"};
    private static String[] columnToolTips = new String[]{"Your choice", "Target pixel angular resolution", "HEALPix parameters: order = log2(NSIDE)", "<html>Number of levels & Number of tiles (image 512x512)<br>at the end of the process<html>", "Disk space used at the end of the process"};
    int defaultRow = -1;
    private int defaultOrder = -1;
    static final Border bord = BorderFactory.createEmptyBorder(0, 10, 0, 0);

    BuildTable(Context context, TabBuild tabBuild) {
        super(BuildTable.createData(DEFAULT_BITPIX, context.getTileOrder()), columnNames);
        this.tabBuild = tabBuild;
        this.context = context;
        this.setAutoscrolls(true);
        for (int i = 0; i < columnSize.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(columnSize[i]);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnModel.getColumnIndexAtX(point.x);
                int n2 = this.columnModel.getColumn(n).getModelIndex();
                return columnToolTips[n2];
            }
        };
    }

    public void setBitpix(int n) {
        BuildTable.setDiskHeader(n);
    }

    private static String getDiskHeader(int n) {
        return "Disk space (bitpix=" + n + ")";
    }

    public static void setDiskHeader(int n) {
        BuildTable.columnToolTips[4] = BuildTable.getDiskHeader(n);
    }

    public void setDefaultRow(int n) {
        this.defaultRow = n;
    }

    public int getDefaultRow() {
        return this.defaultRow;
    }

    public int setSelectedOrder(int n) {
        if (n < 3) {
            n = 3;
        }
        this.defaultOrder = n;
        this.setValueAt(Boolean.TRUE, n - 3, 0);
        return n - 3;
    }

    public void reset() {
        this.defaultOrder = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.setValueAt(new Boolean(false), i, 0);
        }
    }

    public void refresh() {
        this.repaint();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        Color color = this.getBackground();
        if (n == this.defaultRow) {
            color = new Color(204, 234, 234);
        }
        component.setBackground(color);
        ((JComponent)component).setBorder(bord);
        if (n2 == 2 && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(this.getOrderToolTip(n));
        }
        return component;
    }

    private static Object[][] createData(int n, int n2) {
        Object[][] objectArray = new Object[18][5];
        double d = 41252.96124941927;
        long l = (long)Math.pow(4.0, n2);
        long l2 = Math.abs(n) / 8;
        for (int i = 0; i < objectArray.length; ++i) {
            int n3 = i + 3 + 9;
            long l3 = CDSHealpix.pow2(n3);
            long l4 = 12L * l3 * l3;
            objectArray[i][0] = new Boolean(false);
            objectArray[i][1] = Coord.getUnit(Math.sqrt(d / (double)l4));
            objectArray[i][2] = n3 + " / " + l3;
            objectArray[i][3] = i + 3 + " / " + l4 / l;
            objectArray[i][4] = Util.getUnitDisk(l4 * l2);
        }
        return objectArray;
    }

    public int getOrder() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, 0) != Boolean.TRUE) continue;
            return i + 3;
        }
        return this.defaultOrder;
    }

    public String getOrderToolTip(int n) {
        return "<html>512 x 2<sup>" + (n + 3) + "</sup></html>";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 4) {
            double d = this.context.getIndexSkyArea();
            long l = this.tabBuild.getNpix();
            int n3 = n + 3 + this.context.getTileOrder();
            long l2 = CDSHealpix.pow2(n3);
            long l3 = 12L * l2 * l2;
            return Util.getUnitDisk((long)((double)(l3 * l) * d * (n == 1 ? 1.0 : 1.33)));
        }
        if (n2 == 3 && this.context.mocIndex != null) {
            double d = this.context.getIndexSkyArea();
            int n4 = n + 3 + this.context.getTileOrder();
            long l = CDSHealpix.pow2(n4);
            long l4 = 12L * l * l;
            return n + 3 + " / " + (long)((double)l4 * d) / (long)(this.context.getTileSide() * this.context.getTileSide());
        }
        return super.getModel().getValueAt(n, n2);
    }

    public Class<? extends Object> getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 0) {
            super.setValueAt(object, n, n2);
            return;
        }
        if (object == Boolean.TRUE && this.getValueAt(n, 0) == Boolean.TRUE) {
            return;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            super.setValueAt(new Boolean(false), i, 0);
        }
        super.setValueAt(object, n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }
}

