/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyProperties;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderAppend;
import cds.allsky.BuilderCheck;
import cds.allsky.BuilderClean;
import cds.allsky.BuilderCleanDate;
import cds.allsky.BuilderCleanDetails;
import cds.allsky.BuilderCleanFits;
import cds.allsky.BuilderCleanIndex;
import cds.allsky.BuilderCleanJpg;
import cds.allsky.BuilderCleanPng;
import cds.allsky.BuilderCleanTiles;
import cds.allsky.BuilderCleanWeight;
import cds.allsky.BuilderConcat;
import cds.allsky.BuilderCube;
import cds.allsky.BuilderDetails;
import cds.allsky.BuilderGunzip;
import cds.allsky.BuilderGzip;
import cds.allsky.BuilderIndex;
import cds.allsky.BuilderJpg;
import cds.allsky.BuilderMap;
import cds.allsky.BuilderMapTiles;
import cds.allsky.BuilderMirror;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderMocIndex;
import cds.allsky.BuilderPng;
import cds.allsky.BuilderProp;
import cds.allsky.BuilderRgb;
import cds.allsky.BuilderTiles;
import cds.allsky.BuilderTree;
import cds.allsky.BuilderUpdate;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.fits.Fits;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;

public abstract class Builder {
    protected Builder b = null;
    protected Context context;

    protected Builder(Context context) {
        this.context = context;
    }

    public static Builder createBuilder(Context context, Action action) throws Exception {
        switch (action) {
            case INDEX: {
                return new BuilderIndex(context);
            }
            case TILES: {
                return new BuilderTiles(context);
            }
            case ALLSKY: {
                return new BuilderAllsky(context);
            }
            case JPEG: {
                return new BuilderJpg(context);
            }
            case PNG: {
                return new BuilderPng(context);
            }
            case MOC: {
                return new BuilderMoc(context);
            }
            case MOCINDEX: {
                return new BuilderMocIndex(context);
            }
            case CLEAN: {
                return new BuilderClean(context);
            }
            case CLEANINDEX: {
                return new BuilderCleanIndex(context);
            }
            case CLEANDETAILS: {
                return new BuilderCleanDetails(context);
            }
            case CLEANTILES: {
                return new BuilderCleanTiles(context);
            }
            case CLEANFITS: {
                return new BuilderCleanFits(context);
            }
            case CLEANJPEG: {
                return new BuilderCleanJpg(context);
            }
            case CLEANPNG: {
                return new BuilderCleanPng(context);
            }
            case CLEANDATE: {
                return new BuilderCleanDate(context);
            }
            case CLEANWEIGHT: {
                return new BuilderCleanWeight(context);
            }
            case CHECK: {
                return new BuilderCheck(context);
            }
            case GZIP: {
                return new BuilderGzip(context);
            }
            case GUNZIP: {
                return new BuilderGunzip(context);
            }
            case RGB: {
                return new BuilderRgb(context);
            }
            case TREE: {
                return new BuilderTree(context);
            }
            case CONCAT: {
                return new BuilderConcat(context);
            }
            case APPEND: {
                return new BuilderAppend(context);
            }
            case CUBE: {
                return new BuilderCube(context);
            }
            case DETAILS: {
                return new BuilderDetails(context);
            }
            case MAPTILES: {
                return new BuilderMapTiles(context);
            }
            case UPDATE: {
                return new BuilderUpdate(context);
            }
            case PROP: {
                return new BuilderProp(context);
            }
            case MIRROR: {
                return new BuilderMirror(context);
            }
            case MAP: {
                return new BuilderMap(context);
            }
        }
        throw new Exception("No builder associated to this action");
    }

    public abstract void validateContext() throws Exception;

    public boolean isAlreadyDone() {
        return false;
    }

    public abstract void run() throws Exception;

    public abstract Action getAction();

    public void showStatistics() {
    }

    public boolean isFake() {
        if (!this.context.fake) {
            return false;
        }
        this.context.info("Action " + (Object)((Object)this.getAction()) + " not run due to the -n option");
        return true;
    }

    protected void validateInput() throws Exception {
        if (this.context.isValidateInput()) {
            return;
        }
        String string = this.context.getInputPath();
        if (string == null) {
            throw new Exception("Argument \"input\" is required");
        }
        File file = new File(string);
        if (!file.canRead()) {
            throw new Exception("Input not available [" + string + "]");
        }
        if (file.isFile()) {
            this.context.info("Unique input image detected");
            this.context.setFlagInputFile(true);
        }
        if (this.context.isExistingAllskyDir(string) && this.context.hasPropertyFile(string)) {
            throw new Exception("The input directory must be a image collection, not a HiPS => aborted");
        }
        this.context.setValidateInput(true);
    }

    protected void validateOutput() throws Exception {
        File file;
        String string = this.context.getOutputPath();
        if (string == null) {
            string = this.context.getInputPath();
            if (string != null && (string.startsWith("http://") || string.startsWith("https://"))) {
                int n;
                string = this.context.getInputPath();
                if (string.charAt((n = string.length()) - 1) == '/') {
                    --n;
                }
                int n2 = string.lastIndexOf(47, n);
                string = string.substring(n2 + 1, n);
            } else {
                String string2 = this.context.getHipsId();
                if (string2 == null) {
                    string = (string == null ? "" : string) + "HiPS";
                } else {
                    int n;
                    string = this.context.getInputPath();
                    if ((string = string.replace('\\', '/')).charAt((n = string.length()) - 1) == '/') {
                        --n;
                    }
                    int n3 = string.lastIndexOf(47, n);
                    string = string.substring(0, n3 + 1);
                    string2 = string2.substring(6);
                    string2 = string2.replace('/', '_');
                    string2 = string2.replace('?', '_');
                    string = string + string2;
                }
            }
            this.context.setOutputPath(string);
            this.context.info("the output directory will be " + string);
        }
        if (!(!(file = new File(string)).exists() || file.isDirectory() && file.canRead())) {
            throw new Exception("Ouput directory not available [" + string + "]");
        }
        this.context.setValidateOutput(true);
    }

    protected void validateOrder(String string) throws Exception {
        int n = this.context.getOrder();
        int n2 = Util.getMaxOrderByPath(string);
        if (n == -1 || this.context instanceof ContextGui) {
            this.context.info("Order retrieved from [" + string + "] => " + n2);
            this.context.setOrder(n2);
        } else if (n2 != -1 && n != n2) {
            throw new Exception("Detected order [" + n2 + "] does not correspond to the param order [" + n + "]");
        }
    }

    protected void validateDepth() throws Exception {
        String string;
        if (this.context.depthInit) {
            return;
        }
        if (!this.context.isColor()) {
            string = this.context.getImgEtalon();
            if (string == null && this.context.getInputPath() != null && (string = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Use this reference image => " + string);
            }
            if (string != null) {
                try {
                    this.context.setImgEtalon(string);
                }
                catch (Exception exception) {
                    this.context.warning("Reference image problem [" + string + "] => " + exception.getMessage());
                }
            }
        }
        if (!this.context.depthInit) {
            try {
                int n;
                this.context.loadProperties();
                string = this.context.prop.getProperty("hips_cube_depth");
                if (string == null) {
                    string = this.context.prop.getProperty("cubeDepth");
                }
                if (string != null && (n = Integer.parseInt(string)) > 1) {
                    this.context.setDepth(n);
                }
            }
            catch (Exception exception) {
                this.context.warning("Propertie file problem => " + exception.getMessage());
            }
        }
        if (this.context.depthInit && this.context.depth > 1) {
            string = "";
            if (this.context.isCubeCanal()) {
                string = " (crpix3=" + this.context.crpix3 + " crval3=" + this.context.crval3 + " cdelt3=" + this.context.cdelt3 + ")";
            }
            this.context.info("Working on HiPS cube => depth=" + this.context.depth + string);
        }
    }

    protected void validateCut() throws Exception {
        Object object;
        if (this.context.isValidateCut()) {
            return;
        }
        double[] dArray = null;
        double[] dArray2 = this.context.pixelGood;
        boolean bl = dArray2 != null && this.context.good != null;
        boolean bl2 = dArray == null || dArray[0] == 0.0 && dArray[1] == 0.0;
        boolean bl3 = dArray == null || dArray[2] == 0.0 && dArray[3] == 0.0;
        double[] dArray3 = this.context.getPixelRangeCut();
        if ((bl2 || bl3) && dArray3 != null || bl) {
            block24: {
                try {
                    this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
                }
                catch (Exception exception) {
                    object = this.context.getImgEtalon();
                    if (object == null && this.context.getInputPath() != null && (object = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                        this.context.info("Use this reference image => " + (String)object);
                    }
                    if (object == null) break block24;
                    try {
                        this.context.setImgEtalon((String)object);
                    }
                    catch (Exception exception2) {
                        this.context.warning("Reference image problem [" + (String)object + "] => " + exception.getMessage());
                    }
                }
            }
            try {
                int n;
                if (dArray == null) {
                    dArray = new double[5];
                }
                for (n = 0; n < 4; ++n) {
                    if (Double.isNaN(dArray3[n])) continue;
                    dArray[n] = (dArray3[n] - this.context.bzero) / this.context.bscale;
                }
                if (bl) {
                    this.context.good = new double[2];
                    for (n = 0; n < 2; ++n) {
                        this.context.good[n] = (this.context.pixelGood[n] - this.context.bzero) / this.context.bscale;
                    }
                }
            }
            catch (Exception exception) {
                throw new Exception("Cannot retrieve BZERO & BSCALE from previous Allsky.fits file or reference image");
            }
        }
        boolean bl4 = bl2 = dArray == null || dArray[0] == 0.0 && dArray[1] == 0.0;
        if (bl2) {
            String string = this.context.getImgEtalon();
            if (string == null && this.context.getInputPath() != null && (string = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Use this reference image => " + string);
            }
            if (string != null) {
                try {
                    this.context.setImgEtalon(string);
                }
                catch (Exception exception) {
                    this.context.warning("Reference image problem [" + string + "] => " + exception.getMessage());
                }
            }
            this.context.initParameters();
            object = this.context.getCut();
            if (dArray == null) {
                dArray = new double[5];
            }
            if (bl2) {
                dArray[0] = (double)object[0];
                dArray[1] = (double)object[1];
                if (dArray[0] != dArray[1]) {
                    this.context.info("Estimating pixel cut from the reference image => [" + dArray[0] + " .. " + dArray[1] + "]");
                }
            }
        }
        boolean bl5 = bl2 = dArray == null || dArray[0] == 0.0 && dArray[1] == 0.0;
        if (bl2) {
            this.updateCutByProperties(dArray);
        }
        this.context.setCut(dArray);
        double d = this.context.bzero;
        double d2 = this.context.bscale;
        if (dArray == null || dArray[0] == 0.0 && dArray[1] == 0.0) {
            throw new Exception("Argument \"pixelCut\" required");
        }
        if (!(dArray[0] < dArray[1])) {
            throw new Exception("pixelCut error [" + this.ip(dArray[0], d, d2) + " .. " + this.ip(dArray[1], d, d2) + "]");
        }
        this.context.info("pixel cut [" + this.ip(dArray[0], d, d2) + " .. " + this.ip(dArray[1], d, d2) + "]");
        this.context.setValidateCut(true);
    }

    protected void updateCutByProperties(double[] dArray) {
        try {
            String string = this.context.getOutputPath() + Util.FS + "properties";
            MyProperties myProperties = new MyProperties();
            File file = new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(string);
                myProperties.load(fileInputStream);
                fileInputStream.close();
                String string2 = myProperties.getProperty("hips_pixel_cut");
                if (string2 == null) {
                    string2 = myProperties.getProperty("pixelCut");
                }
                this.context.setPixelCut(string2);
                double[] dArray2 = this.context.getPixelRangeCut();
                try {
                    this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
                    if (dArray == null) {
                        dArray = new double[5];
                    }
                    for (int i = 0; i < 4; ++i) {
                        if (Double.isNaN(dArray2[i])) continue;
                        dArray[i] = (dArray2[i] - this.context.bzero) / this.context.bscale;
                    }
                    this.context.info("Pixel cut from the propertie file => [" + this.ip(dArray[0], this.context.bzero, this.context.bscale) + " .. " + this.ip(dArray[1], this.context.bzero, this.context.bscale) + "]");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateBitpix() {
        if (this.context.bitpix != -1) {
            return;
        }
        try {
            this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateLabel() {
        if (this.context.getLabel() != null) {
            return;
        }
        String string = this.getALabel(this.context.getOutputPath(), this.context.getInputPath());
        if (string != null && string.length() > 0) {
            this.context.label = string;
        }
    }

    protected String getALabel(String string, String string2) {
        String string3 = null;
        try {
            String string4 = string + Util.FS + "properties";
            MyProperties myProperties = new MyProperties();
            File file = new File(string4);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(string4);
                myProperties.load(fileInputStream);
                fileInputStream.close();
                String string5 = myProperties.getProperty("obs_collection");
                if (string5 == null) {
                    string5 = myProperties.getProperty("label");
                }
                if (string5 != null && string5.length() > 0) {
                    string3 = string5;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            return string3;
        }
        if (string2 != null) {
            int n = string2.lastIndexOf(Util.FS);
            if (n < 0) {
                n = string2.lastIndexOf(47);
            }
            string3 = n >= 0 ? string2.substring(n + 1) : string2;
        } else {
            int n = string.lastIndexOf(Util.FS);
            if (n < 0) {
                n = string.lastIndexOf(47);
            }
            string3 = n >= 0 ? string.substring(n + 1) : string;
        }
        return string3;
    }

    protected String getFrame() {
        if (this.context.hasFrame()) {
            return this.context.getFrameCode();
        }
        try {
            String string;
            if (this.context.prop == null) {
                this.context.loadProperties();
            }
            if ((string = this.context.prop.getProperty("hips_frame")) == null) {
                string = this.context.prop.getProperty("coordsys");
            }
            if (string == null) {
                string = "G";
            }
            if (string.equals("equatorial")) {
                return "C";
            }
            if (string.equals("ecliptic")) {
                return "E";
            }
            if (string.equals("galactic")) {
                return "G";
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.context.getFrameCode();
        }
    }

    protected String ip(double d, double d2, double d3) {
        return cds.tools.Util.myRound(d) + (d2 != 0.0 || d3 != 1.0 ? "/" + cds.tools.Util.myRound(d * d3 + d2) : "");
    }

    protected void setFitsParamFromPreviousAllsky(String string) throws Exception {
        double d;
        Fits fits = new Fits();
        fits.loadFITS(string);
        double[] dArray = fits.findAutocutRange(0.0, 0.0, true);
        this.context.setBitpix(fits.bitpix);
        this.context.setCut(dArray);
        try {
            this.context.blank = d = fits.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.context.bzero = d = fits.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            double d2;
            this.context.bscale = d2 = fits.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setBzeroBscaleFromPreviousAllsky(String string) throws Exception {
        double d;
        Fits fits = new Fits();
        fits.loadHeaderFITS(string);
        try {
            this.context.bzero = d = fits.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.context.bscale = d = fits.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.context.bitpix == -1) {
            try {
                double d2 = fits.headerFits.getDoubleFromHeader("BITPIX");
                this.context.bitpix = (int)d2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

