/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;

public final class BuilderAllsky
extends Builder {
    private boolean abort = false;
    public static final String FS = System.getProperty("file.separator");

    public BuilderAllsky(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.ALLSKY;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.context.setProgressMax(100.0);
    }

    protected void abort() {
        this.abort = true;
    }

    @Override
    public void run() throws Exception {
        this.abort = false;
        this.validateDepth();
        for (int i = 0; !this.abort && i < this.context.depth; ++i) {
            if (!this.context.isColor()) {
                this.createAllSky(this.context.getOutputPath(), 3, 64, i);
            }
            try {
                if (i == 0 && !this.context.isColor()) {
                    this.validateCut();
                }
                this.createAllSkyColor(this.context.getOutputPath(), 3, "png", 64, i);
                this.createAllSkyColor(this.context.getOutputPath(), 3, "jpeg", 64, i);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.postJob();
    }

    public void runJpegOrPngOnly(String string) throws Exception {
        this.validateDepth();
        this.validateCut();
        for (int i = 0; i < this.context.depth; ++i) {
            this.createAllSkyColor(this.context.getOutputPath(), 3, string, 64, i);
        }
        this.postJob();
    }

    private void postJob() throws Exception {
        this.validateLabel();
        this.validateBitpix();
        this.context.writeMetaFile();
    }

    public void createAllSky(String string, int n, int n2, int n3) throws Exception {
        String string2;
        int n4;
        int n5;
        long l = System.currentTimeMillis();
        int n6 = (int)CDSHealpix.pow2(n);
        int n7 = 12 * n6 * n6;
        if ((double)n7 / (double)(n5 = (int)Math.sqrt(n7)) != (double)(n4 = (int)((double)n7 / (double)n5))) {
            ++n4;
        }
        int n8 = n2 * n5;
        boolean bl = false;
        double d = 0.0;
        double d2 = 1.0;
        double d3 = Double.NaN;
        Fits fits = null;
        for (int i = 0; i < n7; ++i) {
            if (this.abort || this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (this.context.getAction() == this.getAction()) {
                this.context.setProgress((double)i * 100.0 / (double)n7);
            }
            string2 = Util.getFilePath("", n, i, n3);
            Fits fits2 = new Fits();
            String string3 = string + FS + string2;
            try {
                int n9;
                int n10;
                if (!new File(string3 + ".fits").exists()) continue;
                fits2.loadFITS(string3 + ".fits");
                if (!bl) {
                    d = fits2.getBzero();
                    d2 = fits2.getBscale();
                    d3 = fits2.getBlank();
                    bl = true;
                }
                if (fits == null) {
                    if (fits2.width != 0 && fits2.width < n2) {
                        this.context.info("createAllsky: reducing width=>" + fits2.width + " ...");
                        this.createAllSky(string, n, fits2.width, n3);
                        return;
                    }
                    fits = new Fits(n8, n4 * n2, fits2.bitpix);
                    if (d3 != 0.0) {
                        for (n10 = 0; n10 < fits.height; ++n10) {
                            for (n9 = 0; n9 < fits.width; ++n9) {
                                fits.setPixelDouble(n9, fits.height - 1 - n10, d3);
                            }
                        }
                    }
                }
                n10 = i / n5;
                n9 = i % n5;
                int n11 = fits2.width / n2;
                for (int j = 0; j < fits2.width / n11; ++j) {
                    for (int k = 0; k < fits2.width / n11; ++k) {
                        double d4 = fits2.getPixelDouble(k * n11, fits2.height - 1 - j * n11);
                        int n12 = n9 * n2 + k;
                        int n13 = n10 * n2 + j;
                        fits.setPixelDouble(n12, fits.height - 1 - n13, d4);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fits == null) {
            return;
        }
        fits.setBlank(d3);
        fits.setBzero(d);
        fits.setBscale(d2);
        String string4 = BuilderAllsky.getFileName(string, n, n3);
        fits.writeFITS(string4 + ".fits", true);
        if (n3 > 1 && !new File((string2 = BuilderAllsky.getFileName(string, n, 0)) + ".fits").isFile()) {
            fits.writeFITS(string2 + ".fits", true);
        }
        Aladin.trace(2, "BuilderAllsky.createAllSky()... bitpix=" + fits.bitpix + " bzero=" + fits.bzero + " bscale=" + fits.bscale + "] created in " + (int)((System.currentTimeMillis() - l) / 1000L) + "s");
    }

    public static String getFileName(String string, int n, int n2) {
        return string + FS + "Norder" + n + FS + "Allsky" + (n2 > 0 ? "_" + n2 : "");
    }

    public void createAllSkyColor(String string, int n, String string2, int n2, int n3) throws Exception {
        String string3;
        int n4;
        int n5;
        long l = System.currentTimeMillis();
        int n6 = (int)CDSHealpix.pow2(n);
        int n7 = 12 * n6 * n6;
        if ((double)n7 / (double)(n5 = (int)Math.sqrt(n7)) != (double)(n4 = (int)((double)n7 / (double)n5))) {
            ++n4;
        }
        int n8 = n2 * n5;
        int n9 = n4 * n2;
        boolean bl = true;
        String string4 = string2.equals("png") ? ".png" : ".jpg";
        int n10 = string2.equals("png") ? 2 : 1;
        Aladin.trace(3, "Creation Allsky" + string4 + " order=" + n + (n3 > 0 ? "_" + n3 : "") + " mode=FIRST color: " + n7 + " losanges (" + n5 + "x" + n4 + " de " + n2 + "x" + n2 + " soit " + n8 + "x" + n4 * n2 + " pixels)...");
        Fits fits = new Fits(n8, n9, 0);
        for (int i = 0; i < n7; ++i) {
            if (this.abort || this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (this.context.getAction() == this.getAction()) {
                this.context.setProgress((double)i * 100.0 / (double)n7);
            }
            string3 = Util.getFilePath(n, (long)i, n3);
            Fits fits2 = new Fits();
            String string5 = string + FS + string3;
            try {
                if (!new File(string5 + string4).exists()) continue;
                fits2.loadPreview(string5 + string4, true, false, n10);
                if (bl && fits2.width != 0 && fits2.width < n2) {
                    Aladin.trace(3, "restart createAllsky: reducing width=>" + fits2.width + " ...");
                    this.createAllSkyColor(string, n, string2, fits2.width, n3);
                    return;
                }
                bl = false;
                int n11 = i / n5;
                int n12 = i % n5;
                int n13 = fits2.width / n2;
                if (n13 < 1) {
                    n13 = 1;
                }
                for (int j = 0; j < fits2.width / n13; ++j) {
                    for (int k = 0; k < fits2.width / n13; ++k) {
                        int n14 = fits2.getPixelRGB(k * n13, fits2.width - j * n13 - 1);
                        int n15 = n12 * n2 + k;
                        int n16 = n11 * n2 + j;
                        fits.setPixelRGB(n15, n9 - n16 - 1, n14);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            return;
        }
        String string6 = BuilderAllsky.getFileName(string, n, n3);
        fits.writeCompressed(string6 + string4, 0.0, 0.0, null, string2);
        if (n3 > 1 && !new File((string3 = BuilderAllsky.getFileName(string, n, 0)) + string4).isFile()) {
            fits.writeCompressed(string3 + string4, 0.0, 0.0, null, string2);
        }
        this.context.trace(4, "SkyGenerator.createAllSkyColor()... " + (int)((System.currentTimeMillis() - l) / 1000L) + "s");
    }
}

