/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.allsky.HipsGen;
import cds.allsky.Mode;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;

public class BuilderAppend
extends Builder {
    private String outputPath;
    private String inputPath;
    private Mode mode;
    private boolean live = false;
    private String addHipsPath;
    private int order;
    private String skyval;
    private String skyvalues;
    private String bitpix;

    public BuilderAppend(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CONCAT;
    }

    @Override
    public void run() throws Exception {
        this.createAddHips();
        this.concatHips();
        this.removeAddHips();
    }

    private void createAddHips() throws Exception {
        HipsGen hipsGen = new HipsGen();
        String string = "in=\"" + this.context.getInputPath() + "\" out=\"" + this.addHipsPath + "\" order=" + this.order + " bitpix=" + this.bitpix + " -live" + (this.skyvalues != null ? " \"skyvalues=" + this.skyvalues + "\"" : (this.skyval != null ? " skyval=" + this.skyval : "")) + " INDEX TILES";
        Tok tok = new Tok(string);
        String[] stringArray = new String[tok.countTokens()];
        int n = 0;
        while (tok.hasMoreTokens()) {
            stringArray[n] = tok.nextToken();
            ++n;
        }
        hipsGen.execute(stringArray);
    }

    private void removeAddHips() throws Exception {
        this.context.info("Cleaning temporary HiPS " + this.addHipsPath + "...");
        cds.tools.Util.deleteDir(new File(this.addHipsPath));
    }

    private void concatHips() throws Exception {
        HipsGen hipsGen = new HipsGen();
        String string = "out=\"" + this.context.getOutputPath() + "\" in=\"" + this.addHipsPath + "\" CONCAT";
        Tok tok = new Tok(string);
        String[] stringArray = new String[tok.countTokens()];
        int n = 0;
        while (tok.hasMoreTokens()) {
            stringArray[n] = tok.nextToken();
            ++n;
        }
        hipsGen.execute(stringArray);
    }

    @Override
    public void validateContext() throws Exception {
        this.outputPath = this.context.getOutputPath();
        this.inputPath = this.context.getInputPath();
        this.addHipsPath = cds.tools.Util.concatDir(this.outputPath, "AddsHiPS");
        this.mode = this.context.getMode();
        if (this.inputPath == null) {
            throw new Exception("\"in\" parameter required !");
        }
        File file = new File(this.inputPath);
        if (!(!file.exists() || file.isDirectory() && file.canRead())) {
            throw new Exception("\"inputPath\" directory not available [" + this.inputPath + "]");
        }
        this.skyval = this.getSkyVal(this.outputPath);
        if (this.skyval != null && this.skyval.toLowerCase().equals("true")) {
            try {
                this.skyvalues = this.loadProperty(this.outputPath, "hips_skyval_value");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.bitpix = this.getBitpix(this.outputPath);
        this.order = Util.getMaxOrderByPath(this.outputPath);
        if (this.order == -1) {
            throw new Exception("No HiPS found in ouput dir");
        }
        this.context.setOrder(this.order);
        int n = Util.getMaxOrderByPath(this.inputPath);
        if (n != -1) {
            throw new Exception("The input directory must contains original images/cubes. Use CONCAT if you want to merge two HiPS");
        }
        this.context.info("Order retrieved from [" + this.outputPath + "] => " + this.order);
        this.live = this.checkLiveByProperties(this.context.getOutputPath());
        if (this.mode == Mode.AVERAGE && !this.live) {
            this.context.warning("Target HiPS does not provide weight tiles => assuming weigth 1 for each output pixel");
        }
    }

    protected boolean checkLiveByProperties(String string) {
        try {
            String string2 = this.loadProperty(string, "dataproduct_subtype");
            return string2 != null && string2.indexOf("live") >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getSkyVal(String string) {
        try {
            String string2 = this.loadProperty(string, "hips_skyval_method");
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getBitpix(String string) {
        try {
            String string2 = this.loadProperty(string, "hips_pixel_bitpix");
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String loadProperty(String string, String string2) throws Exception {
        MyProperties myProperties = this.loadProperties(string);
        if (myProperties == null) {
            return null;
        }
        return myProperties.getProperty(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyProperties loadProperties(String string) {
        FileInputStream fileInputStream = null;
        try {
            String string2 = string + Util.FS + "properties";
            MyProperties myProperties = new MyProperties();
            File file = new File(string2);
            if (file.exists()) {
                fileInputStream = new FileInputStream(string2);
                myProperties.load(fileInputStream);
                fileInputStream.close();
                fileInputStream = null;
                MyProperties myProperties2 = myProperties;
                return myProperties2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }
}

