/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import java.io.File;

public class BuilderClean
extends Builder {
    private int nbFile = 0;

    public BuilderClean(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CLEAN;
    }

    @Override
    public void run() throws Exception {
        this.deleteDir(new File(this.context.getOutputPath()));
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
    }

    @Override
    public boolean isAlreadyDone() {
        return !new File(this.context.getOutputPath()).exists();
    }

    @Override
    public void showStatistics() {
        if (this.context instanceof ContextGui) {
            return;
        }
        this.context.stat(this.nbFile + " file" + (this.nbFile > 1 ? "s" : "") + " deleted");
    }

    public boolean mustBeDeleted(File file) {
        String string = file.getName();
        return !string.equals("properties");
    }

    public void deleteDir(File file) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.deleteDir(file2);
            }
            file.delete();
        } else if (this.mustBeDeleted(file)) {
            if (!file.delete()) {
                throw new Exception("Cannot delete " + file.getCanonicalPath());
            }
            ++this.nbFile;
            this.context.setProgress(this.nbFile);
        }
    }

    public void deleteDirExceptIndex(File file) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        for (File file2 : file.listFiles()) {
            if (file2.getName().equals("HpxFinder")) continue;
            this.deleteDir(file2);
        }
    }
}

