/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.HealpixProgen;
import cds.aladin.MyProperties;
import cds.aladin.PlanBG;
import cds.allsky.Action;
import cds.allsky.BuilderDetails;
import cds.allsky.BuilderJpg;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderMocIndex;
import cds.allsky.BuilderPng;
import cds.allsky.BuilderTiles;
import cds.allsky.BuilderTree;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class BuilderConcat
extends BuilderTiles {
    private HealpixMoc inputMoc;
    private HealpixMoc outputMoc;
    private String outputPath;
    private String inputPath;
    private String outputPathIndex;
    private String inputPathIndex;
    private Mode mode;
    private boolean doHpxFinder;
    private int tileMode;
    private int tileSide;
    private boolean live = false;
    private boolean liveIn;
    private boolean liveOut;

    public BuilderConcat(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CONCAT;
    }

    @Override
    public void run() throws Exception {
        this.build();
        new BuilderTree(this.context).run();
        this.context.info("tree updated");
        boolean bl = false;
        boolean bl2 = false;
        if (!this.context.isColor()) {
            bl = new File(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.jpg").exists();
            if (bl) {
                new BuilderJpg(this.context).run();
                this.context.info("JPEG tiles updated");
            }
            if (bl2 = new File(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.png").exists()) {
                new BuilderPng(this.context).run();
                this.context.info("PNG tiles updated");
            }
        }
        String string = this.context.getOutputPath();
        this.outputMoc = new HealpixMoc();
        File file = new File(string + Util.FS + "Moc.fits");
        if (file.exists()) {
            this.outputMoc.read(file.getCanonicalPath());
            this.outputMoc = this.outputMoc.union(this.inputMoc);
            this.outputMoc.write(this.context.getOutputPath() + Util.FS + "Moc.fits");
            this.context.info("MOC updated");
        } else {
            new BuilderMoc(this.context).run();
            this.context.info("MOC done");
        }
        if (!this.doHpxFinder) {
            file = new File(this.outputPathIndex);
            if (file.isDirectory()) {
                file.renameTo(new File(this.outputPathIndex + "-partial"));
                this.context.warning("Previous HpxFinder has been removed as HpxFinder-partial");
            }
        } else {
            new BuilderMocIndex(this.context).run();
            this.context.info("Index MOC updated");
            file = new File(this.outputPathIndex + Util.FS + "metadata.xml");
            if (file.exists()) {
                BuilderDetails builderDetails = new BuilderDetails(this.context);
                builderDetails.validateContext();
                builderDetails.run();
                this.context.info("PROGEN tiles updated");
            }
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.outputPath = this.context.getOutputPath();
        this.inputPath = this.context.getInputPath();
        this.outputPathIndex = cds.tools.Util.concatDir(this.outputPath, "HpxFinder");
        this.inputPathIndex = cds.tools.Util.concatDir(this.inputPath, "HpxFinder");
        this.mode = this.context.getMode();
        this.tileMode = 2;
        this.tileSide = this.context.getTileSide();
        if (this.inputPath == null) {
            throw new Exception("\"in\" parameter required !");
        }
        File file = new File(this.inputPath);
        if (!(!file.exists() || file.isDirectory() && file.canRead())) {
            throw new Exception("\"inputPath\" directory not available [" + this.inputPath + "]");
        }
        int n = Util.getMaxOrderByPath(this.outputPath);
        if (n == -1) {
            throw new Exception("No HiPS found in ouput dir");
        }
        this.context.setOrder(n);
        int n2 = Util.getMaxOrderByPath(this.inputPath);
        if (n2 == -1) {
            throw new Exception("No HiPS found in input dir");
        }
        if (n != n2) {
            throw new Exception("Uncompatible HiPS: out.order=" + n + " input.order=" + n2);
        }
        this.context.info("Order retrieved from [" + this.inputPath + "] => " + n);
        try {
            this.addAddendum(this.context.getInputPath(), this.context.getOutputPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits";
        if (new File(string).exists()) {
            this.setContextParamFromPreviousAllskyFile(string);
            this.validateParams(this.inputPath + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
        } else {
            string = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.png";
            if (new File(string).exists()) {
                this.context.setColor("png");
                this.tileMode = 0;
                this.context.info("Processing HiPS colored in " + this.context.getTileExt() + " tiles");
            } else {
                string = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.jpg";
                if (new File(string).exists()) {
                    this.context.setColor("jpg");
                    this.tileMode = 1;
                    this.context.info("Processing HiPS colored in " + this.context.getTileExt() + " tiles");
                }
            }
        }
        boolean bl = this.doHpxFinder = new File(this.inputPathIndex).isDirectory() && new File(this.outputPathIndex).isDirectory();
        if (this.doHpxFinder) {
            this.context.info("HpxFinder will be also concatenated (mode=" + (Object)((Object)this.mode) + ")");
        }
        this.inputMoc = new HealpixMoc();
        file = new File(this.inputPath + Util.FS + "Moc.fits");
        if (file.exists()) {
            this.inputMoc.read(file.getCanonicalPath());
        } else {
            this.context.info("No input MOC found => generate it...");
            this.context.setOutputPath(this.inputPath);
            new BuilderMoc(this.context).run();
            this.context.setOutputPath(this.outputPath);
            file = new File(this.inputPath + Util.FS + "Moc.fits");
            this.inputMoc.read(file.getCanonicalPath());
        }
        if (this.context.mocArea != null) {
            this.inputMoc = this.inputMoc.intersection(this.context.mocArea);
        }
        this.context.moc = this.inputMoc;
        double[] dArray = this.context.getCut();
        this.updateCutByProperties(dArray);
        this.context.setCut(dArray);
        this.context.setValidateCut(true);
        this.liveOut = this.checkLiveByProperties(this.context.getOutputPath());
        this.liveIn = this.checkLiveByProperties(this.context.getInputPath());
        boolean bl2 = this.live = this.liveIn && this.liveOut;
        if (this.mode == Mode.AVERAGE) {
            if (!this.live) {
                this.context.warning("Both HiPS to merge do not provide weight tiles => assuming basic average");
            } else if (!this.liveOut) {
                this.context.warning("Target HiPS do not provide weight tiles => assuming weigth 1 for each output pixel");
            } else if (!this.liveIn) {
                this.context.warning("Source HiPS do not provide weight tiles => assuming weigth 1 for each input pixel");
            }
        }
    }

    protected boolean checkLiveByProperties(String string) {
        try {
            String string2 = this.loadProperty(string, "dataproduct_subtype");
            return string2 != null && string2.indexOf("live") >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void addAddendum(String string, String string2) throws Exception {
        String string3 = this.getHipsIdFromProperty(string2);
        this.context.setHipsId(string3);
        String string4 = this.loadProperty(string2, "addendum_id");
        this.context.setAddendum(string4);
        String string5 = this.getHipsIdFromProperty(string);
        this.context.addAddendum(string5);
        this.context.info("Merging " + string5 + " into " + string3 + "...");
    }

    protected String loadProperty(String string, String string2) throws Exception {
        MyProperties myProperties = this.loadProperties(string);
        if (myProperties == null) {
            return null;
        }
        return myProperties.getProperty(string2);
    }

    protected String getHipsIdFromProperty(String string) throws Exception {
        MyProperties myProperties = this.loadProperties(string);
        return PlanBG.getHiPSID(myProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyProperties loadProperties(String string) {
        FileInputStream fileInputStream = null;
        try {
            String string2 = string + Util.FS + "properties";
            MyProperties myProperties = new MyProperties();
            File file = new File(string2);
            if (file.exists()) {
                fileInputStream = new FileInputStream(string2);
                myProperties.load(fileInputStream);
                fileInputStream.close();
                fileInputStream = null;
                MyProperties myProperties2 = myProperties;
                return myProperties2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    protected void setContextParamFromPreviousAllskyFile(String string) throws Exception {
        Fits fits = new Fits();
        fits.loadHeaderFITS(string);
        double[] dArray = new double[4];
        try {
            dArray[0] = fits.headerFits.getDoubleFromHeader("PIXELMIN");
            dArray[1] = fits.headerFits.getDoubleFromHeader("PIXELMAX");
        }
        catch (Exception exception) {
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        }
        try {
            dArray[2] = fits.headerFits.getDoubleFromHeader("DATAMIN");
            dArray[3] = fits.headerFits.getDoubleFromHeader("DATAMAX");
        }
        catch (Exception exception) {
            dArray[3] = 0.0;
            dArray[2] = 0.0;
        }
        this.context.setCut(dArray);
        try {
            double d;
            this.context.blank = d = fits.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            double d;
            this.context.bscale = d = fits.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            double d;
            this.context.bzero = d = fits.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n;
            this.context.bitpix = n = fits.headerFits.getIntFromHeader("BITPIX");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validateParams(String string) throws Exception {
        Fits fits = new Fits();
        fits.loadHeaderFITS(string);
        int n = fits.headerFits.getIntFromHeader("BITPIX");
        if (n != this.context.bitpix) {
            throw new Exception("Uncompatible HiPS => input.BITPIX=" + n + " output.BITPIX=" + this.context.bitpix);
        }
        double d = 1.0;
        try {
            d = fits.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d != this.context.bscale) {
            this.context.warning("BSCALE modification => ignored (input.BSCALE=" + d + " output.BSCALE=" + this.context.bscale + ")");
        }
        double d2 = 0.0;
        try {
            d2 = fits.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d2 != this.context.bzero) {
            this.context.warning("BZERO modification =>ignored (input.BZERO=" + d2 + " output.BZERO=" + this.context.bzero + ")");
        }
        double d3 = Double.NaN;
        try {
            d3 = fits.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Double.isNaN(d3) && d3 != this.context.blank) {
            this.context.warning("BLANK modification => ignored (input.BLANK=" + d3 + " output.BLANK=" + this.context.blank + ")");
        }
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile threadBuilderTile, String string, String string2, int n, long l, int n2) throws Exception {
        long l2 = System.currentTimeMillis();
        Fits fits = null;
        String string3 = Util.getFilePath(this.inputPath, n, l, n2);
        Fits fits2 = this.loadTile(string3);
        if (fits2 == null) {
            long l3 = System.currentTimeMillis() - l2;
            this.updateStat(0, 0, 1, l3, 0, 0L);
            return null;
        }
        double[] dArray = null;
        double[] dArray2 = null;
        String string4 = Util.getFilePath(this.outputPath, n, l, n2);
        if (this.mode != Mode.REPLACETILE && (fits = this.loadTile(string4)) != null && this.live) {
            dArray = ThreadBuilderTile.loadWeight(string4, this.tileSide, 1.0);
        }
        if (this.live) {
            dArray2 = ThreadBuilderTile.loadWeight(string3, this.tileSide, 1.0);
        }
        switch (this.mode) {
            case REPLACETILE: {
                fits = fits2;
                dArray = dArray2;
                break;
            }
            case KEEPTILE: {
                if (fits != null) break;
                fits = fits2;
                dArray = dArray2;
                break;
            }
            case AVERAGE: {
                if (fits != null) {
                    if (!this.live) {
                        fits2.coadd(fits, true);
                    } else {
                        fits2.coadd(fits, dArray2, dArray);
                    }
                }
                fits = fits2;
                dArray = dArray2;
                break;
            }
            case ADD: {
                if (fits != null) {
                    fits2.coadd(fits, false);
                    if (this.live) {
                        for (int i = 0; i < dArray.length; ++i) {
                            int n3 = i;
                            dArray2[n3] = dArray2[n3] + dArray[i];
                        }
                    }
                }
                fits = fits2;
                dArray = dArray2;
                break;
            }
            case OVERWRITE: {
                if (fits != null) {
                    if (!this.live) {
                        fits.mergeOnNaN(fits2);
                        break;
                    }
                    fits.mergeOnNaN(fits2, dArray, dArray2);
                    break;
                }
                fits = fits2;
                dArray = dArray2;
                break;
            }
            case KEEP: {
                if (fits != null) {
                    if (!this.live) {
                        fits2.mergeOnNaN(fits);
                    } else {
                        fits.mergeOnNaN(fits, dArray2, dArray);
                    }
                }
                fits = fits2;
                dArray = dArray2;
            }
        }
        if (fits == null) {
            throw new Exception("Y a un bl\u00e8me ! out==null");
        }
        this.write(string4, fits);
        if (this.liveOut) {
            ThreadBuilderTile.writeWeight(string4, dArray, this.tileSide);
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (this.doHpxFinder) {
            String string5 = Util.getFilePath(this.inputPathIndex, n, l, n2);
            HealpixProgen healpixProgen = this.loadIndex(string5);
            String string6 = Util.getFilePath(this.outputPathIndex, n, l, n2);
            HealpixProgen healpixProgen2 = this.loadIndex(string6);
            switch (this.mode) {
                case REPLACETILE: {
                    healpixProgen2 = healpixProgen;
                    break;
                }
                case KEEPTILE: {
                    if (healpixProgen2 != null) break;
                    healpixProgen2 = healpixProgen;
                    break;
                }
                case AVERAGE: 
                case ADD: 
                case OVERWRITE: 
                case KEEP: {
                    if (healpixProgen2 != null) {
                        healpixProgen.merge(healpixProgen2);
                    }
                    healpixProgen2 = healpixProgen;
                }
            }
            this.writeIndex(string6, healpixProgen2);
        }
        long l4 = System.currentTimeMillis() - l2;
        this.updateStat(0, 1, 0, l4, 0, 0L);
        return fits;
    }

    private Fits loadTile(String string) throws Exception {
        Fits fits = new Fits();
        try {
            if (this.tileMode == 2) {
                fits.loadFITS(string + ".fits");
            } else if (this.tileMode == 0) {
                fits.loadPreview(string + ".png", true, false, 2);
            } else if (this.tileMode == 1) {
                fits.loadPreview(string + ".jpg", true, false, 1);
            }
        }
        catch (Exception exception) {
            fits = null;
        }
        return fits;
    }

    private void writeIndex(String string, HealpixProgen healpixProgen) throws Exception {
        cds.tools.Util.createPath(string);
        healpixProgen.writeStream(new FileOutputStream(string));
    }

    private HealpixProgen loadIndex(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        HealpixProgen healpixProgen = new HealpixProgen();
        healpixProgen.loadStream(new FileInputStream(file));
        return healpixProgen;
    }
}

