/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyProperties;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderMoc;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.moc.HealpixMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class BuilderCube
extends Builder {
    private String[] inputPath;
    private Mode mode = Mode.COPY;
    private int nbFmt = 1;
    private boolean hasFITS = false;
    private boolean hasPNG = false;
    private boolean hasJPEG = false;
    private int statNbFile;
    private long startTime;
    private long totalTime;

    public BuilderCube(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CUBE;
    }

    @Override
    public void run() throws Exception {
        this.build();
        if (!this.context.isTaskAborting()) {
            BuilderMoc builderMoc = new BuilderMoc(this.context);
            builderMoc.createMoc(this.context.getOutputPath());
            this.context.moc = builderMoc.moc;
        }
        if (!this.context.isTaskAborting()) {
            this.context.writeMetaFile();
        }
    }

    private int getNbFmt() {
        int n = 0;
        if (this.hasFITS) {
            ++n;
        }
        if (this.hasJPEG) {
            ++n;
        }
        if (this.hasPNG) {
            ++n;
        }
        return Math.max(n, this.nbFmt);
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile / this.getNbFmt(), this.totalTime, 0, 0);
    }

    @Override
    public void validateContext() throws Exception {
        boolean bl = false;
        String string = this.context.getInputPath();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        this.inputPath = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < this.inputPath.length; ++i) {
            Comparable<File> comparable;
            String string2;
            this.inputPath[i] = stringTokenizer.nextToken();
            String string3 = this.inputPath[i];
            if (!new File(string3).isDirectory()) {
                throw new Exception("Input HiPS error [" + string3 + "]");
            }
            int n = Util.getMaxOrderByPath(string3);
            if (i == 0 && this.context.order == -1) {
                this.context.order = n;
            } else if (n < this.context.order) {
                this.context.warning("Input HiPS [" + string3 + " => order=" + n + "] not enough depth => ignored");
            }
            if (!bl) {
                string2 = string3 + Util.FS + "properties";
                this.context.prop = new MyProperties();
                comparable = new File(string2);
                if (((File)comparable).exists()) {
                    if (!((File)comparable).canRead()) {
                        throw new Exception("Propertie file not available ! [" + string2 + "]");
                    }
                    FileInputStream fileInputStream = new FileInputStream(string2);
                    this.context.prop.load(fileInputStream);
                    fileInputStream.close();
                    bl = true;
                    try {
                        int n2;
                        String string4 = this.context.prop.getProperty("hips_tile_format");
                        if (string4 == null) {
                            string4 = this.context.prop.getProperty("format");
                        }
                        if ((n2 = new StringTokenizer(string4, " ").countTokens()) > 1) {
                            this.nbFmt = n2;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            string2 = this.getALabel(string3, null);
            this.context.setPropriete("obs_collection_" + i, string2);
            try {
                comparable = new HealpixMoc();
                ((HealpixMoc)comparable).read(string3 + Util.FS + "Moc.fits");
                if (this.context.moc == null) {
                    this.context.moc = comparable;
                    continue;
                }
                this.context.moc = this.context.moc.union((HealpixMoc)comparable);
                continue;
            }
            catch (Exception exception) {
                this.context.warning("Missing original MOC in " + string3 + " => running time estimation will be wrong");
            }
        }
        this.validateOutput();
        this.validateLabel();
        this.context.depth = this.inputPath.length;
        if (this.context.getMode().equals((Object)Mode.LINK)) {
            this.mode = this.context.getMode();
        }
        this.context.info(Mode.getExplanation(this.mode));
    }

    private void initStat() {
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    public void build() throws Exception {
        this.initStat();
        String string = this.context.getOutputPath();
        String string2 = string + Util.FS + "HpxFinder";
        for (int i = 0; i < this.context.depth; ++i) {
            String string3 = this.inputPath[i];
            for (int j = 3; j <= this.context.getOrder(); ++j) {
                this.treeCopy(string3, string, "Norder" + j, i);
            }
            String string4 = string3 + Util.FS + "HpxFinder";
            if (!new File(string4).isDirectory()) continue;
            for (int j = 3; j <= this.context.getOrder(); ++j) {
                this.treeCopy(string4, string2, "Norder" + j, i);
            }
        }
    }

    private void treeCopy(String string, String string2, String string3, int n) throws Exception {
        String string4;
        File file = new File(string + Util.FS + string3);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string5 = fileArray[i].getName();
                this.treeCopy(string, string2, string3 + Util.FS + string5, n);
            }
            return;
        }
        String string6 = file.getName();
        int n2 = string6.lastIndexOf(46);
        String string7 = n2 < 0 ? "" : string6.substring(n2);
        String string8 = n2 < 0 ? string6 : string6.substring(0, n2);
        String string9 = string4 = n == 0 ? "" : "_" + n;
        if (!this.hasPNG && string7.equals(".png")) {
            this.hasPNG = true;
        } else if (!this.hasFITS && string7.equals(".fits")) {
            this.hasFITS = true;
        } else if (!this.hasJPEG && string7.equals(".jpg")) {
            this.hasJPEG = true;
        }
        String string10 = new File(string3).getParent();
        new File(string2 + Util.FS + string10).mkdirs();
        File file2 = new File(string2 + Util.FS + string10 + Util.FS + string8 + string4 + string7);
        if (this.mode == Mode.LINK) {
            BuilderCube.link(file, file2);
        } else {
            this.copy(file, file2);
        }
        this.updateStat();
    }

    private static void link(File file, File file2) throws Exception {
        Method method = File.class.getDeclaredMethod("toPath", new Class[0]);
        Object object = method.invoke((Object)file, new Object[0]);
        Object object2 = method.invoke((Object)file2, new Object[0]);
        Class<?> clazz = Class.forName("java.nio.file.Files");
        Class<?> clazz2 = Class.forName("java.nio.file.Path");
        Class<?> clazz3 = Class.forName("java.nio.file.attribute.FileAttribute");
        Object[] objectArray = (Object[])Array.newInstance(clazz3, 0);
        Class[] classArray = new Class[]{clazz2, clazz2, objectArray.getClass()};
        Method method2 = clazz.getDeclaredMethod("createSymbolicLink", classArray);
        method2.invoke(null, object, object2, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File file, File file2) throws Exception {
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            byArray = new byte[(int)file.length()];
            randomAccessFile.read(byArray);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file2, "rw");
            randomAccessFile.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }
}

